{This file contains various compiler directives which define the manner
 in which the SkyHawk Developer's Toolkit will be compiled. You can
 activate any inactive directive by removing the dot after the opening
 bracket. Similarly, you can deactivate any active directive by insert-
 ing a dot after the opening bracket.}

{$DEFINE Gen87}
{If this directive is active, unit and test files using real-type arith-
 metic will be compiled to generate 80x87 (math coprocessor) instruc-
 tions.}

{$DEFINE EmulationOK}
{If this directive is active, unit and test files using real-type arith-
 metic will emulate the 80x87 chip in the absence of a physical 80x87.
 Note: Activation of this directive will have no effect unless the sym-
 bol Gen87 is defined.}

{$IFNDEF DPMI}
  {$DEFINE OverlaysOK}
  {If this directive is active, unit files which can properly be over-
   laid will be so compiled. Specifically, they will be compiled $O+,F+}
{$ENDIF}

{$DEFINE HaltOnCmplxError}
{If this directive is active, ShCmplx (the complex arithmetic unit) will
 halt program execution with an error message if an error is discovered.}

{$DEFINE HaltOnLngStrInitError}
{If this directive is active, ShLngStr (the long string unit) will halt
 program execution with an error message if an error is encountered due
 to failure to initialize the ring buffer or any error associated with
 initialization of a LongString variable.}

{.$DEFINE HaltOnFinancError}
{If this directive is active, ShFinanc (the financial calculation unit)
 will unconditionally halt with an error message if any of the procedure
 or function parameters are out of the allowable range. If the directive
 is inactive, whether execution halts or proceeds depends on the setting
 of an internal switch which is controlled by the procedure pair
 finErrCheckOn and finErrCheckOff.}

