{}
{( C ) Copyright 1994 By Kimmo Fredriksson.}
{}
{You may use this unit freely in your programs, and distribute them,}
{but you are *NOT* allowed to distribute any modified form of this}
{unit, not source, nor the compiled TPU, TPP or whatsoever, *without*}
{my permission! In it's original form, this source is freeware.}
{}
{Internet email: Kimmo.Fredriksson@Helsinki.FI}
{}

{}
{If you want the Turbo Pascal and assembler source code for the TxtMap}
{Unit, register today. Send $20 (or 100 Fmk) to me, and I'll send all}
{the source to you.}
{}
{Kimmo Fredriksson}
{Silvontie 38}
{37740 Haukila}
{FINLAND}
{}

{}
{( C ) Copyright 1994 By Kimmo Fredriksson.}
{}
{Labyrinth-3D Menus Unit}
{}

{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P+,Q-,R-,S-,T-,V-,X+}

UNIT	L3DMenu;

	INTERFACE

PROCEDURE StartInfo;
PROCEDURE ReportSpeed;
PROCEDURE DebugInfo;
PROCEDURE ShowMap( KeyCode : Byte );
PROCEDURE Menu;
FUNCTION  Sure( CONST s : STRING ) : Boolean;

	IMPLEMENTATION

USES    TxtMap,
	L3DData,
	L3DWorld,
	VGAWin,
	Controls,
	Mouse,
	VGA256;
{
 ͻ
  FUNCTION Yes                                                            
 ͼ
}
FUNCTION Yes : Boolean;
BEGIN
  Yes := Key[ Controls.Y ]
END;
{
 ͻ
  FUNCTION No                                                             
 ͼ
}
FUNCTION No : Boolean;
BEGIN
  No := Key[ Controls.N ]
END;
{
 ͻ
  PROCEDURE WaitYesOrNo                                                   
 ͼ
}
PROCEDURE WaitYesOrNo;
BEGIN
  REPEAT UNTIL Yes OR No
END;
{
 ͻ
  FUNCTION IntToStr                                                       
 ͼ
}
FUNCTION IntToStr( a : LongInt ) : STRING;
VAR s : STRING[ 11 ];
BEGIN
  Str( a, s );
  IntToStr := ' ' + s
END;
{
 ͻ
  PROCEDURE MessageBox                                                    
 Ķ
  Input  : message; text, bg and border colors, border type and scan-code 
           of the to wait (zero, if not any)                              
 Ķ
  Open window, and show the desired message, and wait for key...          
 ͼ
}
PROCEDURE MessageBox( CONST s : STRING; Txt, Bac, Bor, Fr : Byte; WaitKey : Byte );
BEGIN
  IF NOT OpenWinCenter( Length( s ), 1, Bac, Bor, Fr ) THEN Exit;
  WriteWin( 0, 0, Txt, s );
  IF WaitKey = 0 THEN Exit;
  WaitForKey( WaitKey );
  CloseWin;
END;
{
 ͻ
  FUNCTION AskQuestion                                                    
 Ķ
  Input  : question-string                                                
  Output : answer-boolean (TRUE, if user pressed Y, and FALSE if N)       
 ͼ
}
FUNCTION AskQuestion( CONST Message : STRING ) : Boolean;
BEGIN
  MessageBox( Message, DialogTxt, DialogBac, DialogBor, DoubleFr, 0 );
  WaitYesOrNo;
  AskQuestion := Yes;
  WHILE KeyHitC DO;
  CloseWin;
END;
{
 ͻ
  FUNCTION Sure                                                           
 Ķ
  Input  : message (question) to user to apply                            
  Output : TRUE, if Y pressed, and FALSE if N pressed                     
 ͼ
}
FUNCTION Sure( CONST s : STRING ) : Boolean;
BEGIN
  MessageBox( s, DialogTxt, DialogBac, DialogBor, DoubleFr, 0 );
  WaitYesOrNo;
  Sure := Yes;
  CloseWin;
END;
{
 ͻ
  PROCEDURE KeyInfo                                                       
 Ķ
  Show key-instructions in window, and wait for ESC                       
 ͼ
}
PROCEDURE KeyInfo;
BEGIN
  IF NOT OpenWinCenter( 26, 16, HelpBac, HelpBor, SingleFr ) THEN Exit;
  WriteWin( 1, 0,  HelpTxt, #24'       : Move forwards' );
  WriteWin( 1, 1,  HelpTxt, #25'       : Move backwards' );
  WriteWin( 1, 2,  HelpTxt, #27'       : Turnt to left' );
  WriteWin( 1, 3,  HelpTxt, #26'       : Turn to right' );
  WriteWin( 1, 4,  HelpTxt, #27' & ALT : Move to left' );
  WriteWin( 1, 5,  HelpTxt, #26' & ALT : Move to right' );
  WriteWin( 1, 6,  HelpTxt, '+       : Move faster' );
  WriteWin( 1, 7,  HelpTxt, '-       : Move slower' );
  WriteWin( 1, 8,  HelpTxt, '+ & ALT : Turn faster' );
  WriteWin( 1, 9,  HelpTxt, '- & ALT : Turn slower' );
  WriteWin( 1, 10, HelpTxt, 'SPACE   : Show map' );
  WriteWin( 1, 11, HelpTxt, 'P       : Pause' );
  WriteWin( 1, 12, HelpTxt, 'ESC     : Exit to DOS' );
  WriteWin( 1, 14, HelpTxt, 'You may use the mouse' );
  WriteWin( 1, 15, HelpTxt, 'instead of the arrows.' );
  WaitForKey( ESC );
  CloseWin
END;
{
 ͻ
  PROCEDURE L3DInfo                                                       
 ͼ
}
PROCEDURE L3DInfo;
BEGIN
  IF NOT OpenWinCenter( 33, 7, HelpBac, HelpBor, SingleFr ) THEN Exit;
  WriteWin( 1, 0,  HelpTxt, 'You are in 3-D labyrinth, where' );
  WriteWin( 1, 1,  HelpTxt, 'you can move by using the arrow' );
  WriteWin( 1, 2,  HelpTxt, 'keys or mouse.' );
  WriteWin( 1, 3,  HelpTxt, 'If you get lost, you may check' );
  WriteWin( 1, 4,  HelpTxt, 'your position in the map.' );
  WriteWin( 1, 5,  HelpTxt, 'If you need help at any time' );
  WriteWin( 1, 6,  HelpTxt, 'press F1.' );
  WaitForKey( ESC );
  CloseWin
END;
{
 ͻ
  PROCEDURE AboutL3D                                                      
 ͼ
}
PROCEDURE AboutL3D;
BEGIN
  IF NOT OpenWinCenter( 33, 7, HelpBac, HelpBor, SingleFr ) THEN Exit;
  WriteWin( 1, 0,  HelpTxt, ' Labyrinth-3D, register to get' );
  WriteWin( 1, 1,  HelpTxt, ' the Turbo Pascal & assembler' );
  WriteWin( 1, 2,  HelpTxt, ' source of the TxtMap-unit! ' );
  WriteWin( 1, 4,  HelpTxt, '' );
  WriteWin( 1, 5,  HelpTxt, ' (C) 1994 By Kimmo Fredriksson' );
  WriteWin( 1, 6,  HelpTxt, '' );
  WaitForKey( ESC );
  CloseWin
END;
{
 ͻ
  PROCEDURE Instructions                                                  
 ͼ
}
PROCEDURE Instructions;
BEGIN
  IF NOT OpenWinCenter( 16, 5, MenuBac, MenuBor, DoubleFr ) THEN Exit;
  WriteWin( 1, 0, MenuSta, 'Instructions...' );
  WriteWin( 1, 2, MenuTxt, 'F1 - Controls' );
  WriteWin( 1, 3, MenuTxt, 'F2 - Something' );
  WriteWin( 1, 4, MenuTxt, 'F3 - About' );
  WHILE Key[ F1 ] DO;
  REPEAT
    IF Key[ F1 ] THEN KeyInfo;
    IF Key[ F2 ] THEN L3DInfo;
    IF Key[ F3 ] THEN AboutL3D;
  UNTIL Key[ ESC ];
  WHILE Key[ ESC ] DO;
  CloseWin
END;
{
 ͻ
  PROCEDURE ShowMap                                                       
 Ķ
  Input  : If ESC, wait for ESC. If SPACE, wait for SPACE to released     
 Ķ
  Player is the white point in the map, creatures are red, and worms blue.
 ͼ
}
PROCEDURE ShowMap( KeyCode : Byte );
VAR i, j, x, y, xc, yc, xd, yd, IP : Integer;
BEGIN
  xd := MaxWX - MinWX;
  yd := MaxWZ - MinWZ;
  xc := PXCent - xd DIV 2 - MinWX;
  yc := PYCent + yd DIV 2 + MinWZ;
  DefineScr( PScrXMax, PScrYMAx, Ptr( SegA000, 0 ));
  IF NOT OpenWinCenter( xd DIV 8 + 1, yd DIV 8, MessageBac, MessageBac, DoubleFr ) THEN Exit;
  FOR y := MinWZ TO MaxWZ DO FOR x := MinWX TO MaxWX DO
    IF GetOneWall( x, y ) THEN PutPixel( xc + x, yc - y, MessageTxt );
  FOR i := 0 TO Pred( NumOfCreats ) DO WITH Creatures[ i ]^.TxtRecPtr^ DO
    PutPixel( xc + 2 * Points[ LPInd ].X DIV WorldXZ,
	      yc - 2 * Points[ LPInd ].Z DIV WorldXZ, RB + 31 );
  FOR i := 0 TO Pred( NumOfWorms ) DO WITH Worms[ i ]^ DO
    FOR j := 0 TO Pred( Len ) DO WITH TxtRecPtr[ j ]^ DO
      PutPixel( xc + 2 * Points[ LPInd ].X DIV WorldXZ,
		yc - 2 * Points[ LPInd ].Z DIV WorldXZ, BB + 63 );
  PutPixel( xc + 2 * EyePA.X DIV WorldXZ, yc - 2 * EyePA.Z DIV WorldXZ, WB + 63 );
  CASE KeyCode OF
    SPACE : WHILE Key[ SPACE ] OR ( MouseInstalled AND RightButton ) DO;
    ESC   : WaitForKey( ESC );
  END;
  CloseWin
END;
{
 ͻ
  PROCEDURE ShowVersion                                                   
 ͼ
}
PROCEDURE ShowVersion;
BEGIN
  MessageBox( Version, MessageTxt, MessageBac, MessageBor, SingleFr, ESC )
END;
{
 ͻ
  PROCEDURE DebugInfo                                                     
 ͼ
}
PROCEDURE DebugInfo;
BEGIN
  IF NOT OpenWinCenter( 25, 15, MessageBac, MessageBor, SingleFr ) THEN Exit;
  WriteWin( 1, 0,  MessageTxt, 'MemAvail:       ' + IntToStr( MemAvail ));
  WriteWin( 1, 1,  MessageTxt, 'MaxAvail:       ' + IntToStr( MaxAvail ));
  WriteWin( 1, 2,  MessageTxt, 'NumOfTxtObjs:   ' + IntToStr( NumOfTxtObjs ));
  WriteWin( 1, 3,  MessageTxt, 'NumOfPoints:    ' + IntToStr( NumOfPoints ));
  WriteWin( 1, 4,  MessageTxt, 'NumOfTxts:      ' + IntToStr( NumOfTxts ));
  WriteWin( 1, 5,  MessageTxt, 'NumOfWalls:     ' + IntToStr( NumOfWalls ));
  WriteWin( 1, 6,  MessageTxt, 'NumOfVisTxtObjs:' + IntToStr( NumOfVisTxtObjs ));
  WriteWin( 1, 7,  MessageTxt, 'NumOfVisWalls   ' + IntToStr( NumOfVisWalls ));
  WriteWin( 1, 8,  MessageTxt, 'NumOfCreats:    ' + IntToStr( NumOfCreats ));
  WriteWin( 1, 9,  MessageTxt, 'NumOfWorms:     ' + IntToStr( NumOfWorms ));
  WriteWin( 1, 10, MessageTxt, 'EyeX:           ' + IntToStr( EyePA.X ));
  WriteWin( 1, 11, MessageTxt, 'EyeZ:           ' + IntToStr( EyePA.Z ));
  WriteWin( 1, 12, MessageTxt, 'EyeAngle:       ' + IntToStr( EyePA.YAng ));
  WriteWin( 1, 13, MessageTxt, 'MoveSpeed       ' + IntToStr( MoveSpeed ));
  WriteWin( 1, 14, MessageTxt, 'TurnSpeed       ' + IntToStr( TurnSpeed ));
  WaitForKey( ESC );
  CloseWin
END;
{
 ͻ
  PROCEDURE AskChkHit                                                     
 ͼ
}
PROCEDURE AskChkHit;
BEGIN
  ChkHit := AskQuestion('Go throught the walls (Y/N)?' )
END;
{
 ͻ
  PROCEDURE AskWaitVRT                                                    
 ͼ
}
PROCEDURE AskWaitVRT;
BEGIN
  WaitVRT := AskQuestion('Wait Vertical Retrace (Y/N)?' )
END;
{
 ͻ
  PROCEDURE AskRemoveHFF                                                  
 ͼ
}
PROCEDURE AskRemoveHFF;
BEGIN
  RemoveHFF := AskQuestion('Hidden face removal (Y/N)?' )
END;
{
 ͻ
  PROCEDURE ReportSpeed                                                   
 ͼ
}
PROCEDURE ReportSpeed;
VAR s : STRING[ 40 ];
BEGIN
  Str( 10 * FrameCnt DIV ( 65536 * OTime DIV 1193180 ), s );
  Insert( '.', s, Length( s ));
  MessageBox( s + ' frames / second!', MessageTxt, MessageBac, MessageBor, SingleFr, 0 );
  WHILE Key[ F5 ] DO;
  CloseWin
END;
{
 ͻ
  PROCEDURE Debug                                                         
 ͼ
}
PROCEDURE Debug;
BEGIN
  IF NOT OpenWinCenter( 25, 8, MenuBac, MenuBor, DoubleFr ) THEN Exit;
  WriteWin( 1, 0, MenuSta, 'Labyrinth-3D, (C) By KF' );
  WriteWin( 1, 1, MenuSta, '' );
  WriteWin( 1, 3, MenuTxt, 'F1 - Debug Information' );
  WriteWin( 1, 4, MenuTxt, 'F2 - Throught walls...' );
  WriteWin( 1, 5, MenuTxt, 'F3 - Wait VRT' );
  WriteWin( 1, 6, MenuTxt, 'F4 - Hidden Face Remove' );
  WriteWin( 1, 7, MenuTxt, 'F5 - Report Speed' );
  WHILE Key[ F1 ] DO;
  REPEAT
    IF Key[ F1 ] THEN DebugInfo;
    IF Key[ F2 ] THEN AskChkHit;
    IF Key[ F3 ] THEN AskWaitVRT;
    IF Key[ F4 ] THEN AskRemoveHFF;
    IF Key[ F5 ] THEN ReportSpeed;
  UNTIL Key[ ESC ];
  WHILE Key[ ESC ] DO;
  CloseWin
END;
{
 ͻ
  PROCEDURE Menu                                                          
 ͼ
}
PROCEDURE Menu;
BEGIN
  IF NOT OpenWinCenter( 25, 8, MenuBac, MenuBor, DoubleFr ) THEN Exit;
  WriteWin( 1, 0, MenuSta, 'Labyrinth-3D, (C) By KF' );
  WriteWin( 1, 1, MenuSta, '' );
  WriteWin( 1, 3, MenuTxt, 'F1 - Instructions' );
  WriteWin( 1, 4, MenuTxt, 'F2 - Map' );
  WriteWin( 1, 5, MenuTxt, 'F9 - Version' );
  WriteWin( 1, 7, MenuTxt, 'D  - Debug' );
  WHILE Key[ F1 ] DO;
  REPEAT
    IF Key[ F1 ] THEN Instructions;
    IF Key[ F2 ] THEN ShowMap( ESC );
    IF Key[ F9 ] THEN ShowVersion;
    IF Key[ D ] THEN Debug;
  UNTIL Key[ ESC ];
  WHILE Key[ ESC ] DO;
  CloseWin
END;
{
 ͻ
  PROCEDURE StartInfo                                                     
 ͼ
}
PROCEDURE StartInfo;
BEGIN
  IF NOT OpenWinCenter( 25, 5, MenuBac, MenuBor, DoubleFr ) THEN Exit;
  WriteWin( 1, 0, MenuSta, 'Labyrinth-3D, (C) By KF' );
  WriteWin( 1, 1, MenuSta, '' );
  WriteWin( 1, 3, MenuTxt, 'F1      - Instructions' );
  WriteWin( 1, 4, MenuTxt, 'SPACE   - Start' );
  WHILE KeyHitC DO;
  REPEAT
    IF Key[ F1 ] THEN Instructions
  UNTIL Key[ SPACE ];
  WHILE Key[ SPACE ] DO;
  CloseWin
END;

END.
