



                                       Preface


      The Version Control & Maintenance System is an application that
      allows either the client or the programmer to maintain their database
      of source code.  VCM is written in a dBASE IV compatible language
      called Foxpro.

      As a client, this system allows you to obtain the latest updated
      source code.  As a programmer, this system allows you to maintain
      another programmer's database of source code.  At the same time,
      other programmers can keep up with your modifications.  All without
      the need to "check-out" program files.

      For the VCM System to work, you must have a copy of PKWare's
      PKZIP/PKUNZIP utilities.  You also must have a modem and a PC-to-PC
      communication application.  I recommend at least a 9600 baud modem
      and a communication program such as PC Anywhere.

      An IBM personal computer (80386 or better) is recommended.  For
      improved performance, it is highly recommended that the user obtain
      at least three megabytes of extended memory.  A color monitor and a
      mouse are also recommended.

      Considerable effort was expended to make the user reference manual as
      complete as possible.  However, this documentation is in no way to be
      considered an instructive guide to MS-DOS, Foxpro, or PC-to-PC
      communications.  Many reference texts are available on the market
      that explain the MS-DOS operating system, Foxpro programming, and PC-
      to-PC communications.  If you need more information, your reference
      materials should include one of these texts.

      My advice is to read the contents of this user manual.  Familiarize
      yourself with its information.  If you have any questions concerning
      this application, feel free to write or call.























                                     - Page 1 -







                             Copyright/License/Warranty




      This document and the program Version Control & Maintenance ("the
      software") are copyrighted by the author.  The copyright owner hereby
      licenses you to use the software given these restrictions:


           o  the program shall be supplied in its original, unmodified
              form, which includes this documentation;

           o  for-profit use without a license is prohibited;

           o  the program may not be included - or bundled - with other
              goods or services.  Exceptions may be granted upon written
              request only.

           o  no fee is charged beyond a reasonable amount for the media
              and handling ($10 maximum suggested);


           There is no warranty of any kind.  The copyright owner may not
           be held liable for any damages, including any lost profits or
           other incidental or consequential damages arising out of or
           inability to use the software.  By using the software, you agree
           to this.


      Shareware

           VCM is distributed as Shareware.  It is not free software.
           You are free to try it and make copies for others.  If you
           continue to use this application beyond a reasonable trial
           period, you are required to register it with the distributor
           and author.


      ASP Ombudsman

           This program is produced by a member of the Association of
           Shareware Professionals (ASP).  ASP wants to make sure that the
           shareware principle works for you.  If you are unable to resolve
           a shareware-related problem with an ASP member by contacting the
           member directly, ASP may be able to help.  The ASP Ombudsman can
           help you resolve a dispute or problem with an ASP member, but
           does not provide technical support for members' products.

           Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
           MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
           via CompuServe Mail to ASP Ombudsman 70007,3536.



           Copyright (C) 1992 Dennis Allen.  All rights reserved.  All
           trademarks mentioned herein belong to their respective owners.

                                     - Page 2 -







                                  TABLE OF CONTENTS


      Preface                                                    1
      Copyright/License/Warranty                                 2
      Introduction                                               5
          Manual Content                                         5
          Notation Convention                                    6
      System Startup                                             7
          Client Overview                                        7
          Programmer Overview                                    7
          Host Start-up                                          8
              Version Control                                    9
          Creating REMOTE.ZIP                                   11
          Remote Start-up                                       11
          Updating VCM Paths                                    12
          Updating a VCM Path Record                            15
          Creating HOST.ZIP                                     16
          Host Restart                                          16
          Normal Operations                                     16
          Maintaining VCM records                               17
          ZIP Files                                             17
          Quit                                                  19
      Printing VCM Files                                        20
          Printing VCM History Edit List                        20
          Quit                                                  22
      System Setup                                              23
          Expression Builder                                    24
          Printer Control Codes                                 25
          Change Color Set                                      27
              Customizing Color Sets                            27
          Problems & Suggestions                                27
          All About...                                          28
          Edit Data Path/File Names                             28
          Version Control                                       28
          Display/Print Manual                                  29
          Quit                                                  29
      Utilities                                                 30
          Create/Update VCM Path File                           31
          Create new VCM File                                   31
          Rollback VCM file                                     31
          Verify Source code                                    31
          Verify Version code                                   32
          Rebuilding Indices                                    32
          Initializing Databases                                32
          Purging Backup.$$$ files                              33
      Quit to DOS                                               34











                                     - Page 3 -







                                  TABLE OF CONTENTS


      Appendices                                                35
          Appendix A/ Generic Editor                            35
          Appendix A-1/ System Menu                             42
              Sysmenu edit                                      42
              Foxpro Calculator                                 42
              Foxpro Calendar                                   42
              Foxpro DOS Shell                                  43
              Printer Eject                                     43
              Video Mode                                        43
              Print Mode                                        43
          Appendix B/ Data Files                                44
              Backup/Restore Data files                         45
          Appendix C/ Error Handling                            46
              Disk Space                                        46
              Printer not Ready                                 46
              Multi-User Errors                                 47
              Syntax Error                                      47
          Appendix D/ Configuring Application                   48
              Foxpro Runtime Unit                               48
                  FOXR.EXE                                      48
                  FOXRW.EXE                                     49
              CONFIG.FP                                         49
                  EMS                                           50
                  MEMLIMIT                                      50
                  PROGWORK                                      50
                  RESOURCE                                      51
                  TIME                                          51
              FOXPRO.INI                                        52
                  DATA                                          52
                  FONTNAME                                      53
                  FONTSIZE                                      53
                  FONTSTYLE                                     53
                  HOST                                          54
                  INIT                                          54
                  LAST                                          54
                  MULT                                          54
                  PROG                                          55
                  RECALL                                        55
                  SYSMENU                                       55
                  TEMP                                          56
                  TERM                                          56
              FOXUSER.DBF                                       57
              FOXUSER2.DBF                                      57
              Printer Codes                                     58
              Record Filters                                    58
              Configuring Sideways                              58
      Glossary                                                  59
      Index                                                     62







                                     - Page 4 -







                                    Introduction


      The Version Control & Maintenance System is an application that
      allows either the client or the programmer to maintain their database
      of source code.  VCM is written in a dBASE IV compatible language
      called Foxpro.

      Before continuing, we should explain a couple of terms.  First, we
      will refer to the Version Control & Maintenance System as the VCM
      System.  Or simply as VCM.

      When we refer to a user's database of source code, we're talking
      about program files.  Every application has it's own set of program
      files, also known as source code.  A user's entire collection of
      applications, maintained by the VCM System, is a database of source
      code.

      We refer to a user identification as a "user-id".  Every user must be
      assigned a user-id.  A user-id defines the list of accessible file
      directories.

      When we refer to an "editor", it is a program module that allows us
      to add, delete, or change database records. The word "edit" means to
      update, maintain, or change a database record.

      When we refer to a "window", it is a section of the screen that is
      receiving output.  Windows may overlap each other on the screen.
      They are characterized by a double line border and usually have some
      sort of title.

      A "record filter" determines the access allowed to a database.  Only
      those records, defined by a record filter, may be viewed, edited, or
      printed.  Record filters are created/selected using an "expression
      builder".

      Finally, when we say "DOS", we refer to the disk operating system.
      It's usually MS-DOS, but could be Microsoft windows, UNIX, or even
      the Macintosh OS.

      The first section of this manual will describe how to install the VCM
      System.  There are sections that explain the edit, print, system, and
      utility menus.  Appendices are included to describe the generic
      operations of editors, error handling, optimizing VCM, and
      establishing a backup procedure.













                                     - Page 5 -







                                    Introduction


                              Notation Conventions


      CAPITAL LETTERS

           Capital letters indicates a command.  During command entry, this
           text should be entered exactly as it appears.  Unless specified,
           any command may be in upper or lower-case letters.

      lower case

           Parameters to commands are usually typed in lower-case
           characters.

      Ellipsis "..."

           The ellipsis represent repetition of a previous item.

      Single Key "[ ]"

           The single key command is represented by the characters "[" and
           "]".

      Control keys

           Control keys are designated with a "[Ctrl]-" followed by the
           name of another key (for example: [Ctrl]-[S]).  To enter a
           control key, press [Ctrl] on your keyboard and, while holding it
           down, press the additional key.  On some Foxpro menus, control
           keys are designated with a "^" followed by the name of another
           key (for example: ^[End] for [Ctrl]-[End]).

      Carriage Return

           Depending on your keyboard, the same key may be represented by
           different descriptions.  For example, the carriage return may be
           represented as [Enter], [Return], or [Bent arrow symbol].  For
           the most part, this should not be a problem.  Make sure,
           however, that you understand the function of each key so that
           you understand how they appear in this manual.

      Alternate key

           On an IBM PC keyboard, alternate keys are designated with a
           "[Alt]-" followed by the name of another key (for example:
           [Alt]-[V]).  To enter a control key, press [Alt] on your
           keyboard and, while holding it down, press the additional key.

           On a Macintosh keyboard, [Alt] is produced by holding down both
           the [Ctrl] key and the [Option] key.  To produce [Alt]-[V], for
           example, you must press [Ctrl], [Option], and [V] at the same
           time.



                                     - Page 6 -







                                   System Startup



      For version control to proceed, two copies of the VCM System must be
      installed.  One on a remote machine, one on a host machine.  The host
      machine will contain the master copy of source code.  You would own
      the remote machine.  Normal operation would proceed as follows:


                                 Client Overview


      From the remote machine, you would use PC-to-PC software to log onto
      the host machine.  You would run the host machine's VCM System and
      generate a file called REMOTE.ZIP.  This file will contain all source
      code, updated since the last time you logged onto the host machine.

      After exiting the host's VCM System, you would send REMOTE.ZIP to
      your remote machine.  Then you would log off the host machine.  Back
      on the remote machine, you would run the VCM System and retrieve
      REMOTE.ZIP.  This process ensures you have to latest source code and
      can be repeated as often as desired.


      Note:  As a client, if you modify source code, must be aware that any
      updates from the host will eliminate your changes.  Retrieving ZIP
      files, however, does create backup copies of source code.


                               Programmer Overview


      If your a programmer, and have the security clearance, you may also
      send your latest updates to the host machine.  On the remote machine,
      you would run the VCM System and generate a file called HOST.ZIP.
      This file will contain all source code, updated since the last time
      you ran the remote machine's VCM System.

      After exiting your VCM System, you would log into the host machine.
      You would send HOST.ZIP to the host.  Then, you would run the host
      machine's VCM System and retrieve HOST.ZIP.  This process can be
      repeated as often as desired.


      Note:  As a programmer, be aware that any updates from the host will
      override your changes.  Retrieving ZIP files, however, does create
      backup copies of source code.  It is the programmer's responsibility,
      therefore, to:  Receive the host's changes, reconcile the remote's
      changes, and return the updated source code to the host.








                                     - Page 7 -







                                   System Startup


                                  Host Start-up


      For normal operations, each VCM System must first be initialized.
      But purposes of this session, the host system and the remote system
      will be one and the same.

      Your computer should be running and you should be at the DOS prompt.
      You should have already installed your VCM System and your Foxpro
      runtime unit.

      For start-up operations to begin, the system administrator on the
      host machine would first assign you a user identification number.
      Only a user, with a valid user id, may run the host's VCM System.

      However, since this is the VERY first time you will be running this
      application (and only for purposes of testing), you may begin as if
      you were on a host machine.  At the DOS prompt, type:


           HOST TEMP


      and press [Enter].  "TEMP" will be your user id for this session.
      You should see is the following startup screen:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                       (c) 1992 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------- Data Path/File Names -----------------------
      |                                                                    |
                ZIP file Data Path        : C:\ANYWHERE\
                New user Root Directory   : C:\VCM\
      |                                                                    |
                Version Control Extension : VER
                Translated File Extension : PRG
                Other Valid    Extensions :
                Parameter File List       :
      |                                                                    |
      |--------------------------------------------------------------------|
                Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+


      This screen defines the default VCM settings and can be found in the
      system setup menu.  The first field defines the communication
      application directory.  This is where your ZIP files are sent and
      received.  Type the name of your PC-to-PC application directory.  If
      you don't have one yet, just type "C:\" and press [Enter].




                                     - Page 8 -







                                   System Startup


      The next field defines the default root directory.  When you add a
      user id, you will be prompted with this path.  This directory, and
      all sub-directories, will be assigned to the new user-id.  For our
      example session, press [Enter].


                                 Version Control

      The next two fields relate to version control.  Our own in-house
      staff uses a program called dVERSION.  dVERSION takes conditional
      source code and translate it into executable code.  Conditional code
      is stored in a sub-directory from executable code.

      Example:  A program called "DP.VER" may contain conditional code.
      dVERSION would translate "DP.VER" into "DP.PRG", an executable
      program.  "DP.VER" would be stored in "\DP\VER\".  "DP.PRG" would be
      stored in "\DP\".

      When the VCM System finds a program, such as "DP.VER", it checks the
      parent directory for "DP.PRG".  If found, the VCM System will ignore
      it.  In this way, the VCM System doesn't have to send duplicate and
      unnecessary files.  For our session, press [Enter] and [Enter].


      Note:  If you don't want to use version control, simply leave these
      two fields blank.


      The next field defines the list of valid file extensions.  Any file,
      not defined in the list, is ignored by the VCM System.  For our
      session, press [Enter].


      Note:  "   " is considered a valid file extension, but it must be
      defined first in the list.  All extensions in the list must be comma
      delimited.


      The last field on our default screen defines the parameter list.  The
      parameter list serves two purposes.  When adding a user id, the
      parameter list defines valid directory paths.  A valid directory path
      is any path containing a file in the parameter list.

      The parameter list also defines which files are never sent or
      received by the VCM System.  For our example, press [Enter].


      Note:  Like the file extension list, all files in the list must be
      comma delimited.






                                     - Page 9 -







                                   System Startup


      The screen should be complete.  Since "TEMP" is a new user-id, you
      will be asked if you wish to add your user-id.  Press [Y].  You will
      then be given the default VCM root directory.  For our example, press
      [Enter].  This directory, and all sub-directories (with any file
      defined in the parameter list), will be assigned to the user-id
      "TEMP".  You should then see the following screen:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                      (c) 1992 Dennis Allen, All rights reserved
                               Host User ID is TEMP
       -----------------------  M A I N    M E N U -----------------------
      |                                                                    |
                           1 - Retrieve HOST.ZIP File
                           2 - Create REMOTE.ZIP File
                           E - Create/Maintain Edit Files
                           P - Print Reports
                           S - System Setup (Query)
                           U - Utilities
                           C - Change User ID
                           Q - Quit this program
      |                                                                    |
      |--------------------------------------------------------------------|
                                Make a selection:
      +--------------------------------------------------------------------+


      This is our main menu.  Option '1' deals with HOST.ZIP.  On a remote
      machine, you may create HOST.ZIP.  On a host machine, option '1'
      retrieves HOST.ZIP (if it exists in the communication directory).

      Option '2' deals with REMOTE.ZIP.  On a host machine, you may create
      REMOTE.ZIP.  On a remote machine, option '2' will retrieve REMOTE.ZIP
      (if it exists in the communication directory).

      Option 'E' allows you to create and maintain all Edit file.  Option
      'P' will print reports.  Option 'S' allows you to change printer
      codes and system defaults.  Option 'U' contain miscellaneous options
      that allow the user to maintain VCM.  Option 'C' allows you to change
      the current user-id (without having to exit the VCM System).  Option
      'Q' will return you to the DOS prompt.


      Note:  The VCM System is strictly a single-user application.  There
      can be only one person using it, at one time.


      There are a couple of ways to select an option.  One way is to simply
      press the highlighted key, (example: press [S] for system setup).
      Another way is to press the up and down cursor keys to highlight the
      desired option.  Then, by pressing [Enter], the highlighted option is
      selected.


                                     - Page 10 -







                                   System Startup


      Note:  If you have a mouse, you can move the mouse cursor to the
      desired option.  Pressing the left mouse button will then select the
      option.


                               Creating REMOTE.ZIP



      The next step is to create REMOTE.ZIP.  At the main menu, press [2].
      There will be a wait window.  Press any key to create REMOTE.ZIP (or
      [Esc] to abort).  Our REMOTE.ZIP will be created in the communication
      directory and will contain all the directories assigned to the user-
      id "TEMP".  When finished, press [Q] to quit to DOS.


                                 Remote Start-up


      At this point, we would use our PC-to-PC package to send REMOTE.ZIP
      to the remote machine and logoff.  But for our session, assume we did
      that already.  Now, at the DOS prompt, type:


                REMOTE TEMP


      and press [Enter].  Normally, at this point, we would get a "User ID:
      TEMP not found.  Retrieve remote.zip file?" prompt and we would
      answer [Y].  But since "TEMP" already exists in our VCM System, we
      are given the main menu.  So press [2] to retrieve the REMOTE.ZIP.

      This is the first time we're using this user-id on a remote system.
      So we will get an error message "Missing VCM Paths.  Please update
      and try again.".  Don't panic.

      The VCM System has only three database files:  VCMPATH.DBF, VCM.DBF,
      and VCMHIST.DBF.  VCMPATH.DBF stores a user identification number and
      all file paths assigned to that user-id.  VCM.DBF stores all file
      path, names, dates, and times.  VCMHIST.DBF simply stores a history
      of changes to VCM.DBF.

      VCMPATH.DBF not only contains the host's list of file directories,
      but the remote's corresponding list of directories.  In other words,
      the host can have a 'C:\VCM' system that updates the remote's
      'D:\VCM' system.

      We got an error message because we haven't yet defined the remote's
      corresponding directories.  So, at the main menu, press [E].  You
      should see the following screen:





                                     - Page 11 -







                                   System Startup


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                      (c) 1992 Dennis Allen, All rights reserved
                               Remote User ID is TEMP
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Edit VCM File
                          2 - Edit VCM History File
                          3 - Edit VCM Path File
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      This is the edit menu.  Here, all components of the VCM System can be
      maintained.  Option '1' will allow you to maintain VCM.DBF.  Option
      '2' will allow you to maintain VCMHIST.DBF.  Option '3' will allow
      you to maintain VCMPATH.DBF.  Option 'Q' will return you to the main
      menu.

      Before continuing, notice that the edit window is slightly smaller
      than the main menu window.  This is a built-in feature.  This feature
      allows the user to see how far he/she is into the program.  It is
      intended to give the user a sense of depth.


                               Updating VCM Paths


      Updating VCM Path records is simple.  At the edit menu, press [3].
      The following screen will appear:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                      (c) 1992 Dennis Allen, All rights reserved
                               Remote User ID is TEMP
       -------------------------- VCM Path File -------------------------
      |                                                                    |
           User ID: TEMP
      |                                                                    |
           File Path       : C:\VCM\          ZIP Allowed:   Y
      |                                                                    |
           Remote File Path:  :\VCM\          ZIP Allowed:   Y
      |                                                                    |
      |--------------------------------------------------------------------|
              Toggle Index (File Path)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+



                                     - Page 12 -







                                   System Startup


      This screen is typical of a generic editor used with Foxpro.  At the
      bottom of the screen are all the one-character options available to
      the user.

      Like the main menu, there are three ways of selecting a function.  By
      direct keystroke, by the cursor keys and [Enter], or by the mouse.
      Before continuing, we will briefly describe each function.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.
      Whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the Enter key,
      moves the cursor forward one field at a time.  The up arrow moves the
      cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.

      The [Home] key will move the cursor to the beginning of a field.  If
      it is already there, [Home] will move the cursor to the first field
      in the screen.  [End] will move the cursor to the end of the field.
      If it is already there, [End] will move the cursor to the last field
      in the screen.

      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

      Note:  If you have a mouse, move the mouse cursor to the desired
      field.  Press the right mouse button, once to move to the field, and
      once for the help text.

      After you have entered your data, moving the cursor beyond the last
      input field on the screen tells the editor to accept the record.  You
      can either use the arrow keys to move the cursor, or press [F10].
      [Esc] will abort any updating, returning the screen to its original
      condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit on one
      screen.  You use the arrow keys to move from record to record.
      Pressing [F10] will return you to the edit screen.  The browse
      function is explained in more detail in Appendix A.




                                     - Page 13 -







                                   System Startup


                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is a quick
      way of finding a desired record.  Since the current database is
      indexed by file path, this option will prompt you for the host's file
      path.  Type the desired path and press [Enter].  If found, the
      desired record will be displayed.  You could then delete it, or
      update it.

                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      The goto window remains active until you press [Esc] or [Q] to quit.
      The goto function is explained in more detail in Appendix A.

                                  Help Function

      Pressing [H] will display a summary of commands used in the edit
      menu.  Pressing any key after that returns you to the edit menu.

                              Toggle Index Function

      For a database with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

      For example, if the current index is by host file path, pressing [T]
      will change the current index to the remote's file path.  Upon
      pressing [F], the user will be prompted for the remote's file path.
      Pressing [T], repeatedly, will eventually return you to the host's
      file path.

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by last
      name, then 'ALPHA' will come after 'BETA'.  Pressing [O] again will
      change the current index back to ascending.




                                     - Page 14 -







                                   System Startup


                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, pressing [F10] will complete the update.
      Pressing [Esc] will abort the update.

                                  Quit Function

      Finally, pressing [Q] will return you the menu that invoked the
      editor.  For more information on the capabilities of this type of
      editor, see Appendix A.


                           Updating a VCM Path Record


      Now that you have an idea how the editor works, you can update the
      current record.  Press [U] at the option prompt.

      The "file path" field is the host's file path and can only be edited
      on the host.  The host "ZIP Allowed" field indicates whether the host
      may send source code and whether the remote may receive source code1.

      The next field specifies the remote's file path, corresponding to the
      host file path.  This field MUST be complete.  For our session, type
      the same path as the host's file path and press [Enter].

      The remote "ZIP Allowed" field indicates whether the remote may send
      source code to the host and whether the host may receive source
      code2.

      The current record should be complete.  Since we needed to update
      only one record, press [Q] to quit.  From the edit menu, press [Q] to
      quit to the main menu.  Now that we have completed the directory
      information, press [2] to receive REMOTE.ZIP.  This time, the process
      of receiving should be without error.

      Note:  If you still get a "PATH not found", go back to the VCM Path
      editor and check your records.  All remote paths MUST exist.










      ____________________
      1 Note:  This field may only be updated by the host (security
      clearance).
      2 Note:  This field may only be updated by the host (security
      clearance).

                                     - Page 15 -







                                   System Startup


                                Creating HOST.ZIP


      The next step is to send a HOST.ZIP to the host.  If you have a
      client system, this will be the only time you need to send one.
      Press [1] to create a HOST.ZIP.  When complete, press [Q] to quit to
      the DOS prompt.


                                  Host Restart


      At this point, we would use our PC-to-PC package to log onto the host
      machine and send our HOST.ZIP.  But for our session, assume we did
      that already.  Now, at the DOS prompt, type:


                HOST TEMP


      and press [Enter].  At the main menu, press [1] to receive the
      HOST.ZIP.  At this point, each VCM System has been initialized.
      However, no source code has been sent.


                                Normal Operations


      Now we're ready to begin normal operations.  If we were on a host
      machine, separate from the remote, we would again press [2] to create
      REMOTE.ZIP.  REMOTE.ZIP would now contain all the source code the
      remote computer needed.  We would send REMOTE.ZIP to the remote
      machine, logoff, and receive REMOTE.ZIP from the remote's VCM System.

      But our session's host and remote machines are one and the same.  The
      remote machine, therefore, needs no source code from the host.  So
      REMOTE.ZIP would not contain source code.

      Well, we've installed the source code database for our host and
      remote machines.  If you wish, experiment sending and receiving ZIP
      files.  Or you may want to stay at the main menu for the next section
      in this manual.  We will be going over the VCM file editors.













                                     - Page 16 -







                               Maintaining VCM records


      From the main menu, press [E] for the edit menu.  You should see the
      following:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                      (c) 1992 Dennis Allen, All rights reserved
                               Host User ID is TEMP
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Edit VCM File
                          2 - Edit VCM History File
                          3 - Edit VCM Path File
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      This is the edit menu.  Here, all components of the VCM System can be
      maintained.

      The VCM System has only three database files:  VCMPATH.DBF, VCM.DBF,
      and VCMHIST.DBF.  VCMPATH.DBF stores file paths assignments.  VCM.DBF
      stores all file path, names, dates, and times.  VCMHIST.DBF simply
      stores a history of changes to VCM.DBF.

      Option '1' will allow you to maintain VCM.DBF.  Option '2' will allow
      you to maintain VCMHIST.DBF.  Option '3' will allow you to maintain
      VCMPATH.DBF.  Option 'Q' will return you to the main menu.


                                    ZIP Files


      When you create either REMOTE.ZIP or a HOST.ZIP, the VCM System
      searches through all the directories in VCMPATH.DBF.  All files found
      are listed in VCM.DBF.  Any file additions, deletions, or updates to
      VCM.DBF are logged into VCMHIST.DBF.  When you send/receive a ZIP
      file, a copy of VCM.DBF, VCMHIST.DBF, and VCMPATH.DBF are included.


      We have already looked at VCMPATH.DBF file editor.  Now let's take a
      look at the VCM.DBF editor.  At the edit menu, press [1].  You should
      see the following screen:








                                     - Page 17 -







                               Maintaining VCM records


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                      (c) 1992 Dennis Allen, All rights reserved
                               Host User ID is TEMP
       ------------------------ Edit VCM File ---------------------------
           User ID: TEMP
      |                                                                    |
           File Path       : C:\VCM\
      |                                                                    |
           Remote File Path: C:\VCM
      |                                                                    |
           File Name       : VCM.PRG
      |                                                                    |
           Date: 12/03/92                                12/03/92
           Time:  0:17:11                                 0:17:11
           Size:       1082 bytes                         1082 bytes
      |                                                                    |
           Type: H
      |--------------------------------------------------------------------|
              Toggle Index (File Path)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      You have the "user-id" and host "file path" fields, which comes from
      the host.  The "remote file path" field comes from the associated
      host "file path" in VCMPATH.DBF.  The "user-id", host "file path",
      and "file name" determine a unique record.  The "date", "time", and
      "size" fields determine if a file has been changed.  To the right of
      these fields are displayed the file's actual date, time, and size.

      The record "type" field indicates what action took place, the last
      time you created or received a ZIP.  The possible values are:


           F    -    File.  No action.
           D    -    Deleted.  File was removed from other VCM System.
           H    -    History.  File that has been updated.
           O    -    Out of Sync.  File is overwritten from host.
           U    -    Undefined.  File cannot be unzipped.


      If a file record is type "F" or "H", no problem.  Type "F" indicates
      nothing has occurred with this file, lately.  Type "H" indicates that
      the file has been updated, but not on both VCM Systems.

      If a file record is type "D", the file was deleted from other VCM
      System.  If you are on the remote, the file was deleted on host.  You
      will be prompted whether you wish to physically remove your copy.

      If a file record is type "O", you received a file from host.  If a
      file record is type "U", the file could not be unzipped on other
      machine (usually the host).  Let me explain.


                                     - Page 18 -







                               Maintaining VCM records


      The VCM System allows you to modify a file on the remote AND host at
      the same time.  Nothing prevents that.  However, the HOST machine has
      priority.

      Example:  Say that you and the host modify the same file, since the
      last time you were on the host.  If you try to send this file to the
      host, you will get a file type "U" and the file will not be unzipped.
      When you receive a ZIP from the host, your file will be overwritten
      with the host's file (file type "O").


      Note:  The VCM System does create backup copies of source code.
      These files will have a "$" file extension.  If you ever receive an
      out-of-sync file, simply use the backup copy to add your changes to
      the host's file.  Then send a new REMOTE.ZIP to the host.


      Well, that's the VCM.DBF file layout.  The edit functions are exactly
      the same as in the VCM Path editor.  The VCMHIST.DBF file layout is
      exactly the same.  Experiment, if you wish, in adding, updating, or
      browsing.  When finished, press [Q] to quit to the edit menu.


      Just remember:  Unless explicitly stated, a "file path" refers to the
      host's file path.


                                      Quit


      Well, that's all you need to know about the edit menu.  Later, you
      can experiment with finding, deleting, and updating records.  For
      now, simply press [Q] to return to the main menu.






















                                     - Page 19 -







                                   Print VCM Files


      In the first half of this manual we learned how to create a mailing
      list record.  Now we are going to learn how to print mailing labels.

      From the previous examples, you should now be at the main menu.  We
      will be printing a record, so make sure your printer is connected and
      on-line.  If not, you may wish to skip this section.  If your printer
      is ready, press [P].  You should see the following screen:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                      (c) 1992 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------- P R I N T    M E N U --------------------
      |                                                                    |
                           1 - Print VCM         Edit List
                           2 - Print VCM History Edit List
                           3 - Print VCM Path    Edit List
      |                                                                    |
                           Q - Return to main menu
      |                                                                    |
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      The menu is simple and self-explanatory.  Option '1' allows you to
      print an edit list of VCM.DBF.  Option '2' will print  an edit list
      of VCMHIST.DBF.    Option '3' will print an edit list of VCMPATH.DBF.
      Option 'Q' will return you to the main menu.


                         Printing VCM History Edit List


      Option '2', of the print menu, introduces the concept of the option
      grid.  The VCM History edit list will be your most often used report.
      This report will tell you what events occurred when a ZIP was sent or
      received.  At the print menu, press [2].  You should see the
      following screen:














                                     - Page 20 -







                                   Print VCM Files


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                    (c) 1992 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------ Print VCM File ---------------------------
      |                                                                    |
                File Path       :
      |                                                                    |
      |                                                                    |
                File Name       :
      |                                                                    |
                Date:   /  /
                Time:   :  :
                Size:
      |                                                                    |
                Type:
      |                                                                    |
                Index File :
                Index Order:
      |--------------------------------------------------------------------|
                  Print   Screen    Help   Update    Quit
      +--------------------------------------------------------------------+


      You are given an option grid.  The option grid will look like the VCM
      edit window.  The option grid prompts will determine what records
      will be printed and in what order.  For example, specifying "H" for
      type will print a listing of all files that were extracted from the
      last ZIP.

      Most fields provide this wild-carding technique.  The exception is
      the date field.  An file date of "01/01/91", for example, will print
      only those files have been updated since January 1, 1991.

      From this option grid, you are also allowed to select the index file
      and index order.  These fields are the push button equivalent to the
      toggle index/toggle order found in the VCM history editor.

      Press [F10] to complete the option grid.  You will be given a menu of
      choices, depending on the report.  You can press [U] to update the
      option grid.  You can press [H] for help, or press [Q] to quit to the
      print menu.

      Pressing [S] for screen mode, or [P] for print mode, will start
      creating a print file.  During this operation, you can abort by
      pressing [Esc].

      If you pressed [S], you will see the report displayed upon the
      screen.  Press [Pgup] or [Pgdn] to view the report.  Press [Esc] or
      [F10] to return to the option grid.

      Pressing [P] will copy the report to the printer.  When you are
      finished, press [Q] to return to the print menu.


                                     - Page 21 -







                                   Print VCM Files


      Note:  If you need to adjust the printer device or printer controls,
      use option S of the main menu.  See System setup.


                                      Quit


      Options '1' of the print menu all provide the same prompts as option
      '2'.  Option '3' provides an option grid, similar in layout to option
      '3' of the edit menu.  When you have experimented enough, press [Q]
      at the print menu to return to the main menu.












































                                     - Page 22 -







                                    System Setup


      Option 'S' of the main menu offers several facilities.  Among them,
      the ability to change printer control codes.  Upon pressing [S] at
      the main menu, you should see the following:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                       (c) 1992 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  S Y S T E M   S E T U P  ---------------------
      |                                                                    |
                           1 - Edit Expression Builder
                           2 - Edit Printer Control Codes
                           3 - Change Color Set
                           4 - Problems & Suggestions
                           5 - All about...
                           6 - Edit Data Path/File Names
      |                                                                    |
                           M - Display/Print Manual
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option '1' will invoke the expression builder.  The expression
      builder creates a record filter.  A record filter defines those
      records that can be viewed, edited, and printed.

      Option '2' allows you to change printer control codes.  It also
      allows you to change mailing label dimensions.

      Option '3' will allow you to change the current color set.  If you
      don't like the colors used by VCM, this option lets you change them.

      Option '4' will allow you to leave a message to the application
      author.  Messages can point out a problem or can offer a suggestion.

      Option '5' will display status information about this application.
      What version of Foxpro is running and about much memory is available.

      Option '6' allows you to define the default VCM System startup
      values.

      Option 'M' allows you to display and/or print the user manual.
      Option 'Q' returns you to the main menu.







                                     - Page 23 -







                                    System Setup


                               Expression Builder


      The expression builder allows you to select a record filter from a
      list of record filters.  A record filter defines those records in a
      database that can be viewed, edited, or printed.  The record filter
      is in effect only while your application is running.  Filters can be
      redefined as often as desired.

      At the system setup menu, press [1].  Upon entry, you are given a
      list of existing record filters.  Chose an existing filter.  For
      example, move the cursor to the filter named "History".  Press
      [Enter].  The filter "History" is now active and will allow you to
      view only VCM.DBF and VCMHIST.DBF records with type "H".

      You also might want to create a record filter.  At the system setup
      menu, press [1].  Press [F10] for the menu and press "N" to create an
      expression.  Enter "Deleted" for the name of your expression.  You
      will be given a choice of the custom expression builder, or the
      Foxpro expression builder.  Unless you know how to use the Foxpro
      expression builder, select the custom builder.

      You will be given a popup list of available field names.  Select the
      field "Type".  The next popup will display the action that can be
      taken on "Type".  Select the popup "Contains".  Now you will be
      prompted for a character string.  Type "D" and press [Enter].

      The record filter is displayed.  You may add, delete, or edit phrases
      in the expression.  But just press [F10] to accept the current one.

      That's all there is to it!  You've created a filter that views only
      records of deleted files.  Press [Enter] to select the filter.  You
      will be returned to the system setup menu.  If you don't want to use
      this filter, simply return to the expression builder and press [Esc]
      to abort.




















                                     - Page 24 -







                                    System Setup


                              Printer Control Codes


      At the setup menu, press [2].  The following screen will be
      displayed:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                      (c) 1992 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------- S Y S T E M   S E T U P ---------------------
      |                                                                    |
                     Printer Name         : Default
                     Printer Device       : PRN
                     Printer Default      : CHR(27)+"@"
                     Printer 10 cpi       :
                     Printer 12 cpi       :
                     Printer Condense On  :
                     Printer Bold      On :
                     Printer Bold      Off:
                     Printer Underline On :
                     Printer Underline Off:
      |                                                                    |
                     Number of Straight Lines/Page:
                     Number of Sideways Lines/Page:
      |                                                                    |
                     Print in Draft mode?
      |--------------------------------------------------------------------|
               Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+

                                  Printer Name


      The printer name is simply identifies the current configuration.  If
      the database P_CODES.DBF is available, you may press [F1] for a list
      of all available printers.  A selection changes all printer codes to
      the selected printer.  Press [F10] to complete the screen.

                                 Printer Device

      The printer device defines where output is to be sent.  Typically,
      you would use LPT1 or LPT2.











                                     - Page 25 -







                                    System Setup


                                  Printer Codes

      If you have an 80 column printer, define the control codes required
      by your printer to invoke compressed printing.  These control codes
      are sometimes referred to as 16.7 or 17 characters per inch.  Also
      define the control codes required to cancel condensed printing.
      These control codes are sometimes referred to as the default.  VCM
      will use these codes for reports normally requiring a 132 column
      printer.  Printer control codes are specified with dBASE expressions
      such as:

      CHR(27) + CHR(64)

      or:


      CHR(27) + '@'

      In general, most printer manuals give printer control strings as
      BASIC programming statements using the BASIC function CHR$().  The
      dBASE CHR() function is identical, so simply removing the "$" sign
      from the examples in your printer manual should do the job.

      Note:  If you press [F1], you will see a browse popup of available
      printers.  Simply select your printer and press [Enter].  All printer
      codes will be converted to the selected printer.

                             Straight lines per page

      To this day, there are some printers that do not accept form feeds.
      So rather than asking for form feed code, VCM asks for the number of
      lines per page.  Most printers use 66 lines.  Laser printers usually
      need 57 lines.

                                    Sideways

      It is sometimes necessary to print large reports using a sideways
      print utility.  So in case it is ever needed, the system setup
      prompts for the number of lines to print sideways.  For an 80 column
      printer, use 53 lines. For a 132 column printer, use 90 lines.

                                   Draft mode

      A report option grid creates a report file.  From the option grid,
      there are two ways to print this file:  Regular mode and draft mode.
      In regular mode the report file is read and printed, one line at a
      time.  The user may press [Esc] to abort.  If the printer becomes
      off-line, the user can usually restart at the point of interruption.

      In draft mode, the report file is copied directly to the print
      device.  In MS-DOS windows, draft mode will bypass the print spooler.
      Draft mode, however, does not allow the user to press [Esc] or nor
      does it allow the user to restart a print job.


                                     - Page 26 -







                                    System Setup


      The mode you use depend on your needs.  Regular mode is the most
      reliable method.  Under MS-DOS windows, draft mode is the quickest.


                                Change Color Set


      A Foxpro color set defines all color attributes used by this
      application.  Upon pressing [3] at the system setup, a popup menu
      will display all the different color sets available.  These color
      sets reside within the Foxpro resource file (FOXUSER.DBF).  Use the
      cursor keys to highlight the desired color set.  Then, select by
      pressing [Enter].

                             Customizing Color Sets


      A new feature has been added to the color selector.  The user now has
      the ability to customize colors.  Once a color has been selected, the
      color selector will search for a second Foxpro resource file
      (FOXUSER2.DBF).  In this file, color sets are stored in ASCII text
      format.

      If you are a system administrator, you will be prompted whether to
      edit the ASCII text of your selected color set.  The text layout is
      simple.  Twelve lines for the twelve color schemes used by this
      application.  Each line contain ten color pairs.  A color pair
      "W*/B+", for example, would denote a white foreground, blue
      background ("*" denotes blinking and "+" denotes intensity).  For a
      description of color pairs used within a scheme, check the color
      picker portion of the Foxpro manual.

      Experiment with different color sets.  Note that the top of the
      screen may not change color until you exit and reenter the
      application.  Be warned, however.  The color set becomes permanent
      until the next time you select a different color.

      Note:  The second Foxpro resource file can only be created and edited
      by the system administrator.


                             Problems & Suggestions


      Upon pressing [4], you will be presented with a memo window.  Type
      any message you wish to leave the application programmer.  Press
      [F10] to complete the message, or [Esc] to abort.  Your message will
      be placed in the Foxpro error file (FOXERR.DBF).

      If you have already created messages, you may wish to modify them.  A
      browse, indicating the date and time of each message, will be
      displayed.  Select the desired message record.  Then, press [Ctrl]-
      [Pgdn] to expand the message window.


                                     - Page 27 -







                                    System Setup



                                  All About...


      Option '5', of the system menu, will display status information about
      this application.  What version of Foxpro is running, about much
      memory is available, and the different kinds of application modes
      (Multi-user, debug, system administration).  This option will also
      tell you how the various data paths are defined.


                            Edit Data Path/File Names



      Upon pressing '6', at the system menu, you will be presented with the
      following screen:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                       (c) 1992 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------- Data Path/File Names -----------------------
      |                                                                    |
                ZIP file Data Path        : C:\ANYWHERE\
                New User Root Directory   : C:\VCM\
      |                                                                    |
                Version Control Extension : VER
                Translated File Extension : PRG
                Other Valid    Extensions :
                Parameter File List       :
      |                                                                    |
      |--------------------------------------------------------------------|
                Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+


      This screen defines the default VCM settings.  The first field
      defines the communication application directory.  This is where your
      ZIP files are sent and received.

      The next field defines the default root directory.  When you add a
      user id, you will be prompted with this path.  This directory, and
      all sub-directories, will be assigned to the new user-id.


                                 Version Control

      The next two fields relate to version control.  The first field
      defines your version control extension.  The second field defines the
      translated (executable) file extension.



                                     - Page 28 -







                                    System Setup


      In the VCM System, version control source code must reside in sub-
      directories of translated source code.  In this way, the VCM System
      doesn't have to send duplicate and unnecessary files.  If you don't
      want to use version control, simply leave these two fields blank.

      The next field defines the list of valid file extensions.  Any file,
      not defined in the list, is ignored by the VCM System.


      Note:  "   " is considered a valid file extension, but it must be
      defined first in the list.  All extensions in the list must be comma
      delimited.


      The last field on our default screen defines the parameter list.  The
      parameter list serves two purposes.  When adding a user id, the
      parameter list defines valid directory paths.  A valid directory path
      is any path containing a parameter list file.

      The parameter list also defines which files are to be ignored by the
      VCM System.  Like the file extension list, all files in the list must
      be comma delimited.

      For our example, press [Esc] to abort this screen.  You will be
      returned to the system menu.


                              Display/Print Manual



      Option 'M', of the system menu, will display the user manual.  You
      may use [PgUp] or [PgDn] to view various pages.  You may print the
      entire user manual by pressing [Alt]-P].  Press [Esc] to return to
      the system setup menu.


                                      Quit


      Before leaving the system setup menu, a reminder.  Record filters
      remain in effect only for the duration of the application.  Color
      sets and printer control codes, on the other hand, are permanent.
      When you have experimented enough, press [Q] at the system setup menu
      to return to the main menu.










                                     - Page 29 -







                                      Utilities


      Option 'U' of the main menu provides the miscellaneous options needed
      to maintain the mailing list system.  Upon pressing [U] at the main
      menu, you should see the following:


      +--------------------------------------------------------------------+
                    Version Control & Maintenance, Version 02.00.00
                       (c) 1992 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  U T I L I T Y    M E N U ---------------------
      |                                                                    |
                           1 - Create/Update VCMPATH file
                           2 - Create new VCM file
                           3 - RollBack   VCM file
      |                                                                    |
                           4 - Verify source  code
                           5 - Verify Version code
      |                                                                    |
                           A - Rebuild indices
                           B - Initialize Databases
                           C - Purge Backup.$$$ files
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option '1' will create a new set of file directories.  Option '2'
      will create a new set of VCM file records, without actually creating
      a new ZIP file.  Option '3' allows you to rollback what was done in
      option '2'.

      Option '4' allows you to verify translated files against your version
      control files.  Option '5' will show you which files have been
      updated recently.

      Option 'A' reconstructs all system indices in the event of a crash or
      other strange system behavior.  Option 'A' also removes deleted
      records, thereby reclaiming disk space.

      Option 'B' will allow you to reset any or all database files in the
      VCM System.  Option 'C' will allow you to remove all VCM System
      backup files.  Option 'Q' will return you to the main menu.

      Note:  Option '1' is only available on the host.  Option 'B' is only
      available to the system administrator.  See Appendix D.







                                     - Page 30 -







                                      Utilities


                           Create/Update VCM Path File


      When you create a new user-id, a set of file directories are assigned
      to that user-id.  Option '1' allows you to either assign a new set of
      file directories, or append to your existing set, to the current
      user-id.

      Upon pressing [1], at the utility menu, you will be prompted for the
      root directory.  You are then prompted whether you wish to append to
      the existing directory list.  Answering 'no' will remove the existing
      directory list.  The specified directory, and all sub-directories
      (with any file defined in the parameter list), will then be assigned
      to the current user-id.  You will be returned to the utility menu.


                               Create new VCM File


      When you create a ZIP file, either on the host or on the remote, a
      new set of records are created in VCM.DBF.  Any changes in VCM.DBF
      are recorded in VCMHIST.DBF.  Option '1' does the very same
      procedure.  Actually, it IS the same procedure.  However, no ZIP file
      is created.


                                Rollback VCM File


      Let's say, for example, you created a REMOTE.ZIP and tried to send it
      to the host.  In the process your computer locks up and trashed the
      REMOTE.ZIP.  In such an event, use option '3' of the utility menu.

      Option '3' simply moves the records, found in VCMHIST.DBF, to
      VCM.DBF.  In effect, this option returns the state of your VCM System
      to where it was before you sent the ZIP file.


                               Verify Source code


      Upon pressing [4], at the utility menu, all version control files and
      all translated files are checked.  A report will be displayed.  In
      this report the first comment line of each file, beginning with "*"
      and containing "version", will be displayed.  You can then determine
      if your translated code is up to date with your version control code.

      Use [PgUp] or [PgDn] to scroll through this report.  Upon press
      [Esc], whether you wish to print this report.  You are then returned
      to the utility menu.





                                     - Page 31 -







                                      Utilities


                               Verify Version code


      Upon pressing [5], at the utility menu, all version control files are
      checked.  You will be prompted for the parameter file name and the
      parameter date.  A report will be displayed.  In this report, the
      first comment line, beginning with "*", containing the specified
      parameter name, and a date greater than or equal to the parameter
      date, will be displayed.  You can then determine which files you
      recently worked on.

      Use [PgUp] or [PgDn] to scroll through this report.  Upon press
      [Esc], whether you wish to print this report.  You are then returned
      to the utility menu.


                               Rebuilding Indices


      Option 'A' of the utility menu will reconstruct all system indices in
      the event of a crash or other strange system behavior.  You will be
      prompted whether to continue.  Upon pressing [Y], all indices will be
      rebuilt.  Option 'A' also removes deleted records, thereby reclaiming
      disk space.  You will then be returned to the utility menu.


                             Initializing Databases


      Option 'B' of the utility menu will allow you to "reset" any or all
      database files in the VCM System by removing all data from them.  You
      probably will want to use this option after completing the sample
      entries and exercises in this manual, so you can begin fresh with
      "real" data.

      Upon press [B] at the utility menu, you will be prompted whether to
      reset each database file, one at a time.  You will then be returned
      to the utility menu1.














      ____________________
      1 System Administration function only.  See Appendix D.

                                     - Page 32 -







                                      Utilities


                             Purge Backup.$$$ files


      Whenever source code is received, the VCM System will make backup
      copies of existing files.  Example:  The VCM System would create
      "DP.PR$" as a backup of "DP.PRG".

      Option 'C', of the utility menu, simply deletes backup files.  Any
      file, with a file extension "$", are removed from any directory
      assigned to the current user-id.

      Well, that's it for the utility menu.  When you have experimented
      enough, press [Q] at the utility menu to return to the main menu.










































                                     - Page 33 -







                                     Quit to DOS


      Once you have returned to the main menu, press [Q] to return to the
      DOS ready.  It is VERY important that you do not leave the VCM System
      without returning to DOS.  NEVER turn off the machine while in the
      VCM System.  Doing so may result in file corruption and lots of
      headaches to us developers.

      This concludes the system overview.  If you wish to know more about
      the mailing list editor, or any other editor in the VCM System, see
      Appendix A.  If you wish to know about the file layouts, see Appendix
      B.  If you ever see the infamous error message "Ignore, Retry,
      Suspend, or Quit", see Appendix C.












































                                     - Page 34 -







                                     Appendix A


      This section describes all characteristics, in detail, of the generic
      editor used in this type of Foxpro application.  While this editor
      may be customized for many applications, all share common functions.
      Thus, to learn one version is to know another version.

      This type of Foxpro application usually has an edit menu.  This menu
      allows the user to invoke one or more editors.  The following is an
      example of the edit menu used in the dMAIL4 System:


      +--------------------------------------------------------------------+
                          Mailing List, Version 03.05.00
                    (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Edit Mailing List
                          2 - Edit User IDs
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      In this edit menu, the user has the option to use two editors.  Each
      editor allows the user to maintain separate, but related, databases
      in the dMAIL4 System.  While we really don't need to go any further,
      but it is good to know where most editors are invoked.

      Once a generic editor is invoked, its window will be displayed.  The
      window consists of a window title, field descriptions, and all fields
      of the database record that happens to be current.  A menu window is
      also displayed.  The menu window contains all the one-character
      options available to the user.  The following is a sample screen of
      the mailing list editor used in the dMAIL4 System:


















                                     - Page 35 -







                                     Appendix A


      +--------------------------------------------------------------------+
                            Mailing List, Version 03.05.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------------- Mailing List --------------------------
       User ID:
       First Name:                       Last:
                  Billing                Shipping
       Address 1 :
       Address 2 :
       City/State:
       Zip Code  :
       Sex:          Status:             Head of HouseHold:
       Home: (  )    -                   Birth:
       Work: (  )    -                   Wedding:
       Soc.Sec. #:   -  -                Active Date:
            [ ] MS-DOS    +------------ Message Memo -------------+
            [ ] CP/M      |                                       |
            [ ] TRSDOS    |                                       |
                          +---------------------------------------+
      |--------------------------------------------------------------------|
              Toggle Index (Last Name)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      All editors have the same basic functions.  Before continuing, we
      will describe each function in detail.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.  Now
      whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the [Enter] key,
      moves the cursor forward one field at a time.  The left arrow and up
      arrow will move the cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.

      The [Home] key will move the cursor to the beginning of a field.  If
      the cursor is already there, [Home] will move the cursor to the first
      field in the screen.  The [End] key will move the cursor to the end
      of the field.  If the cursor is already there, [End] will move the
      cursor to the last field in the screen.

      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

                                     - Page 36 -







                                     Appendix A



      Note: By pressing [F1] (then [F10] if there is help text), you may
      invoke another Foxpro editor.  If the current input field is
      validated against another file, the editor of that file will appear.
      Use the Goto option to display the desired record.  Then press [Q] to
      quit.  Your input field will be filled with the corresponding field
      in the chosen record.

      Pressing [Ctrl]-[Home] will repeat the last text that was displayed
      in the current field.  This function provides a convenient means of
      adding many records with similar field descriptions.

      Once you have entered your data, moving the cursor beyond the last
      field on the screen tells the editor to accept the record.  Pressing
      [F10] also will tell the editor to accept the record.  You would then
      be prompted to add another record.  The [Esc] key will abort the add
      function, returning the screen to its original condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit in one
      window.  You can use the left arrow, right arrow, [Tab], and [Shift]-
      [Tab] keys to move the cursor from field to field.  You can move from
      record to record with the up and down arrow keys.  You use the page
      up/down keys to display the next/previous window of records in the
      current database.

      If you have a mouse, you also can use the characters located on the
      right side of the window.  Place the mouse cursor on the up/down
      arrow characters and press the left button to move one record at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position you in
      the database.

      Mouse Note:  After you found the record you want, place the mouse
      cursor on the record and press the left button.  Otherwise, the first
      time you try to update a record will put you back to the last record
      displayed before using the mouse.

      If there are more fields than can be displayed in one window,
      pressing [TAB] will scroll to the next field.  Pressing [Shift]-[TAB]
      will scroll back one field.

      If you have a mouse, you also may use the characters located across
      the bottom of the window.  Place the mouse cursor on the left/right
      arrow characters and press the left button to move one field at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position the
      fields displayed in the database.



                                     - Page 37 -







                                     Appendix A


      Mouse Note:  After you found the field you want, place the mouse
      cursor on the field and press the left button.  Otherwise, the first
      time you try to update a field will put you back to the last field
      displayed before using the mouse.

      In the browse function you may edit any field as desired.  Press
      [Ctrl]-[N] to add a record from the browse.  Press [Ctrl]-[T] to
      delete the current record from the browse.  When finished, press
      [F10] to return to the edit menu.  Pressing [Esc] also will return
      you to the edit menu, but it will abort any change to the current
      record.

      Note:  The JKEY incremental search has recently been added to the
      browse command.  When performing a browse, press [Ctrl]-[J] to
      activate JKEY.  A search will begin on the current index.  Each new
      keystroke will be added to the search string and the record, closest
      matching to the current string, will be displayed.  You may press
      [BackSpace] to revise the search string, or press [Ctrl]-[Y] to clear
      it.  To abort JKEY, simply press [Ctrl]-[J] once again (or [Esc] to
      abort the browse).

                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is only
      available if a database is indexed.

      If invoked, you would type the key of the desired record, and press
      [Enter].  If found, the record would be displayed.  You could then
      delete it, or update it.


      Note:  The key doesn't have to be a complete description.  For
      incomplete keys, the find function will try to find the record with
      the closet matching key.

      Recently, wild-carding has been introduced into the [F]ind function.
      For example, suppose we have a customer file.  It has an index by
      last name.  When the find function prompts us, we could type:

           Last Name:  ..ll..

      In this example, we are searching for a customer whose last name
      contain a "ll".  In another example:

           Last Name:  ..en

      We are searching for a customer whose last name ends with "en".  In
      one more example:

                                     - Page 38 -







                                     Appendix A



           Last Name:  al..

      We are searching for a customer whose last name begins with "al".

      Here's where wild-carding get interesting.  Let's use the first
      example.  Say we find a customer whose last name contains a "ll".  If
      we use the [G]oto function, we get an extra option.  This option,
      called [C]ontinue, will allow us to find the next customer whose last
      name contains a "ll".

      The continue option will remain in effect until you perform another
      find.  It will search for the next wild-card occurrence no matter
      where you are in the database.  In that sense, think of wild-carding
      as an implicit record filter.

      Oh, a new feature has been added to wild-carding:  The triple period
      "...".  Like the double period "..", the triple period denotes wild-
      carding.  Using the triple, however, will also disable the current
      index during the search.

      You see, wild-card searches are a LOT faster when done on an
      unordered database.  So if you are looking for just one record or two
      records, don't care about viewing order, and are using a huge
      database, the triple period might save you valuable time.

                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      The goto window remains active until you press [Esc] or [Q] to quit.

      If the current database is indexed, order is defined by the toggle
      order function.  For example, if the current record is customer 5,
      pressing [N] will display customer 6.  If the index order is
      descending, however, pressing [N] will display customer 4.  See
      toggle index order.

      A new option, [W] for window, has been added.  Pressing [W] activates
      the goto window.  The user may then move the goto window to any
      location on the screen.  That location remains in effect for the
      duration of the editor.

      To move the window, press [Ctrl]-[F7].  The goto window border will
      flash.  Press any cursor key to move the window.  Press [Ctrl]-[F7]
      to stop the window from flashing.  Then press [Esc] to resume the
      normal goto prompts.

      Note:  You also may use a mouse to move the goto window.  Press [W].
      Place the mouse cursor on the border of the goto window.  Press the
      left button.  Drag the mouse cursor (and window) to the desired
      location.  Then, press the right button to resume the goto prompts.

                                     - Page 39 -







                                     Appendix A



                                  Help Function

      Pressing [H] will display a summary of commands used in the edit menu
      as in the following screen.  Pressing any key after that returns you
      to the edit menu.


          Command prompt

          [T]oggle Index -  Change Index used by [F]ind command
          Toggle [O]rder -  Current Index in Ascending/Descending Order

          [A]dd        -  Add a record to the current database
          [B]rowse     -  List all records a page at a time
          [D]elete     -  Delete the currently displayed record
          [F]ind       -  Search database for record with specified key
          [G]oto       -  Display the First, Last, Next, or Previous record
          [H]elp       -  Display help information
          [R]ecall     -  Recall Deleted Records
          [U]pdate     -  Update the currently displayed record
          [Q]uit       -  Return to calling program

          Common full screen keystrokes

          [ESC]        -  Abort operation, return to prompt/menu
          [HOME]       -  move cursor to beginning field
          [END]        -  move cursor to ending field
          [CTRL][HOME] -  repeat last input field completed
          [CTRL][END]  -  Complete operation, return to prompt/menu
          [F1]         -  Display Help text/call another editor
          [F10]        -  Complete operation, return to prompt/menu























                                     - Page 40 -







                                     Appendix A



                                 Recall Function

      Pressing [R] allows you to recall a deleted record.  You will be
      presented with a browse window of all deleted records.  Simply locate
      the record to be recalled and press [Enter].

      Note:  If the current database has no deleted() index, you will be
      prompted for the record key (just like the find function).  Type the
      key of the record to be recalled and press [Enter].  If the deleted
      record is found, it is made active again.


                              Toggle Index Function

      For databases with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by last
      name, then 'ALPHA' will come after 'BETA'  Pressing [O] again will
      change the current index back to ascending.

                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, moving the cursor past the last field will
      complete the updating.  Pressing [Esc] will abort any update.

                                  Quit Function

      Finally, pressing [Q] will quit the editor.  You will be returned to
      the menu that invoked the editor.















                                     - Page 41 -







                                    Appendix A-1




      If you ever been on an input field, you may have noticed that
      pressing [Alt] displays a menu at the very top of the screen.  This
      is called the system menu, or sysmenu for short.  The system menu
      displayed is a customized version of the Foxpro sysmenu.  It contains
      a variety of functions and is available to all users.  The following
      describes only a few features available through the sysmenu.  For
      more information, see the Foxpro users manual.


                                  Sysmenu edit


      The sysmenu edit popup is very powerful.  It gives any input field a
      variety of edit functions.  For example, highlighting a section of
      text ([Shift] and cursor key) and pressing [Del] will delete this
      text.  But [Ctrl]-[C] would have copied this text into the clipboard.
      You would then use [Ctrl]-[V] to paste this text.

      Note:  The sysmenu edit popup provides a [Ctrl]-[U] option to undo a
      deletion, copy, cut, or paste.

      Another example:  Suppose you are editing a memo field.  The sysmenu
      edit popup provides a [Ctrl]-[F] option to find specified text.  This
      popup also provides a [Ctrl]-[G] option to repeat the last find.

      There are other functions in the sysmenu edit popup.  See the Foxpro
      users manual for details.


                                Foxpro Calculator


      Simply enter a numeric value on any input field.  Press [Alt]-[F4] to
      activate the Foxpro calculator.  The Foxpro calculator will display
      your numeric value.

      When you have a new calculated value, press [Ctrl]-[F4] to deactivate
      the calculator.  Your new numeric value will be placed into the
      current input field.

      Note:  If you just want the calculator, press [F4].  But you must be
      on an input field to invoke [F4].


                                 Foxpro Calendar


      Simply enter a date on any input field.  Press [Alt]-[F5] to invoke
      the Foxpro calendar.  The Foxpro calendar will display the year,
      month, and day of the specified date.



                                     - Page 42 -







                                    Appendix A-1


      Select any desired date.  When you have a new date, press [Ctrl]-[F5]
      will deactivate the calendar.  Your new date will be placed into the
      current input field.

      Note:  If you just want the calendar, press [F5].  But you must be on
      an input field to invoke [F5].


                                Foxpro DOS Shell


      In Foxpro for DOS, the system pulldown menu provides a DOS shell.  If
      you are a system administrator, pressing [Alt]-[S] [O] brings up the
      DOS command window.  Type any desired DOS command.  Type 'EXIT' and
      press [Enter] to leave the DOS shell.


                                  Printer Eject


      Press [F7] for a page eject.  A form feed will be sent to the printer
      device, specified in the System Setup.  Very useful for people with
      Laser Printers.

                                   Video Mode


      Press [Alt]-[V] for the video mode.  In Foxpro for DOS, a VGA screen
      will toggle between 25 and 43 line modes.  All subsequent windows
      will conform to the specified mode.  Very useful in displaying
      reports.

      In Foxpro for windows, [Alt]-[V] will display a font selector.  All
      sub-windows, to the current window, will conform to the specified
      font.  If you change the main menu window, the font becomes permanent
      to your application.

                                   Print Mode


      In Foxpro for windows, you can print a report with the current font.
      Send the report to the screen and use the 'Print' option of the
      'File' popup in sysmenu.  'Print' will print the entire contents of
      the current window, fonts and all.  Remember, however, that 'Print'
      will not use your printer codes.

      Note:  'Print' may not be available with the Foxpro for windows
      runtime unit.  To print font reports, obtain the developers copy of
      Foxpro for windows.






                                     - Page 43 -







                                      GLOSSARY


      ANSI  -  American National Standards Institute.  A standard for both
           screen output and keyboard input.

      Arrow Keys  -  Equivalent to cursor keys.  Those keys on the keyboard
           labeled with arrows.

      ASCII  -  American Standard Code for Information Interchange.  A
           standard 7 bit code used to represent data.

      Batch File  -  A file containing multiple DOS commands.  These
           commands are executed by DOS, one at a time, as if typed by the
           user.

      Byte  -  A unit of information.  In text form, equivalent to an ASCII
           character.

      Code  -  Program code.  Another way of saying program instructions.

      Compiler  -  A program that converts program code from one form to
           another, usually more primitive, form.  The converted code is
           then ready for execution.

      CONFIG.FP  -  The Foxpro configuration file.  This file tells Foxpro
           where is find the resource file.  On a network, there is a one
           copy for each Foxpro user.

      CONFIG.FPM  -  The Foxpro for Macintosh configuration file.

      CONFIG.FPW  -  The Foxpro for windows configuration file.

      Cursor  -  A flashing character on the screen.  It indicates where
           typed text will be next placed.

      Cursor Keys  -  Equivalent to arrow keys.  Those keys on the keyboard
           labeled with arrows.

      Data Dictionary  -  A database file that defines the input/output to
           database files in an application.

      dBASE  -  Popular database management language.  The software package
           dBASE III+ is an interpreter for dBASE code.

      dVERSION  -  A program that translates dBASE code, conditional upon
           specified parameters, into executable dBASE code.

      Disk  -  A unit where information is stored.  There are two major
           types: hard disk, and floppy disk.

      Disk Error  -  An error occurring when a program is unable to read or
           write properly to a disk.

      Diskspace  -  A unit of how much room is available on a drive.  It is
           usually measured in bytes.


                                     - Page 59 -







                                      GLOSSARY


      DOS  -  Disk Operating System.

      EMS  -  Refers to expanded memory.  Most 80286 computers have
           expanded memory.  80386 computers have extended memory.  There
           are, however, 80386 software drivers (QEMM for example), that
           can offer either extended or expanded memory.

      Extended  -  Extended memory.  80386 (or better) computers have
           extended memory.  The extended version of Foxpro needs at least
           three megabytes of extended memory.  The standard version of
           Foxpro requires expanded memory.

      Filespec  -  any DOS filename.ext including catalog names, passwords,
           etc.

      Floppy Disk  -  A self contained unit where information is stored.
           Depending on the type, floppy disks are easily transportable.
           Sometimes called a diskette.

      Foxbase  -   A dBASE III plus compatible language.

      Foxpro  -   A dBASE IV compatible language.

      FOXERR.DBF  -  The Foxpro error file.  Every major error event is
           recorded in this file.

      FOXUSER.DBF  -  The Foxpro resource file.  This file stores all the
           attributes of the user.  It also stores all the color sets
           available to Foxpro.  On a network, there is a one copy for each
           Foxpro user.

      Hard Disk  -  A self contained unit where information is stored.
           Usually not removable.

      HELP  -  A facility that provides on-line assistance in the use of a
           given program.

      Highlight  -  A form of a cursor, where an entire field is considered
           the cursor.

      Interpreter  -  A program that executes language code.  Whereas a
           compiler translates program code to executable code, an
           interpreter translates a single line of program code before
           executing it.

      Kilobyte  -  One kilobyte of memory equals 1,024 bytes.

      Megabyte  -  One megabyte of memory equals 1,024,000 bytes.

      Multi-user  -  When more one than one person is capable of
           accessing/updating the same database at the same time.  The VCM
           System, however, is strictly a single user application.

      MS-DOS  -  Microsoft Disk Operating System.

                                     - Page 60 -







                                      GLOSSARY



      PKZIP.EXE  -  PKWare's data compression utility.  Creates ZIP files.
           License for use within VCM.

      PKUNZIP.EXE  -  PKWare's data expansion utility.  Expands ZIP files.
           License for use within VCM.

      Sideways  -  A DOS Utility that will print text up and down instead
           of across the paper.

      Source Code  -  What a translator/compiler takes in as input.

      Syntax  -  The rules for the arrangement of statements in a
           programming language









































                                     - Page 61 -







                                        Index


      *.ESL  48                            Creating HOST.ZIP  16
      *.ESO  48                            Creating REMOTE.ZIP  11
      .BAT  44                             Cursor  36, 59
      .CDX  44                             Cursor Keys  59
      .DBF  44                             Customizing Color Sets  27
      .FPT  44                             DATA  52
      .FXP  44                             Data dictionary  44, 55, 59
      .PRG  44                             Database of source code  5
      [Alt]-[F4]  42                       DBASE  59
      [Alt]-[F5]  42                       DBASE IV  1
      [Alt]-[V]  43                        Delete Function  14, 38
      [Ctrl]-[F4]  42                      Disk  59
      [Ctrl]-[F5]  43                      Disk Error  59
      [Ctrl]-[Home]  37                    Disk Space  46
      [Ctrl]-[J]  38                       Diskspace  59
      [Ctrl]-[N]  38                       Display/Print Manual  29
      [Ctrl]-[T]  38                       DOS  5, 60
      [Ctrl]-[Y]  38                       Draft mode  26
      [End]  36                            DVERSION  9, 59
      [Esc]  37                            Edit Data Path/File Names  28
      [F1]  36                             Editor  5
      [F10]  38                            EMS  48, 50, 60
      [F4]  42                             Expanded  50
      [F5]  43                             Expression builder  5, 24
      [F7]  43                             Extended  1, 50, 60
      [Home]  36                           Filespec  60
      [Shift]-[TAB]  37                    Filter  23, 24
      [TAB]  37                            Find Function  14, 38
      Add Function  13, 36                 Floppy Disk  60
      All About...  28                     FONTNAME  53
      ANSI  56, 59                         FONTSIZE  53
      Appendix A  35                       FONTSTYLE  53
      Appendix A-1  42                     Foxbase  60
      Appendix B  44                       FOXERR.DBF  27, 44, 47, 60
      Appendix C  46                       Foxpro  1, 5, 60
      Appendix D  48                       Foxpro Calculator  42
      Arrow Keys  59                       Foxpro Calendar  42
      ASCII  59                            Foxpro DOS Shell  43
      BACK  45                             Foxpro for DOS  43
      Backup/Restore Data Files  45        Foxpro for windows  43, 50, 52,
      Batch File  59                           53
      Browse Function  13, 37              Foxpro runtime unit  8, 48
      Byte  59                             Foxpro runtime unit directory
      Change Color Set  27                     48
      Client Overview  7                   FOXPRO.INI  52
      Code  59                             FOXR.EXE  48
      Compiler  59                         FOXRUN  48
      CONFIG.FP  48, 49, 59                FOXRW.EXE  49
      CONFIG.FPM  59                       FOXSWAP.COM  48
      CONFIG.FPW  49, 50, 59               FOXUSER.DBF  27, 44, 57, 60
      Configuring Sideways  58             FOXUSER2.DBF  27, 57
      Copyright/License/Warranty  2        GLOSSARY  59
      Create new VCM File  31              Goto Function  14, 39
      Create/Update VCM Path File  31      Hard Disk  60

                                     - Page 62 -







                                        Index


      HELP  60                             Quit Function  15, 41
      Help Function  14, 40                Quit to DOS  34
      Highlight  60                        Ramdisk  56
      Host  7, 54                          Rebuilding Indices  32
      Host Restart  16                     RECALL  55
      Host Start-up  8                     Recall Function  41
      HOST.ZIP  7                          Record filter  5, 23, 24
      Index  62                            Record Filters  58
      INIT  54                             Regular mode  26
      Initializing Databases  32           Remote  7
      Interpreter  60                      Remote Start-up  11
      Introduction  5                      REMOTE.ZIP  7
      JKEY  38                             RESOURCE  51
      Kilobyte  60                         Resource directory  48
      Laser Printers  43                   Rollback VCM File  31
      LAST  54                             SCR.DBF  44
      LIM 4.0  50                          Security clearance  7
      Macintosh  6                         Sideways  26, 61
      Maintaining VCM records  17          SIDEWAYS.COM  58
      MANUAL  44                           SIDEWAYS.DFT  58
      Megabyte  60                         Source code  5, 61
      Megabytes  1                         Straight lines per page  26
      MEMLIMIT  50                         SWSETUP.COM  58
      Memo  27, 44                         Syntax  61
      MODE  46                             Syntax Error  47
      MS-DOS  1, 60                        Sysmenu  42, 55
      MULT  54                             Sysmenu edit  42
      Multi-user  60                       System administration  54
      Multi-User Errors  47                System administrator  8, 27, 43,
      Network  48, 54                          46
      Normal Operations  16                System Setup  23
      Notation Conventions  6              System Startup  7
      P_CODES.DBF  25                      TABLE OF CONTENTS  3
      PKUNZIP.EXE  61                      TEMP  56
      PKZIP.EXE  61                        TERM  56
      Preface  1                           TIME  51
      Print Mode  43                       Toggle Index Function  14, 41
      Print VCM Files  20                  Toggle Order Function  14, 41
      Printer Codes  26, 58                UNBACK  45
      Printer Control Codes  25            Update Function  15, 41
      Printer Device  25                   Updating a VCM Path Record  15
      Printer Eject  43                    Updating VCM Paths  12
      Printer Name  25                     User id  8
      Printer not Ready  46                User-id  5
      Printing VCM History Edit List       Utilities  30
          20                               VCM  1, 5
      Problems & Suggestions  27           VCM.DBF  44
      PROG  55                             VCMHIST.DBF  44
      Program files  5                     VCMPATH.DBF  44
      Programmer Overview  7               VCMSYS.MEM  44
      PROGWORK  50                         Verify Source code  31
      Purge Backup.$$$ files  33           Verify Version code  32
      Q*.*  44                             Version Control  9, 28
      Quit  19, 22, 29                     Video Mode  43

                                     - Page 63 -







                                        Index


      Wild-carding  38
      Window  5
      ZIP Files  17




















































                                     - Page 64 -



