



                                       Preface


        dVERSION is a dBASE text translator.  It was designed to give the
        dBASE programmer a facility to maintain dBASE code.

        dVERSION is a program that will conditionally translate dBASE code.
        dVERSION allows the programmer to have many versions of an
        application in one set of source code.  In addition, dVERSION offers
        an INCLUDE facility that can insert code from specified files.

        dVERSION is for the serious software developer.  Source code can be
        conditionally translated to many operating systems.  The INCLUDE
        facility provides more efficient use of disk space.

        dVERSION will work on most IBM personal computers.  No additional
        hardware is required.

        Although considerable effort was expended to make the user reference
        manual as complete as possible, this documentation is in no way to be
        considered an instructive guide to dBASE.  Many reference texts are
        available on the market that explain dBASE programming.  If you are
        learning dBASE, your reference materials should include one of these
        texts.

        My advice is to peruse the contents of this reference manual to
        familiarize yourself with its information.  If you are working on
        large projects or projects for more than one operating system,
        concentrate especially on the conditional translating.  You will
        probably need it at one time or another.

        If you have any questions concerning this application, feel free to
        write or call.

























                                     - Page 1 -







                             Copyright/License/Warranty




        This document and the program dVERSION ("the software") are
        copyrighted by the author.  The copyright owner hereby licenses you
        to use the software given these restrictions:


             o  the program shall be supplied in its original, unmodified
                form, which includes this documentation;

             o  for-profit use without a license is prohibited;

             o  the program may not be included - or bundled - with other
                goods or services.  Exceptions may be granted upon written
                request only.

             o  no fee is charged beyond a reasonable amount for the media
                and handling ($10 maximum suggested);


             There is no warranty of any kind.  The copyright owner may not
             be held liable for any damages, including any lost profits or
             other incidental or consequential damages arising out of or
             inability to use the software.  By using the software, you agree
             to this.


        Shareware

             dVERSION is distributed as Shareware.  It is not free software.
             You are free to try it and make copies for others.  If you
             continue to use this application beyond a reasonable trial
             period, you are required to register it with the distributor
             and author.


        ASP Ombudsman

             This program is produced by a member of the Association of
             Shareware Professionals (ASP).  ASP wants to make sure that the
             shareware principle works for you.  If you are unable to resolve
             a shareware-related problem with an ASP member by contacting the
             member directly, ASP may be able to help.  The ASP Ombudsman can
             help you resolve a dispute or problem with an ASP member, but
             does not provide technical support for members' products.

             Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
             MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
             via CompuServe Mail to ASP Ombudsman 70007,3536.



             Copyright (C) 1987 Dennis Allen.  All rights reserved.  All
             trademarks mentioned herein belong to their respective owners.

                                     - Page 2 -







                                  TABLE OF CONTENTS


        Preface                                                    1
        Copyright/License/Warranty                                 2
        Introduction                                               4
            Manual Content                                         4
            Notation Convention                                    5
        Getting Started                                            6
            Translating dVERSION code                              7
            Conditional Translating                                7
            Remarks                                                8
            INCLUDE\                                               8
        Advanced Techniques                                        9
            Command Line                                          10
            Automated                                             10
        dVERSION Reference Section                                11
            Part I/ dVERSION Commands                             11
                BLK Command                                       11
                CLEAR Command                                     12
                CLS                                               12
                HELP Command                                      12
                HLP Command                                       13
                IN Command                                        13
                LIST Command                                      14
                OUT Command                                       14
                PAR Command                                       14
                PARMS Command                                     15
                PMT Command                                       15
                QUIT Command                                      15
                REM Command                                       16
                REMOVE Command                                    16
                RUN Command                                       16
                SUF Command                                       17
                SYSTEM Command                                    17
            Part II/ dVERSION Reserved Words                      18
                - Conditional Translating -                       18
                - INCLUDE\ -                                      18
                - Remarks -                                       19
                - Macros -                                        19
            Part III/ dVERSION Error Messages                     20
            Part IV/ dVERSION Sample Output                       21
            Appendix A/ Data Files                                26
            Appendix B/ dVERSION Standards                        27
        Glossary                                                  28
        Index                                                     30












                                     - Page 3 -







                                    Introduction


        The purpose of dVERSION is to translate dBASE code, conditional upon
        specified parameters, into executable dBASE code.  It was designed to
        give the programmer a facility to maintain dBASE code.

        Before continuing, we should explain a couple of terms.  We mentioned
        earlier the concept of conditional translation.  Conditional
        translation means that only specified portions code will be
        translated into dBASE code.  Conditional translation allows many
        versions of a program to reside in one file.

        Source code refers to what a translator reads as input.  In other
        words, the input file.  Output code refers to what a translator
        creates from source code.  In other words, the resulting output file.

        This manual assumes that you are already familiar with dBASE terms.
        If not, refer to the Glossary or consult your dBASE reference manual.

        The dVERSION manual is divided into three main sections.  The first
        section explains how to get started using the dVERSION.  The second
        section explains how to specify wildcard filenames.  The third
        section is a dVERSION reference.  Each reference section gives
        detailed information on use of commands, code, and will show sample
        output.
































                                     - Page 4 -







                                    Introduction


                                Notation Conventions


        CAPITAL LETTERS

             Capital letters indicates a command.  During command entry, this
             text should be entered exactly as it appears.  Unless specified,
             any command may be in upper or lower-case letters.

        lower case

             Parameters to commands are usually typed in lower-case
             characters.

        Ellipsis "..."

             The ellipsis represent repetition of a previous item.

        Single Key "[ ]"

             The single key command is represented by the characters "[" and
             "]".

        Control keys

             Control keys are designated with a "[Ctrl]-" followed by the
             name of another key (for example: [Ctrl]-[S]).  To enter a
             control key, press [Ctrl] on your keyboard and, while holding it
             down, press the additional key.  On some Foxpro menus, control
             keys are designated with a "^" followed by the name of another
             key (for example: ^[End] for [Ctrl]-[End]).

        Carriage Return

             Depending on your keyboard, the same key may be represented by
             different descriptions.  For example, the carriage return may be
             represented as [Enter], [Return], or [Bent arrow symbol].  For
             the most part, this should not be a problem.  Make sure,
             however, that you understand the function of each key so that
             you understand how they appear in this manual.















                                     - Page 5 -







                                   Getting Started


        The purpose of this section is to help you get started using
        dVERSION.  To use dVERSION, at the DOS prompt, type:

             DVER

        and press [Enter].  The first thing you should see is the following:

             dVERSION 2.x for MS-DOS
             Copyright (c) 1987 by Dennis Allen
             Portions (C) Copyright
             Microsoft Corp. 1987 - 1993
             All Rights Reserved


             .

        "." is the dVERSION command prompt.  dVERSION is a command oriented
        program.  But do not confuse dVERSION commands with dBASE code.
        dVERSION commands set the parameters necessary to translate dBASE
        code.

        dVERSION commands are easy to use.  For instance, to exit dVERSION,
        you would type:


             QUIT


        and press [Enter].  If you needed help, you would type:


             HELP


        and press [Enter].

        The HELP command is provided to allow quick access to dVERSION topics
        listed in the reference section.  For example, to find more
        information on the HELP command you can either look it up in Part I
        of the dVERSION reference section, or type:


             HELP HELP_CMD


        and press [Enter].  If you typed "HELP HELP_CMD", a search would be
        made in the file DVER.HLP for the topic HELP_CMD.  If found, all
        information about that topic would be displayed.  For a summary of
        dVERSION help topics type:


             HELP TOPICS



                                     - Page 6 -







                                   Getting Started


        and press [Enter].


                              Translating dVERSION code


        Now let's set the parameters so dVERSION can translate code.  We
        first need to specify the file dVERSION will read as input.  Type:


             IN SAMPLE.VER


        and press [Enter].  If no error message appears, it means the input
        file was found, and verified.  If a message does appear, stay calm.
        Most of the time the input file was not found.  Check your spelling
        and try it again.

        Next, we need to specify an output file dVERSION will create.  Type:


             OUT SAMPLE.PRG


        and press [Enter].


                               Conditional Translating


        In the source file "SAMPLE.VER", we have sections of code bounded by
        the dVERSION reserved words IF\, and END\.  These sections of code
        will be translated depending on the PAR command.  In our example we
        will specify that only code, conditional upon the parameter DOS, be
        translated.  At the dVERSION prompt, type:


             PAR DOS


        and press [Enter].














                                     - Page 7 -







                                   Getting Started


                                       Remarks


        To remove leading spaces in output code, type:


             BLK ON


        and press [Enter].  To remove remarks in output code, type:


             REM ON


        and press [Enter].

        All other dVERSION commands need not be specified since they have
        default values.  So let's check our parameters.  Type IN and press
        [Enter].  IN should be set with "SAMPLE.VER".  If not, retype.  Type
        OUT and press [Enter].  OUT should be set to "SAMPLE.PRG".  Type PAR
        and press [Enter].  PAR should have the parameter "DOS".

        We now are ready to translate.  Type RUN and press [Enter].  Assuming
        that no errors occurred either in the typing of commands, or in the
        translating of code, you should have a file named "SAMPLE.PRG".  This
        file should be correctly translated.


                                      INCLUDE\


        You will notice in "SAMPLE.PRG" that additional code was inserted.
        If you look at the file "SAMPLE.VER" you will see the dVERSION
        reserved word:


             INCLUDE\ SAMPLE2.VER


        This dVERSION reserved word inserted the file "SAMPLE2.VER" into our
        sample output.  This reserved word can be very useful in saving
        repetitive typing and disk space.  If you are finished, type "QUIT"
        and press [Enter] to return to DOS.











                                     - Page 8 -







                                 Advanced Techniques


        The purpose of this section is to show you some of the more advanced
        dVERSION command and techniques.  At the DOS prompt, type:

             DVER

        and press [Enter].  In our last example, we typed "SAMPLE.VER" for
        the input file.  This time, type:


             IN *.VER


        and press [Enter].  This is a wildcard filename.  All files with a
        file extension "VER", will be converted.

        In the last example, we typed "SAMPLE.PRG" for the output file name.
        But since dVERSION v2.0, the output file name defaults to "*.PRG".
        This means that any output file will acquire the input file name and
        will have a "PRG" file extension.


        Example:  If the input file name is "SAMP.VER", the output file name
        will be "SAMP.PRG".


        Wildcarding also applies to directories.  If the IN command specifies
        "\TEMP\*.VER" all "VER" files, in the TEMP directory, will be
        processed.  If the OUT command is "TEMP2\*.TMP", any input file will
        be create a "TMP" file in the TEMP2 directory.


        In our last example, we typed in our conditional parameters using the
        PAR command.  But any dVERSION command can be stored in a dVERSION
        parameter file.  Type:


             PARMS PARMS


        and press [Enter].  The parameter file "PARMS" is read, and all
        dVERSION commands within it, are executed.

        Suggestion:  Create a parameter file for each of your clients.  That
        way, many clients can share a common set of source code.  When you
        want to test a client's modifications, simply run dVERSION and use
        that client's parameter file.









                                     - Page 9 -







                                 Advanced Techniques



                                    Command Line




        Perhaps the most timesaving feature added to dVERSION v2.0 is the
        command line mode.  Example, at the DOS prompt, type:


             DVER *.VER *.PRG PARMS


        and press [Enter].  At the DOS prompt, you may specify an input file,
        an output file, and a parameter file.  If you specify all three,
        conversion begins immediately.  When all files are converted, you are
        returned to the DOS prompt.

        In each sample session, we used only a few dVERSION commands and a
        few dVERSION reserved words.  To use the more advanced dVERSION
        features, you will need to read the reference section carefully.
        Also look at the sample output section for advanced features.  The
        more you experiment with dVERSION, the easier it will become to use.


                                      Automated




        To remain compatible with batch files prior to dVERSION v2.0, you may
        still type:


             DVER AUTOMATED


        at the DOS prompt.  All AUTOMATED does is disable testing for the
        escape key, during a conversion.
















                                     - Page 10 -







                             dVERSION Reference Section


                              Part I/ dVERSION Commands


        The following is a summary of all dVERSION commands:

        BLK ON               - leading blanks are to be removed from output
                                 code
        CLEAR                - reset all commands to their defaults
        CLS                  - clear screen and home cursor
        HELP topic           - displays a specified topic from the help file
        HLP filespec         - filespec is the dVERSION help file
        IN filespec          - filespec is the dVERSION input file
        LIST LPT2            - send all source code to printer LPT2
        OUT filespec         - filespec is the dVERSION output file
        PAR word             - specifies word as a conditional translating
                                 parameter
        PARMS filespec       - filespec is the dVERSION parameter file
        PMT .                - sets the dVERSION prompt character to "."
        QUIT                 - exit dVERSION and enter DOS
        REM ON               - remarks are to be removed from output code
        REMOVE ON            - remove all trace of specified parameters
        RUN                  - starts program processing
        SUF #                - sets the dVERSION reserved word suffix to "#"
        SYSTEM               - displays the current directory


        These commands set up the parameters necessary to translate code.
        They may be typed in Upper/Lowercase, and may be specified in any
        order.


                                     BLK Command


        SYNTAX:  BLK [flag]

        PARAMETERS:
        flag           -    optional, ON or OFF

        DESCRIPTION:  Sets the option to remove leading blanks from output
        code.  If no flag is specified, the current status is displayed.  The
        default is OFF.













                                     - Page 11 -







                             dVERSION Reference Section


                                    CLEAR Command


        SYNTAX:  CLEAR [command]

        PARAMETERS:
        command        -    any dVERSION command

        DESCRIPTION:  Sets the specified dVERSION command to it's default
        value.  If command is not specified, all commands are reset to their
        defaults.


                                     CLS Command


        SYNTAX:  CLS

        PARAMETERS:  none

        DESCRIPTION:  This command clears the screen and homes the cursor.


                                    HELP Command


        SYNTAX:  HELP [topic] [topic] ...
                 or
                 ? [topic] [topic] ...

        PARAMETERS:
        topic          -    any valid help topic

        DESCRIPTION:  The help facility provides the user a means of
        displaying information on certain topics.  The HELP command will open
        a help file and will search for a specified topic.  The ? is a HELP
        extension that will not reopen the help file, but will search for a
        specified topic.

        If more than one topic is specified, a search is made until each
        subtopic is found.  If no topics are specified, then the next
        available topic is displayed.  For a summary of topics, type HELP
        TOPICS.


        EXAMPLE 1:

             HELP HELP.COMMAND EXAMPLE

        The help file is opened.  A search is made for the topic
        HELP.COMMAND, and then for the subtopic EXAMPLE.  If found, the
        subtopic EXAMPLE is displayed.



                                     - Page 12 -







                             dVERSION Reference Section


        EXAMPLE 2:

             HELP HELP

        If a topic is less than 5 characters, HELP will search for the first
        topic whose beginning characters match it.  In our case, the subject
        topic is HELP.  A search is made of any topic whose first characters
        match HELP.

        Having found HELP, suppose we want to see the HELP EXAMPLE.  We can
        type:

             ?EXAMPLE

        ? can be used instead of HELP.  It merely indicates that the help
        file need not be closed, and the topic search need not start from the
        beginning of the help file.


                                     HLP Command


        SYNTAX:  HLP filespec

        PARAMETERS:
        filespec       -    any HELP file on a directory

        DESCRIPTION:  Sets the HELP file name.  If no file is specified, the
        current file is displayed.  This command is commonly used to allow
        the HELP file to be stored on a ramdisk drive.  The default is
        DVER.HLP.


                                     IN Command


        SYNTAX:  IN [filespec]

        PARAMETERS:
        filespec       -    any DOS path\filename.ext

        DESCRIPTION:  Sets the input file parameter.  This command specifies
        the dVERSION source file.  Wildcards "*" and "?" are  allowed.  If no
        file is specified, the current input file is displayed.











                                     - Page 13 -







                             dVERSION Reference Section



                                    LIST Command


        SYNTAX:  LIST [flag or port]

        PARAMETERS:
        flag           -    optional, ON or OFF
        port           -    any printer port (LPT1, COM1, etc.)

        DESCRIPTION:  Sets the option to send all input/include files to the
        printer.  If no flag is specified, the current flag is displayed.  If
        the current flag is on, the port is displayed.  Specifying a port
        sets the flag to ON.  The default is OFF.


                                     OUT Command


        SYNTAX:  OUT [filespec]

        PARAMETERS:
        filespec       -    any DOS path\filename.ext

        DESCRIPTION:  Sets the output file parameter.  This command specifies
        the output file.  If no file is specified, the current output file is
        displayed.  If no file extension is specified, the last known
        extension is assumed.  The default output file is "*.PRG".

        Note:  If the IN command has a wildcard, the OUT command's
        filename is ignored (path and file extension are still used).


                                     PAR Command


        SYNTAX:  PAR [word or number]

        PARAMETERS:
        word           -    any valid dBASE variable
        number         -    number of leading spaces

        DESCRIPTION:  Adds [word] to a list of conditional translating
        parameters.  All code specified as conditional upon word will be
        translated.  If no parameter is specified, all parameters currently
        in the list are displayed.  See Conditional Translating.

        If [number] is specified (and BLK is OFF), [number] of leading spaces
        will be removed from every statement within each conditional.






                                     - Page 14 -







                             dVERSION Reference Section


                                    PARMS Command


        SYNTAX:  PARMS filespec

        PARAMETERS:
        filespec       -    any DOS path\filename.ext

        DESCRIPTION:  This command specifies the parameter file.  The
        parameter file may contain any valid dVERSION command.  Upon
        executing this command, the parameter file is read and each dVERSION
        command is executed.

        Note:  Any Leading prompt character is ignored.  See PMT Command.





                                      PMT Command


        SYNTAX:  PMT <char>

        PARAMETERS:
        <char>         -    optional, a non alphanumeric character

        DESCRIPTION:  This command sets the prompt character, recognized in
        source code, as a dVERSION command.  If no character is specified,
        the current prompt character is displayed.  The default is a ".".

        Note:  Whatever prompt character you choose, make sure it's the same
        prompt character used throughout your source code.


                                    QUIT Command


        SYNTAX:  QUIT

        PARAMETERS:  none

        DESCRIPTION:  Specifies program exit.  The user is returned to DOS.












                                     - Page 15 -







                             dVERSION Reference Section


                                     REM Command


        SYNTAX:  REM [flag]

        PARAMETERS:
             flag      -    optional, ON or OFF

        DESCRIPTION:  Sets the option to remove all records from dBASE code
        that begin with the remark character "*".  If no command is
        specified, the current flag is displayed.  The default for flag is
        OFF.

        Note:  Remarks that start with "&&" or "NOTE" are not removed.


                                   REMOVE Command


        SYNTAX:  REMOVE [flag]

        PARAMETERS:
             flag      -    optional, ON or OFF

        DESCRIPTION:  Sets the option to remove all trace of parameters,
        specified by the PAR command, in output code.  When set to ON, all
        parameters not specified by the PAR command will remain in the output
        code.  If no command is specified, the current flag is displayed.
        The default for flag is OFF.

        Note:  This command allows you to remove parameters, creating a
               fresh set of dVERSION source code.  dVERSION include files,
               therefore, are ignored.


                                     RUN Command


        SYNTAX:  RUN

        PARAMETERS:  none

        DESCRIPTION:  This command merely begins the translation.  This
        program will read the input file(s), specified by IN, and will create
        the output file(s), specified by OUT.










                                     - Page 16 -







                             dVERSION Reference Section


                                     SUF Command


        SYNTAX:  SUF <char>

        PARAMETERS:
        <char>         -    optional, a non alphanumeric character

        DESCRIPTION:  This command sets the ASCII value for the dVERSION
        reserved word suffix.  If no character is specified, the current
        suffix character is displayed.  The default is a "\".

        Note:  Whatever suffix character you choose, make sure it's the same
        suffix character used throughout your source code.


                                   SYSTEM Command


        SYNTAX:  SYSTEM expression

        PARAMETERS:
        expression     -    any DOS command

        DESCRIPTION:  Allows user access to DOS.  If no expression is
        specified, the current directory is displayed.


        Note:  The expression parameter may or may not work for your DOS.  If
        it does not work, the expression parameter will be ignored.

























                                     - Page 17 -







                             dVERSION Reference Section


                          Part II/ dVERSION Reserved Words


        The following functions are available in dVERSION code:


        IF\                 END\           INCLUDE\
        Remarks             Macros


                             - Conditional Translating -


        SYNTAX:  IF\ [NOT] word [, word] [, word] ...
                 END\

        PARAMETERS:
        NOT            -    optional, if parameter word is NOT
                            specified, then condition is true
        word           -    Any valid dBASE variable phrase

        DESCRIPTION:  Conditional translating is a facility that allows the
        programmer to specify certain sections of code to be translated or to
        be ignored.  When dBASE code is between the dVERSION reserved words
        IF\ or END\, it is assumed to be within conditional translating.

        When the dVERSION reserved word IF\ is found, a comparison is made
        between all word parameter(s) and the list of parameters specified by
        the PAR command.  If any match, all following code will be included
        in translation.  If none match, all following code is ignored in
        translation.

        When the reserved word END\ is found, conditional translating is
        reset to the status before the last IF\.  Any following code is
        translated as standard dBASE code until another IF\ or END\ is found.


                                    - INCLUDE\ -


        SYNTAX:  INCLUDE\ filespec

        PARAMETERS:
        filespec       -    any DOS path\filename.ext

        DESCRIPTION:  When the first statement in a program line is a
        INCLUDE, it is assumed to be an dVERSION reserved word.  If the file
        is found, it is opened and it's code included.







                                     - Page 18 -







                             dVERSION Reference Section


                                     - Remarks -


        SYNTAX:  *anything...

        PARAMETERS:  none

        DESCRIPTION:  When the REM flag is set (see REM command), all source
        code records starting with an asterisk are ignored and are not sent
        to the output file.

        Note:  There is one exception.  If the REMOVE flag is set (see REMOVE
        command), then any remark beginning with (** ' ), and containing the
        uppercase portion of any specified parameter (see PAR command) will
        not be sent to the output file.


                                     - Macros -


        SYNTAX: .command

        PARAMETERS:

        DESCRIPTION:  Macros are dVERSION commands contained in source code.
        All macros begin with the dVERSION prompt character (see PMT
        command).  The default is a period.  The command following the period
        may be any dVERSION command (REM, BLK, PAR, etc.).  In this way, the
        Macro facility provides a way of setting default values without using
        batch files.

























                                     - Page 19 -







                             dVERSION Reference Section


                          Part III/ dVERSION Error Messages


        The following is a brief description of dVERSION command errors:

        ** Invalid Command
             Either the command was not found, or the command was incorrectly
             typed.  Check your spelling, and retype.

        ** Topic Not Found

        ** End of Topic (or Subtopic)
             Merely indicates that the HELP utility found all the information
             it can on a given topic.

        ** File Name Conflict
             dVERSION cannot continue runtime execution until the IN and the
             OUT commands are correctly specified.  IN also cannot equal OUT.

        ** INCLUDE filespec cannot be opened
             The maximum of 15 files have been opened at one time.

        ** Device not available, Error#25
             Printer is not online.

        ** File Not Found, Error#53

        ** Bad File Name, Error#64

        ** Syntax Error, Error#

        ** Disk Error, Error#
             Refer to your Disk owners manual, or to your quick basic
             reference guide.





















                                     - Page 20 -







                             dVERSION Reference Section


                           Part IV/ dVERSION Sample Output


        The following is a sample session, the sample input files, and the
        output file produced:

        DVER
        IN SAMPLE.VER
        OUT SAMPLE.PRG
        PAR DOS
        REM ON
        BLK ON
        RUN
        QUIT


                             dVERSION Sample Input File


        NOTE PROGRAM MAL.PRG 03.05.01
        NOTE PROGRAMMER D. ALLEN
        NOTE CREATED AUG 30, 1987
        NOTE UPDATED FEB 12, 1993
        NOTE COPYRIGHT(C) 1987
        *
        *     THE PROCEDURE IS A STRIPPED DOWN VERSION OF MAL.PRG, THE
        *     STARTUP PROCEDURE OF THE DMAIL4 APPLICATION.
        *

        CLEAR ALL
        CLOSE ALL
        SET RESOURCE ON
        SET SAFETY OFF
        SET TALK OFF

        SET PROCEDURE TO SCRPROC

        IF\ DOS
          SET BORDER TO DOUBLE
          SET CLOCK TO 00,SCOLS()-11
          SET CLOCK ON
          SET SHADOWS ON
          = SYS(2008,"I",2)
          = SYS(2008,"O",0)
          = INSMODE(.F.)
        END\
        IF\ WINDOWS
          DO COLORSET WITH "FOXDEF"
          CLEAR
          SET CLOCK ON
          SET CLOCK STATUS
          SET STATUS BAR ON
        END\


                                     - Page 21 -







                             dVERSION Reference Section


        INCLUDE\ SAMPLE2.VER

        *
        *    MAIN ROUTINE
        *
        ACTIVATE SCREEN
        @ 1,0 CLEAR
        DO CTR WITH 1, IIF(bMULT,"Multi-user ","")+"Mailing List, Version
        03.05.01"
        DO CTR WITH 2, "(c) 1987 Dennis Allen, All rights reserved"
        DO WHILE .T.

          ON ERROR DO FOXERR WITH ERROR(), MESSAGE(), MESSAGE(1), PROGRAM(),
        LINENO(), SYS(16)

          DO WINDOW WITH "MAL", " M A I N   M E N U "
          cCHOICES = "EPSU"
          nCOL = ROUND(WCOLS()/2,0) - 19
          @  1,nCOL PROMPT " [\<E] - Edit  Mailing List "
          @  3,nCOL PROMPT " [\<P] - Print Mailing List "
          @  7,nCOL PROMPT " [\<S] - System Setup (Query)"
          @  9,nCOL PROMPT " [\<U] - Utilities"
          @ 13,nCOL PROMPT " [\<Q] - Quit this program"
          cCHOICES = cCHOICES+"Q"
          MENU TO mCHOICE
          cCHOICE = IIF(mCHOICE > 0,SUBSTR(cCHOICES,mCHOICE,1),"")
          DO DIALOG WITH .F.
          DO CASE
          CASE cCHOICE = "E"
            DO MALED
          CASE cCHOICE = "P"
            DO MALPR
          CASE cCHOICE = "S"
            DO MALSYS
          CASE cCHOICE = "U"
            DO MALUT
          CASE cCHOICE = "Q"
            IF YESNO(" Are you Sure (Y or N) ?  ","N") = "N"
              LOOP
            ENDIF
            DELETE FILE (PROGRAM()+".MEM")
            IF SYS(16,1) = SYS(16)
              QUIT
            ENDIF
            EXIT
          ENDCASE
        ENDDO
        RETURN







                                     - Page 22 -







                             dVERSION Reference Section




                            dVERSION Sample Include File


        IF\ DOS
          IF DATE() = {01/01/1980}
            ??CHR(7)+CHR(7)
            TEXT

          The system date has not been set.  Use the operating system DATE
        command
          to set today's date.  At the operating system prompt, type a
        command of
          the form:

                              DATE 07.07.87

        ... and press the RETURN key, which may be marked ENTER or --+.  The
          above command would set the date to July 7, 1987.  Once you have
        done
          this you can run this program again.

            ENDTEXT
            @ 23,0
            WAIT "Press any key to return to the operating system . . . "
            QUIT
          ENDIF
        END\

        IF DISKSPACE() < 1474560
          ??CHR(7)+CHR(7)
          TEXT
          Diskspace too small for application...
          ENDTEXT
          @ 23,0
          WAIT "Press any key to return to the operating system . . . "
          QUIT
        ENDIF

        IF !SYS(2000,PROGRAM()+".MEM") == ""
          ??CHR(7)+CHR(7)
          TEXT
          Please remember to exit this application before turning off the
        computer...
          ENDTEXT
          @ 23,0
          WAIT "Press any key to continue . . . "
        ENDIF
        SAVE TO (PROGRAM())





                                     - Page 23 -







                             dVERSION Reference Section


                             dVERSION Sample Output File


        NOTE PROGRAM MAL.PRG 03.05.01
        NOTE PROGRAMMER D. ALLEN
        NOTE CREATED AUG 30, 1987
        NOTE UPDATED FEB 12, 1993
        NOTE COPYRIGHT(C) 1987
        CLEAR ALL
        CLOSE ALL
        SET RESOURCE ON
        SET SAFETY OFF
        SET TALK OFF
        SET PROCEDURE TO SCRPROC
        SET BORDER TO DOUBLE
        SET CLOCK TO 00,SCOLS()-11
        SET CLOCK ON
        SET SHADOWS ON
        = SYS(2008,"I",2)
        = SYS(2008,"O",0)
        = INSMODE(.F.)
        IF DATE() = {01/01/1980}
        ??CHR(7)+CHR(7)
        TEXT

          The system date has not been set.  Use the operating system DATE
        command
          to set today's date.  At the operating system prompt, type a
        command of
          the form:

                              DATE 07.07.87

          ... and press the RETURN key, which may be marked ENTER or --+.
        The
          above command would set the date to July 7, 1987.  Once you have
        done
          this you can run this program again.

        ENDTEXT
        @ 23,0
        WAIT "Press any key to return to the operating system . . . "
        QUIT
        ENDIF
        IF DISKSPACE() < 1474560
        ??CHR(7)+CHR(7)
        TEXT
          Diskspace too small for application...
        ENDTEXT
        @ 23,0
        WAIT "Press any key to return to the operating system . . . "
        QUIT
        ENDIF
        IF !SYS(2000,PROGRAM()+".MEM") == ""

                                     - Page 24 -







                             dVERSION Reference Section


        ??CHR(7)+CHR(7)
        TEXT
          Please remember to exit this application before turning off the
        computer...
        ENDTEXT
        @ 23,0
        WAIT "Press any key to continue . . . "
        ENDIF
        SAVE TO (PROGRAM())
        ACTIVATE SCREEN
        @ 1,0 CLEAR
        DO CTR WITH 1, IIF(bMULT,"Multi-user ","")+"Mailing List, Version
        03.05.01"
        DO CTR WITH 2, "(c) 1987 Dennis Allen, All rights reserved"
        DO WHILE .T.
        ON ERROR DO FOXERR WITH ERROR(), MESSAGE(), MESSAGE(1), PROGRAM(),
        LINENO(), SYS(16)
        DO WINDOW WITH "MAL", " M A I N   M E N U "
        cCHOICES = "EPSU"
        nCOL = ROUND(WCOLS()/2,0) - 19
        @  1,nCOL PROMPT " [\<E] - Edit  Mailing List "
        @  3,nCOL PROMPT " [\<P] - Print Mailing List "
        @  7,nCOL PROMPT " [\<S] - System Setup (Query)"
        @  9,nCOL PROMPT " [\<U] - Utilities"
        @ 13,nCOL PROMPT " [\<Q] - Quit this program"
        cCHOICES = cCHOICES+"Q"
        MENU TO mCHOICE
        cCHOICE = IIF(mCHOICE > 0,SUBSTR(cCHOICES,mCHOICE,1),"")
        DO DIALOG WITH .F.
        DO CASE
        CASE cCHOICE = "E"
        DO MALED
        CASE cCHOICE = "P"
        DO MALPR
        CASE cCHOICE = "S"
        DO MALSYS
        CASE cCHOICE = "U"
        DO MALUT
        CASE cCHOICE = "Q"
        IF YESNO(" Are you Sure (Y or N) ?  ","N") = "N"
        LOOP
        ENDIF
        DELETE FILE (PROGRAM()+".MEM")
        IF SYS(16,1) = SYS(16)
        QUIT
        ENDIF
        EXIT
        ENDCASE
        ENDDO
        RETURN





                                     - Page 25 -







                               Appendix A/ Data Files


        The first thing you should do is make a backup copy of your dVERSION
        disk IMMEDIATELY.  There are many ways to backup your disk, so check
        your DOS owner's manual for details.

        The following programs are included on your Data Disk:

             DVER.EXE            DVER.HLP            DVER.MAN
             MANUAL.BAT          SAMPLE.VER          SAMPLE2.VER

        DVER.EXE is the dVERSION BASIC compiled program.  DVER.HLP is the
        help file.  It contains on-line instructions on how to use dVERSION.

        DVER.MAN is the dVERSION manual.  To print the manual, type MANUAL at
        the DOS prompt.









































                                     - Page 26 -







                           Appendix B/ dVERSION Standards


        The following is a set of guidelines for creating dVERSION files:

        1.   File names should use the following file extensions:
             a) VER for a dVERSION input file
             b) PRG for a dVERSION output file
             c) HLP for a dVERSION HELP file

        2.   A program should begin with the following remarks:
             a) * program name
             b) * programmer's name
             c) * date created
             d) * date updated

        3.   A program should also include the following documentation:
             a) briefly state the purpose of the program
             b) state all Input/Processing/Output of the program
             c) include a variable dictionary

        4.   All procedures should have the following documentation:
             a) state the purpose of the procedure
             b) state any flags set
             c) state the name of the calling procedure, if any
             d) state the name of the procedure to return
             e) include parameter, public, and variable dictionaries

        5.   All programmer documentation should begin with an asterisk.

        6.   Any modification to dBASE code should be contained within a
             conditional.  All conditionals should be documented.  The
             following is an example remark for the conditional UNITMS:

             ** ' 01/01/89 DA Handling UNITMS   **

        7.   All dVERSION reserved words should be in uppercase characters.

        8.   Do not use dVERSION reserved words as variables.

        9.   Program lines within the body of an "IF\ END\" conditional block
             should be indented 2 spaces past the starting column of the
             "IF\".  The "END\" starts in the same column as the "IF\".  Use
             the dVERSION command "PAR 2" to keep conditional code lined up.

        10.  If a program line is continued, the continuation line should be
             indented 2 spaces beyond the original line column.











                                     - Page 27 -







                                      GLOSSARY


        Arrow Keys  -  Equivalent to cursor keys.  Those keys on the keyboard
             labeled with arrows.

        ASCII  -  American Standard Code for Information Interchange.  A
             standard 7 bit code used to represent data.

        Batch File  -  A file containing multiple DOS commands.  These
             commands are executed by DOS, one at a time, as if typed by the
             user.

        Boolean  -  The logical comparison between two values.  Common
             boolean operators are: OR, AND, and NOT.

        Byte  -  A unit of information.  In text form, equivalent to an ASCII
             character.

        COBOL  -  COmmon Business Oriented Language.

        Code  -  Program code.  Another way of saying program instructions.

        Compiler  -  A program that converts program code from one form to
             another, usually more primitive, form.  The converted code is
             then ready for execution.

        Conditional Translation  -  Derived from FORTRAN.  A process where
             code is compiled/translated if certain parameters are met.

        Cursor  -  A flashing character on the screen.  It indicates where
             typed text will be next placed.

        Cursor Keys  -  Equivalent to arrow keys.  Those keys on the keyboard
             labeled with arrows.

        dBASE  -  Popular database management program.  The software package
             dBASE III+ is an interpreter for dBASE code.

        Disk  -  A unit where information is stored.  There are two major
             types: hard disk, and floppy disk.

        Disk Error  -  An error occurring when a program is unable to read or
             write properly to a disk.

        Diskspace  -  A unit of how much room is available on a drive.  It is
             usually measured in bytes.

        DOS  -  Disk Operating System.

        Executable Code  -  What a translator or compiler creates from source
             code.

        Expression  -  A general Term for Data.  There are four types of
             expressions:  Numeric, String, Relational, and Logical.



                                     - Page 28 -







                                      GLOSSARY


        Filespec  -  any DOS filename.ext including catalog names, passwords,
             etc.

        Floppy Disk  -  A self contained unit where information is stored.
             Depending on the type, floppy disks are easily transportable.
             Sometimes called a diskette.

        Foxbase  -   A dBASE III plus compiler.

        Foxpro  -   A dBASE IV compiler.

        Hard Disk  -  A self contained unit where information is stored.
             Usually not removable.

        HELP  -  A facility that provides on-line assistance in the use of a
             given program.

        Highlight  -  A form of a cursor, where an entire field is considered
             the cursor.

        Interpreter  -  A program that executes program code.  Whereas a
             compiler translates program code to executable code, an
             interpreter translates a single line of program code before
             executing it.

        MS-DOS  -  Microsoft Disk Operating System.

        Multi-user  -  When more one than one person is capable of
             accessing/updating the same database at the same time.

        Reserved word  -  What an interpreter/compiler recognizes as a
             language command.

        Runtime  -  A period of time when a program is executing, compiling,
             or translating.

        Sideways  -  A Utility that will print text up and down instead of
             across the paper.

        Source Code  -  What a translator/compiler takes in as input.

        Syntax  -  The rules for the arrangement of statements in a
             programming language.

        Translator  -  A program that converts program code from one form to
             another form.

        Variable Phrase  -  A variable name beginning with a letter (A-Z),
             and consisting of letters, digits, or underlines (A-Z,0-9,_).  A
             dBASE variable may have up to 10 characters.





                                     - Page 29 -







                                        Index


        - Conditional Translating -  18
        - INCLUDE\ -  18
        - Macros -  19
        - Remarks -  19
        Advanced Techniques  9
        Appendix A/ Data Files  26
        Appendix B/ dVERSION Standards  27
        Arrow Keys  28
        ASCII  28
        Automated  10
        Batch File  28
        BLK Command  11
        Boolean  28
        Byte  28
        CLEAR Command  12
        CLS Command  12
        COBOL  28
        Code  28
        Command Line  10
        Compiler  28
        Conditional Translating  7
        Conditional translation  4, 28
        Copyright/License/Warranty  2
        Cursor  28
        Cursor Keys  28
        DBASE  1, 28
        Disk  28
        Disk Error  28
        Diskspace  28
        DOS  28
        DVER  6, 9
        DVER.EXE  26
        DVER.MAN  26
        DVERSION  1
        DVERSION Reference Section  11
        DVERSION Sample Include File  23
        DVERSION Sample Input File  21
        DVERSION Sample Output File  24
        Executable Code  28
        Expression  28
        Filespec  29
        Floppy Disk  29
        Foxbase  29
        Foxpro  29
        Getting Started  6
        GLOSSARY  28
        Hard Disk  29
        HELP  29
        HELP Command  12
        Highlight  29
        HLP Command  13
        IN Command  13
        INCLUDE  1
        INCLUDE\  8

                                     - Page 30 -







                                        Index


        Index  30
        Interpreter  29
        Introduction  4
        LIST Command  14
        MS-DOS  29
        Multi-user  29
        Notation Conventions  5
        OUT Command  14
        Output code  4
        PAR Command  14
        PARMS Command  15
        Part I/ dVERSION Commands  11
        Part II/ dVERSION Reserved Words  18
        Part III/ dVERSION Error Messages  20
        Part IV/ dVERSION Sample Output  21
        PMT Command  15
        Preface  1
        QUIT Command  15
        REM Command  16
        Remarks  8
        REMOVE Command  16
        Reserved word  29
        RUN Command  16
        Runtime  29
        Sideways  29
        Source code  4, 29
        SUF Command  17
        Syntax  29
        SYSTEM Command  17
        TABLE OF CONTENTS  3
        Translating dVERSION code  7
        Translator  29
        Variable Phrase  29
        Wildcard  9





















                                     - Page 31 -



