;----------------------------------------------------------------------
; (c) copyright 1993 Santronics Software
; All Rights Reserved World Wide
; Version 5.03
;----------------------------------------------------------------------
; THIS XPMENU.CTL WORKS FOR VERSION 5.0x OF XPMAIL.EXE ONLY. THE OLDER
; 3.0x or 4.0x XPMENU.CTL FORMAT WILL NOT WORK WITH VERSION 5.0x.
;----------------------------------------------------------------------
;
; Silver Xpress Menu System is a dynamic menu system.  You can define upto
; 20 different menus with each menu having 20 different items. Since Silver
; Xpress is a very sophiscated application, it has alot of options users
; can use.  All the options are security based (Xpress security).  This
; default menus and options defined here will give your user the MOST of
; Silver Xpress. It is also setup for the SYSOP to have some other sysop
; only options. Pay attention to the security values.
;
;----------------------------------------------------------------------

; Defining the top menu and configuration menu.
; There are two special menus Xpress looks for:
;
;    TopMenuName        REQUIRED  - Top Level Menu
;    ConfigMenuName     OPTIONAL  - Displayed to first time user
;
; TopMenuName     This menu will be the FIRST MENU DISPLAY to the user
;                 every time he enters Silver Xpress. The only exception
;                 is if the user is a FIRST TIME USER and ConfigMenuName
;                 keyword is defined.
;
; ConfigMenuName  If defined, this is the menu which will be shown the
;                 first time the user enters Silver Xpress. This allows
;                 Xpress to present Xpress configuration options first.
;                 If this keyword is not defined, no configuration menu
;                 will be showned and the user will be taken to the top
;                 menu.

TopMenuName  MAIN
ConfigMenuName CONFIG

;----------------------------------------------------------------------
; Defining macros for the menus
;
; Xpress 5.0x has a new macro system which allows you to add tremendous
; power to Silver Xpress (like it needed any more <grin>).  As you will
; see below, each menu items you define use action codes (tags). You
; can basically STACK this action codes into macros and then use the
; macros for your menu items.  To offer macros, create a MACRO block.
;
;    MACRO
;       <MacroName> <Security> <keystrokes> [description]
;       .
;       .
;    ENDMACRO
;
;    MacroName       This is the name of the macro that you can use with
;                    the _MACRO action code.
;    Security        The Xpress user security required to access this macro
;    Keystrokes      Keystrokes that are used for this macro.
;    Description     Optional description beginning with double quote.
;

MACRO
 LIST       0     @174             "Liste des macros disponibles
 SCANOPX    0     @153@107         "Balayage et empaquetage d'un paquet OPX
 SCANQWK    0     @154@107         "Balayage et empaquetage d'un paquet QWK
 ANSI       0     @119@122         "Rgler les menus  ANSI et novice
 BYE        0     @131             "Quitter Xpress
 DEFAULT    0     @111Z@112Z@153   "Slectionner ZModem, ZIP et mode OPX
 ARCH       0     @112             "Slectionner un archiveur
 XFER       0     @111             "Slectionner un protocole
 RIPON      0     @175             "Activer le graphisme RIP
 RIPOFF     0     @176             "Dsactiver le graphisme RIP
 MAIN       0     @135             "Retour au menu principal
 DL         200   @105             "Recevoir un fichier (commande SYSOP)
 KEYWORD    0     @114             "Editer les chanes de recherche
 DOS        40000 @104             "Shell au Dos (commande (SYSOP)
ENDMACRO

; The following keywords defined the POWER and MACRO keys the user
; can use at the menus. It is highly recommended that you don't change
; them unless there was a real need. Note: Any ascii character can be
; used except ';' (semi-colon) and '|' (vertical bar);

; Power Char is used with a action code number, i,e,. @112 where 112 is
; the action code.  Macro Char is used with a macro command, i.e., \ANSI

POWERCHAR @
MACROCHAR \

; The ACTION CODE list allows you to define the security for each available
; command in Xpress.  The security only works within the MACRO or POWER
; command system, not in the menus. In other words, if you use a _DNLDFILE
; option in one of the menus, the menu option security overrides the action
; code security.  The action code security is used when the user attempts
; to use a macro or power command from any menu level, i.e., \DL

ACTIONCODE
 _USRLIST         0
 _RUSRLIST        0
 _LOG             0
 _SHELL           40000
 _DNLDFILE        200
 _UPLDFILE        0
 _DNLDMAIL        0
 _UPLDMAIL        0
 _USERLOG         0
 _SELECT          0
 _XFERTYPE        0
 _ARCHTYPE        0
 _BULLETINS       0
 _KEYWORDS        0
 _OWNMAIL         0
 _GRPMAIL         0
 _LASTDATE        0
 _RESTORELR       0
 _COLOR           0
 _HOTKEY          0
 _IBMCHAR         0
 _NOVICE          0
 _VETERAN         0
 _GXPRESS         0
 _RPASSWORD       0
 _DPASSWORD       0
 _VACSAVER        0
 _FILESCAN        0
 _FILEDATE        0
 _DELXAM          0
 _QUIT            0
 _HELP            0
 _RETURN          0
 _GOODBYE         0
 _TOPMENU         0
 _NORIP           0
 _AUTOSTART       0
 _SYSPARM         0
 _CHAT            200
 _DISPLAY         0
 _VACPAC          0
 _DISPVER         0
 _DNLDUPD         0
 _SAVEINFO        0
 _AVATAR          0
 _TTYMODE         0
 _PKTOPX          0
 _PKTQWK          0
 _PKTTEXT         0
 _QWKSTRIPK       0
 _QWKCAPHDR       0
 _QWKNDX          0
 _SENDXFILES      0
 _SELAREAS        0
 _PKTCOUNT        0
 _CHANGELR        0
 _GOSUB           0
 _USEFLEXASST     0
 _SHOWMAILONLY    0
 _QWKWWRAP        0
 _TOSSDUMP        0
 _XNLIST1         0
 _XNLIST2         0
 _MACRO           0
 _MACROLIST       0
 _RIPON           0
 _RIPOFF          0
 _RULESEARCH      0
 _SRCHTEXT        0
 _REPRECEIPT      0
 _ANSILIST        0
 _FILEFREQ        200
ENDACTION

;----------------------------------------------------------------------
; Defining a Menu to Present to the user.
;
; Each Menu is defined using the MENU and ENDMENU block keywords.
;
;           MENU MenuName Security
;             ITEMCOLOR  <hotkey color> <option color>
;             ITEM  <security> <actiontag [optional data]> <description>
;             ITEM ......
;             ITEM ......
;           ENDMENU
;
;    MenuName        The name of the menu. You can use this name in you
;                    _GOSUB menu action codes.
;    Security        The Xpress user security required to access this menu.
;
; Each ITEM has the following format:
;
;    ITEM  <security> <actiontag [optional data]> <description>
;
;    Security        The Xpress user security to access this item
;    ActionTag       Action to be taken. See doc for available action tags.
;                    Some action tags required optional data.
;                    _DISPLAY <filename>
;                    _DNLDFILE <filename or ? for prompt>
;                    _UPLDFILE <filename or ? for prompt>
;                    _GOSUB    <Name of Menu to link>
;                    _MACRO    <macro name in macro block>
;    description     This is the description the user sees in the menu.
;                    The hot key for this item must be surrounded by carets.
;                    If you precede the description with a quote character,
;                    no leading spaces will be removed. If you end the line
;                    a semi-colon, then no carriage return and linefeed will
;                    be added. The semi-colon is good for creating 2 column
;                    menus.
;
;                    If the description has any of the % parameters, a
;                    substition will be made.
;
;                      %sa   - # of selected areas
;                      %tm   - file transfer protocol
;                      %cm   - compression method
;                      %gb   - general bulletins
; obselete             %kw   - total keywords
;                      %ro   - receive own mail
;                      %rg   - receive group mail
;                      %ld   - last usage date
;                      %ag   - Color Graphics (Ansi)
;                      %av   - Avatar Graphics
;                      %hk   - Menu Hot Keys
;                      %ic   - IBM Characters
;                      %nm   - Novice Menu Mode
;                      %xm   - Veteran Menu Mode
;                      %gx   - Gold Xpress Menu Mode
;                      %vs   - Vacation saver
;                      %fs   - file scan
;                      %fd   - file scan date
;                      %pt   - packet type
;                      %sk   - strip kludges in mail
;                      %ch   - capitalize header in qwk mail
;                      %sn   - Do not Send NDX files
;                      %sx   - Do not send QWK/X files
;                      %so   - send selected areas only
;                      %hr   - HMS (QBBS/RA) last read value
;                      %pc   - Use Packet Counter
;                      %fa   - Use flex assistance
;                      %mo   - Show area with mail only
;                      %ww   - Perform Word Wrapping for QWK
;                      %nr   - NO Rip Graphics
;                      %nl1  - Xpress nodelist 1
;                      %nl2  - Xpress nodelist 2
;                      %as   - Auto Start Xpress
;                      %sb   - search body of text
;                      %rr   - send reply receipt
;
;----------------------------------------------------------------------
;
; A menu block must begin with a MENU command, the first parameter is the
; menu name and the optional second parameter is the Xpress Security
; value. If no security is define, then it becomes 0 and all users will
; see this menu.


MENU MAIN

; This is the prompt shown to the user when he has Gold Xpress mode enabled.
; These are usually short keywords which a smart comm program can pick up
; to display off-loaded menus.

  GXPROMPT  SX_MAIN>
;
; NTITLE is the title shown during novice mode, VTITLE is the title shown
; during veteran (expert) mode, and RTITLE is use during RIP mode. NTITLE
; is commented out because the title is display using JUNK menu items. See
; below.
;
; NTITLE    YELLOW Silver Xpress Menu Principal
  VTITLE    YELLOW Menu Principal
  RIPTITLE  Silver Xpress Main Menu
;
;
; name of help file
; (also name of optional menu ansi file shown, x.ANS or x.TXT or x.RIP)
;
  HELP      main
;
; Menu items. In this example, the NTITLE is commented out and menuitems are
; used to draw a TITLE HEADER for the menu.  The _JUNK xpress menu token is
; used to tell Xpress the menu option is meaningless.
;
  ITEMCOLOR YELLOW WHITE
  MENUITEM  0 _JUNK     'Ŀ'
  MENUITEM  0 _JUNK     '                        ^Silver Xpress Menu Principal^                        '
  MENUITEM  0 _JUNK     ''
  ITEMCOLOR YELLOW CYAN

  MENUITEM  0  _GOSUB SYSOP   ' [^I^]..Information du systme         ;
  RIP # Sysop Options
  MENUITEM  0  _GOSUB CONFIG  ' [^C^]..Configuration
  RIP Configuration
  MENUITEM  0 _DISPLAY  DLRDR ' [^R^]..Recevoir le lecteur Xpress     ;
  RIP Download Xpress Reader
  MENUITEM  0 _GOSUB ASSIST   ' [^A^]..Assistant Xpress
  RIP Xpress Assistant

  MENUITEM
  MENUITEM  0 _MACRO SCANOPX  ' [^X^]..Balayage/Rception paquet OPX  ;
  RIP Scan/Download OPX Packet (Xpress Reader Only)
  MENUITEM  0 _MACRO SCANQWK  ' [^K^]..Balayage/Rception paquet QWK
  RIP Scan/Download QWK Packet
  MENUITEM  0 _UPLDMAIL       ' [^T^]..Transmettre votre courrier     ;
  RIP Upload Your Mail
  MENUITEM  0 _VACPAC         ' [^V^]..Vrifier votre courrier de vacance
  RIP Check Vacation Mail
  MENUITEM  0 _USERLOG        ' [^J^]..Journal personnel              ;
  RIP See Personal Log
  MENUITEM  0 _HELP           ' [^?^]..Aide
  RIP ? Help
  MENUITEM  0 _QUIT           ' [^B^]..Retour au babillard            ;
  RIP QUIT
;
; if you do not want to have a goodbye option, then comment out the
; goodbye option. If do you comment it out, uncomment the _JUNK MENUITEM
; below it.
;
  MENUITEM  0 _GOODBYE        ' [^Q^]..Quitter (Raccrocher)
  RIP GoodBye
; MENUITEM
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
;
; Normally, the menu system will allow a carriage return to go to previous menu.
; It will normally use the LAST hotkey defined. Since the last menuitem is not
; a normal option, RETURNKEY is used to define the key that will be used
; when carriage return is hit.
;
  RETURNKEY Q
;
; This is the line shown during veteran mode
;
   VETERAN   YELLOW WHITE Cls valides: [^%keys^]
;
; This is the prompt shown to users. Highlight color, normal color,
; and the prompt color is the order of the format. Only two substitutions
; can be made, %tr time remaining, %fn user's first name.
;
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU

;
; configuration menu.
;

MENU CONFIG
  GXPROMPT  SX_CFG>
  VTITLE    WHITE Menu Configuration
  RIPTITLE  Silver Xpress Configuration Menu
  HELP      config
  ITEM COLOR 63 WHITE
  MENUITEM  0 _JUNK      '^ Menu Configuration ^'
  ITEMCOLOR YELLOW CYAN
  MENUITEM  0 _SELECT     ' [^S^]....Slection des confrences   - ^%sa de slectionne(s)^
  RIP Select Mail Areas
  MENUITEM  0 _XFERTYPE   ' [^P^]....Protocole de transfert      - ^%tm^
  RIP File Transfer Method
  MENUITEM  0 _ARCHTYPE   ' [^A^]....Archiveur dsir            - ^%cm^
  RIP Archiver Method
  MENUITEM
  MENUITEM  0 _GOSUB MAILOPTS  ' [^O^]....Options courrier
  RIP Mail Options
  MENUITEM  0 _GOSUB SERVICES  ' [^X^]....Services Xpress
  RIP Xpress Services
  MENUITEM  0 _GOSUB TERMINAL  ' [^T^]....Options terminal
  RIP Terminal Options
  MENUITEM  0 _SAVEINFO   ' [^C^]....Sauvegarde de la configuration
  RIP Save Configuration
  MENUITEM  0 _HELP       ' [^?^]....Aide
  RIP ? HELP
  MENUITEM  0 _RETURN     ' [^Q^]....Retour au menu prcdent
  RIP Quit
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU

;
; mail options
;

MENU MAILOPTS
  GXPROMPT  SX_MOPT>
  VTITLE    WHITE Options Courrier
  RIPTITLE  Mail Options
  HELP      moptions
  ITEM COLOR 63 WHITE
  MENUITEM  0 _JUNK         '^ Options Courrier ^'
  ITEMCOLOR YELLOW CYAN
  MENUITEM  0 _KEYWORDS      ' [^R^]....Dfinissions des critres de recherche (Chanes)
  RIP Define Keywords
  MENUITEM  0 _SRCHTEXT      ' [^C^]....Recherche des chanes dans le contenu des messages .......: ^%sb^
  RIP Search Message Body
  MENUITEM  0 _OWNMAIL       ' [^P^]....Recevoir votre propre courrier ...........................: ^%ro^
  RIP Receive Your OWN Mail
  MENUITEM  0 _GRPMAIL       ' [^G^]....Recevoir le courrier de groupe ...........................: ^%rg^
  RIP Receive Group Mail
  MENUITEM  0 _GOSUB PACKET  ' [^F^]....Slection du format de paquet ............................: ^%pt^
  RIP Choose Packet Format
  MENUITEM  0 _PKTCOUNT      ' [^U^]....Utiliser le compteur de paquet utilisant l'extension .....: ^%pc^
  RIP Use Packet Extension
  MENUITEM  0 _SELAREAS      ' [^T^]....Transmettre les confrences slectionnes seulement.......: ^%so^
  RIP Send Selected
  MENUITEM  0 _USEFLEXASST   ' [^A^]....Utiliser l'assistant Flex pendant le balayage du courrier : ^%fa^
  RIP Flex Assistant
  MENUITEM  0 _SHOWMAILONLY  ' [^M^]....Montrer seulement les confrences avec du courrier .......: ^%mo^
  RIP Show Areas With Mail
  MENUITEM  0
  MENUITEM  0 _LASTDATE      ' [^D^]....Changer les pointeurs du courrier par date
  RIP Change Pointers by Date
  MENUITEM  0 _CHANGELR      ' [^N^]....Changer les pointeurs du courrier par numro
  RIP Change Pointers by Number
  MENUITEM  0 _RESTORELR     ' [^I^]....Rtablir les pointeurs initiaux
  RIP Restore Entry Pointers
  MENUITEM  0 _HELP          ' [^?^]....Aide
  RIP ? HELP
  MENUITEM  0 _TOPMENU       ' [^/^]....Menu Principal
  RIP / (Main)
  MENUITEM  0 _RETURN        ' [^Q^]....Retour au menu prcdent
  RIP Quit
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU

;
; terminal options
;
MENU TERMINAL
  GXPROMPT  SX_TOPT>
  VTITLE     WHITE Options Terminal
  RIPTITLE   Terminal Options
  HELP      terminal
  ITEM COLOR 63 WHITE
  MENUITEM  0 _JUNK      '^ Options Terminal ^'
  ITEMCOLOR YELLOW CYAN
  MENUITEM  0 _COLOR      ' [^C^]....Couleur Ansi             - ^%ag^
  RIP Use Ansi (Color)
  MENUITEM  0 _TTYMODE    ' [^T^]....TTY (Pas de couleur)     - ^%at^
  RIP Use TTY
  MENUITEM  0 _AVATAR     ' [^A^]....Graphisme Avatar         - ^%av^
  RIP Use Avatar
  MENUITEM  0 _HOTKEY     ' [^O^]....Touches turbo            - ^%hk^
  RIP Use Menu Hot Keys
  MENUITEM  0 _IBMCHAR    ' [^I^]....Caractres IBM           - ^%ic^
  RIP Use IBM Characters
  MENUITEM  0 _NOVICE     ' [^N^]....Mode novice              - ^%nm^
  RIP Novice Menu Mode
  MENUITEM  0 _VETERAN    ' [^V^]....Mode vtran (Expert)    - ^%xm^
  RIP Veteran Menu Mode
  MENUITEM  0 _GXPRESS    ' [^G^]....Mode Gold Xpress         - ^%gx^
  RIP Gold Xpress Menu Mode
  MENUITEM  0 _NORIP      ' [^R^]....Ignorer le graphisme RIP - ^%nr^
  RIP Skip RIP Graphics
  MENUITEM  0
  MENUITEM  0 _HELP       ' [^?^]....Aide
  RIP ? HELP
  MENUITEM  0 _TOPMENU    ' [^/^]....Menu Principal
  RIP / (Main)
  MENUITEM  0 _RETURN     ' [^Q^]....Retour au menu prcdent
  RIP Quit
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU

;
; services menu
;

MENU SERVICES
  GXPROMPT  SX_SERV>
  VTITLE     WHITE Menu de Services Xpress
  RIPTITLE  Silver Xpress Services Menu
  HELP      services
  ITEMCOLOR 63 WHITE
  MENUITEM  0 _JUNK      '^ Menu de Services Xpress ^'
  ITEMCOLOR YELLOW CYAN
  MENUITEM  0 _VACSAVER   ' [^S^]....Sauvegarde du courrier de vacance ............: ^%vs^
  RIP Xpress Vacation Saver
  MENUITEM  0 _FILESCAN   ' [^F^]....Balayage pour nouveaux fichiers ..............: ^%fs^
  RIP Scan for New Files
  MENUITEM  0 _FILEDATE   ' [^D^]....Changer la date du balayage de fichiers ......: ^%fd^
  RIP Change File Scan Date
  MENUITEM  0 _ANSILIST   ' [^N^]....Lister nouveaux fichiers en Ansi .............: ^%al^
  RIP Ansi New Files List
  MENUITEM  0 _BULLETINS  ' [^B^]....Recevoir les bulletins .......................: ^%gb^
  RIP Send Bulletins
  MENUITEM  0 _AUTOSTART  ' [^A^]....Dmarrage automatique de Xpress ..............: ^%as^
  RIP Auto Start Xpress
  MENUITEM  0 _REPRECEIPT ' [^T^]....Transmettre l'accus de rception ............: ^%rr^
  RIP Send Reply Receipt
  MENUITEM  0 _DELXAM     ' [^E^]....Effacer le message du rpondeur automatique
  RIP Erase Mail Recording
  MENUITEM  0 _RPASSWORD  ' [^L^]....Mot de passe du lecteur HORS-LIGNE
  RIP Set Reader Password
  MENUITEM  0 _DPASSWORD  ' [^P^]....Mot de passe de la porte
  RIP Set Door Password
  MENUITEM  0 _HELP       ' [^?^]....Aide
  RIP ? HELP
  MENUITEM  0 _TOPMENU    ' [^/^]....Menu Principal
  RIP / (Main)
  MENUITEM  0 _RETURN     ' [^Q^]....Retour au menu prcdent
  RIP Quit
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU

;
; sysop menu, only the Xpress sysop can use the action codes in this
; menu. It doesn't matter if you moved them to another menu.
;

MENU SYSOP 0
  GXPROMPT  SX_SYS>
  VTITLE     YELLOW Informations Systmes
  RIPTITLE   Xpress Sysop Menu
  HELP      sysop
  ITEMCOLOR 63 WHITE
  MENUITEM  0   _JUNK         '^ Information Systme ^'
  ITEMCOLOR YELLOW CYAN
  MENUITEM   0  _USRLIST      ' [^1^] Liste des utilisateurs
  RIP 1-Xpress User List
  MENUITEM   0  _RUSRLIST     ' [^2^] Liste des utilisateurs enregistrs
  RIP 2-Registered Users
  MENUITEM  200 _DNLDFILE  ?  ' [^3^] Recevoir un fichier
  RIP 3-Download a File
  MENUITEM  200 _UPLDFILE  ?  ' [^4^] Transmettre un fichier.
  RIP 4-Upload a File
  MENUITEM  200  _SYSPARM     ' [^5^] Variables Xpress
  RIP 5-Xpress Variables
  MENUITEM  200 _LOG          ' [^6^] Visionner le journal Xpress
  RIP 6-Xpress Log
  MENUITEM  200 _SHELL        ' [^7^] Shell au DOS
  RIP 7-Shell to DOS
  MENUITEM  200 _CHAT         ' [^8^] Mode conversation
  RIP 8-Chat Window
  MENUITEM  200 _TOSSDUMP     ' [^9^] Insrer le courrier de la section dump
  RIP 9-Toss Dump Mail
  MENUITEM  0   _MACROLIST    ' [^L^] Liste des macros disponibles
  RIP L-List Macros
  MENUITEM  0   _DISPVER      ' [^A^] Afficher les informations de la version
  RIP V-Version Information
  MENUITEM  200 _FILEFREQ     ' [^T^] Test de requisition de fichiers
  RIP Test File Requesting
  MENUITEM  200 _HELP         ' [^?^] Aide
  RIP ? HELP
  MENUITEM   0  _RETURN       ' [^Q^] Retour au menu Principal
  RIP Quit
  ITEMCOLOR WHITE WHITE
  MENUITEM   0  _JUNK         ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU


;
; Menu for Xpress Packet Type
;

MENU PACKET
  GXPROMPT  SX_PKT>
  VTITLE    WHITE Type de paquet pour le Courrier
  RIPTITLE  Mail Packet Type and QWK Options
  HELP      pkttype
  ITEMCOLOR 63 WHITE
  MENUITEM  0 _JUNK      '^ Type de paquet pour le Courrier ^'
  ITEMCOLOR YELLOW CYAN
  MENUITEM  0 _JUNK        Type de paquet : ^%pt^
  MENUITEM
  MENUITEM  0 _PKTOPX     ' [^X^]....OPX pour lecteur Silver Xpress
  RIP Create OPX Packets
  MENUITEM  0 _PKTQWK     ' [^K^]....QWK pour lecteurs compatibles au format QWK
  RIP Create QWK Packets
  MENUITEM  0 _GOSUB QWKOPTS  ' [^O^]....Options courrier pour QWK
  RIP Options courrier pour QWK
  MENUITEM
  MENUITEM  0 _HELP       ' [^?^]....Aide
  RIP ? HELP
  MENUITEM  0 _TOPMENU    ' [^/^]....Menu Principal
  RIP / (Main)
  MENUITEM  0 _RETURN     ' [^Q^]....Retour au menu prcdent
  RIP Quit
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU

;
; QWK Menu Options
;

MENU QWKOPTS
  GXPROMPT  SX_QWKOPT>
  VTITLE    WHITE Mail Packet Type
  RIPTITLE  Mail Packet Type
  HELP      qwkopts
  ITEMCOLOR 63 WHITE
  MENUITEM  0 _JUNK      '^ Options QWK ^'
  MENUITEM
  ITEMCOLOR YELLOW CYAN
  MENUITEM  0 _QWKSTRIPK  ' [^S^]....Supprimer les lignes contrle A de Fido   ^%sk^
  RIP Send Kludges Lines
  MENUITEM  0 _QWKCAPHDR  ' [^M^]....Entte des messages (MAJUSCULE/minuscule) ^%ch^
  RIP Capitalize QWK Header
  MENUITEM  0 _QWKNDX     ' [^T^]....Transmettre les fichiers NDX              ^%sn^
  RIP Send NDX Index Files
  MENUITEM  0 _QWKWWRAP   ' [^R^]....Retour  la ligne des mots incomplets     ^%ww^
  RIP Perform Word Wrapping
  MENUITEM  0
  MENUITEM  0 _HELP       ' [^?^]....Aide
  RIP ? HELP
  MENUITEM  0 _TOPMENU    ' [^/^]....Menu Principal
  RIP / (Main)
  MENUITEM  0 _RETURN     ' [^Q^]....Retour au menu prcdent
  RIP Quit
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU

MENU ASSIST
  GXPROMPT  SX_ASST>
  VTITLE    WHITE Assistant Xpress
  RIPTITLE  Xpress Assistant
  HELP      pkttype
  ITEMCOLOR 63 WHITE
  MENUITEM  0 _JUNK      '^ Assistant Xpress ^'
  MENUITEM
  ITEMCOLOR YELLOW CYAN
  MENUITEM  0 _DISPLAY EXPLAIN ' [^B^]....Expliquer un BBS
  RIP Explain a BBS
  MENUITEM  0 _DISPLAY ASSIST  ' [^E^]....Expliquer Xpress avec example
  RIP Xpress Assistant
  MENUITEM  0 _DISPLAY NEWUSER ' [^I^]....Information pour nouvel utilisateur
  RIP New User Information
  MENUITEM  0 _RETURN          ' [^Q^]....Retour au menu prcdent
  RIP Quit
  MENUITEM
  ITEMCOLOR WHITE WHITE
  MENUITEM  0 _JUNK      ''
  RETURNKEY Q
  VETERAN   YELLOW WHITE Cls valides: [^%keys^]
  PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Votre Commande :
ENDMENU
