@ECHO OFF
REM Sample PCBTEST.BAT batch file for UC2DIZ v1.0
REM Modify to suit your needs..

IF EXIST PCBPASS.TXT DEL PCBPASS.TXT
IF EXIST PCBFAIL.TXT DEL PCBFAIL.TXT

TESTFILE %1 ZIP ARJ LZH UC2
IF ERRORLEVEL == 98 GOTO END
IF ERRORLEVEL == 4 GOTO UC2
IF ERRORLEVEL == 3 GOTO LZH
IF ERRORLEVEL == 2 GOTO ARJ
IF ERRORLEVEL == 1 GOTO ZIP
GOTO END

:UC2
ECHO  Testing UC2 File Integrity
UC T %1 > PCBFAIL.TXT
IF ERRORLEVEL == 1 GOTO END
DEL PCBFAIL.TXT
ECHO  Checking For FILE_ID.DIZ In UC2 File
UC2DIZ C:\PCB\UC2DIZ.CFG %1 %3
GOTO END

:LZH
ECHO  Testing LZH File Integrity
LHA T %1 > PCBFAIL.TXT
IF ERRORLEVEL == 1 GOTO END
DEL PCBFAIL.TXT
ECHO  Checking For FILE_ID.DIZ In LZH File
DIZ-2PCB C:\PCB\DIZ-2PCB.CNF %1 %3
GOTO END

:ARJ
ECHO  Testing LZH File Integrity
ARJ T %1 > PCBFAIL.TXT
IF ERRORLEVEL == 1 GOTO END
DEL PCBFAIL.TXT
ECHO  Checking For FILE_ID.DIZ In ARJ File
DIZ-2PCB C:\PCB\DIZ-2PCB.CNF %1 %3
GOTO END

:ZIP
ECHO  Testing ZIP File Integrity
PKUNZIP T %1 > PCBFAIL.TXT
IF ERRORLEVEL == 1 GOTO END
DEL PCBFAIL.TXT
ECHO  Checking For FILE_ID.DIZ In ZIP File
DIZ-2PCB C:\PCB\DIZ-2PCB.CNF %1 %3
GOTO END

:END
