/* CHKSMB.C */

#include "smblib.h"

/****************************************************************************/
/* Checks the disk drive for the existence of a file. Returns 1 if it       */
/* exists, 0 if it doesn't.                                                 */
/****************************************************************************/
char fexist(char *filespec)
{
    struct ffblk f;

if(findfirst(filespec,&f,0)==0)
    return(1);
return(0);
}


char *usage="\nusage: chksmb [/opts] <filespec.SHD>\n"
			"\n"
			"opts:\n"
			"       s - stop after errored message base\n"
			"       p - pause after errored messsage base\n"
			"       q - quiet mode (no beeps while checking)\n";

int main(int argc, char **argv)
{
	char		str[128],*p,*s,*beep="\7";
	int 		i,j,x,y,errors,errlast,stop_on_error=0,pause_on_error=0;
	ulong		l,m,n,length,size,total=0,orphan=0,deleted=0,headers=0
				,*offset,*number
				,delhdrblocks,deldatblocks,hdrerr=0,lockerr=0,hdrnumerr=0
				,dupenum=0,dupenumhdr=0,dupeoff=0,delidx=0,attr=0,actalloc=0
				,delalloc=0,datactalloc=0,misnumbered=0,timeerr=0,idxofferr=0
				,zeronum,idxzeronum,idxnumerr,packable=0L;
	idxrec_t	idx;
	smbmsg_t	msg;
    smbstatus_t status;

printf("\nCHKSMB v1.12  Checks Synchronet Message Base  Copyright 1994"
	" Digital Dynamics\n");

if(argc<2) {
	printf("%s",usage);
	exit(1); }

errlast=errors=0;
for(x=1;x<argc;x++) {
	if(stop_on_error && errors)
		break;
	if(pause_on_error && errlast!=errors) {
        printf("\7\nHit any key to continue...");
        if(!getch())
            getch();
        printf("\n"); }
	errlast=errors;
	if(argv[x][0]=='/') {
		for(y=1;argv[x][y];y++)
			switch(toupper(argv[x][y])) {
				case 'Q':
					beep="";
					break;
				case 'P':
					pause_on_error=1;
					break;
				case 'S':
					stop_on_error=1;
					break;
				default:
					printf("%s",usage);
					exit(1); }
		continue; }

strcpy(smb_file,argv[x]);
p=strrchr(smb_file,'.');
s=strrchr(smb_file,'\\');
if(p>s) *p=0;
strupr(smb_file);

sprintf(str,"%s.SHD",smb_file);
if(!fexist(str)) {
	printf("\n%s doesn't exist.\n",smb_file);
	continue; }

printf("\nChecking %s Headers\n\n",smb_file);

if((i=smb_open(10))!=0) {
	printf("smb_open returned %d\n",i);
	errors++;
	continue; }

if(filelength(fileno(shd_fp))<sizeof(smbhdr_t)) {
	printf("Empty\n");
	smb_close();
	continue; }

if((i=smb_locksmbhdr(10))!=0) {
	smb_close();
	printf("smb_locksmbhdr returned %d\n",i);
	errors++;
	continue; }

if((i=smb_getstatus(&status))!=0) {
	smb_unlocksmbhdr();
	smb_close();
	printf("smb_getstatus returned %d\n",i);
	errors++;
	continue; }


length=filelength(fileno(shd_fp));


if((length/SHD_BLOCK_LEN)*sizeof(ulong)) {
	if((number=(ulong *)MALLOC(((length/SHD_BLOCK_LEN)+2)*sizeof(ulong)))
		==NULL) {
		printf("Error allocating %lu bytes of memory\n"
			,(length/SHD_BLOCK_LEN)*sizeof(ulong));
		return(++errors); } }
else
	number=NULL;

if((i=smb_open_ha(10))!=0) {
	printf("smb_open_ha returned %d\n",i);
	return(++errors); }

if((i=smb_open_da(10))!=0) {
	printf("smb_open_da returned %d\n",i);
	return(++errors); }

headers=deleted=orphan=dupenumhdr=attr=zeronum=timeerr=lockerr=hdrerr=0;
delalloc=actalloc=datactalloc=deldatblocks=delhdrblocks=0;

for(l=status.header_offset;l<length;l+=size) {
	printf("\r%2u%%  ",(long)(100.0/((float)length/l)));
	msg.idx.offset=l;
	if((i=smb_lockmsghdr(msg,10))!=0) {
		printf("\n(%06lX) smb_lockmsghdr returned %d\n",l,i);
		lockerr++;
		headers++;
		size=SHD_BLOCK_LEN;
		continue; }
	if((i=smb_getmsghdr(&msg))!=0) {
		smb_unlockmsghdr(msg);
		fseek(sha_fp,(l-status.header_offset)/SHD_BLOCK_LEN,SEEK_SET);
		j=fgetc(sha_fp);
		if(j) { 			/* Allocated block or at EOF */
			printf("%s\n(%06lX) smb_getmsghdr returned %d\n",beep,l,i);
			hdrerr++; }
		else
			delhdrblocks++;
		size=SHD_BLOCK_LEN;
		continue; }
	smb_unlockmsghdr(msg);
	printf("#%-5lu (%06lX) %-25.25s ",msg.hdr.number,l,msg.from);
	if(msg.hdr.attr&MSG_DELETE) {
		deleted++;
		if(number)
			number[headers]=0; }
	else {

		if(msg.hdr.number>status.last_msg) {
			printf("%sOut-Of-Range message number\n",beep);
			hdrnumerr++; }

		if(smb_getmsgidx(&msg)) {
			printf("%sNot found in index\n",beep);
			orphan++; }
		else if(msg.hdr.attr!=msg.idx.attr) {
			printf("%sAttributes mismatch index\n",beep);
			attr++; }
		else if(msg.hdr.when_imported.time!=msg.idx.time) {
			printf("%sImport date/time mismatch index\n",beep);
			timeerr++; }

		if(msg.hdr.number==0) {
			printf("%sZero message number\n",beep);
			zeronum++; }
		if(number) {
			for(m=0;m<headers;m++)
				if(number[m] && msg.hdr.number==number[m]) {
					printf("%sDuplicate message number\n",beep);
					dupenumhdr++;
					break; }
			number[headers]=msg.hdr.number; } }

	size=smb_getmsghdrlen(msg);
	while(size%SHD_BLOCK_LEN)
		size++;

	fseek(sha_fp,(l-status.header_offset)/SHD_BLOCK_LEN,SEEK_SET);
	for(m=0;m<size;m+=SHD_BLOCK_LEN)
		if(msg.hdr.attr&MSG_DELETE && (i=fgetc(sha_fp))!=0) {
			printf("%sDeleted Header Block %lu marked %02X\n"
				,beep,m/SHD_BLOCK_LEN,i);
			delalloc++; }
		if(!(msg.hdr.attr&MSG_DELETE) && (i=fgetc(sha_fp))!=1) {
			printf("%sActive Header Block %lu marked %02X\n"
				,beep,m/SHD_BLOCK_LEN,i);
			actalloc++; }

	if(!(msg.hdr.attr&MSG_DELETE)) {
		for(n=0;n<msg.hdr.total_dfields;n++) {
			fseek(sda_fp
				,((msg.hdr.offset+msg.dfield[n].offset)/SDT_BLOCK_LEN)*2
				,SEEK_SET);
			for(m=0;m<msg.dfield[n].length;m+=SDT_BLOCK_LEN) {
				fread(&i,2,1,sda_fp);
				if(!i) {
					printf("%sActive Data Block %lu.%lu marked free\n"
						,beep,n,m/SHD_BLOCK_LEN);
					datactalloc++; } } } }
	else
		delhdrblocks+=(size/SHD_BLOCK_LEN);
	headers++;
    smb_freemsgmem(msg); }

if(number)
    FREE(number);

printf("\r%79s\r100%%\n","");

printf("\nChecking %s Data Blocks\n\n",smb_file);

length=filelength(fileno(sda_fp));

fseek(sda_fp,0L,SEEK_SET);
for(l=0;l<length;l+=2) {
	printf("\r%2u%%  ",l ? (long)(100.0/((float)length/l)) : 0);
	i=0;
	if(!fread(&i,2,1,sda_fp))
		break;
	if(!i)
		deldatblocks++; }

fclose(sha_fp);
fclose(sda_fp);

printf("\r%79s\r100%%\n","");

total=filelength(fileno(sid_fp))/sizeof(idxrec_t);

dupenum=dupeoff=delidx=misnumbered=idxzeronum=idxnumerr=idxofferr=0;

if(total) {

printf("\nChecking %s Index\n\n",smb_file);

if((offset=(ulong *)MALLOC(total*sizeof(ulong)))==NULL) {
    printf("Error allocating %lu bytes of memory\n",total*sizeof(ulong));
	return(++errors); }
if((number=(ulong *)MALLOC(total*sizeof(ulong)))==NULL) {
    printf("Error allocating %lu bytes of memory\n",total*sizeof(ulong));
	return(++errors); }
fseek(sid_fp,0L,SEEK_SET);

for(l=0;l<total;l++) {
	printf("\r%2lu%%  %5lu ",l ? (long)(100.0/((float)total/l)) : 0,l);
    fread(&idx,sizeof(idxrec_t),1,sid_fp);
	printf("#%-5lu (%06lX) 1st Pass ",idx.number,idx.offset);
	if(idx.attr&MSG_DELETE) {
		printf("%sMarked for deletion\n",beep);
		delidx++; }
	for(m=0;m<l;m++)
        if(number[m]==idx.number) {
			printf("%sDuplicate message number\n",beep);
			dupenum++;
			break; }
	for(m=0;m<l;m++)
        if(offset[m]==idx.offset) {
			printf("%sDuplicate offset\n",beep,idx.offset);
			dupeoff++;
			break; }
	if(idx.offset<status.header_offset) {
		printf("%sInvalid offset\n",beep);
		idxofferr++;
		break; }
	if(idx.number==0) {
		printf("%sZero message number\n",beep);
		idxzeronum++;
		break; }
	if(idx.number>status.last_msg) {
		printf("%sOut-Of-Range message number\n",beep);
		idxnumerr++;
		break; }
    number[l]=idx.number;
    offset[l]=idx.offset; }

printf("\r%79s\r","");
for(m=0;m<total;m++) {
	printf("\r%2lu%%  %5lu ",m ? (long)(100.0/((float)total/m)) : 0,m);
	printf("#%-5lu (%06lX) 2nd Pass ",number[m],offset[m]);
	for(n=0;n<m;n++)
		if(number[m] && number[n] && number[m]<number[n]) {
			printf("%sMisordered message number\n",beep);
			misnumbered++;
			number[n]=0;
			break; } }
FREE(number);
FREE(offset);

printf("\r%79s\r100%%\n","");

}


printf("\n");
printf("%-35.35s (=): %lu\n"
	,"Status Total"
	,status.total_msgs);
printf("%-35.35s (=): %lu\n"
	,"Index Records"
	,total);
printf("%-35.35s (=): %lu\n"
	,"Active Headers"
	,headers-deleted);
printf("%-35.35s ( ): %lu\n"
	,"Header Records"
    ,headers);
printf("%-35.35s ( ): %lu\n"
	,"Deleted Headers"
	,deleted);
printf("%-35.35s ( ): %-5lu (%lu bytes)\n"
	,"Deleted Header Blocks"
	,delhdrblocks,delhdrblocks*SHD_BLOCK_LEN);
packable+=(delhdrblocks*SHD_BLOCK_LEN);
printf("%-35.35s ( ): %-5lu (%lu bytes)\n"
	,"Deleted Data Blocks"
	,deldatblocks,deldatblocks*SDT_BLOCK_LEN);
packable+=(deldatblocks*SDT_BLOCK_LEN);
if(orphan)
	printf("%-35.35s (!): %lu\n"
		,"Orphaned Headers"
		,orphan);
if(idxzeronum)
	printf("%-35.35s (!): %lu\n"
		,"Zeroed Index Numbers"
		,idxzeronum);
if(zeronum)
	printf("%-35.35s (!): %lu\n"
		,"Zeroed Header Numbers"
		,zeronum);
if(delidx)
	printf("%-35.35s (!): %lu\n"
		,"Deleted Index Records"
		,delidx);
if(idxofferr)
	printf("%-35.35s (!): %lu\n"
		,"Invalid Index Offsets"
		,idxofferr);
if(dupenum)
	printf("%-35.35s (!): %lu\n"
		,"Duplicate Index Numbers"
		,dupenum);
if(dupeoff)
	printf("%-35.35s (!): %lu\n"
		,"Duplicate Index Offsets"
		,dupeoff);
if(dupenumhdr)
	printf("%-35.35s (!): %lu\n"
		,"Duplicate Header Numbers"
		,dupenumhdr);
if(misnumbered)
	printf("%-35.35s (!): %lu\n"
		,"Misordered Index Numbers"
		,misnumbered);
if(lockerr)
	printf("%-35.35s (!): %lu\n"
		,"Unlockable Header Records"
		,lockerr);
if(hdrerr)
	printf("%-35.35s (!): %lu\n"
		,"Unreadable Header Records"
		,hdrerr);
if(idxnumerr)
    printf("%-35.35s (!): %lu\n"
		,"Out-Of-Range Index Numbers"
		,idxnumerr);
if(hdrnumerr)
    printf("%-35.35s (!): %lu\n"
		,"Out-Of-Range Header Numbers"
		,hdrnumerr);
if(attr)
	printf("%-35.35s (!): %lu\n"
		,"Mismatched Header Attributes"
		,attr);
if(timeerr)
	printf("%-35.35s (!): %lu\n"
		,"Mismatched Header Import Time"
		,timeerr);
if(datactalloc)
	printf("%-35.35s (!): %lu\n"
		,"Misallocated Active Data Blocks"
		,datactalloc);
if(actalloc)
	printf("%-35.35s (!): %lu\n"
		,"Misallocated Active Header Blocks"
		,actalloc);
if(delalloc)
	printf("%-35.35s (!): %lu\n"
		,"Misallocated Deleted Header Blocks"
		,delalloc);

printf("\n%s Message Base ",smb_file);
if((headers-deleted)!=status.total_msgs || total!=status.total_msgs
	|| (headers-deleted)!=total || idxzeronum || zeronum
	|| orphan || delidx || dupenumhdr || dupenum || dupeoff || attr
	|| lockerr || hdrerr || hdrnumerr || idxnumerr || idxofferr
	|| actalloc || delalloc || datactalloc || misnumbered || timeerr) {
	printf("%shas Errors!\n",beep);
	errors++; }
else
	printf("is OK\n");

smb_unlocksmbhdr();
smb_close();
}
if(pause_on_error && errlast!=errors) {
	printf("\7\nHit any key to continue...");
	if(!getch())
		getch();
	printf("\n"); }
if(packable)
	printf("\n%lu total packable bytes\n",packable);
return(errors);
}
