/*
 Ŀ
                                                                         
                      
     ߱   ߱ ۱۱ ߱            
             ۱۱                
            ߱  ߱      ۱          
                              
                                       
                                                                         
       Module   :       SCANMAIL.C - extraction de mail de la base       
                        source pompe de GETMAIL, by Ren Cougnenc       
                                                                         
 
*/


#include <fcntl.h>
#include <io.h>
#include <malloc.h>
#include <memory.h>
#include <share.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pcbmove.h"
#include "mystring.h"
#include "postmsg.h"
#include "system.h"
#include "scanmail.h"
#include "strings.h"

int error;                /* flag si erreur lors d'un move */
long LowNum;

int scan_mail (void)
{
  int fin;
  int code_retour;
  SingleBasic BAS_LowNum;

   if(  (fin = sopen(Config.MessageBase, O_RDWR | O_BINARY, SH_DENYNO )) == -1)
   {
        puterrorlog(_Strings[L_CanNotAccesMessage], Config.MessageBase);
        return ERROR;
   }

   lseek( fin, 4L, SEEK_SET );
   read (fin, BAS_LowNum, sizeof (SingleBasic));
   LowNum = BasNum (BAS_LowNum);    /* get LowerMessage number and */
                                    /* convert from Basic          */
   lseek( fin, 128L, SEEK_SET );   /* skip the message base header */

   printf(_Strings[M_ScanningMessage], Config.MessageBase);
   putuselog (_Strings[L_ScanMessage], Config.MessageBase);

   code_retour = extract_mail (fin);
   printf("\n");
   close (fin);
   return (code_retour);

}
/*------------------------------------------------------------------------*/
int extract_mail (int fin)
{

    char buf[128] ;
    long curpos ;
    int len = strlen( Config.ToField );
    char far *msgbuf ;


    if(( msgbuf = (char *) malloc(MAXMSG)) == NULL )
    {
        puterrorlog (_Strings[L_MallocMessageError], MAXMSG);
        return ERROR ;
    }

    while(1)
    {
        curpos = tell( fin );
        if( (read( fin, buf , 128 )) <= 0 )
             break ;  /* end of file... */

        read( fin, msgbuf, (buf[9] -1) * 128 ); /* read the message..      */
        if(! strncmp( buf +23, Config.ToField, len ) && buf[120] != '')
        {                       /* User found and message isn"t killed: */
            error = NON;
            read_body(buf, msgbuf);          /* extract the message...       */
            buf[120]  = '';                 /* Kill the message.            */
            lseek( fin, curpos, SEEK_SET );  /* Go back to the header....    */
            write( fin, buf , 128 ) ;        /* Write the header back...     */
            mark_kill_in_index(buf);         /* Kill in index message base   */
            read( fin, msgbuf, (buf[9] -1) * 128 ); /* skip the message..    */
            if (*Config.DebugFlag == ON || error == OUI)
                putdebug (msgbuf, (buf[9] -1) * 128);
        } /* fin if */
    } /* boucle sans fin */

    free( msgbuf );
}

/*--------------------------------------------------------------------------*/
/*
 *      READ_BODY : On analyse le corps du message
 */

void read_body(char *buf, char *msgbuf)
{
       char far *fptr = msgbuf ;
       char far *fptr2;
       unsigned len, i, area_nbr;
       int      code_retour;

       len = (buf[9] -1 ) * 128 ;       /* message length */

       strncpy(FromField, buf + 58, 25 );
       strclean(FromField);
       strupr (FromField);              /* on met au net le From */

       strncpy(DateField, buf + 10, 8 );
       DateField[8] = 0;

       strncpy(HeureField, buf + 18, 5 );
       HeureField[5] = 0;

       if (!strcmp (FromField, Config.ToField)) return;
                        /* si From PCBMOVE : c'est une plaisanterie */
       if (strcmp (FromField, "SYSOP"))    /* si SYSOP, no level test */
       {                                   /* sinon, level test ...   */
            i = getuserlevel (FromField);
            if (i == ERROR)
            {
                 puterrorlog (_Strings[L_UnknownUser], FromField);
                 error = OUI;
                 return;
            }
            if ( i < atoi (Config.Security)
               && Config.UserNeedForward)       /* si exist un message type */
            {
               fptr2 = msgbuf+len-1;            /* fptr2 = fin du message */
               while (*fptr2 == ' ') *fptr2-- = '\0';
                                                /* mis au net fin du message */
               forwardmove (msgbuf);             /* on fait le forward */
               PostFile(Config.UserNeedForward); /* on dit que ca t forward*/
               putuserlog(_Strings[L_Forward], FromField, Config.ForwardUser);
               return;
            }
       } /* fin if */

       for( i = 0 ; i < len ; i++ )     /* Use ASCII format */
       {
           if( *fptr == '' )
              *fptr = 0;
           fptr++;
       } /* fin for */
       fptr--;

       while( *fptr == ' ' )            /* Cleanup the last block.*/
       {
          *fptr-- = '\0';
          len--;
       } /* fin while */

       fptr2 = fptr;
       fptr = msgbuf;

       while( fptr < fptr2)     /* tant qu'on est pas  la fin du message */
       {
          strcpy (tampon, fptr);
          i = sscanf (tampon, "%s %d %d", file_to_move, &area_ori, &area_tar);
          if (*Config.DebugFlag == ON)
              printf (_Strings[M_MoveFoundInMessage],
                      FromField, file_to_move, area_ori, area_tar);
          if (i == 3 && area_ori != area_tar)
          {                            /* y'a bien 1 mot suivi de 2 nombres */
            strupr (file_to_move);
            code_retour = move ();                      /* on fait le move */
            switch (code_retour) {
              case NOTINLIST:                 /* pas trouv l o spcifi */
                area_nbr = getmaxarea();
                for (i=1; i <= area_nbr ;i++ )
                {
                    if (i == area_ori) i++;     /* si numro d'origine, */
                                                /* on a dj cherch    */
                    getfilelist (i);    /* retourne le nom de la filelist */
                                        /* dans tampon et regarde s'il */
                                        /* n'est pas pas hasard l dedans */
                    code_retour = is_file_in_list (tampon);
                    if (code_retour == OUI)
                    {                   /* fichier dans une autre area */
                       if (i == area_tar) break;  /* il est dj o il faut */
                       AreaFound = i;
                       PostFile(Config.UserOtherAreaError);
                       break;
                    } /* fin if */
                } /* fin for */
                                        /* pas bon nom de fichier */
                if (i > area_nbr) PostFile(Config.UserFileNameError);
                break;

              case AREANOTEXIST:
                PostFile(Config.UserAreaError);
                break;

              case ORIFORBIDEN:
                PostFile(Config.UserAreaOriForbid);
                break;

              case TARFORBIDEN:
                PostFile(Config.UserAreaTarForbid);
                break;

              case ERROR:
                error = OUI;
                break;

            }  /* fin switch */

          } /* fin if */

          do fptr++; while (*fptr);      /* pour arriver au caractere NUL */
          do fptr++; while (!*fptr);     /* pour arriver  la prochaine lettre*/

       }
}
/*--------------------------------------------------------------------------
 * FORWARD : Renvoie le message d'une personne qui n'a pas un security level
 *           suffisant  un tier dsign par le SYSOP (lui mme habituellement)
 */

void forwardmove (char *msg)
{
  char *message = _Strings[M_ForwardMessage];

  memmove (msg+strlen(message), msg, MAXMSG - strlen(message));
  memcpy (msg, message, strlen(message));


  PostMessage(PRIVATE, LOCAL,            /* "Postage" du message */
              Config.ToField,Config.ForwardUser, FromField,
              msg, Config.MessageBase);
}
/*--------------------------------------------------------------------------
 * GETUSERLEVEL : retourne le niveau de scurit de l'utilisateur pass en
 *                paramtre
 */
int getuserlevel (char *FromField)
{
  FILE *fin;
  char *userbuf;
  int lenuser = 400;
  int security;

   if ((fin = _fsopen(Config.UserBase, "rb", SH_DENYNO )) == NULL)
   {
        puterrorlog(_Strings[L_CanNotAccesMessage], Config.MessageBase);
        return ERROR;
   }

   if ((userbuf = (char *) malloc(lenuser)) == NULL )
   {
       puterrorlog (_Strings[L_MallocMessageError], lenuser);
       return  ERROR ;
   }

   while (fread(userbuf, 1, lenuser, fin) == lenuser){
         *(userbuf+25) = 0;             /* marque la fin de la chaine */
         if (!strncmp (FromField, strclean(strupr(userbuf)), 25)){
            security = *(userbuf+107);
            fclose (fin);
            free (userbuf);
            return (security);
         } /* fin if */
   } /* fin while */

   fclose (fin);
   free (userbuf);
   return ERROR;
}
/*--------------------------------------------------------------------------
 * PUTDEBUG : sauve le message dans debug.msg avant de l'effacer
 *
 */
void putdebug (char *buffer, int taille)
{
    FILE *fout;
    int i;
    char *fptr;

    if(( fout = fopen("debug.msg","ab")) == NULL )
    {
        puterrorlog(_Strings[L_CanNotOpenDebug]);
        return;
    }

    fprintf (fout, "\n===================================\n");
    fprintf (fout, _Strings[M_DebugField1], FromField);
    fprintf (fout, _Strings[M_DebugField2], DateField, HeureField);

    fptr = buffer;

    for( i = 0 ; i < taille ; i++ )     /* Use ASCII format */
    {
        if( *fptr == '' )
           *fptr = '\n';
        fptr++;
    } /* fin for */

    while( *fptr == ' ' )            /* Cleanup the last block.*/
    {
       *fptr-- = '\0';
       taille--;
    }

    fwrite(buffer, taille, 1, fout);

    fclose (fout);
}

/*--------------------------------------------------------------------------
 * MARK_KILL_IN_INDEX : sauve le message dans debug.msg avant de l'effacer
 *
 */
void mark_kill_in_index (char *buf)
{
   long MsgNum;
   FILE *fidx;
   long offset;

   MsgNum = BasNum (buf+1);     /* get Message number and convert from Basic */

   mkPCBnames( );              /* Retrouve le nom du fichier index */

   fidx = _fsopen(index_file,"r+b", SH_DENYNO);

   fseek (fidx,(MsgNum-LowNum)*sizeof(indextype),SEEK_SET);
   fread (&offset, 4, 1, fidx);

   offset = ~(--offset) ;          /* get negative number */

   fseek (fidx,(MsgNum-LowNum)*sizeof(indextype),SEEK_SET);
   fwrite (&offset, 4, 1, fidx);                /* put negative number for */
                                                /* inactive messages */
   fclose(fidx );
}
