/*
 Ŀ
                                                                         
                      
     ߱   ߱ ۱۱ ߱            
             ۱۱                
            ߱  ߱      ۱          
                              
                                       
                                                                         
                                                                         
       Module   :   INSTALL.C (pomp  95 % sur un soft de Rn Cougnenc)
                                                                         
       Fonction :   Programme d'installation de la configuration.        
                                                                         
                                                                         
                    Ce programme ne doit tre lanc qu'une fois, juste   
                    aprs la compilation.                                
                    Il crit la structure de configuration  la fin      
                    du code xcutable, en y placant un CRC et l'heure   
                    de la compilation.                                   
                                                                         
                    Le CRC est uniquement sur la structure et sert      
                    vrifier que celle-ci n'a pas t altre.           
                                                                         
 
*/

#include <time.h>
#include "install.h"
#include <memory.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <io.h>

#define SIGNATURE " PCBMOVE - V.Gillet 1993 - Domaine Public "

char *_months1_[] =
{
    "Jan", "Fev", "Mar", "Avr", "Mai", "Jun",
    "Jui", "Aou", "Sep", "Oct", "Nov", "Dec"
};

char *_months_[] =
{
    "Jan", "Fev", "Mar", "Avr", "Mai", "Jun",
    "Jui", "Aou", "Sep", "Oct", "Nov", "Dec"
};

char *_days_[] =
{
    "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"
};

struct InstallType Install =
{
        0x00                ,      /* CrcTest                     */
        STRUV               ,      /* Version of this structure   */
        0L                  ,      /* Time of program compilation */
} ;

/*------------------- FIN D'INIT DE LA STRUCTURE ---------------------------*/

char tampon[80];

char *frtime( long );
int calcrc(char *ptr, int count);

/*---------------------------------------------------------------------------*/
/*           ECRITURE DE LA CONFIGURATION DANS LE FICHIER EXECUTABLE         */
/*---------------------------------------------------------------------------*/
/*
*/

int WriteConf(char *programme)
{
   int fichier;                               /* handle fichier             */
   int test,trech;
   long taillefich;
   long cptime ;

   time ( & cptime );

   printf("\n        INSTALL:Ecriture de la Config par dfaut dans %s ...\n"
             ,programme);

   fichier=open(programme,O_RDWR|O_BINARY,S_IREAD|S_IWRITE);
   if(fichier==-1)return(0);               /* mais c'est peu probable...*/
   test=lseek(fichier,0L,SEEK_END);        /* va au bout du fichier       */
   if(test==-1)
   {
      printf(" Erreur dans Seek.\n");
      exit(3);
   }

   Install.CompilTime = cptime ;      /* Met la date de compilation en place */
   strcpy(Install.Signature, SIGNATURE ); /* Signe le programme */

                                 /* CRC pour securiser le nom du mec */
   Install.CrcTest =(int) calcrc((char *)&Install.StruVer,sizeof(Install) - 2);


   write(fichier,(char *)&Install.CrcTest,sizeof(Install));
   close(fichier);                           /* ma bonne dame !              */

   printf("        ( Taille Install : %d octets, CRC : %x )\n",
                     sizeof(Install),Install.CrcTest);

   printf("         Date : %s\n", frtime(Install.CompilTime ) );

   return(1);
}
/*---------------------------------------------------------------------------*/

aide()
{
printf("INSTALL: Pour la version %d de la structure de PCBMOVE.EXE !!\n",STRUV);
puts("\nSyntaxe:Install pcbmove.exe\n\n\n"
       "Initialise le fichier xcutable PCBMOVE avec une date de compilation\n"
       "A utiliser UNE SEULE fois aprs compilation de PCBMOVE.EXE\n\n");
puts("Ce programme va crire la structure de config  la FIN du fichier \n"
       "xcutable.\n\n\n");
}

/*---------------------------------------------------------------------------*/

main(int argc,char **argv)
{
#ifdef __TURBOC__
directvideo = 1;
#endif

if( argc <2)
  {
       aide();
       return(1);
  }

if( ! WriteConf(argv[1]) )
  {
   puts("Erreur,pas de fichier...\n");
   return(2);
  }
 return(0);
}

/* ------------------------------------------------------------------------ */
char *frtime( long t )
{

     struct tm *tm;

     tm = localtime( &t );

     sprintf(tampon,"%s %02d %s %d , %02d H %02d mn %02d s",
             _days_[tm->tm_wday], tm->tm_mday,
             _months_[tm->tm_mon],tm->tm_year + 1900,
             tm->tm_hour, tm->tm_min, tm->tm_sec );

  return (tampon);
}

/*-------------------------------------------------------------------------*/
/*

      Calcul du crc:extrait de la documentation de Chuck Forsberg

         Figure 8.  Example of CRC Calculation written in C


    This function calculates the CRC used by the XMODEM/CRC Protocol
    The first argument is a pointer to the message block.
    The second argument is the number of bytes in the message block.
    The function returns an integer which contains the CRC.
    The low order 16 bits are the coefficients of the CRC.
*/

int calcrc(char *ptr, int count)
   {
       int crc, i;

       crc = 0;
       while(--count >= 0)
           {
           crc = crc ^ (int)*ptr++ << 8;
           for(i = 0; i < 8; ++i)
               if(crc & 0x8000)
                   crc = crc << 1 ^ 0x1021;
               else
                   crc = crc << 1;
           }
       return (crc & 0xFFFF);
   }

/*--------------------------------------------------------------------------*/
