//****************************************************************************
// File: outlined.cpp
//
// Purpose: This file contains the code to implement a dialog
// box which displays an outline control in any of five different
// styles
//
// Functions:  Each function below is commented to explain the
// purpose.
//
// Development Team:    Phillip Cooper - Microsoft Developer Support
//
//
// Written by Microsoft Product Support Services, Languages Developer Support
// Copyright (c) 1993 Microsoft Corporation. All rights reserved.
//****************************************************************************
// outlined.cpp : implementation file
//

#define OEMRESOURCE

#include "stdafx.h"
#include "outvbx.h"
#include "outlined.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//***********************************************************************
// Function: COutlineDlg::COutlineDlg(CWnd* pParent /*=NULL*/)
//	: CDialog(COutlineDlg::IDD, pParent)
//
//
// Purpose: This function creates HPIC values that are assigned to an
// array of HPICs which is a member of this dialog class.  Those HPIC values
// are later used to initialize the picture properties of this control.
//
// The outline control has a set of default pictures that should be available
// without explicitly loading any other bitmaps.  However, due to a problem
// in MFC 2.0's emulation of Visual Basic, these default pictures are not
// available.
//
//
// Parameters:  CWnd* pParent.  A pointer to the parent of this dialog.  If
// nothing is passed in, NULL is assumed which makes the application's main
// frame window the owner of this dialog.
//
// Returns:  Constructors do not return a value
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93  Phillip Cooper - Initial implementation             PC
//***********************************************************************
/////////////////////////////////////////////////////////////////////////////
// COutlineDlg dialog

COutlineDlg::COutlineDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COutlineDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COutlineDlg)
	m_Outline = NULL;
	//}}AFX_DATA_INIT
    
   if (m_Style != 0 && m_Style !=4) 
   {
	m_Bitmaps[CLOSED].LoadBitmap(IDB_CLOSED);
    
	PIC pClosedPic ;
	pClosedPic.picData.bmp.hbitmap = 
	   (HBITMAP)m_Bitmaps[CLOSED].GetSafeHandle();
	pClosedPic.picType = PICTYPE_BITMAP;
	m_HPICS[CLOSED] = AfxSetPict(NULL, &pClosedPic);

	m_Bitmaps[OPEN].LoadBitmap(IDB_OPEN);
	PIC pOpenPic ;
	pOpenPic.picData.bmp.hbitmap = 
	   (HBITMAP)m_Bitmaps[OPEN].GetSafeHandle();
	pOpenPic.picType = PICTYPE_BITMAP;
	m_HPICS[OPEN] = AfxSetPict(NULL, &pOpenPic);

	m_Bitmaps[LEAF].LoadBitmap(IDB_LEAF);
	PIC pLeafPic ;
	pLeafPic.picData.bmp.hbitmap = 
	   (HBITMAP)m_Bitmaps[LEAF].GetSafeHandle();
	pLeafPic.picType = PICTYPE_BITMAP;
	m_HPICS[LEAF] = AfxSetPict(NULL, &pLeafPic);

	m_Bitmaps[PLUS].LoadBitmap(IDB_PLUS);
	PIC pPlusPic ;
	pPlusPic.picData.bmp.hbitmap = 
	   (HBITMAP)m_Bitmaps[PLUS].GetSafeHandle();
	pPlusPic.picType = PICTYPE_BITMAP;
	m_HPICS[PLUS] = AfxSetPict(NULL, &pPlusPic);

	m_Bitmaps[MINUS].LoadBitmap(IDB_MINUS);
	PIC pMinusPic ;
	pMinusPic.picData.bmp.hbitmap = 
	   (HBITMAP)m_Bitmaps[MINUS].GetSafeHandle();
	pMinusPic.picType = PICTYPE_BITMAP;
	m_HPICS[MINUS] = AfxSetPict(NULL, &pMinusPic);
    }
}

//***********************************************************************
// Function: COutlineDlg::~COutlineDlg()
//
// Purpose: The HPICs created in the constructor for this dialog
// must be freed before the program terminates.  This function
// does that - but only if the style property is set to one that
// actually uses the picture properties.
//
//
// Parameters: None
//
// Returns: Destructors do not return values.
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93 Phillip Cooper   Initial implementation             PC
//***********************************************************************

COutlineDlg::~COutlineDlg()
{
	// Only decrement HPIC usage count for those
	// styles that use picture properties.
	if (m_Style != 0 && m_Style !=4) {
		AfxReferencePict(m_HPICS[CLOSED], FALSE);
		AfxReferencePict(m_HPICS[OPEN], FALSE);
		AfxReferencePict(m_HPICS[LEAF], FALSE);
		AfxReferencePict(m_HPICS[PLUS], FALSE);
		AfxReferencePict(m_HPICS[MINUS], FALSE);
	}
}

void COutlineDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COutlineDlg)
	DDX_VBControl(pDX, IDC_OUTLINE, m_Outline);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COutlineDlg, CDialog)
	//{{AFX_MSG_MAP(COutlineDlg)
	ON_VBXEVENT(VBN_EXPAND, IDC_OUTLINE, OnExpandOutline1)
	ON_VBXEVENT(VBN_COLLAPSE, IDC_OUTLINE, OnCollapseOutline1)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COutlineDlg message handlers


//***********************************************************************
// Function: void COutlineDlg::SetPicProperties()
//
// Purpose: This function assigns the HPIC values created in the
// dialog's constructor to the picture properties for the control.
//
//
// Parameters: None
//
// Returns: void
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93  Phillip Cooper   Initial Implementation            PC
//***********************************************************************
void COutlineDlg::SetPicProperties()
{
  // Only set the picture properties for those styles
  // that require it.
  if (m_Style != 0 && m_Style != 4) {
	m_Outline->SetPictureProperty("PictureClosed",m_HPICS[CLOSED]);
	m_Outline->SetPictureProperty("PictureOpen",m_HPICS[OPEN]);
	m_Outline->SetPictureProperty("PictureLeaf",m_HPICS[LEAF]);
	m_Outline->SetPictureProperty("PicturePlus",m_HPICS[PLUS]);
	m_Outline->SetPictureProperty("PictureMinus",m_HPICS[MINUS]);
  }
}


//***********************************************************************
// Function: BOOL COutlineDlg::SetStyle(int style) 
//
// Purpose: This function checks the style parameter to make sure that it is
// a valid value, then assigns it to the m_Style member variable.
//
// Parameters:  int style- value to set the Outline control's style
// property to.
//
// Returns:  TRUE/FALSE.  TRUE if style is valid, otherwise FALSE.
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93  Phillip Cooper   Initial implementation            PC
//***********************************************************************
BOOL COutlineDlg::SetStyle(int style) 
{
  if (style >= 0 && style <= 5) {
    m_Style = style;
    return TRUE;
  }
  else
    return FALSE;
}

//***********************************************************************
// Function: BOOL COutlineDlg::InitOutlineCtrl()
//
// Purpose: This function handled initialization of the control.  It sets the
// style property, picture properties, add adds items to the outline control.
//
// Parameters: None
//
// Returns: TRUE/FALSE  Always returns true.  Should add error-checking
// code and return FALSE on error.
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93   Phillip Cooper   Initial Implementation            PC
//***********************************************************************
BOOL COutlineDlg::InitOutlineCtrl()
{
	// Set the outline style property.
	m_Outline->SetNumProperty("Style", m_Style);
	
	// Set picture properties.
	// NOTE: default picture properties do not seem to work in Visual C++.
	SetPicProperties();
	
	// Add the items to the outline control
	m_Outline->AddItem("Root Level", 0);
	m_Outline->SetNumProperty("Indent",0,0) ;
	m_Outline->SetNumProperty("PictureType", MSOUTLINE_PICTURE_OPEN, 0);

	for (int i=0 ; i<10 ; i++)
	{
		m_Outline->AddItem("Level 1", (long)((i*3)+1));
		m_Outline->SetNumProperty("Indent",1,
			(int)m_Outline->GetNumProperty("ListCount")-1) ;
		m_Outline->SetNumProperty("Expand",TRUE,
		    (int)m_Outline->GetNumProperty("ListCount")-1);             
		m_Outline->SetNumProperty("PictureType", MSOUTLINE_PICTURE_CLOSED, (i*3)+1);

		for (int j=1 ; j<=2 ; j++)
		{
			m_Outline->AddItem("Level 2", (long)((i*3)+j+1));
			m_Outline->SetNumProperty("Indent", 2,
				(int)m_Outline->GetNumProperty("ListCount")-1) ;
			m_Outline->SetNumProperty("PictureType", MSOUTLINE_PICTURE_LEAF, (i*3)+j+1);
		}
	}
	
	return TRUE;
}

BOOL COutlineDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	InitOutlineCtrl();      // Initialize outline control
	CenterWindow();         // Center dialog in Main frame window
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

//***********************************************************************
// Function: void COutlineDlg::OnCollapseOutline1(UINT, int, CWnd*, LPVOID lpParams)
//
// Purpose: This function handles the Collapse event by setting the picturetype
// property to MSOUTLINE_PICTURE_CLOSED.  In effect, this shows the closed folder
// bitmap.
//
// Parameters:  These are standard parameters for any VBX event handling function.
// The parameters are decoded using macros, such as AFX_NUM_EVENTPARAM, which are
// documented in MFC technote #27 in the section titled "VBX Event-Handling Function
// Parameters".  This function handles the Expand event.
//
// Returns: void
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93   Phillip Cooper   Initial implementation           PC
//***********************************************************************
void COutlineDlg::OnExpandOutline1(UINT, int, CWnd*, LPVOID lpParams)
{

   long index = AFX_NUM_EVENTPARAM (LONG, lpParams);
   
   if (m_Outline->GetNumProperty("HasSubItems", (int)index) != 0)
		m_Outline->SetNumProperty("PictureType", MSOUTLINE_PICTURE_OPEN, (int)index);
}

//***********************************************************************
// Function: void COutlineDlg::OnCollapseOutline1(UINT, int, CWnd*, LPVOID lpParams)
//
// Purpose: This function handles the Collapse event by setting the picturetype
// property to MSOUTLINE_PICTURE_CLOSED.  this shows the closed folder bitmap when
// the item is collapsed.
//
// Parameters:  Standard parameters for VBX event handling functions.  See MFC technote #27
// for more information on this.
//
// Returns: void
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93   Phillip Cooper   Initial implementation           PC
//***********************************************************************
void COutlineDlg::OnCollapseOutline1(UINT, int, CWnd*, LPVOID lpParams)
{
   long index = AFX_NUM_EVENTPARAM (LONG, lpParams);
   
   if (m_Outline->GetNumProperty("HasSubItems", (int)index) != 0)
		m_Outline->SetNumProperty("PictureType", MSOUTLINE_PICTURE_CLOSED, (int)index);
}

//***********************************************************************
// Function: void COutlineDlg::OnDestroy()
//
// Purpose: This function is called when the dialog is just about to be destroyed.
// The items in the Outline control are removed at this time.
//
// Parameters: None
//
// Returns: void
//
// Comments:
//
// History:
//
//   Date   Comment                                           Initials
// ======== ================================================= ========
// 11/01/93   Phillip Cooper    Initial Implementation          PC
//***********************************************************************
void COutlineDlg::OnDestroy()
{
   for (int i=(int)m_Outline->GetNumProperty("ListCount") ; i>0 ; i--)
      m_Outline->RemoveItem(i-1) ;

   CDialog::OnDestroy();
}

void COutlineDlg::OnButton1()
{
	m_Outline->SetRedraw(FALSE);
    for (int i=(int)m_Outline->GetNumProperty("ListCount") ; i>0 ; i--)
       m_Outline->RemoveItem(i-1) ;	
	m_Outline->SetRedraw();
	m_Outline->Invalidate();
}
