*******************************************************************************
*******************************************************************************
** Program:      DEMO.PR1                                                    **
** Created:      04/15/94    17:40:03                                        **
**                                                                           **
**        Written By:  Mark H. Kania                                         **
**        Builder Version 2.0 Demo                                           **
**        Copyright (c) 1994 Aeolus Software                                 **
**                                                                           **
** Compile:      Clipper Demo /n                                             **
**    Link:      {linker} Fi Demo Li Builder,BldrAsm                         **
**                                                                           **
**        --- Source Created Automatically by the Aeolus BUILDER ---         **
*******************************************************************************
*******************************************************************************
**                               FUNCTION MAP:                               **
**          Funcs are not in 'map order' in the program.  This is a          **
**         listing of the order funcs are executed.  In other words          **
**                           a logic flow diagram.                           **
**                                                                           **
** MENU - Root Menu                                                          **
**   MENU002 - Builder Menu                                                  **
**     MENU006 - Menus Menu                                                  **
**       HAND022 - View BDEMO002.TXT (Menus)                                 **
**     MENU005 - Dialogs Menu                                                **
**       HAND023 - View BDEMO003.TXT (Dialogs)                               **
**       DLOG035 - Dialog Sample                                             **
**         HAND036 - Dialog Prompt                                           **
**           DLOG037 - Show Progress Thermometer                             **
**             HAND038 - Display Progress Thermometer                        **
**     MENU003 - Picklist Menu                                               **
**       HAND102 - Picklist No Options Setup                                 **
**         PLST027 - No Options Picklist                                     **
**           HAND032 - No Opts Picklist Selection                            **
**       DLOG028 - Bounded by Picklist (By State)                            **
**         HAND056 - Setup Bounded by Picklist                               **
**           PLST029 - Picklist Bounded by Sample                            **
**             HAND033 - Bounded Picklist Selection                          **
**       HAND103 - QWERTY Scroll Option Setup                                **
**         PLST030 - QWERTY Picklist Sample                                  **
**           HAND031 - QWERTY Picklist Selection                             **
**       HAND024 - View BDEMO004.TXT (PickLists)                             **
**       DLOG128 - Lateral Scroll Picklist Sample                            **
**         HAND129 - Lateral Scroll Picklist Sample                          **
**           PLST130 - Lateral Scroll Picklist Sample                        **
**             HAND133 - Lateral Scroll Picklist Sample                      **
**     MENU004 - File Maintenance Menu                                       **
**       HAND025 - View BDEMO005.TXT (F Maint)                               **
**       HAND104 - File Maintenance Setup                                    **
**         FMNT034 - City File Maintenance                                   **
**     DLOG020 - Builder Desc Text File View                                 **
**       HAND021 - View BDEMO001.TXT                                         **
**     MENU008 - BMOUSE Menu                                                 **
**       HAND026 - View BDEMO006.TXT (bMouse)                                **
**     HAND138 - View BDEMO019.TXT (Incentives)                              **
**   MENU007 - Breport Menu                                                  **
**     HAND039 - View BDEMO007.TXT (Breport)                                 **
**   MENU009 - Library Menu                                                  **
**     HAND040 - View BDEMO008.TXT (Lib Funcs)                               **
**     MENU017 - Screen Menu                                                 **
**       DLOG041 - Winpush/Pop Sample                                        **
**       DLOG042 - Center() Sample                                           **
**         HAND043 - Center() Sample                                         **
**       DLOG044 - Message Sample                                            **
**         HAND045 - Message Sample                                          **
**       MENU046 - MsgBox() Menu                                             **
**         HAND047 - Plain MsgBox() Sample                                   **
**         HAND048 - Array MsgBox() Sample                                   **
**         HAND049 - Menu MsgBox() Sample                                    **
**         HAND050 - Prompt MsgBox() Sample                                  **
**       DLOG051 - SetMsgLin() Sample                                        **
**         HAND105 - SetMsgLin() Sample                                      **
**       DLOG052 - Thermometr() Sample                                       **
**         HAND053 - Thermometr() Sample                                     **
**       HAND054 - View BDEMO009.TXT (Screen)                                **
**       DLOG064 - AddPrompt() Sample                                        **
**       DLOG065 - Ask() Sample                                              **
**         HAND066 - Ask() Sample                                            **
**       DLOG067 - AskMenu() Sample                                          **
**         HAND068 - AskMenu() Sample                                        **
**       HAND134 - aPop() Sample                                             **
**       DLOG141 - AbGetEdit() Sample                                        **
**         DLOG140 - AbGetEdit() Sample                                      **
**     MENU016 - Database Menu                                               **
**       DLOG057 - Gen_Maint() Lib Func                                      **
**         FMNT058 - City File Maintenance                                   **
**       DLOG059 - Rel_Maint() Sample                                        **
**         HAND060 - Rel_Maint() Sample                                      **
**           DLOG063 - Rel_Maint() Sample                                    **
**             HAND139 - Rel_Maint() Sample                                  **
**               PLST061 - Rel_Maint() Sample                                **
**                 DLOG062 - Rel_Maint() Sample (Maint)                      **
**       DLOG069 - Plist() Sample                                            **
**       DLOG072 - Save_It() Sample                                          **
**       DLOG070 - Browser() Sample                                          **
**         HAND071 - Browser() Sample                                        **
**       DLOG073 - Fld_Repl() Sample                                         **
**       DLOG074 - iSeek() Sample                                            **
**       DLOG082 - Open_Fil() Sample                                         **
**       HAND055 - View BDEMO010.TXT (Database)                              **
**     MENU015 - Valid Menu                                                  **
**       DLOG077 - Show_Text() Sample                                        **
**       DLOG075 - PckVld() Sample                                           **
**       DLOG076 - ChkChk() Sample                                           **
**       DLOG078 - InFile() Sample                                           **
**       DLOG079 - DupChk() Sample                                           **
**       DLOG080 - GenVld() Sample                                           **
**       DLOG081 - Req() Sample                                              **
**       DLOG083 - Rght_Jst() Sample                                         **
**         HAND084 - Rght_Jst() Sample                                       **
**       HAND085 - View BDEMO011.TXT (Valid)                                 **
**     MENU014 - DOS Menu                                                    **
**       DLOG089 - ChgDir() Sample                                           **
**         HAND090 - ChgDir() Sample                                         **
**       DLOG091 - ChgDsk() Sample                                           **
**       DLOG092 - MakDir() Sample                                           **
**         HAND093 - MakDir() Sample                                         **
**       DLOG094 - InPath() Sample                                           **
**         HAND095 - InPath() Sample                                         **
**       DLOG096 - MaxHndls() Sample                                         **
**         HAND097 - MaxHndls() Sample                                       **
**       HAND086 - View BDEMO012.TXT (DOS)                                   **
**     MENU013 - Text Menu                                                   **
**       DLOG098 - fEof() Sample                                             **
**       DLOG099 - fGets() Sample                                            **
**       DLOG100 - fGetsR() Sample                                           **
**       DLOG101 - TextView() Sample                                         **
**       HAND087 - View BDEMO013.TXT (Text Files)                            **
**     MENU012 - Memo Menu                                                   **
**       DLOG106 - Edt_Memo() Sample                                         **
**         HAND107 - Edt_Memo() Sample                                       **
**       DLOG108 - Show_Memo() Sample                                        **
**       HAND088 - View BDEMO014.TXT (Memo Files)                            **
**     MENU011 - Control Menu                                                **
**       DLOG111 - TimeOut() Sample                                          **
**         HAND112 - TimeOut() Sample                                        **
**           DLOG113 - TimeOut() Sample                                      **
**       DLOG110 - TotalKeyOn()/TotalKeyOff()                                **
**       HAND109 - View BDEMO015.TXT (Control)                               **
**     MENU010 - Conversion Menu                                             **
**       DLOG115 - Hex2Dec() Sample                                          **
**         HAND116 - Hex2Dec() Sample                                        **
**       DLOG117 - Dec2Hex() Sample                                          **
**         HAND118 - Dec2Hex() Sample                                        **
**       DLOG125 - Asc2Bin() Sample                                          **
**       HAND114 - View BDEMO016.TXT (Convrsn)                               **
**     MENU018 - Other Lib Funcs Menu                                        **
**       DLOG121 - ErrTone() Sample                                          **
**         HAND124 - ErrTone() Sample                                        **
**       DLOG122 - WaitKey() Sample                                          **
**         HAND123 - WaitKey() Sample                                        **
**       DLOG131 - Between() Sample                                          **
**       DLOG132 - Numeric() Sample                                          **
**       DLOG135 - DbState() Sample                                          **
**       HAND120 - View BDEMO018.TXT (Other)                                 **
**     MENU019 - Mouse Lib Funcs Menu                                        **
**       DLOG137 - SetMouse() Sample                                         **
**       DLOG126 - AddMPad()/DelMPad() Sample                                **
**         HAND127 - AddMPad()/DelMPad() Sample                              **
**       HAND119 - View BDEMO017.TXT (Mouse)                                 **
**       DLOG136 - MouseInit() Sample                                        **
*******************************************************************************
*******************************************************************************
** Additional Procs/Funcs in this Source File:                               **
**                                                                           **
** CHK_NTXS     - Verify All System Indexes, Build if Missing.               **
** OPEN_DATA    - Open All System Database and Indexes.                      **
** DBINIT1()  - Initialize Database Field Arrays.                            **
**                                                                           **
*******************************************************************************

#include "Demo.ch"
#include "Builder.ch"
#include "Inkey.ch"
#include "Set.ch"

MEMVAR GetList

// Dialog box window coordinates
MEMVAR nDr1,nDc1,nDr2,nDc2

// Menu Selection Variables
MEMVAR nOpt,nOpt1,nOpt2,nOpt3

// GET Menu Variables
MEMVAR cMemChk1,aMemMenu1

// Memo GET Variables
MEMVAR aGetMenu1

// OPTIONS.DBF variables
MEMVAR cSys_Name,cAppl_Name,cPrt_Port,lHelp_Edit, ;
        lHelp_On,nHMax_Lins
MEMVAR qTsttxt,qReset,qCmprs,qLndcmp

STATIC nFmr1,nFmc1,nFmr2,nFmc2               // File Maintenance Window Borders

// Static Arrays to Hold Database Field Data
STATIC aCities := {},aFriends := {}

FUNC Main()
LOCAL I

************************** Initialize Clipper SET's ***************************
ALTD( 0 )          // Need Alt+D for Menus
SET(_SET_SOFTSEEK,.T.)
SET(_SET_DELETED,.T.)
SET(_SET_SCOREBOARD,.F.)
SET(_SET_WRAP,.T.)
SET(_SET_CONFIRM,.F.)
SET(_SET_EPOCH,1964)
SETCURSOR(0)
SET DATE TO AMERICAN
SET CENTURY OFF

SET(_SET_EXCLUSIVE,.T.)

************************* Initialize System Variables *************************
*# SNAPCODE USE OPTIONS
Open_Fil("OPTIONS",.T.)

VarInit()                        // set Builder defaults

** Declare variables for OPTIONS.DBF **
PRIVATE cSys_Name,cAppl_Name,cPrt_Port,lHelp_Edit, ;
        lHelp_On,nHMax_Lins
PRIVATE qTsttxt,qReset,qCmprs,qLndcmp

IF ISCOLOR()
   IF(EMPTY(Options->cBkgd_Clr),NIL,Var(BKGD_CLR_,Options->cBkgd_Clr))
   IF(EMPTY(Options->cWndw_Clr),NIL,Var(WNDW_CLR_,Options->cWndw_Clr))
   IF(EMPTY(Options->cwMsg_Clr),NIL,Var(WMSG_CLR_,Options->cwMsg_Clr))
   IF(EMPTY(Options->cwErr_Clr),NIL,Var(WERR_CLR_,Options->cwErr_Clr))
   IF(EMPTY(Options->cwRev_Clr),NIL,Var(WREV_CLR_,Options->cwRev_Clr))
   IF(EMPTY(Options->cShdw_Clr),NIL,Var(SHDW_CLR_,Options->cShdw_Clr))
   IF(EMPTY(Options->cErr_Clr),NIL,Var(ERR_CLR_,Options->cErr_Clr))
   IF(EMPTY(Options->cMsg_Clr),NIL,Var(MSG_CLR_,Options->cMsg_Clr))
   IF(EMPTY(Options->cHdr_Clr),NIL,Var(HDR_CLR_,Options->cHdr_Clr))
   IF(EMPTY(Options->cHdr_Msg),NIL,Var(HDR_MSG_,Options->cHdr_Msg))
   IF(EMPTY(Options->cHelp_Clr),NIL,Var(HELP_CLR_,Options->cHelp_Clr))
ELSE
   IF(EMPTY(Options->mBkgd_Clr),NIL,Var(BKGD_CLR_,Options->mBkgd_Clr))
   IF(EMPTY(Options->mWndw_Clr),NIL,Var(WNDW_CLR_,Options->mWndw_Clr))
   IF(EMPTY(Options->mwMsg_Clr),NIL,Var(WMSG_CLR_,Options->mwMsg_Clr))
   IF(EMPTY(Options->mwErr_Clr),NIL,Var(WERR_CLR_,Options->mwErr_Clr))
   IF(EMPTY(Options->mwRev_Clr),NIL,Var(WREV_CLR_,Options->mwRev_Clr))
   IF(EMPTY(Options->mShdw_Clr),NIL,Var(SHDW_CLR_,Options->mShdw_Clr))
   IF(EMPTY(Options->mErr_Clr),NIL,Var(ERR_CLR_,Options->mErr_Clr))
   IF(EMPTY(Options->mMsg_Clr),NIL,Var(MSG_CLR_,Options->mMsg_Clr))
   IF(EMPTY(Options->mHdr_Clr),NIL,Var(HDR_CLR_,Options->mHdr_Clr))
   IF(EMPTY(Options->mHdr_Msg),NIL,Var(HDR_MSG_,Options->mHdr_Msg))
   IF(EMPTY(Options->mHelp_Clr),NIL,Var(HELP_CLR_,Options->mHelp_Clr))
ENDIF

Var(WMSG_CLR_,Var(WMSG_CLR_)+","+Var(WGET_CLR_)+",,,"+Var(WREV_CLR_))
Var(WERR_CLR_,Var(WERR_CLR_)+","+Var(WGET_CLR_)+",,,"+Var(WREV_CLR_))
Var(WNDW_CLR_,Var(WNDW_CLR_)+","+Var(WGET_CLR_)+",,,"+Var(WREV_CLR_))

** set up defaults from OPTIONS.DBF **
cSys_Name := ALLTRIM(Options->Sys_Name)
cAppl_Name := ALLTRIM(Options->Appl_Name)
cPrt_Port := Options->Prt_Port
IF !EMPTY(cPrt_Port)
   SET(_SET_PRINTFILE,"LPT"+cPrt_Port)
ENDIF
Var(NETWORK,(Options->NtWrk="Y"))       // tell library if shared environment
Var(XPLODE,(Options->wXPlde="Y"))       // tell library if exploding windows
lHelp_Edit := (Options->Help_Edit="Y")       // Allow/Disallow Editting of Help File
lHelp_On := (Options->Help_On="Y")           // set to .T. if Help System On
                                        // or .F. to Turn Off.
nHMax_Lins := Options->HMax_Lins             // max lines editable if QHELP_EDIT is
                                        // .T.
** User Defined Defaults from OPTIONS.DBF **
qTsttxt := Options->Tsttxt
qReset := Options->Reset
qCmprs := Options->Cmprs
qLndcmp := Options->Lndcmp
*USE                                       // close OPTIONS.DBF

************************** Display Background Screen **************************
SET COLOR TO (Var(BKGD_CLR_))
FOR I := 0 TO 24
   @ I,0 SAY REPLICATE(CHR(176),80)
NEXT

** Display Company/System Name in Screen Header Box **
SET COLOR TO (Var(HDR_CLR_))
WinPush(00,00,03,79,.F.,.T.,.T.,.F.)
Message("F1-Help",00,70,00,Var(HDR_CLR_))
Center(cSys_Name,01,01,78,Var(HDR_MSG_))
Center(cAppl_Name,02,01,78,Var(HDR_MSG_))

** Display Root Menu Window **
SET COLOR TO (Var(WNDW_CLR_))
WinPush(03,00,05,79,.F.,.T.,.T.,.F.)

** Turn on Mouse Awareness **
MouseInit(KP_ALT_MINUS)

************************* Open All Application Files **************************

** Verify Existence of All Application Indexes and Create if Missing **
Message("Checking Indexes...",04,02,76)
Chk_Ntxs(04,02,76)

** Open All System Files and Indexes **
Message("Opening Files...",04,02,76)
Open_Data()
DbInit1()              // Located at End of File

*******************************************************************************
** Main Program Loop - Calls Root Menu                                       **
*******************************************************************************
SETKEY(K_F1,{||ABHelp()})
AddMPad(00,71,00,77,0,{||__KEYBOARD(CHR(K_F1))})
DO WHILE .T.
   Message("",04,02,76)
   RootMenu()
   Message("",04,02,76)
   SetMsgLin(" Press Y-Yes or N-No ")
   IF AskMenu("Exit System? ",{"< Yes >","< No >"},04,02) == "Y"
      EXIT
   ENDIF
ENDDO

*************************** Clean Up and Exit to OS ***************************
Message("Closing Files...",04,02,76)
CLOSE DATABASES
SET COLOR TO W/N
SET CURSOR ON
CLEAR
QUIT
RETURN(NIL)

*******************************************************************************
** >>>>>>>>>>>>>>>>>>>>>>>>>>>>> Menuing Sytem <<<<<<<<<<<<<<<<<<<<<<<<<<<<< **
*******************************************************************************

*******************************************************************************
** ROOT MENU OF MENUING SYSTEM                                               **
*******************************************************************************
FUNC RootMenu()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt

   nMr1 := 03
   nMc1 := 00
   nMr2 := nMr1+02
   nMc2 := nMc1+79

   SET COLOR TO (Var(WNDW_CLR_))
   VarPush("MENU001")

   nOpt=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+06," About Builder ",{||Menu002()})
   AddPrompt(aMenuArray,nMr1+01,nMc1+30," About Breport ",{||Menu007()})
   AddPrompt(aMenuArray,nMr1+01,nMc1+54," Library Functions ",{||Menu009()})

   nOpt := Menu(aMenuArray,nOpt)

   VarPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Root Menu Selection << About Builder >>                        **
**   Comment: Builder Menu                                                   **
*******************************************************************************
FUNC Menu002()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt1

   nMr1 := 05
   nMc1 := 03
   nMr2 := nMr1+08
   nMc2 := nMc1+19

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU002")

   nOpt1=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description      ",{||Dlog020("BDEMO001.TXT")})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Menus            ",{||Menu006()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Dialogs          ",{||Menu005()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," Picklists        ",{||Menu003()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," File Maintenance ",{||Menu004()})
   AddPrompt(aMenuArray,nMr1+06,nMc1+01," BMOUSE.OBJ       ",{||Menu008()})
   AddPrompt(aMenuArray,nMr1+07,nMc1+01," Incentives       ",{||Hand138()})

   TtlKeyOn()                 // enable left/right menu movement
   nOpt1 := Menu(aMenuArray,nOpt1)
   TtlKeyOff()                // disable left/right menu movement

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Picklists >> in Proc:  MENU002                    **
**   Comment: Picklist Menu                                                  **
*******************************************************************************
FUNC Menu003()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 10
   nMc1 := 09
   nMr2 := nMr1+06
   nMc2 := nMc1+23

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU003")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description          ",{||Hand024()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," No Options           ",{||Hand102()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Bounded by Option    ",{||Dlog028()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," QWERTY Scroll Option ",{||Hand103()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," Lateral Scrolling    ",{||Dlog128()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << File Maintenance >> in Proc:  MENU002             **
**   Comment: File Maintenance Menu                                          **
*******************************************************************************
FUNC Menu004()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 11
   nMc1 := 12
   nMr2 := nMr1+03
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU004")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand025()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Sample      ",{||Hand104()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Dialogs >> in Proc:  MENU002                      **
**   Comment: Dialogs Menu                                                   **
*******************************************************************************
FUNC Menu005()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 09
   nMc1 := 14
   nMr2 := nMr1+03
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU005")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand023()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Show Dialog ",{||Dlog035()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Menus >> in Proc:  MENU002                        **
**   Comment: Menus Menu                                                     **
*******************************************************************************
FUNC Menu006()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 08
   nMc1 := 12
   nMr2 := nMr1+02
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU006")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand022()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Root Menu Selection << About Breport >>                        **
**   Comment: Breport Menu                                                   **
*******************************************************************************
FUNC Menu007()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt1

   nMr1 := 05
   nMc1 := 30
   nMr2 := nMr1+02
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU007")

   nOpt1=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand039()})

   TtlKeyOn()                 // enable left/right menu movement
   nOpt1 := Menu(aMenuArray,nOpt1)
   TtlKeyOff()                // disable left/right menu movement

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << BMOUSE.OBJ >> in Proc:  MENU002                   **
**   Comment: BMOUSE Menu                                                    **
*******************************************************************************
FUNC Menu008()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 12
   nMc1 := 11
   nMr2 := nMr1+02
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU008")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand026()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Root Menu Selection << Library Functions >>                    **
**   Comment: Library Menu                                                   **
*******************************************************************************
FUNC Menu009()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt1

   nMr1 := 05
   nMc1 := 56
   nMr2 := nMr1+12
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU009")

   nOpt1=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand040()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Screen      ",{||Menu017()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Database    ",{||Menu016()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," Valid       ",{||Menu015()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," DOS         ",{||Menu014()})
   AddPrompt(aMenuArray,nMr1+06,nMc1+01," Text Files  ",{||Menu013()})
   AddPrompt(aMenuArray,nMr1+07,nMc1+01," Memo        ",{||Menu012()})
   AddPrompt(aMenuArray,nMr1+08,nMc1+01," Control     ",{||Menu011()})
   AddPrompt(aMenuArray,nMr1+09,nMc1+01," Conversion  ",{||Menu010()})
   AddPrompt(aMenuArray,nMr1+10,nMc1+01," Mouse       ",{||Menu019()})
   AddPrompt(aMenuArray,nMr1+11,nMc1+01," Other       ",{||Menu018()})

   TtlKeyOn()                 // enable left/right menu movement
   nOpt1 := Menu(aMenuArray,nOpt1)
   TtlKeyOff()                // disable left/right menu movement

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Conversion >> in Proc:  MENU009                   **
**   Comment: Conversion Menu                                                **
*******************************************************************************
FUNC Menu010()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 15
   nMc1 := 49
   nMr2 := nMr1+05
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU010")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand114()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Hex2Dec()   ",{||Dlog115()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Dec2Hex()   ",{||Dlog117()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," Asc2Bin()   ",{||Dlog125()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Control >> in Proc:  MENU009                      **
**   Comment: Control Menu                                                   **
*******************************************************************************
FUNC Menu011()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 14
   nMc1 := 36
   nMr2 := nMr1+04
   nMc2 := nMc1+29

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU011")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

// AddPrompt(aMenuArray,nMr1+01,nMc1+01," Dummy                      ")
   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description                ",{||Hand109()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," TimeOut()                  ",{||Dlog111()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," TotalKeyOn()/TotalKeyOff() ",{||Dlog110()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Memo >> in Proc:  MENU009                         **
**   Comment: Memo Menu                                                      **
*******************************************************************************
FUNC Menu012()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 13
   nMc1 := 50
   nMr2 := nMr1+04
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU012")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand088()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Edt_Memo()  ",{||Dlog106()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Show_Memo() ",{||Dlog108()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Text Files >> in Proc:  MENU009                   **
**   Comment: Text Menu                                                      **
*******************************************************************************
FUNC Menu013()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 12
   nMc1 := 50
   nMr2 := nMr1+06
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU013")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand087()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," fEof()      ",{||Dlog098()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," fGets()     ",{||Dlog099()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," fGetsR()    ",{||Dlog100()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," TextView()  ",{||Dlog101()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << DOS >> in Proc:  MENU009                          **
**   Comment: DOS Menu                                                       **
*******************************************************************************
FUNC Menu014()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 11
   nMc1 := 51
   nMr2 := nMr1+07
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU014")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand086()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," ChgDir()    ",{||Dlog089()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," ChgDsk()    ",{||Dlog091()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," MakDir()    ",{||Dlog092()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," InPath()    ",{||Dlog094()})
   AddPrompt(aMenuArray,nMr1+06,nMc1+01," MaxHndls()  ",{||Dlog096()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Valid >> in Proc:  MENU009                        **
**   Comment: Valid Menu                                                     **
*******************************************************************************
FUNC Menu015()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 10
   nMc1 := 51
   nMr2 := nMr1+10
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU015")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand085()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Show_Text() ",{||Dlog077()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," PckVld()    ",{||Dlog075()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," ChkChr()    ",{||Dlog076()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," InFile()    ",{||Dlog078()})
   AddPrompt(aMenuArray,nMr1+06,nMc1+01," DupChk()    ",{||Dlog079()})
   AddPrompt(aMenuArray,nMr1+07,nMc1+01," GenVld()    ",{||Dlog080()})
   AddPrompt(aMenuArray,nMr1+08,nMc1+01," Req()       ",{||Dlog081()})
   AddPrompt(aMenuArray,nMr1+09,nMc1+01," Rght_Jst()  ",{||Dlog083()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Database >> in Proc:  MENU009                     **
**   Comment: Database Menu                                                  **
*******************************************************************************
FUNC Menu016()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 09
   nMc1 := 50
   nMr2 := nMr1+10
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU016")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand055()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Gen_Maint() ",{||Dlog057()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Rel_Maint() ",{||Dlog059()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," Plist()     ",{||Dlog069()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," Browser()   ",{||Dlog070()})
   AddPrompt(aMenuArray,nMr1+06,nMc1+01," Save_It()   ",{||Dlog072()})
   AddPrompt(aMenuArray,nMr1+07,nMc1+01," Fld_Repl()  ",{||Dlog073()})
   AddPrompt(aMenuArray,nMr1+08,nMc1+01," iSeek()     ",{||Dlog074()})
   AddPrompt(aMenuArray,nMr1+09,nMc1+01," Open_Fil()  ",{||Dlog082()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Screen >> in Proc:  MENU009                       **
**   Comment: Screen Menu                                                    **
*******************************************************************************
FUNC Menu017()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 08
   nMc1 := 42
   nMr2 := nMr1+13
   nMc2 := nMc1+23

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU017")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description          ",{||Hand054()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," WinPush()/WinPop()   ",{||Dlog041()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Center()             ",{||Dlog042()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," Message()            ",{||Dlog044()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," MsgBox()             ",{||Menu046()})
   AddPrompt(aMenuArray,nMr1+06,nMc1+01," SetMsgLin()          ",{||Dlog051()})
   AddPrompt(aMenuArray,nMr1+07,nMc1+01," Thermometr()         ",{||Dlog052()})
   AddPrompt(aMenuArray,nMr1+08,nMc1+01," AddPrompt()/AbMenu() ",{||Dlog064()})
   AddPrompt(aMenuArray,nMr1+09,nMc1+01," Ask()                ",{||Dlog065()})
   AddPrompt(aMenuArray,nMr1+10,nMc1+01," AskMenu()            ",{||Dlog067()})
   AddPrompt(aMenuArray,nMr1+11,nMc1+01," aPop()               ",{||Hand134()})
   AddPrompt(aMenuArray,nMr1+12,nMc1+01," AbGetEdit()          ",{||Dlog141()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Other >> in Proc:  MENU009                        **
**   Comment: Other Lib Funcs Menu                                           **
*******************************************************************************
FUNC Menu018()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 15
   nMc1 := 42
   nMr2 := nMr1+07
   nMc2 := nMc1+14

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU018")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description ",{||Hand120()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," ErrTone()   ",{||Dlog121()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," WaitKey()   ",{||Dlog122()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," Between()   ",{||Dlog131()})
   AddPrompt(aMenuArray,nMr1+05,nMc1+01," Numeric()   ",{||Dlog132()})
   AddPrompt(aMenuArray,nMr1+06,nMc1+01," DbState()   ",{||Dlog135()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Mouse >> in Proc:  MENU009                        **
**   Comment: Mouse Lib Funcs Menu                                           **
*******************************************************************************
FUNC Menu019()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt2

   nMr1 := 16
   nMc1 := 43
   nMr2 := nMr1+05
   nMc2 := nMc1+22

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU019")

   nOpt2=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Description         ",{||Hand119()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," MouseInit()         ",{||Dlog136()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," SetMouse()          ",{||Dlog137()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," AddMPad()/DelMPad() ",{||Dlog126()})

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << MsgBox() >> in Proc:  MENU017                     **
**   Comment: MsgBox() Menu                                                  **
*******************************************************************************
FUNC Menu046()
   LOCAL nMr1,nMc1,nMr2,nMc2,aMenuArray := {}
   PRIVATE nOpt3

   nMr1 := 14
   nMc1 := 40
   nMr2 := nMr1+05
   nMc2 := nMc1+09

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nMr1,nMc1,nMr2,nMc2)
   VarPush("MENU046")

   nOpt3=0
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ")
   SET COLOR TO (Var(WNDW_CLR_))

   AddPrompt(aMenuArray,nMr1+01,nMc1+01," Plain  ",{||Hand047()})
   AddPrompt(aMenuArray,nMr1+02,nMc1+01," Array  ",{||Hand048()})
   AddPrompt(aMenuArray,nMr1+03,nMc1+01," Menu   ",{||Hand049()})
   AddPrompt(aMenuArray,nMr1+04,nMc1+01," Prompt ",{||Hand050()})

   nOpt3 := Menu(aMenuArray,nOpt3)

   VarPop()
   WinPop()
   RETURN(NIL)

************************* ENDMENU End of Menu System **************************

*******************************************************************************
** >>>>>>>>>>>>>>>>>>>>>>>>>> Hand Coded by User <<<<<<<<<<<<<<<<<<<<<<<<<<< **
*******************************************************************************

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG020   Builder Desc Text File View          **
**   Comment: View BDEMO001.TXT                                              **
*******************************************************************************
FUNC Hand021(cViewFile)
   LOCAL cOldClr,nUpIdx,nDnIdx,nRtIdx,nLfIdx

   IF cViewFile == NIL
      ErrTone()
      MsgBox("ERROR:  No File to View")
      RETURN(NIL)
   ENDIF

   IF !FILE(cViewFile)
      ErrTone()
      MsgBox("ERROR: File "+cViewFile+" is Missing!")
      RETURN(NIL)
   ENDIF

   SetMsgLin(" Arrows/PgUp/PgDn-Scroll  Alt+P-Print"+ ;
             " ESC-Exit ")
   cOldClr := SETCOLOR(AbVar(WMSG_CLR_))

   // Set up mouse pads on window borders
   nUpIdx := AddMPad(nDr1,nDc1,nDr1,nDc2,1,{||__KEYBOARD(CHR(K_UP))})
   nDnIdx := AddMPad(nDr2,nDc1,nDr2,nDc2,1,{||__KEYBOARD(CHR(K_DOWN))})
   nLfIdx := AddMPad(nDr1,nDc1,nDr2,nDc1,1,{||__KEYBOARD(CHR(K_LEFT))})
   nRtIdx := AddMPad(nDr1,nDc2,nDr2,nDc2,1,{||__KEYBOARD(CHR(K_RIGHT))})

   TextView(nDr1+1,nDc1+1,nDr2-1,nDc2-1,cViewFile,.t.)

   // Remove mouse pads
   DelMPad(nUpIdx)
   DelMPad(nDnIdx)
   DelMPad(nLfIdx)
   DelMPad(nRtIdx)

   SETCOLOR(cOldClr)
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU006                  **
**   Comment: View BDEMO002.TXT (Menus)                                      **
*******************************************************************************
FUNC Hand022()
   Dlog020("BDEMO002.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU005                  **
**   Comment: View BDEMO003.TXT (Dialogs)                                    **
*******************************************************************************
FUNC Hand023()
   Dlog020("BDEMO003.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU003                  **
**   Comment: View BDEMO004.TXT (PickLists)                                  **
*******************************************************************************
FUNC Hand024()
   Dlog020("BDEMO004.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU004                  **
**   Comment: View BDEMO005.TXT (F Maint)                                    **
*******************************************************************************
FUNC Hand025()
   Dlog020("BDEMO005.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU008                  **
**   Comment: View BDEMO006.TXT (bMouse)                                     **
*******************************************************************************
FUNC Hand026()
   Dlog020("BDEMO006.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Pick List Window:  PLST030   QWERTY Picklist Sample            **
**   Comment: QWERTY Picklist Selection                                      **
*******************************************************************************
FUNC Hand031()
   MsgBox("You Selected City: "+Cities->City,AbVar(MSG_CLR_))
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Pick List Window:  PLST027   No Options Picklist               **
**   Comment: No Opts Picklist Selection                                     **
*******************************************************************************
FUNC Hand032()
   MsgBox("You Selected City: "+Cities->City,AbVar(MSG_CLR_))
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Pick List Window:  PLST029   Picklist Bounded by Sample        **
**   Comment: Bounded Picklist Selection                                     **
*******************************************************************************
FUNC Hand033()
   MsgBox("You Selected City: "+Cities->City,AbVar(MSG_CLR_))
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG035   Dialog Sample                        **
**   Comment: Dialog Prompt                                                  **
*******************************************************************************
FUNC Hand036()
   LOCAL p := "Ready to Start? ",a := {"Yes","No"}

   // Present Prompt, Return to Previous Window Unless "Yes" is Selected
   SetMsgLin(" Press Y-Yes or N-No ")
   IF AskMenu(p,a,nDr2-1,nDc1+2,,nDc2-nDc1-3,AbVar(WMSG_CLR_)) != "Y"
      // "No" Selected
      RETURN(NIL)
   ENDIF

   // "Yes" Selected
   Dlog037()                    // Execute Next Window in Chain
   KEYBOARD CHR(K_ESC)         // Remove Previous Window from Screen
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG037   Show Progress Thermometer            **
**   Comment: Display Progress Thermometer                                   **
*******************************************************************************
FUNC Hand038()
   LOCAL J,cThm,cOThm := " "

   // Display a Progression Thermometer
   FOR J := 1 TO 500
      cThm := Thermometr(40,1,500,J)
      IF cThm != cOThm
         @ nDr2-1,nDc1+2 SAY cThm
         cOThm := cThm
      ENDIF
   NEXT

   KEYBOARD(K_ESC)            // Remove Previous Window
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU007                  **
**   Comment: View BDEMO007.TXT (Breport)                                    **
*******************************************************************************
FUNC Hand039()
   Dlog020("BDEMO007.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU009                  **
**   Comment: View BDEMO008.TXT (Lib Funcs)                                  **
*******************************************************************************
FUNC Hand040()
   Dlog020("BDEMO008.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG042   Center() Sample                      **
**   Comment: Center() Sample                                                **
*******************************************************************************
FUNC Hand043()
   Center(">> This is Centered <<",nDr1+4,nDc1+1,nDc2-nDc1-3)
   WaitKey()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG044   Message Sample                       **
**   Comment: Message Sample                                                 **
*******************************************************************************
FUNC Hand045()
   Message("Press a Key for the Next Message",nDr2-1,nDc1+2, ;
           nDc2-nDc1-3,AbVar(WERR_CLR_))
   WaitKey()

   Message("This One Blinks, Press a Key",nDr2-1,nDc1+2, ;
           nDc2-nDc1-3,"*"+AbVar(WERR_CLR_))
   WaitKey()

   Message("Last One!  Goodbye",nDr2-1,nDc1+2,nDc2-nDc1-3,AbVar(WMSG_CLR_))
   WaitKey()

   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Plain >> in Proc:  MENU046                        **
**   Comment: Plain MsgBox() Sample                                          **
*******************************************************************************
FUNC Hand047()
   MsgBox("Plain MsgBox() Sample")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Array >> in Proc:  MENU046                        **
**   Comment: Array MsgBox() Sample                                          **
*******************************************************************************
FUNC Hand048()
   MsgBox({"An Array Can Be Passed", ;
           "To the MsgBox() Function", ;
           "To Create Multi Line" , ;
           "Boxed Messages."})
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Menu >> in Proc:  MENU046                         **
**   Comment: Menu MsgBox() Sample                                           **
*******************************************************************************
FUNC Hand049()
   LOCAL nAnswer

   SetMsgLin(" Use Arrows-Move Pointer  ENTER-Select  ESC-Exit ")
   nAnswer := MsgBox({"How Much Wood Would", ;
                      "a Woodchuck Chuck", ;
                      "If a Woodchuck Could", ;
                      "Chuck Wood?"},AbVar(MSG_CLR_),, ;
                      {"Little","Some","Lots","Gobs"})

   DO CASE
   CASE nAnswer == 1
      MsgBox("Your Answer: LITTLE")
   CASE nAnswer == 2
      MsgBox("Your Answer: SOME")
   CASE nAnswer == 3
      MsgBox("Your Answer: LOTS")
   CASE nAnswer == 4
      MsgBox("Your Answer: GOBS")
   ENDCASE
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Prompt >> in Proc:  MENU046                       **
**   Comment: Prompt MsgBox() Sample                                         **
*******************************************************************************
FUNC Hand050()
   LOCAL cAnswer

   SetMsgLin(" Press L-Little, S-Some, O-lOts, or G-Gobs  ESC-Exit")
   cAnswer := MsgBox({"How Much Wood Would", ;
                      "a Woodchuck Chuck", ;
                      "If a Woodchuck Could", ;
                      "Chuck Wood?", ;
                      "[L]ittle [S]ome L[O]ts [G]obs"}, ;
                      AbVar(MSG_CLR_),,"LSOG")

   DO CASE
   CASE cAnswer == "L"
     MsgBox("Your Answer: LITTLE")
   CASE cAnswer == "S"
      MsgBox("Your Answer: SOME")
   CASE cAnswer == "O"
      MsgBox("Your Answer: LOTS")
   CASE cAnswer == "G"
      MsgBox("Your Answer: GOBS")
   ENDCASE
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG052   Thermometr() Sample                  **
**   Comment: Thermometr() Sample                                            **
*******************************************************************************
FUNC Hand053()
   LOCAL J,cThm,cOThm := " "

   // Display a Progression Thermometer
   FOR J := 1 TO 500
      cThm := Thermometr(40,1,500,J)
      IF cThm != cOThm
         @ nDr2-1,nDc1+2 SAY cThm
         cOThm := cThm
      ENDIF
   NEXT

   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU017                  **
**   Comment: View BDEMO009.TXT (Screen)                                     **
*******************************************************************************
FUNC Hand054()
   Dlog020("BDEMO009.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU016                  **
**   Comment: View BDEMO010.TXT (Database)                                   **
*******************************************************************************
FUNC Hand055()
   Dlog020("BDEMO010.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG028   Bounded by Picklist (By State)       **
**   Comment: Setup Bounded by Picklist                                      **
*******************************************************************************
FUNC Hand056()
   SELECT Cities
   SET ORDER TO 3
   IF !iSeek(mState,"CITIES",3)
      ErrTone()
      MsgBox("That State Not Found")
      RETURN(NIL)
   ENDIF

   Plst029()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG059   Rel_Maint() Sample                   **
**   Comment: Rel_Maint() Sample                                             **
*******************************************************************************
FUNC Hand060()
   LOCAL nKeyPress

   DO WHILE .T.
      nKeyPress := WaitKey()

      IF nKeyPress == K_SPACE
         Dlog063()
         EXIT
      ENDIF

      IF nKeyPress == K_ESC
         EXIT
      ENDIF
   ENDDO
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG065   Ask() Sample                         **
**   Comment: Ask() Sample                                                   **
*******************************************************************************
FUNC Hand066()
   LOCAL cAnswer

   cAnswer := Ask("Do You Like the Builder System? (Y/N)","YN", ;
          nDr2-1,nDc1+2,nDc2-nDc1-3,AbVar(WMSG_CLR_),"ESC")

   IF cAnswer == "Y"
      MsgBox({"WONDERFUL!  By the Way...", ;
              "Registration is Only $59", ;
              "or $99 with Library Source!"},AbVar(MSG_CLR_))
   ENDIF

   IF cAnswer == "N"
      MsgBox({"WELL Then You'll Just Have", ;
              "to Examine This Demo Until", ;
              "You See the Light!"},AbVar(MSG_CLR_))
   ENDIF
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG067   AskMenu() Sample                     **
**   Comment: AskMenu() Sample                                               **
*******************************************************************************
FUNC Hand068()
   LOCAL cAnswer

   cAnswer := AskMenu("It is: ", ;
                      {"Assembler","BASIC","C","Clipper","FoxPro"}, ;
                      nDr2-1,nDc1+2,"A",nDc2-nDc1-3,AbVar(WMSG_CLR_),"ESC")

   DO CASE
   CASE cAnswer == "A"
      MsgBox({"Fun Stuff","But Your Still a Bit-Twiddler!"})
   CASE cAnswer == "B"
      MsgBox({"I'll Keep this Demo","Simple for You"})
   CASE cAnswer == "C"
      MsgBox({"Bit-Twiddler!  Which is OK", ;
             "As Long as You Don't Use UNIX"})
   Case cAnswer == "L"
      MsgBox("When Your Right, You're RIGHT!")
   CASE cAnswer  == "F"
      MsgBox({"You are Completely","H O P E L E S S !"})
   ENDCASE
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG070   Browser() Sample                     **
**   Comment: Browser() Sample                                               **
*******************************************************************************
FUNC Hand071()
   DO WHILE .T.
     WaitKey()

     IF LASTKEY() == K_ESC .or. LastKey() == K_SPACE
       EXIT
     ENDIF
   ENDDO

   IF LASTKEY() == K_ESC
     RETURN(NIL)
   ENDIF

   SELECT Cities
   GO TOP
   SETCOLOR("+"+ABVar(HELP_CLR_))

   SetMsgLin(" Arrows/PgUp/PgDn-Scroll  ESC-Exit ")
   Browser(07,07,20,50)

   SETCOLOR(AbVar(WNDW_CLR_))
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG083   Rght_Jst() Sample                    **
**   Comment: Rght_Jst() Sample                                              **
*******************************************************************************
FUNC Hand084()
   Message("Press Any Key to Try Again.  ESC Exits",nDr2-1,nDc1+2, ;
           nDc2-nDc1-3,AbVar(WMSG_CLR_))
   WaitKey()

   IF LASTKEY() == K_ESC
     KEYBOARD CHR(K_ESC)
   ENDIF

   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU015                  **
**   Comment: View BDEMO011.TXT (Valid)                                      **
*******************************************************************************
FUNC Hand085()
   Dlog020("BDEMO011.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU014                  **
**   Comment: View BDEMO012.TXT (DOS)                                        **
*******************************************************************************
FUNC Hand086()
   Dlog020("BDEMO012.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU013                  **
**   Comment: View BDEMO013.TXT (Text Files)                                 **
*******************************************************************************
FUNC Hand087()
   Dlog020("BDEMO013.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU012                  **
**   Comment: View BDEMO014.TXT (Memo Files)                                 **
*******************************************************************************
FUNC Hand088()
   Dlog020("BDEMO014.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG089   ChgDir() Sample                      **
**   Comment: ChgDir() Sample                                                **
*******************************************************************************
FUNC Hand090()
   MsgBox("ChgDir() Return Code: "+ALLTRIM(STR(ChgDir(cDrctry),4,0)))
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG092   MakDir() Sample                      **
**   Comment: MakDir() Sample                                                **
*******************************************************************************
FUNC Hand093()
   MsgBox("MakDir() Result Code: "+ALLTRIM(STR(MakDir(cDrctry),4,0)))
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG094   InPath() Sample                      **
**   Comment: InPath() Sample                                                **
*******************************************************************************
FUNC Hand095()
   LOCAL cPath := InPath(mFile)

   DO CASE
   CASE EMPTY(cPath)
     MsgBox("File Not in DOS PATH")
   CASE cPath == "."
     MsgBox("File is in Current Directory")
   OTHERWISE
     MsgBox({"File is Located in Subdirectory:",cPath})
   ENDCASE
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG096   MaxHndls() Sample                    **
**   Comment: MaxHndls() Sample                                              **
*******************************************************************************
FUNC Hand097()
   @ nDr2-2,nDc1+28 SAY STR(MaxHndls(),3,0)
   WaitKey()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << No Options >> in Proc:  MENU003                   **
**   Comment: Picklist No Options Setup                                      **
*******************************************************************************
FUNC Hand102()
   SELECT Cities
   SET ORDER TO 1
   GO TOP

   Plst027()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << QWERTY Scroll Option >> in Proc:  MENU003         **
**   Comment: QWERTY Scroll Option Setup                                     **
*******************************************************************************
FUNC Hand103()
   SELECT Cities
   SET ORDER TO 2
   GO TOP

   Plst030()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Sample >> in Proc:  MENU004                       **
**   Comment: File Maintenance Setup                                         **
*******************************************************************************
FUNC Hand104()
   SELECT Cities
   SET ORDER TO 2
   GO TOP

   Fmnt034()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG051   SetMsgLin() Sample                   **
**   Comment: SetMsgLin() Sample                                             **
*******************************************************************************
FUNC Hand105()
   LOCAL cMsgLin

   SetMsgLin(" Press a Key to Save This Text ")
   WaitKey()
   cMsgLin := SetMsgLin(" Previous Text Saved  Press a Key to Restore ")
   WaitKey()
   SetMsgLin(cMsgLin)
   WaitKey()

   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG106   Edt_Memo() Sample                    **
**   Comment: Edt_Memo() Sample                                              **
*******************************************************************************
FUNC Hand107()
   DO WHILE .T.
      WaitKey()

      IF LASTKEY() == K_ENTER .OR. LASTKEY() == K_ESC
         EXIT
      ENDIF
   ENDDO

   IF LASTKEY() == K_ENTER
      SET CURSOR ON
      SELECT Options
      qTstTxt := Edt_Memo(10,01,22,78,qTstTxt,"TSTTXT"," TEST COMMENTS ", ;
               AbVar(WNDW_CLR_),AbVar(WMSG_CLR_),20)
      SET CURSOR OFF
   ENDIF
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU011                  **
**   Comment: View BDEMO015.TXT (Control)                                    **
*******************************************************************************
FUNC Hand109()
   Dlog020("BDEMO015.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG111   TimeOut() Sample                     **
**   Comment: TimeOut() Sample                                               **
*******************************************************************************
FUNC Hand112()
   DO WHILE .T.
      WaitKey()

      IF LASTKEY() == K_ENTER
         EXIT
      ENDIF

      IF LASTKEY() == K_ESC
         RETURN(NIL)
      ENDIF
   ENDDO

   SET KEY KP_ALT_MINUS TO TimO_Test
   TimeOut(5,Hex2Dec("4A00"))         // Set a 5 Second Timeout
   Dlog113()
   SET KEY KP_ALT_MINUS TO
   TimeOut(0,0)                       // Turn TimeOut() Off/Reset
   RETURN(NIL)

   PROC TimO_Test(Prc,Lin,Var)
      IF TimeOut() == "Y"
         MsgBox("No System Activity for 5 Consecutive Seconds!")
         KEYBOARD CHR(K_ESC)
      ENDIF
      RETURN

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU010                  **
**   Comment: View BDEMO016.TXT (Convrsn)                                    **
*******************************************************************************
FUNC Hand114()
   Dlog020("BDEMO016.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG115   Hex2Dec() Sample                     **
**   Comment: Hex2Dec() Sample                                               **
*******************************************************************************
FUNC Hand116()
   MsgBox({"The Decimal Equivalant of "+ALLTRIM(mHexNbr), ;
          "is "+ALLTRIM(STR(Hex2Dec(ALLTRIM(mHexNbr)),10,0))})
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG117   Dec2Hex() Sample                     **
**   Comment: Dec2Hex() Sample                                               **
*******************************************************************************
FUNC Hand118()
   MsgBox({"The Hexidecimal Equivalent to "+ALLTRIM(STR(mDecNbr,10,0)), ;
          "is "+Dec2Hex(mDecNbr)})
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU019                  **
**   Comment: View BDEMO017.TXT (Mouse)                                      **
*******************************************************************************
FUNC Hand119()
   Dlog020("BDEMO017.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU018                  **
**   Comment: View BDEMO018.TXT (Other)                                      **
*******************************************************************************
FUNC Hand120()
   Dlog020("BDEMO018.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG122   WaitKey() Sample                     **
**   Comment: WaitKey() Sample                                               **
*******************************************************************************
FUNC Hand123()
   MsgBox("LastKey() == "+AllTrim(Str(WaitKey())))
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG121   ErrTone() Sample                     **
**   Comment: ErrTone() Sample                                               **
*******************************************************************************
FUNC Hand124()
   ErrTone(mToneNbr)
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG126   AddMPad()/DelMPad() Sample           **
**   Comment: AddMPad()/DelMPad() Sample                                     **
*******************************************************************************
FUNC Hand127()
   LOCAL nTstIdx1 := AddMPad(nDr2-3,nDc1+1,nDr2,nDc2-1,1,{||MousePrss()}), ;
         nTstIdx2 := AddMPad(nDr2-3,nDc1+1,nDr2,nDc2-1,0,{||MouseRlse()})

   DO WHILE .T.
      WaitKey()

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF
   ENDDO

   DelMPad(nTstIdx1)
   DelMPad(nTstIdx2)

   RETURN(NIL)

   FUNC MousePrss()
      Message("LEFT MOUSE BUTTON PRESSED",nDr2-1,nDc1+2,nDc2-nDc1-3, ;
              AbVar(WERR_CLR_))
      RETURN(NIL)

   FUNC MouseRlse()
      Message("LEFT MOUSE BUTTON RELEASED",nDr2-1,nDc1+2,nDc2-nDc1-3, ;
              Abvar(WMSG_CLR_))
      RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG128   Lateral Scroll Picklist Sample       **
**   Comment: Lateral Scroll Picklist Sample                                 **
*******************************************************************************
FUNC Hand129()
   LOCAL nMouseIdx := AddMPad(0,0,24,79,0,{||__KEYBOARD(CHR(13))})

   DO WHILE .T.
      WaitKey()

      IF LASTKEY() == K_ENTER .OR. LASTKEY() == K_ESC
         EXIT
      ENDIF
   ENDDO

   DelMPad(nMouseIdx)

   IF LASTKEY() == K_ENTER
      Plst130()
   ENDIF
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Pick List Window:  PLST130   Lateral Scroll Picklist Sample    **
**   Comment: Lateral Scroll Picklist Sample                                 **
*******************************************************************************
FUNC Hand133()
   MsgBox({" City: "+Cities->City, ;
           "State: "+Cities->State, ;
           "  Zip: "+Cities->Zip, ;
           "Selected Record"})
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << aPop() >> in Proc:  MENU017                       **
**   Comment: aPop() Sample                                                  **
*******************************************************************************
FUNC Hand134()
   LOCAL Settings := {" Auto Save"," Print Headings"," Color Screen", ;
                      " Network Mode"," Display Clock"}, ;
                      MsgTxt := {"Settings You Selected:",}

   aPop(08,40,14,58,@Settings)

   AEVAL(Settings,{|x|IF(LEFT(x,1) == CHR(251), ;
         AADD(MsgTxt,"@C"+SUBSTR(x,2)),NIL)})
   MsgBox(MsgTxt,AbVar(MSG_CLR_))

   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Incentives >> in Proc:  MENU002                   **
**   Comment: View BDEMO019.TXT (Incentives)                                 **
*******************************************************************************
FUNC Hand138()
   Dlog020("BDEMO019.TXT")
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG063   Rel_Maint() Sample                   **
**   Comment: Rel_Maint() Sample                                             **
*******************************************************************************
FUNC Hand139()
   SELECT Cities
   SET ORDER TO 2
   GO TOP
   WaitKey()

   Plst061()
   RETURN(NIL)

************************** ENDHAND End of Hand Code ***************************

*******************************************************************************
** >>>>>>>>>>>>>>>>>>>>>>>>>>>>> Dialog Boxes <<<<<<<<<<<<<<<<<<<<<<<<<<<<<< **
*******************************************************************************

*******************************************************************************
** CALLED BY: Selection << Description >> in Proc:  MENU002                  **
**   Comment: Builder Desc Text File View                                    **
*******************************************************************************
FUNC Dlog020(cViewFile)
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG020")

   nDr1 := 05
   nDc1 := 00
   nDr2 := nDr1+17
   nDc2 := nDc1+78

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+01,nDc1+02 SAY "Loading File..."

   *SetMsgLin(" Enter Your Own Message Line Here  ESC-Exit ")

   Hand021(cViewFile)

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Bounded by Option >> in Proc:  MENU003            **
**   Comment: Bounded by Picklist (By State)                                 **
*******************************************************************************
FUNC Dlog028()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mstate

   VarPush("DLOG028")

   nDr1 := 14
   nDc1 := 16
   nDr2 := nDr1+06
   nDc2 := nDc1+43

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Following Picklist Will Only Display"
   @ nDr1+02,nDc1+02 SAY "Records From the State You Select."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+04,nDc1+02 SAY "State Code:"

   Mstate := Space(02)

   DO WHILE .T.
      SetMsgLin(" Enter State Code  ESC-Exit ")

      AddGet(nDr1+04,nDc1+14,{|x|IF(x==NIL,MSTATE,MSTATE:=x)},"MSTATE", ;
             "!!", ;
      {|| ;
          GenVld(In_Usa(GETACTIVE():varGet()), ;
                 "Enter a Valid U.S. State Code", ;
                 nDr2-1,nDc1+2,nDc2-2,.T.,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand056()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Show Dialog >> in Proc:  MENU005                  **
**   Comment: Dialog Sample                                                  **
*******************************************************************************
FUNC Dlog035()
   LOCAL x,aGetMenu1
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mdummy1,Mdummy2,Mdummy3,Mdummy4, ;
          Mdummy5,Mdummy6,Mdummy,Mcolor

   VarPush("DLOG035")

   nDr1 := 02
   nDc1 := 27
   nDr2 := nDr1+20
   nDc2 := nDc1+48

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+01,nDc1+02 SAY "Display Text In Your Dialog Box..."
   @ nDr1+02,nDc1+02 SAY "Display"

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+02,nDc1+10 SAY "Highlighted"
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+02,nDc1+22 SAY "Text also..."
   @ nDr1+04,nDc1+02 SAY "Issue SAYs and/or GETS"
   @ nDr1+06,nDc1+02 SAY "You Can Only Exit With ESC Until ALL Valids"
   @ nDr1+07,nDc1+02 SAY "are Satisfied.  Each of the Following Must be"
   @ nDr1+08,nDc1+02 SAY "Y or N.  Try Bypassing Using PgDn or Mouse!"

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+12,nDc1+02 SAY "Issue a MENU type GET that Will Return"
   @ nDr1+13,nDc1+02 SAY "Either a Unique Character or Numeric Value:"
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+14,nDc1+02 SAY "What is Your Favorite Color?"
   @ nDr1+17,nDc1+02 SAY "Follow Up a Dialog with Hand Code to"
   @ nDr1+18,nDc1+02 SAY "Take a Confirmation Prompt."

   Mdummy := Space(04)
   Mdummy1 := " "
   Mdummy2 := " "
   Mdummy3 := " "
   Mdummy4 := " "
   Mdummy5 := " "
   Mdummy6 := " "
   aGetMenu1 := CrteMnuArry(nDr1+15,nDc1+02,{"Red","Green","Blue","Yellow","Orange"})
   Mcolor := Space(01)

   DO WHILE .T.
      SetMsgLin(" A Dialog is a General Purpose Window  ESC-Exit ")

      AddGet(nDr1+04,nDc1+25,{|x|IF(x==NIL,MDUMMY,MDUMMY:=x)},"MDUMMY", ;
             "!!!!")
      AddGet(nDr1+10,nDc1+03,{|x|IF(x==NIL,MDUMMY1,MDUMMY1:=x)},"MDUMMY1", ;
             "!", ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})
      AddGet(nDr1+10,nDc1+07,{|x|IF(x==NIL,MDUMMY2,MDUMMY2:=x)},"MDUMMY2", ;
             "!", ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})
      AddGet(nDr1+10,nDc1+11,{|x|IF(x==NIL,MDUMMY3,MDUMMY3:=x)},"MDUMMY3", ;
             "!", ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})
      AddGet(nDr1+10,nDc1+15,{|x|IF(x==NIL,MDUMMY4,MDUMMY4:=x)},"MDUMMY4", ;
             "!", ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})
      AddGet(nDr1+10,nDc1+19,{|x|IF(x==NIL,MDUMMY5,MDUMMY5:=x)},"MDUMMY5", ;
             "!", ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})
      AddGet(nDr1+10,nDc1+23,{|x|IF(x==NIL,MDUMMY6,MDUMMY6:=x)},"MDUMMY6", ;
             "!", ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Onl", ;
                 nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})
      AddGet(nDr1+15,nDc1+02,{|x|IF(x==NIL,MCOLOR,MCOLOR:=x)},"MCOLOR",,,, ;
           {|x|IF(x==NIL,Menu(aGetMenu1,MCOLOR,x,.T.),Menu(aGetMenu1,MCOLOR,x))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand036()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Hand Code:  HAND036   Dialog Prompt                            **
**   Comment: Show Progress Thermometer                                      **
*******************************************************************************
FUNC Dlog037()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG037")

   nDr1 := 19
   nDc1 := 24
   nDr2 := nDr1+03
   nDc2 := nDc1+43

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+01,nDc1+02 SAY "Processing..."

   SetMsgLin(" Processing--Please Wait  ESC-Exit ")

   Hand038()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << WinPush()/WinPop() >> in Proc:  MENU017           **
**   Comment: Winpush/Pop Sample                                             **
*******************************************************************************
FUNC Dlog041()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG041")

   nDr1 := 11
   nDc1 := 14
   nDr2 := nDr1+07
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "WinPush()ing Displays Windows on the Screen"
   @ nDr1+02,nDc1+02 SAY "WinPop()ing Removes the Last Window from the"
   @ nDr1+03,nDc1+02 SAY "Screen."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "This Window was WinPush()ed onto the Screen."
   @ nDr1+06,nDc1+02 SAY "Press ESC to WinPop() This Window."

   DO WHILE .T.
      SetMsgLin(" WinPush()/WinPop() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Center() >> in Proc:  MENU017                     **
**   Comment: Center() Sample                                                **
*******************************************************************************
FUNC Dlog042()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG042")

   nDr1 := 12
   nDc1 := 15
   nDr2 := nDr1+07
   nDc2 := nDc1+44

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Builder Center() Function is Designed"
   @ nDr1+02,nDc1+02 SAY "to be Useable Inside a Window."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+06,nDc1+02 SAY "Press Any Key to Remove Window."

   SetMsgLin(" Center() Function Information  ESC-Exit ")

   Hand043()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Message() >> in Proc:  MENU017                    **
**   Comment: Message Sample                                                 **
*******************************************************************************
FUNC Dlog044()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG044")

   nDr1 := 13
   nDc1 := 12
   nDr2 := nDr1+06
   nDc2 := nDc1+48

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Message() Function Simply Displays a"
   @ nDr1+02,nDc1+02 SAY "Screen Message.  It is Most Useful When"
   @ nDr1+03,nDc1+02 SAY "One Screen Line is Used for Several Messages."
   SET COLOR TO (Var(WNDW_CLR_))

   SetMsgLin(" Message() Function Information  ESC-Exit ")

   Hand045()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << SetMsgLin() >> in Proc:  MENU017                  **
**   Comment: SetMsgLin() Sample                                             **
*******************************************************************************
FUNC Dlog051()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG051")

   nDr1 := 05
   nDc1 := 03
   nDr2 := nDr1+17
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The SetMsgLin() Function Works Like the"
   @ nDr1+02,nDc1+02 SAY "Clipper SetColor() Function, Except that"
   @ nDr1+03,nDc1+02 SAY "It Saves/Changes the Bottom Screen Line"
   @ nDr1+04,nDc1+02 SAY "Instead of the Screen Color."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+06,nDc1+02 SAY "For Example:"
   @ nDr1+07,nDc1+07 SAY "cLin24 := SetMsgLin()"
   @ nDr1+09,nDc1+02 SAY 'Would Set "cLin24" Equal to the Text From'
   @ nDr1+10,nDc1+02 SAY "Screen Line 24.  And:"
   @ nDr1+11,nDc1+07 SAY 'Lin24 := SetMsgLin(" Enter Stuff ")'
   @ nDr1+13,nDc1+02 SAY "Would Save the Contents of Screen Line 24"
   @ nDr1+14,nDc1+02 SAY 'in "cLin24" and Set Line 24 to the Character'
   @ nDr1+15,nDc1+02 SAY "Data Passed."

   *SetMsgLin(" Enter Your Own Message Line Here  ESC-Exit ")

   Hand105()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Thermometr() >> in Proc:  MENU017                 **
**   Comment: Thermometr() Sample                                            **
*******************************************************************************
FUNC Dlog052()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG052")

   nDr1 := 16
   nDc1 := 18
   nDr2 := nDr1+03
   nDc2 := nDc1+43

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+01,nDc1+02 SAY "Processing..."

   SetMsgLin(" Processing--Please Wait  ESC-Exit ")

   Hand053()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Gen_Maint() >> in Proc:  MENU016                  **
**   Comment: Gen_Maint() Lib Func                                           **
*******************************************************************************
FUNC Dlog057()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mopts

   VarPush("DLOG057")

   nDr1 := 12
   nDc1 := 12
   nDr2 := nDr1+08
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Gen_Maint() (Generic Mainenance) Library"
   @ nDr1+02,nDc1+02 SAY "Function is a Full Feature File Maintenance"
   @ nDr1+03,nDc1+02 SAY "Routine that is Typically Created by the"
   @ nDr1+04,nDc1+02 SAY "Builder Code Generator (Not by Hand)."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+06,nDc1+02 SAY "Enter the Allowed Menu Options:"

   Mopts := "ACDF"

   DO WHILE .T.
      SetMsgLin(" Enter A-Add, C-Change, D-Delete, F-Find  ESC-Exit ")

      AddGet(nDr1+06,nDc1+34,{|x|IF(x==NIL,MOPTS,MOPTS:=x)},"MOPTS", ;
             "!!!!")

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Fmnt058()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Rel_Maint() >> in Proc:  MENU016                  **
**   Comment: Rel_Maint() Sample                                             **
*******************************************************************************
FUNC Dlog059()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG059")

   nDr1 := 13
   nDc1 := 10
   nDr2 := nDr1+08
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Rel_Maint() Function is a File Maintenance"
   @ nDr1+02,nDc1+02 SAY "Function That Works Like the Gen_Maint()"
   @ nDr1+03,nDc1+02 SAY "Function, Except that Rel_Maint() is Used"
   @ nDr1+04,nDc1+02 SAY "to Edit the Many Records of a One-to-Many"
   @ nDr1+05,nDc1+02 SAY "Database Relationship."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+07,nDc1+02 SAY "Press <Space> for Sample or ESC to Exit"

   SetMsgLin(" Press Any Key for Rel_Maint() Sample  ESC-Exit ")

   Hand060()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Pick List Window:  PLST061   Rel_Maint() Sample                **
**   Comment: Rel_Maint() Sample (Maint)                                     **
*******************************************************************************
FUNC Dlog062()
   PRIVATE nDr1,nDc1,nDr2,nDc2,cOldCity

   VarPush("DLOG062")

   nDr1 := 06
   nDc1 := 01
   nDr2 := nDr1+07
   nDc2 := nDc1+29

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+02,nDc1+02 SAY "First"
   @ nDr1+03,nDc1+03 SAY "Last"
   @ nDr1+05,nDc1+02 SAY "Phone"

   SELECT Friends
   SET ORDER TO 1

   iSeek(Cities->City,"FRIENDS",1)

   cOldCity := Cities->City
   Rel_Maint(nDr1,nDc1,nDr2,nDc2,"062",{||cOldCity == Friends->City}, ;
             "FRIENDS",aFriends,2)

   VarPop()
   WinPop()
   RETURN(NIL)

Function Get062()
   LOCAL x

    BCITY := cOldCity
    AddGet(nDr1+02,nDc1+08,{|x|IF(x==NIL,BFNAME,BFNAME:=x)},"BFNAME", ;
           "!xxxxxxxxxxxxx", ;
    {|| ;
        Req("First Name Required", ;
            nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})
    AddGet(nDr1+03,nDc1+08,{|x|IF(x==NIL,BLNAME,BLNAME:=x)},"BLNAME", ;
           "!xxxxxxxxxxxxxxxxxxx")
    AddGet(nDr1+05,nDc1+08,{|x|IF(x==NIL,BPHONE,BPHONE:=x)},"BPHONE", ;
           "@R (999) 999-9999")
    RETURN(NIL)

*******************************************************************************
** CALLED BY: Hand Code:  HAND060   Rel_Maint() Sample                       **
**   Comment: Rel_Maint() Sample                                             **
*******************************************************************************
FUNC Dlog063()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG063")

   nDr1 := 10
   nDc1 := 06
   nDr2 := nDr1+07
   nDc2 := nDc1+44

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Following Windows Will Present a"
   @ nDr1+02,nDc1+02 SAY "Picklist of Cities.  Following it Will be"
   @ nDr1+03,nDc1+02 SAY "a Rel_Maint() to Enter a List of Friends"
   @ nDr1+04,nDc1+02 SAY "in That City."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+06,nDc1+02 SAY "Press Any Key to Continue"

   SetMsgLin(" Press Any Key to Continue  ESC-Exit ")

   Hand139()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << AddPrompt()/AbMenu() >> in Proc:  MENU017         **
**   Comment: AddPrompt() Sample                                             **
*******************************************************************************
FUNC Dlog064()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG064")

   nDr1 := 11
   nDc1 := 05
   nDr2 := nDr1+11
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Builder Menu System Consists of Two"
   @ nDr1+02,nDc1+02 SAY "Functions.  The AddPrompt() Function Which"
   @ nDr1+03,nDc1+02 SAY "Works Like the Clipper @..PROMPT Command and"
   @ nDr1+04,nDc1+02 SAY "the AbMenu() Function Which Works Like the"
   @ nDr1+05,nDc1+02 SAY "Clipper MENU TO .. Command."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+07,nDc1+02 SAY "The Menu System is Mouseable.  This Demo"
   @ nDr1+08,nDc1+02 SAY "Program's Menus Use The Builder Menu System."
   @ nDr1+09,nDc1+02 SAY "Normally Builder Writes All the Menu Source"
   @ nDr1+10,nDc1+02 SAY "Code.  Look at the Program Source for Samples."

   DO WHILE .T.
      SetMsgLin(" Builder Menu Functions  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Ask() >> in Proc:  MENU017                        **
**   Comment: Ask() Sample                                                   **
*******************************************************************************
FUNC Dlog065()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG065")

   nDr1 := 11
   nDc1 := 07
   nDr2 := nDr1+07
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+01,nDc1+02 SAY "The Builder Ask() Function Allows a Question"
   @ nDr1+02,nDc1+02 SAY "to Be Asked.  The Ask() Function Erases"
   @ nDr1+03,nDc1+02 SAY "it's Prompt When Finished."
   @ nDr1+04,nDc1+02 SAY "Sample:"

   SetMsgLin(" Press Y-Yes or N-No  ESC-Exit ")

   Hand066()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << AskMenu() >> in Proc:  MENU017                    **
**   Comment: AskMenu() Sample                                               **
*******************************************************************************
FUNC Dlog067()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG067")

   nDr1 := 11
   nDc1 := 08
   nDr2 := nDr1+09
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+01,nDc1+02 SAY "The AskMenu() Function Works Much Like the"
   @ nDr1+02,nDc1+02 SAY "Ask() Function Except That Instead of Pressing"
   @ nDr1+03,nDc1+02 SAY "a Single Key The User Can Select From a Menu."
   @ nDr1+04,nDc1+02 SAY "Sample:"

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+06,nDc1+02 SAY "What is Your Favorite Computer Language?"
   SET COLOR TO (Var(WNDW_CLR_))

   SetMsgLin(" Use Arrows to Move  ENTER-Select  ESC-Exit ")

   Hand068()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Plist() >> in Proc:  MENU016                      **
**   Comment: Plist() Sample                                                 **
*******************************************************************************
FUNC Dlog069()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG069")

   nDr1 := 08
   nDc1 := 02
   nDr2 := nDr1+13
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Builder Plist() (Picklist) Function is"
   @ nDr1+02,nDc1+02 SAY "a Very Powerful Database Scanning Tool."
   @ nDr1+03,nDc1+02 SAY "There are Many Options in Plist(), Most"
   @ nDr1+04,nDc1+02 SAY "Can be Set Using Builder Alone."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+06,nDc1+02 SAY "Setting Both a 'Bounded by' AND a QWERTY"
   @ nDr1+07,nDc1+02 SAY "Plist(), However, Requires Adding 3 Parameters"
   @ nDr1+08,nDc1+02 SAY "to the Plist() Call After Builder Creates"
   @ nDr1+09,nDc1+02 SAY "the Source Code."

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+11,nDc1+02 SAY 'See The "Picklist" Menu Selection Under'
   @ nDr1+12,nDc1+02 SAY '"About Builder" also.'
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Plist() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Browser() >> in Proc:  MENU016                    **
**   Comment: Browser() Sample                                               **
*******************************************************************************
FUNC Dlog070()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG070")

   nDr1 := 15
   nDc1 := 12
   nDr2 := nDr1+06
   nDc2 := nDc1+46

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "Browser() is a VERY Simple Database Browse."
   @ nDr1+02,nDc1+02 SAY "It is So Simple, In Fact, That DbEdit() is"
   @ nDr1+03,nDc1+02 SAY "Used Instead of tBrowse Code."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Press <Space> for Sample.  ESC to Exit"

   SetMsgLin(" Press <Space> to Start  ESC-Exit ")

   Hand071()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Save_It() >> in Proc:  MENU016                    **
**   Comment: Save_It() Sample                                               **
*******************************************************************************
FUNC Dlog072()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG072")

   nDr1 := 08
   nDc1 := 07
   nDr2 := nDr1+10
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Save_It() Function Allows Builder"
   @ nDr1+02,nDc1+02 SAY "Applications to ADD and CHANGE databases"
   @ nDr1+03,nDc1+02 SAY "One Record at a Time, Rather Than One Field"
   @ nDr1+04,nDc1+02 SAY "At a Time."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+06,nDc1+02 SAY "Optionally Use a Builder Delete Index and"
   @ nDr1+07,nDc1+02 SAY "Recycle Your Deleted Records."

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+09,nDc1+02 SAY "Save_It() Locks/Unlocks Records on a Network"
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Save_It() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Fld_Repl() >> in Proc:  MENU016                   **
**   Comment: Fld_Repl() Sample                                              **
*******************************************************************************
FUNC Dlog073()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG073")

   nDr1 := 17
   nDc1 := 19
   nDr2 := nDr1+04
   nDc2 := nDc1+41

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   @ nDr1+01,nDc1+02 SAY "Use Fld_Repl() Instead of the Clipper"
   @ nDr1+02,nDc1+02 SAY "REPLACE Command.  Fld_Repl() Will Lock"
   @ nDr1+03,nDc1+02 SAY "and Unlock Records on a Network."

   DO WHILE .T.
      SetMsgLin(" Fld_Repl() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << iSeek() >> in Proc:  MENU016                      **
**   Comment: iSeek() Sample                                                 **
*******************************************************************************
FUNC Dlog074()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG074")

   nDr1 := 11
   nDc1 := 15
   nDr2 := nDr1+06
   nDc2 := nDc1+42

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The iSeek() Function Does an Indexed"
   @ nDr1+02,nDc1+02 SAY "Database Search.  Pass a Database Alias"
   @ nDr1+03,nDc1+02 SAY "and an Index Order."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "One Line of Code to Replace 4 or 5"

   DO WHILE .T.
      SetMsgLin(" iSeek() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << PckVld() >> in Proc:  MENU015                     **
**   Comment: PckVld() Sample                                                **
*******************************************************************************
FUNC Dlog075()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mcity

   VarPush("DLOG075")

   nDr1 := 14
   nDc1 := 15
   nDr2 := nDr1+08
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "PckVld() Forces Entry into a Field to be"
   @ nDr1+02,nDc1+02 SAY "Controlled by a Look Up Table by Providing"
   @ nDr1+03,nDc1+02 SAY "a Plist() on Invalid Entries."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "City:"
   @ nDr1+07,nDc1+02 SAY "Easily Set Up PckVld()'s from Builder!"

   Mcity := Space(25)

   DO WHILE .T.
      SetMsgLin(" Enter a Valid City Name  ESC-Exit ")

      AddGet(nDr1+05,nDc1+08,{|x|IF(x==NIL,MCITY,MCITY:=x)},"MCITY", ;
             "@!", ;
      {|| ;
          PckVld("CITIES",1,2,.F., ;
                 "City", ;
                 .T.)})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << ChkChr() >> in Proc:  MENU015                     **
**   Comment: ChkChk() Sample                                                **
*******************************************************************************
FUNC Dlog076()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mpart_Typ

   VarPush("DLOG076")

   nDr1 := 15
   nDc1 := 18
   nDr2 := nDr1+06
   nDc2 := nDc1+42

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The ChkChr() Function Forces Input to a"
   @ nDr1+02,nDc1+02 SAY "GET to Match a Substring Search."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+04,nDc1+02 SAY "Enter Part Type:"

   Mpart_Typ := " "

   DO WHILE .T.
      SetMsgLin(" Enter Part Type B-Bolt, N-Nut, or S-Screw  ESC-Exit ")

      AddGet(nDr1+04,nDc1+19,{|x|IF(x==NIL,MPART_TYP,MPART_TYP:=x)},"MPART_TYP", ;
             "!", ;
      {|| ;
          ChkChr("BNS", ;
                 "B-Bolt, N-Nut, or S-Screw Only", ;
                 nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Show_Text() >> in Proc:  MENU015                  **
**   Comment: Show_Text() Sample                                             **
*******************************************************************************
FUNC Dlog077()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG077")

   nDr1 := 11
   nDc1 := 07
   nDr2 := nDr1+11
   nDc2 := nDc1+46

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Show_Text() Function Allows the Display"
   @ nDr1+02,nDc1+02 SAY "of Data from a Look-Up Table if the Search"
   @ nDr1+03,nDc1+02 SAY "Key Within a GET Stream is Changed."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "For Example, Displaying a Part Description"
   @ nDr1+06,nDc1+02 SAY "When GETing a Part Number."
   @ nDr1+08,nDc1+02 SAY "Calls to This Function Must be Written by"
   @ nDr1+09,nDc1+02 SAY "Hand, Builder Does Not Create Show_Txt()"
   @ nDr1+10,nDc1+02 SAY "Calls."

   DO WHILE .T.
      SetMsgLin(" Show_Text() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << InFile() >> in Proc:  MENU015                     **
**   Comment: InFile() Sample                                                **
*******************************************************************************
FUNC Dlog078()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mzip

   VarPush("DLOG078")

   nDr1 := 12
   nDc1 := 10
   nDr2 := nDr1+09
   nDc2 := nDc1+44

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The InFile() Function Forces Input to a"
   @ nDr1+02,nDc1+02 SAY "GET to be Located in a Look Up Table."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+04,nDc1+02 SAY "Example, Enter a Zip Code From the CITIES"
   @ nDr1+05,nDc1+02 SAY "Database."
   @ nDr1+07,nDc1+02 SAY "Zip Code:"

   Mzip := Space(09)

   DO WHILE .T.
      SetMsgLin(" Enter Zip Code  ESC-Exit ")

      AddGet(nDr1+07,nDc1+12,{|x|IF(x==NIL,MZIP,MZIP:=x)},"MZIP", ;
             "@R 99999 9999", ;
      {|| ;
          InFile("CITIES",1, ;
                 "Zip Code Not Found in CITIES", ;
                 nDr2-1,nDc1+2,nDc2-2,.T.,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << DupChk() >> in Proc:  MENU015                     **
**   Comment: DupChk() Sample                                                **
*******************************************************************************
FUNC Dlog079()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG079")

   nDr1 := 08
   nDc1 := 09
   nDr2 := nDr1+07
   nDc2 := nDc1+44

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The DupChk() Function is Useful When You"
   @ nDr1+02,nDc1+02 SAY "Need to Maintain 2 Indexes on a Database,"
   @ nDr1+03,nDc1+02 SAY "Both Without Duplicates."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "DupChk() Force Entry Into a GET to Not"
   @ nDr1+06,nDc1+02 SAY "Duplicate an Existing Record."

   DO WHILE .T.
      SetMsgLin(" Enter State Code  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << GenVld() >> in Proc:  MENU015                     **
**   Comment: GenVld() Sample                                                **
*******************************************************************************
FUNC Dlog080()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mdate

   VarPush("DLOG080")

   nDr1 := 13
   nDc1 := 06
   nDr2 := nDr1+09
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The GenVld() (Generic Valid) Function Allows"
   @ nDr1+02,nDc1+02 SAY "ANY Logical Expression to Be Used for GET"
   @ nDr1+03,nDc1+02 SAY "Validation."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Pass a Logical Expression and an Error Message"
   @ nDr1+07,nDc1+02 SAY "Todays Date:"

   Mdate := Ctod("")

   DO WHILE .T.
      SetMsgLin(" Enter Current Date  ESC-Exit ")

      AddGet(nDr1+07,nDc1+15,{|x|IF(x==NIL,MDATE,MDATE:=x)},"MDATE",, ;
      {|| ;
          GenVld(GETACTIVE():varGet()==Date(), ;
                 "Not Equal to Your Computer Date", ;
                 nDr2-1,nDc1+2,nDc2-2,.T.,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Req() >> in Proc:  MENU015                        **
**   Comment: Req() Sample                                                   **
*******************************************************************************
FUNC Dlog081()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mstuff

   VarPush("DLOG081")

   nDr1 := 13
   nDc1 := 09
   nDr2 := nDr1+06
   nDc2 := nDc1+46

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Req() Function Simply Forces Entry"
   @ nDr1+02,nDc1+02 SAY "Into a GET.  No Further Validation is Done."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+04,nDc1+02 SAY "Enter Stuff:"

   Mstuff := Space(20)

   DO WHILE .T.
      SetMsgLin(" Enter Something  ESC-Exit ")

      AddGet(nDr1+04,nDc1+15,{|x|IF(x==NIL,MSTUFF,MSTUFF:=x)},"MSTUFF",, ;
      {|| ;
          Req("Enter Something, Anything", ;
              nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Open_Fil() >> in Proc:  MENU016                   **
**   Comment: Open_Fil() Sample                                              **
*******************************************************************************
FUNC Dlog082()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG082")

   nDr1 := 07
   nDc1 := 04
   nDr2 := nDr1+10
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Open_Fil() Function is Replacement for"
   @ nDr1+02,nDc1+02 SAY "Clipper's USE Command.  Open_Fil() Tests for"
   @ nDr1+03,nDc1+02 SAY "Several Error Conditions and Displays an"
   @ nDr1+04,nDc1+02 SAY "Error Message If the Database Cannot Be"
   @ nDr1+05,nDc1+02 SAY "Opened."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+07,nDc1+02 SAY "Open_Fil() Will Either Return a Logical"
   @ nDr1+08,nDc1+02 SAY "False or Exit to DOS When an Error is"
   @ nDr1+09,nDc1+02 SAY "Encountered, Depending on the Parameters Sent."

   DO WHILE .T.
      SetMsgLin(" Open_Fil() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Rght_Jst() >> in Proc:  MENU015                   **
**   Comment: Rght_Jst() Sample                                              **
*******************************************************************************
FUNC Dlog083()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mstuff

   VarPush("DLOG083")

   nDr1 := 13
   nDc1 := 11
   nDr2 := nDr1+09
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Rght_Jst() Function Will Right Justify"
   @ nDr1+02,nDc1+02 SAY "Input Into a GET.  This Will Only Work on"
   @ nDr1+03,nDc1+02 SAY "a Character Memory Variable."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Enter Something to Right Justify:"
   @ nDr1+07,nDc1+02 SAY "Right Justify:"

   Mstuff := Space(10)

   DO WHILE .T.
      SetMsgLin(" Enter Something to Right Justify  ESC-Exit ")

      AddGet(nDr1+07,nDc1+17,{|x|IF(x==NIL,MSTUFF,MSTUFF:=x)},"MSTUFF",, ;
      {|| ;
          Rght_Jst("0")})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand084()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << ChgDir() >> in Proc:  MENU014                     **
**   Comment: ChgDir() Sample                                                **
*******************************************************************************
FUNC Dlog089()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG089")

   nDr1 := 10
   nDc1 := 02
   nDr2 := nDr1+11
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The ChgDir() Function Accepts One Parameter,"
   @ nDr1+02,nDc1+02 SAY "a Character Value of a DOS Subdirectory Name."
   @ nDr1+03,nDc1+02 SAY "ChgDir() Attempts to Change to That Directory."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "ChgDir() Returns a Numeric Value Indicating"
   @ nDr1+06,nDc1+02 SAY "the DOS Return Code."
   @ nDr1+08,nDc1+02 SAY "Directory Name:"

   Cdrctry := Padr("\"+CurDir(),60)

   DO WHILE .T.
      SetMsgLin(" Enter New Directory Name  ESC-Exit ")

      AddGet(nDr1+09,nDc1+02,{|x|IF(x==NIL,CDRCTRY,CDRCTRY:=x)},"CDRCTRY", ;
             "@S46@!")

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand090()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << ChgDsk() >> in Proc:  MENU014                     **
**   Comment: ChgDsk() Sample                                                **
*******************************************************************************
FUNC Dlog091()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG091")

   nDr1 := 09
   nDc1 := 07
   nDr2 := nDr1+05
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The ChgDsk() Function Works Much Like the"
   @ nDr1+02,nDc1+02 SAY "ChgDir() Function, Except that the Default"
   @ nDr1+03,nDc1+02 SAY "DOS Disk is Changed.  Based on a One Byte"
   @ nDr1+04,nDc1+02 SAY "Drive Letter Passed to the Function."
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" ChgDsk() Function Description  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << MakDir() >> in Proc:  MENU014                     **
**   Comment: MakDir() Sample                                                **
*******************************************************************************
FUNC Dlog092()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG092")

   nDr1 := 08
   nDc1 := 08
   nDr2 := nDr1+08
   nDc2 := nDc1+44

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The MakDir() Function Attempts to Create"
   @ nDr1+02,nDc1+02 SAY "a New DOS Subdirectory.  Pass a Character"
   @ nDr1+03,nDc1+02 SAY "Value of the New Directory Name."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Directory to Create?"

   Cdrctry := Space(60)

   DO WHILE .T.
      SetMsgLin(" Enter New Directory Name  ESC-Exit ")

      AddGet(nDr1+06,nDc1+02,{|x|IF(x==NIL,CDRCTRY,CDRCTRY:=x)},"CDRCTRY", ;
             "@S41@!")

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand093()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << InPath() >> in Proc:  MENU014                     **
**   Comment: InPath() Sample                                                **
*******************************************************************************
FUNC Dlog094()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG094")

   nDr1 := 08
   nDc1 := 05
   nDr2 := nDr1+09
   nDc2 := nDc1+48

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The InPath() Function Will Check Your DOS"
   @ nDr1+02,nDc1+02 SAY "PATH (Or Another) Environment Variable for"
   @ nDr1+03,nDc1+02 SAY "The Existence of the Filename Passed."
   @ nDr1+04,nDc1+02 SAY "InPath() Returns the Name of the Subdirectory"
   @ nDr1+05,nDc1+02 SAY "Where the File is Located."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+07,nDc1+02 SAY "Filename to Find:"

   Cfile := Space(12)

   DO WHILE .T.
      SetMsgLin(" Enter a Filename  ESC-Exit ")

      AddGet(nDr1+07,nDc1+20,{|x|IF(x==NIL,CFILE,CFILE:=x)},"CFILE", ;
             "@!", ;
      {|| ;
          Req("Enter a Filename", ;
              nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_)).and. ;
          Req("Enter a Filename", ;
              nDr2-1,nDc1+2,nDc2-2,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand095()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << MaxHndls() >> in Proc:  MENU014                   **
**   Comment: MaxHndls() Sample                                              **
*******************************************************************************
FUNC Dlog096()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG096")

   nDr1 := 10
   nDc1 := 09
   nDr2 := nDr1+07
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The MaxHndls() Function Counts the Number"
   @ nDr1+02,nDc1+02 SAY "of Available DOS File Handles and Returns"
   @ nDr1+03,nDc1+02 SAY "a Value Based on That Data."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Your System Has a Maximum xxx File Handles"
   @ nDr1+06,nDc1+02 SAY "Available to Use."

   SetMsgLin(" Press ESC to Remove Window  ESC-Exit ")

   Hand097()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << fEof() >> in Proc:  MENU013                       **
**   Comment: fEof() Sample                                                  **
*******************************************************************************
FUNC Dlog098()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG098")

   nDr1 := 08
   nDc1 := 06
   nDr2 := nDr1+08
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The fEof() Function is to CR/LF Delimited"
   @ nDr1+02,nDc1+02 SAY "Text Files What the Clipper Eof() Function"
   @ nDr1+03,nDc1+02 SAY "is to Databases."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY 'A "DO WHILE !FEOF()/ENDDO" Loop (With an'
   @ nDr1+06,nDc1+02 SAY "fGets() Inside) Will Read the Contents of"
   @ nDr1+07,nDc1+02 SAY "a Text File."

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << fGets() >> in Proc:  MENU013                      **
**   Comment: fGets() Sample                                                 **
*******************************************************************************
FUNC Dlog099()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG099")

   nDr1 := 16
   nDc1 := 13
   nDr2 := nDr1+04
   nDc2 := nDc1+46

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The fGets() Function Simply Reads the Next"
   @ nDr1+02,nDc1+02 SAY "Sequential Record of a CR/LF Delimited Text"
   @ nDr1+03,nDc1+02 SAY "File."
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << fGetsR() >> in Proc:  MENU013                     **
**   Comment: fGetsR() Sample                                                **
*******************************************************************************
FUNC Dlog100()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG100")

   nDr1 := 10
   nDc1 := 06
   nDr2 := nDr1+05
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The fGetsR() Function Works Like fGets()"
   @ nDr1+02,nDc1+02 SAY "Except that it Reads the PREVIOUS Sequential"
   @ nDr1+03,nDc1+02 SAY "Record in a CR/LF Delimted Text File.  The"
   @ nDr1+04,nDc1+02 SAY '"R" Stands for "Reverse".'
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << TextView() >> in Proc:  MENU013                   **
**   Comment: TextView() Sample                                              **
*******************************************************************************
FUNC Dlog101()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG101")

   nDr1 := 10
   nDc1 := 05
   nDr2 := nDr1+07
   nDc2 := nDc1+48

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The TextView() Function Displays the Contents"
   @ nDr1+02,nDc1+02 SAY "of a CR/LF Delimited Text File Within a Set"
   @ nDr1+03,nDc1+02 SAY "of Screen Coordinates."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY 'All the "Description" Menu Selections in'
   @ nDr1+06,nDc1+02 SAY "This Program are Examples of TextView()."

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Edt_Memo() >> in Proc:  MENU012                   **
**   Comment: Edt_Memo() Sample                                              **
*******************************************************************************
FUNC Dlog106()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG106")

   nDr1 := 07
   nDc1 := 03
   nDr2 := nDr1+14
   nDc2 := nDc1+48

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "Edt_Memo() is the Full-Feature Half of the"
   @ nDr1+02,nDc1+02 SAY "Builder Memo Functions."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+04,nDc1+02 SAY "Edt_Memo() Will Put a Border on the Screen,"
   @ nDr1+05,nDc1+02 SAY "a Title on the Window, and  Save Changes"
   @ nDr1+06,nDc1+02 SAY "to Disk if Ctrl+W is Pressed."
   @ nDr1+08,nDc1+02 SAY "Optionally You Can Start Editing at the End"
   @ nDr1+09,nDc1+02 SAY "of the Memo Text or Limit the Size."
   @ nDr1+11,nDc1+02 SAY "You Can Pass a Character String That is"
   @ nDr1+12,nDc1+02 SAY "Appended to the Memo in the Event Any Changes"
   @ nDr1+13,nDc1+02 SAY "are Made."

   SetMsgLin(" Press Enter for Test Memo  ESC-Exit ")

   Hand107()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Show_Memo() >> in Proc:  MENU012                  **
**   Comment: Show_Memo() Sample                                             **
*******************************************************************************
FUNC Dlog108()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG108")

   nDr1 := 07
   nDc1 := 00
   nDr2 := nDr1+12
   nDc2 := nDc1+54

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Show_Memo() Function Performs Some Features"
   @ nDr1+02,nDc1+02 SAY "Before it Calls the Clipper MEMOEDIT() Function"
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+04,nDc1+04 SAY "o You Can Limit the Number of Lines Keyed"
   @ nDr1+05,nDc1+06 SAY "into the Memo (Preventing Out of Memory Errors)"
   @ nDr1+07,nDc1+04 SAY "o You Can Optionally Start Editting at the"
   @ nDr1+08,nDc1+06 SAY "End of the Memo Text."

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+10,nDc1+02 SAY "However, It Does NOT:  Put a Border or Title"
   @ nDr1+11,nDc1+02 SAY "On the Screen.  And Doesn't Save Changes to Disk"
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Press ESC to Continue  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << TotalKeyOn()/TotalKeyOff() >> in Proc:  MENU011   **
**   Comment: TotalKeyOn()/TotalKeyOff()                                     **
*******************************************************************************
FUNC Dlog110()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG110")

   nDr1 := 07
   nDc1 := 03
   nDr2 := nDr1+10
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The TotalKeyOn() and TotalKeyOff() Functions"
   @ nDr1+02,nDc1+02 SAY "Turn On and Off the Menu System's Ability to"
   @ nDr1+03,nDc1+02 SAY "Jump Between Menus Dropped From the Root Menu."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Try This by Pressing the Right and Left Arrow"
   @ nDr1+06,nDc1+02 SAY 'Keys From the "Library Functions" Menu.'
   @ nDr1+08,nDc1+02 SAY "Builder Automatically Inserts Calls to These"
   @ nDr1+09,nDc1+02 SAY "Functions Where Required."

   DO WHILE .T.
      SetMsgLin(" Press ESC to Continue  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << TimeOut() >> in Proc:  MENU011                    **
**   Comment: TimeOut() Sample                                               **
*******************************************************************************
FUNC Dlog111()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG111")

   nDr1 := 11
   nDc1 := 00
   nDr2 := nDr1+11
   nDc2 := nDc1+54

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The TimeOut() Function Tests (Huup <deep breath>)"
   @ nDr1+02,nDc1+02 SAY "The Keyboard, Screen, Disk, Communications, and"
   @ nDr1+03,nDc1+02 SAY "Printer System Interrupts for Activity."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "If There is NO ACTIVITY on ANY Interrupt for the"
   @ nDr1+06,nDc1+02 SAY "Specified Time Period, a Keystroke is Stuffed into"
   @ nDr1+07,nDc1+02 SAY "the Keyboard Buffer.  Subsequent Calls to TimeOut()"
   @ nDr1+08,nDc1+02 SAY 'and the Function Will Return the Value of "Y".'

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+10,nDc1+02 SAY "Press ENTER for a TimeOut() Test"
   SET COLOR TO (Var(WNDW_CLR_))

   SetMsgLin(" TimeOut() Function Sample  ESC-Exit ")

   Hand112()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Hand Code:  HAND112   TimeOut() Sample                         **
**   Comment: TimeOut() Sample                                               **
*******************************************************************************
FUNC Dlog113()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mdummy

   VarPush("DLOG113")

   nDr1 := 08
   nDc1 := 13
   nDr2 := nDr1+06
   nDc2 := nDc1+48

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "If You Do Not Touch Your Keyboard for Five"
   @ nDr1+02,nDc1+02 SAY "Consectutive Seconds, a TimeOut() Will Occur."
   SET COLOR TO (Var(WNDW_CLR_))

   Mdummy := Space(20)

   DO WHILE .T.
      SetMsgLin(" TimeOut() Function Sample  ESC-Exit ")

      AddGet(nDr1+04,nDc1+02,{|x|IF(x==NIL,MDUMMY,MDUMMY:=x)},"MDUMMY")

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Hex2Dec() >> in Proc:  MENU010                    **
**   Comment: Hex2Dec() Sample                                               **
*******************************************************************************
FUNC Dlog115()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mhexnbr

   VarPush("DLOG115")

   nDr1 := 11
   nDc1 := 11
   nDr2 := nDr1+07
   nDc2 := nDc1+42

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "What Function Library Would Be Complete"
   @ nDr1+02,nDc1+02 SAY "Without a Hexidecimal to Decimal Number"
   @ nDr1+03,nDc1+02 SAY "Conversion?"
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Enter Hex Number:"

   Mhexnbr := Space(10)

   DO WHILE .T.
      SetMsgLin(" Enter a Hexidecimal Number to Convert  ESC-Exit ")

      AddGet(nDr1+05,nDc1+20,{|x|IF(x==NIL,MHEXNBR,MHEXNBR:=x)},"MHEXNBR", ;
             "@!")

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand116()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Dec2Hex() >> in Proc:  MENU010                    **
**   Comment: Dec2Hex() Sample                                               **
*******************************************************************************
FUNC Dlog117()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mdecnbr

   VarPush("DLOG117")

   nDr1 := 10
   nDc1 := 08
   nDr2 := nDr1+07
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "Of Course, a Library with a Hexidecimal to"
   @ nDr1+02,nDc1+02 SAY "Decimal Conversion Also Needs the Ability"
   @ nDr1+03,nDc1+02 SAY "to Do the Reverse Conversion."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Enter a Decimal Number:"

   Mdecnbr := 0

   DO WHILE .T.
      SetMsgLin(" Enter a Number to Convert to Hexidecimal  ESC-Exit ")

      AddGet(nDr1+05,nDc1+26,{|x|IF(x==NIL,MDECNBR,MDECNBR:=x)},"MDECNBR", ;
             "9999999999")

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand118()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << ErrTone() >> in Proc:  MENU018                    **
**   Comment: ErrTone() Sample                                               **
*******************************************************************************
FUNC Dlog121()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mtonenbr

   VarPush("DLOG121")

   nDr1 := 07
   nDc1 := 01
   nDr2 := nDr1+09
   nDc2 := nDc1+44

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The ErrTone() Function Simply Sounds the"
   @ nDr1+02,nDc1+02 SAY "Speaker of Your Computer.  It Makes Five"
   @ nDr1+03,nDc1+02 SAY "Different Sounds.  Enter a Number Between"
   @ nDr1+04,nDc1+02 SAY "0 and 4 Below to Hear Each Sound Made by"
   @ nDr1+05,nDc1+02 SAY "ErrTone()."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+07,nDc1+02 SAY "Error Tone to Sound:"

   Mtonenbr := 0

   DO WHILE .T.
      SetMsgLin(" Enter a Number Between 0 and 4  ESC-Exit ")

      AddGet(nDr1+07,nDc1+23,{|x|IF(x==NIL,MTONENBR,MTONENBR:=x)},"MTONENBR", ;
             "9", ;
      {|| ;
          GenVld(Between(GETACTIVE():varGet(),0,4), ;
                 "Enter a Number Between 0 and 4 Only", ;
                 nDr2-1,nDc1+2,nDc2-2,.F.,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Hand124()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << WaitKey() >> in Proc:  MENU018                    **
**   Comment: WaitKey() Sample                                               **
*******************************************************************************
FUNC Dlog122()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG122")

   nDr1 := 09
   nDc1 := 00
   nDr2 := nDr1+08
   nDc2 := nDc1+49

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The WaitKey() Function is a Replacement for"
   @ nDr1+02,nDc1+02 SAY "the Clipper Inkey(0) Function.  The Builder"
   @ nDr1+03,nDc1+02 SAY "WaitKey() Will Respond to Builder Mouse Inputs"
   @ nDr1+04,nDc1+02 SAY "and Will React to SET KEY TO ... Also."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+06,nDc1+02 SAY "All Builder Programs and Library Functions"
   @ nDr1+07,nDc1+02 SAY "Use WaitKey() Where Appropriate."

   SetMsgLin(" Press Any Key to Continue  ESC-Exit ")

   Hand123()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Asc2Bin() >> in Proc:  MENU010                    **
**   Comment: Asc2Bin() Sample                                               **
*******************************************************************************
FUNC Dlog125()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG125")

   nDr1 := 06
   nDc1 := 02
   nDr2 := nDr1+16
   nDc2 := nDc1+50

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Asc2Bin() Function Allows You to Create"
   @ nDr1+02,nDc1+02 SAY "Character Strings With Embedded Control"
   @ nDr1+03,nDc1+02 SAY "Characters Easily."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "This is Especially Useful When Creating"
   @ nDr1+06,nDc1+02 SAY "Printer Control Strings."
   @ nDr1+08,nDc1+02 SAY "For Example:"
   @ nDr1+09,nDc1+02 SAY 'The String "^[l1O" When Passed to Asc2Bin()'
   @ nDr1+10,nDc1+02 SAY 'Would Create the HP-PCL Control Code Esc+"l1O",'
   @ nDr1+11,nDc1+02 SAY 'or the Equivalent of Chr(27)+"l1O" in Clipper'
   @ nDr1+12,nDc1+02 SAY "Code.  (Laser Printer Code for Landscape)"

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+14,nDc1+02 SAY "This Allows Storing Printer Control Strings"
   @ nDr1+15,nDc1+02 SAY "in Databases That Users Can Update."
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Asc2Bin() Function Example  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << AddMPad()/DelMPad() >> in Proc:  MENU019          **
**   Comment: AddMPad()/DelMPad() Sample                                     **
*******************************************************************************
FUNC Dlog126()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG126")

   nDr1 := 04
   nDc1 := 04
   nDr2 := nDr1+16
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The AddMPad() and DelMPad() Functions Add"
   @ nDr1+02,nDc1+02 SAY "and Delete Mouse Hot Spots.  You Will Only"
   @ nDr1+03,nDc1+02 SAY "Need to Use These for Your Own Routines or"
   @ nDr1+04,nDc1+02 SAY "Adding Mouse Awareness to Another 3rd Party"
   @ nDr1+05,nDc1+02 SAY "Library Function.  All Builder GETs, Menus,"
   @ nDr1+06,nDc1+02 SAY "and Picklists are Already Mouse Aware."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+08,nDc1+02 SAY "If the AddMPad() Does Not Work, You May Need"
   @ nDr1+09,nDc1+02 SAY "to Use the Builder SetMouse() Function.  See"
   @ nDr1+10,nDc1+02 SAY "the Description for SetMouse() for More"
   @ nDr1+11,nDc1+02 SAY "Information."
   @ nDr1+13,nDc1+02 SAY "............................................"
   @ nDr1+14,nDc1+02 SAY "........Click.Left.Mouse.Button.Here........"
   @ nDr1+15,nDc1+02 SAY "............................................"

   SetMsgLin(" AddMPad()/DelMPad() Function Sample  ESC-Exit ")

   Hand127()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Lateral Scrolling >> in Proc:  MENU003            **
**   Comment: Lateral Scroll Picklist Sample                                 **
*******************************************************************************
FUNC Dlog128()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG128")

   nDr1 := 07
   nDc1 := 25
   nDr2 := nDr1+12
   nDc2 := nDc1+46

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "If a Picklist Window is Narrower than the"
   @ nDr1+02,nDc1+02 SAY "Data Being Displayed, an Arrow is Displayed"
   @ nDr1+03,nDc1+02 SAY "in Either the Lower Left or Right Corner of"
   @ nDr1+04,nDc1+02 SAY "the Window.  This Indicates More Data is"
   @ nDr1+05,nDc1+02 SAY "Available for Viewing Outside the Window"
   @ nDr1+06,nDc1+02 SAY "Boundries."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+08,nDc1+02 SAY "Press the Left/Right Arrows or TAB/Back TAB"
   @ nDr1+09,nDc1+02 SAY "Keys to Scroll the Picklist Laterally.  You"
   @ nDr1+10,nDc1+02 SAY "Can Also Press the Left Mouse Button on the"
   @ nDr1+11,nDc1+02 SAY "Left or Right Picklist Border."

   SetMsgLin(" Press ENTER for Example  ESC-Exit ")

   Hand129()

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Between() >> in Proc:  MENU018                    **
**   Comment: Between() Sample                                               **
*******************************************************************************
FUNC Dlog131()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mnumber

   VarPush("DLOG131")

   nDr1 := 08
   nDc1 := 04
   nDr2 := nDr1+10
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Between() Function Simply Determines"
   @ nDr1+02,nDc1+02 SAY "If a Value (any data type) is <= One Value"
   @ nDr1+03,nDc1+02 SAY "and >= to Another Value."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "To Test This, Enter a Number Between 1 and"
   @ nDr1+06,nDc1+02 SAY "100."
   @ nDr1+08,nDc1+02 SAY "Enter a Number:"

   Mnumber := 0

   DO WHILE .T.
      SetMsgLin(" Enter a Number Between 1 and 100  ESC-Exit ")

      AddGet(nDr1+08,nDc1+18,{|x|IF(x==NIL,MNUMBER,MNUMBER:=x)},"MNUMBER", ;
             "999999", ;
      {|| ;
          GenVld(Between(GETACTIVE():varGet(),1,100), ;
                 "That Number is NOT Between 1 and 100", ;
                 nDr2-1,nDc1+2,nDc2-2,.T.,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << Numeric() >> in Proc:  MENU018                    **
**   Comment: Numeric() Sample                                               **
*******************************************************************************
FUNC Dlog132()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2,Mnumtst

   VarPush("DLOG132")

   nDr1 := 09
   nDc1 := 04
   nDr2 := nDr1+10
   nDc2 := nDc1+45

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The Numeric() Function Tests a Character"
   @ nDr1+02,nDc1+02 SAY "String to Determine if All the Characters"
   @ nDr1+03,nDc1+02 SAY "are Numeric or Not."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Enter Numeric or Non-Numeric or Mixed Data"
   @ nDr1+06,nDc1+02 SAY "to Test:"
   @ nDr1+08,nDc1+02 SAY "Numeric Data Test:"

   Mnumtst := Space(10)

   DO WHILE .T.
      SetMsgLin(" Enter Numeric() Test String  ESC-Exit ")

      AddGet(nDr1+08,nDc1+21,{|x|IF(x==NIL,MNUMTST,MNUMTST:=x)},"MNUMTST",, ;
      {|| ;
          GenVld(Numeric(GETACTIVE():varGet()), ;
                 "Data is NOT Numeric", ;
                 nDr2-1,nDc1+2,nDc2-2,.T.,Var(WERR_CLR_))})

      SET CURSOR ON
      READ
      SET CURSOR OFF

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << DbState() >> in Proc:  MENU018                    **
**   Comment: DbState() Sample                                               **
*******************************************************************************
FUNC Dlog135()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG135")

   nDr1 := 07
   nDc1 := 00
   nDr2 := nDr1+14
   nDc2 := nDc1+48

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The DbState() Function is Useful When You are"
   @ nDr1+02,nDc1+02 SAY "Writing Your Own Routines.  It Saves All"
   @ nDr1+03,nDc1+02 SAY "Aspects of a Database Select Area to a Memory"
   @ nDr1+04,nDc1+02 SAY "Variable.  Passing a DbState() Created Memory"
   @ nDr1+05,nDc1+02 SAY "Variable as a Parameter Will Restore The"
   @ nDr1+06,nDc1+02 SAY "Database to It's Previous State."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+08,nDc1+02 SAY "DbState() Saves The Select Area, Index Order"
   @ nDr1+09,nDc1+02 SAY "Number, Filter Condition, All Relations, and"
   @ nDr1+10,nDc1+02 SAY "the Database Record Number."

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+12,nDc1+02 SAY "DbState() is Most Helpful When Writing"
   @ nDr1+13,nDc1+02 SAY "'Black Box' Functions."
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" DbState() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << MouseInit() >> in Proc:  MENU019                  **
**   Comment: MouseInit() Sample                                             **
*******************************************************************************
FUNC Dlog136()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG136")

   nDr1 := 07
   nDc1 := 04
   nDr2 := nDr1+13
   nDc2 := nDc1+47

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The MouseInit() Function Should Only Be Used"
   @ nDr1+02,nDc1+02 SAY "Once per Program Execution.  It Initializes"
   @ nDr1+03,nDc1+02 SAY "the Mouse Awareness for a Builder Application"
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+05,nDc1+02 SAY "Builder Will Put the MouseInit() Call in"
   @ nDr1+06,nDc1+02 SAY "the Program for You."

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+08,nDc1+02 SAY "MouseInit() Initializes the Mouse Interrupt"
   @ nDr1+09,nDc1+02 SAY "(Int 51h), Turns the Mouse Cursor On, Puts"
   @ nDr1+10,nDc1+02 SAY "the Mouse Cursor in the Lower Right Screen"
   @ nDr1+11,nDc1+02 SAY "Corner, and Initializes the Array Used by"
   @ nDr1+12,nDc1+02 SAY "AddMPad()/DelMPad()"
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" MouseInit() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << SetMouse() >> in Proc:  MENU019                   **
**   Comment: SetMouse() Sample                                              **
*******************************************************************************
FUNC Dlog137()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG137")

   nDr1 := 07
   nDc1 := 04
   nDr2 := nDr1+15
   nDc2 := nDc1+46

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The SetMouse() Function Has Three Purposes"
   @ nDr1+02,nDc1+04 SAY "1) To Get the Mouse Button Status."
   @ nDr1+03,nDc1+04 SAY "2) To Set the Mouse Button Status."
   @ nDr1+04,nDc1+04 SAY "3) To Redirect Mouse Button Activity to"
   @ nDr1+05,nDc1+07 SAY "Keyboard Activity."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+07,nDc1+02 SAY "Number Three Should Only be Used With Non-"
   @ nDr1+08,nDc1+02 SAY "Builder Routines.  For Example; DbEdit(),"
   @ nDr1+09,nDc1+02 SAY "MemoEdit(), or a Routine from Another"
   @ nDr1+10,nDc1+02 SAY "Library."

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+12,nDc1+02 SAY "Note That the Builder Edt_Memo() Function"
   @ nDr1+13,nDc1+02 SAY "Sets Up Mouse Awareness Before Calling"
   @ nDr1+14,nDc1+02 SAY "MemoEdit()."
   SET COLOR TO (Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" SetMouse() Function Information  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** Add a command here to execute something after this **
      ** dialog box.                                        **
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG141   AbGetEdit() Sample                   **
**   Comment: AbGetEdit() Sample                                             **
*******************************************************************************
FUNC Dlog140()
   LOCAL x
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG140")

   nDr1 := 10
   nDc1 := 02
   nDr2 := nDr1+09
   nDc2 := nDc1+55

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "PRINTER CODES:"
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+03,nDc1+02 SAY "132 Columns"
   @ nDr1+05,nDc1+02 SAY "273 Columns"
   @ nDr1+07,nDc1+08 SAY "Reset"

   DO WHILE .T.
      SetMsgLin(" Enter Printer Codes  ESC-Exit ")

      AddGet(nDr1+03,nDc1+14,{|x|IF(x==NIL,QCMPRS,QCMPRS:=x)},"QCMPRS")
      AddGet(nDr1+05,nDc1+14,{|x|IF(x==NIL,QLNDCMP,QLNDCMP:=x)},"QLNDCMP")
      AddGet(nDr1+07,nDc1+14,{|x|IF(x==NIL,QRESET,QRESET:=x)},"QRESET")

      GetEdit("OPTIONS",nDr2-1,nDc1+2)
      EXIT
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Selection << AbGetEdit() >> in Proc:  MENU017                  **
**   Comment: AbGetEdit() Sample                                             **
*******************************************************************************
FUNC Dlog141()
   PRIVATE nDr1,nDc1,nDr2,nDc2

   VarPush("DLOG141")

   nDr1 := 07
   nDc1 := 19
   nDr2 := nDr1+09
   nDc2 := nDc1+43

   SET COLOR TO (Var(WNDW_CLR_))
   WinPush(nDr1,nDc1,nDr2,nDc2)

   SET COLOR TO (Var(WMSG_CLR_))
   @ nDr1+01,nDc1+02 SAY "The AbGetEdit() function allows you to"
   @ nDr1+02,nDc1+02 SAY "save fields edited in a dialog box to a"
   @ nDr1+03,nDc1+02 SAY "database record--using ONE line of code!"
   @ nDr1+05,nDc1+02 SAY "This is most useful when programming a"
   @ nDr1+06,nDc1+02 SAY "window to edit your system's defaults."
   SET COLOR TO (Var(WNDW_CLR_))
   @ nDr1+08,nDc1+02 SAY "Press any key to see a sample."

   DO WHILE .T.
      SetMsgLin(" Press Any key for Sample Window  ESC-Exit ")

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      ** You may want to do some validations here **
      ** before executing the next proc.          **
      Dlog140()
   ENDDO

   VarPop()
   WinPop()
   RETURN(NIL)

*********************** ENDDLOG End of Dialog Box Procs ***********************

*******************************************************************************
** >>>>>>>>>>>>>>>>>>>>>>>>>>>> Pick List Boxes <<<<<<<<<<<<<<<<<<<<<<<<<<<< **
*******************************************************************************

*******************************************************************************
** CALLED BY: Hand Code:  HAND102   Picklist No Options Setup                **
**   Comment: No Options Picklist                                            **
*******************************************************************************
FUNC Plst027()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp

   nPr1 := 13
   nPc1 := 20
   nPr2 := nPr1+09
   nPc2 := nPc1+44

   VarPush("PLST027")

   cDisp := 'Transform(Zip,"@R 99999 99999")+" "+State+" "+City'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",1,cDisp,.F.,"","",{||Hand032()})

   *#SNAPCODE HAND032()

   VarPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Hand Code:  HAND056   Setup Bounded by Picklist                **
**   Comment: Picklist Bounded by Sample                                     **
*******************************************************************************
FUNC Plst029()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp
   LOCAL mState,bCond

   nPr1 := 16
   nPc1 := 32
   nPr2 := nPr1+06
   nPc2 := nPc1+44

   VarPush("PLST029")

   ** NOTE:  Using the PLIST() Bounded By option usually will require
   **        an indexed search here

   ** Declare Bounded By Memvar **
   mState := Cities->State
   bCond := {||Cities->State == mState}

   cDisp := 'State+" "+City+" "+Transform(Zip,"@R 99999 9999")'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",3,cDisp,.F.,"","",{||Hand033()},bCond)

   *#SNAPCODE HAND033()

   VarPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Hand Code:  HAND103   QWERTY Scroll Option Setup               **
**   Comment: QWERTY Picklist Sample                                         **
*******************************************************************************
FUNC Plst030()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp
   LOCAL cKey

   nPr1 := 15
   nPc1 := 18
   nPr2 := nPr1+07
   nPc2 := nPc1+44

   VarPush("PLST030")

   ** You may want KF initialized to something other than **
   ** spaces, it depends on your particular usage.        **
   cKey := SPACE(25)

   cDisp := 'City+" "+State+" "+Transform(Zip,"@R 99999 9999")'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",2,cDisp,.T.,@cKey,"",{||Hand031()})

   *#SNAPCODE HAND031()

   VarPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Hand Code:  HAND139   Rel_Maint() Sample                       **
**   Comment: Rel_Maint() Sample                                             **
*******************************************************************************
FUNC Plst061()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp
   LOCAL cKey

   nPr1 := 09
   nPc1 := 02
   nPr2 := nPr1+06
   nPc2 := nPc1+44

   VarPush("PLST061")

   ** You may want KF initialized to something other than **
   ** spaces, it depends on your particular usage.        **
   cKey := SPACE(25)

   cDisp := 'City+" "+State+" "+Transform(Zip,"@R 99999 9999")'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",2,cDisp,.T.,@cKey,"",{||Dlog062()})

   *#SNAPCODE DLOG062()

   VarPop()
   RETURN(NIL)

*******************************************************************************
** CALLED BY: Hand Code:  HAND129   Lateral Scroll Picklist Sample           **
**   Comment: Lateral Scroll Picklist Sample                                 **
*******************************************************************************
FUNC Plst130()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp

   nPr1 := 15
   nPc1 := 52
   nPr2 := nPr1+06
   nPc2 := nPc1+25

   VarPush("PLST130")

   cDisp := 'Zip+" "+City+" "+State'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",1,cDisp,.F.,"","",{||Hand133()})

   *#SNAPCODE HAND133()

   VarPop()
   RETURN(NIL)

************************ ENDPLST End of Picklist Calls ************************

*******************************************************************************
** >>>>>>>>>>>>>>>>>>>>>>>> File Maintenance Calls <<<<<<<<<<<<<<<<<<<<<<<<< **
**                                                                           **
**                        Note: for GEN_MAINT calls:                         **
**          If the 3rd to last parameter is zero (0), you may want           **
**          to replace it with the index order number of the index           **
**                               created like:                               **
**                   INDE ON IF(DELETED(),"*"," ") TO ...                    **
**                            This requires that:                            **
**                              SET DELETED ON                               **
**           is in effect also.  This way the deleted records will           **
**           be RECALLED and updated when you add a record instead           **
**           of always doing an APPEND BLANK. This method removes            **
**                      the need to PACK the database.                       **
*******************************************************************************

*******************************************************************************
** CALLED BY: Hand Code:  HAND104   File Maintenance Setup                   **
**   Comment: City File Maintenance                                          **
*******************************************************************************
FUNC Fmnt034()
   PRIVATE cMemChk1,aMemMenu1

   VarPush("FMNT034")

   nFmr1 := 12
   nFmc1 := 26
   nFmr2 := nFmr1+08
   nFmc2 := nFmc1+36

   SELECT Cities
   DBSETORDER(2)

   cMemChk1 := "N"
   aMemMenu1 := CrteMnuArry(nFmr1+06,nFmc1+19,{" Yes "," No "})

   Gen_Maint(nFmr1,nFmc1,nFmr2,nFmc2,"034",aCities,4,.F.)

   VarPop()
   RETURN(NIL)

FUNC gSays_034()
   SET COLOR TO (Var(WNDW_CLR_))
   @ nFmr1+02,nFmc1+03 SAY "City"
   @ nFmr1+04,nFmc1+03 SAY "State"
   @ nFmr1+04,nFmc1+15 SAY "Zip"
   @ nFmr1+06,nFmc1+02 SAY "Edit Memo Field?"

   RETURN(NIL)

FUNC gGets_034(cG_Func)
   LOCAL x

   AddGet(nFmr1+02,nFmc1+09, ;
      {|x|IF(x==NIL,ACITY,ACITY:=x)},"ACITY", ;
          "!xxxxxxxxxxxxxxxxxxxxxxxx")
   CLEAR GETS

   AddGet(nFmr1+04,nFmc1+09,{|x|If(x==NIL,ASTATE,ASTATE:=x)},"ASTATE", ;
          "!!")
   AddGet(nFmr1+04,nFmc1+19,{|x|If(x==NIL,AZIP,AZIP:=x)},"AZIP", ;
          "@R 99999-9999")
   AddGet(nFmr1+06,nFmc1+19,MemVarBlock("CMEMCHK1"),"CMEMCHK1",, ;
          {||ATEXT:=Edt_Memo(10,00,22,78,ATEXT,"TEXT"," COMMENTS ",Var(WMSG_CLR_),Var(MSG_CLR_)),.T.},, ;
          {|x|IF(x==NIL,Menu(aMemMenu1,cMemChk1,x,.T.),Menu(aMemMenu1,cMemChk1,x))})

   RETURN(NIL)

FUNC gEdit_034()
   ** enter any additional field edits here and return false if an **
   ** error occured.                                               **
   RETURN(.T.)

FUNC gKey_034(cGk_Func)        // A-Add, C-Change, D-Delete
   LOCAL nFkr1,nFkc1,nFkr2,nFkc2,gKey,x,gKey1

   nFkr1 := nFmr2-03
   nFkc1 := nFmc2-40
   nFkr2 := nFmr2+1
   nFkc2 := nFmc2+1

   WinPush(nFkr1,nFkc1,nFkr2,nFkc2)
   SetMsgLin(" Enter Key Information  ESC-Exit ")

   gKey1 := SPACE(25)

   @ nFkr1+01,nFkc1+2 SAY "City"
   AddGet(nFkr1+01,nFkc1+07,{|x|IF(x==NIL,gKey1,gKey1:=x)},"GKEY1", ;
          "!xxxxxxxxxxxxxxxxxxxxxxxx")

   IF cGk_Func != "A"
      @ nFkr2-2,nFkc1+2 SAY "Enter Key Info or Blank for Current Rec"
   ELSE
      @ nFkr2-2,nFkc1+2 SAY "Enter Key Info to Add or ESC to Exit"
   ENDIF

   SET CURSOR ON
   READ
   SET CURSOR OFF

   IF LASTKEY() != K_ESC
      IF !EMPTY(gKey1)
         ACITY := gKey1
      ENDIF
   ENDIF
   gKey := gKey1

   WinPop()
   RETURN(gKey)

*******************************************************************************
** CALLED BY: Dialog Window:  DLOG057   Gen_Maint() Lib Func                 **
**   Comment: City File Maintenance                                          **
*******************************************************************************
FUNC Fmnt058()
   PRIVATE cMemChk1,aMemMenu1

   VarPush("FMNT058")

   nFmr1 := 08
   nFmc1 := 02
   nFmr2 := nFmr1+08
   nFmc2 := nFmc1+36

   SELECT Cities
   DBSETORDER(2)

   cMemChk1 := "N"
   aMemMenu1 := CrteMnuArry(nFmr1+06,nFmc1+19,{" Yes "," No "})

   Gen_Maint(nFmr1,nFmc1,nFmr2,nFmc2,"058",aCities,4,.F.,mOpts)

   VarPop()
   RETURN(NIL)

FUNC gSays_058()
   SET COLOR TO (Var(WNDW_CLR_))
   @ nFmr1+02,nFmc1+03 SAY "City"
   @ nFmr1+04,nFmc1+03 SAY "State"
   @ nFmr1+04,nFmc1+15 SAY "Zip"
   @ nFmr1+06,nFmc1+02 SAY "Edit Memo Field?"

   RETURN(NIL)

FUNC gGets_058(cG_Func)
   LOCAL x

   AddGet(nFmr1+02,nFmc1+09, ;
      {|x|IF(x==NIL,ACITY,ACITY:=x)},"ACITY", ;
          "!xxxxxxxxxxxxxxxxxxxxxxxx")
   CLEAR GETS

   AddGet(nFmr1+04,nFmc1+09,{|x|If(x==NIL,ASTATE,ASTATE:=x)},"ASTATE", ;
          "!!", ;
      {|| ;
       GenVld(In_Usa(GETACTIVE():varGet()), ;
              "U.S. State Code Required", ;
              nFmr2-1,nFmc1+2,nFmc2-2,.T.,Var(WERR_CLR_))})
   AddGet(nFmr1+04,nFmc1+19,{|x|If(x==NIL,AZIP,AZIP:=x)},"AZIP", ;
          "@R 99999-9999", ;
      {|| ;
       Req("Zip Code Required", ;
           nFmr2-1,nFmc1+2,nFmc2-2,Var(WERR_CLR_))})
   AddGet(nFmr1+06,nFmc1+19,MemVarBlock("CMEMCHK1"),"CMEMCHK1",, ;
          {||ATEXT:=Edt_Memo(10,00,22,78,ATEXT,"TEXT"," COMMENTS ",Var(WMSG_CLR_),Var(MSG_CLR_)),.T.},, ;
          {|x|IF(x==NIL,Menu(aMemMenu1,cMemChk1,x,.T.),Menu(aMemMenu1,cMemChk1,x))})

   RETURN(NIL)

FUNC gEdit_058()
   ** enter any additional field edits here and return false if an **
   ** error occured.                                               **
   RETURN(.T.)

FUNC gKey_058(cGk_Func)        // A-Add, C-Change, D-Delete
   LOCAL nFkr1,nFkc1,nFkr2,nFkc2,gKey,x,gKey1

   nFkr1 := nFmr2-03
   nFkc1 := nFmc2-40
   nFkr2 := nFmr2+1
   nFkc2 := nFmc2+1

   WinPush(nFkr1,nFkc1,nFkr2,nFkc2)
   SetMsgLin(" Enter Key Information  ESC-Exit ")

   gKey1 := SPACE(25)

   @ nFkr1+01,nFkc1+2 SAY "City"
   AddGet(nFkr1+01,nFkc1+07,{|x|IF(x==NIL,gKey1,gKey1:=x)},"GKEY1", ;
          "!xxxxxxxxxxxxxxxxxxxxxxxx")

   IF cGk_Func != "A"
      @ nFkr2-2,nFkc1+2 SAY "Enter Key Info or Blank for Current Rec"
   ELSE
      @ nFkr2-2,nFkc1+2 SAY "Enter Key Info to Add or ESC to Exit"
   ENDIF

   SET CURSOR ON
   READ
   SET CURSOR OFF

   IF LASTKEY() != K_ESC
      IF !EMPTY(gKey1)
         ACITY := gKey1
      ENDIF
   ENDIF
   gKey := gKey1

   WinPop()
   RETURN(gKey)

******************** ENDFMNT End of File Maintenance Calls ********************

*******************************************************************************
** Check Indexes, Called During Initialization                               **
*******************************************************************************
FUNC Chk_Ntxs(nRw,nCl,nLn)
   LOCAL cIt,cOldRdd := RddSetDefault()

   SELECT 0

   IF !FILE("HELP1"+ORDBAGEXT())
      USE Help
      IF !FILE("HELP1"+ORDBAGEXT())
         Message("HELP1"+ORDBAGEXT()+" Missing; Building-",nRw,nCl,nLn)
         cIt := Type('Hproc+Var')
         INDEX ON Hproc+Var+Ibar(nRw,nCl+29,cIt) TO Help1
         SET INDEX TO           // Index File MUST be Closed for ZAP_IBAR
         Zap_iBar("HELP1"+ORDBAGEXT())
      ENDIF
      USE
   ENDIF

   RDDSETDEFAULT(cOldRdd)
   IF !FILE("CITIES1"+ORDBAGEXT()) ;
      .OR. !FILE("CITIES2"+ORDBAGEXT()) ;
      .OR. !FILE("CITIES3"+ORDBAGEXT()) ;
      .OR. !FILE("CITIES4"+ORDBAGEXT())
      USE Cities
      IF !FILE("CITIES1"+ORDBAGEXT())
         Message("CITIES1"+ORDBAGEXT()+" Missing; Building-",nRw,nCl,nLn)
         cIt := Type('Zip')
         INDEX ON Zip+Ibar(nRw,nCl+30,cIt) TO Cities1
         SET INDEX TO           // Index File MUST be Closed for ZAP_IBAR
         Zap_iBar("CITIES1"+ORDBAGEXT())
      ENDIF
      IF !FILE("CITIES2"+ORDBAGEXT())
         Message("CITIES2"+ORDBAGEXT()+" Missing; Building-",nRw,nCl,nLn)
         cIt := Type('City')
         INDEX ON City+Ibar(nRw,nCl+30,cIt) TO Cities2
         SET INDEX TO           // Index File MUST be Closed for ZAP_IBAR
         Zap_iBar("CITIES2"+ORDBAGEXT())
      ENDIF
      IF !FILE("CITIES3"+ORDBAGEXT())
         Message("CITIES3"+ORDBAGEXT()+" Missing; Building-",nRw,nCl,nLn)
         cIt := Type('State')
         INDEX ON State+Ibar(nRw,nCl+30,cIt) TO Cities3
         SET INDEX TO           // Index File MUST be Closed for ZAP_IBAR
         Zap_iBar("CITIES3"+ORDBAGEXT())
      ENDIF
      IF !FILE("CITIES4"+ORDBAGEXT())
         Message("CITIES4"+ORDBAGEXT()+" Missing; Building-",nRw,nCl,nLn)
         cIt := Type('If(Dele(),"*"," ")')
         INDEX ON If(Dele(),"*"," ")+Ibar(nRw,nCl+30,cIt) TO Cities4
         SET INDEX TO           // Index File MUST be Closed for ZAP_IBAR
         Zap_iBar("CITIES4"+ORDBAGEXT())
      ENDIF
      USE
   ENDIF

   RDDSETDEFAULT(cOldRdd)
   IF !FILE("FRIENDS1"+ORDBAGEXT()) ;
      .OR. !FILE("FRIENDS2"+ORDBAGEXT())
      USE Friends
      IF !FILE("FRIENDS1"+ORDBAGEXT())
         Message("FRIENDS1"+ORDBAGEXT()+" Missing; Building-",nRw,nCl,nLn)
         cIt := Type('City')
         INDEX ON City+Ibar(nRw,nCl+31,cIt) TO Friends1
         SET INDEX TO           // Index File MUST be Closed for ZAP_IBAR
         Zap_iBar("FRIENDS1"+ORDBAGEXT())
      ENDIF
      IF !FILE("FRIENDS2"+ORDBAGEXT())
         Message("FRIENDS2"+ORDBAGEXT()+" Missing; Building-",nRw,nCl,nLn)
         cIt := Type('If(Dele(),"*"," ")')
         INDEX ON If(Dele(),"*"," ")+Ibar(nRw,nCl+31,cIt) TO Friends2
         SET INDEX TO           // Index File MUST be Closed for ZAP_IBAR
         Zap_iBar("FRIENDS2"+ORDBAGEXT())
      ENDIF
      USE
   ENDIF
   RDDSETDEFAULT(cOldRdd)

   RETURN(NIL)

*******************************************************************************
** Open All Application Data and Index Files                                 **
*******************************************************************************
FUNC Open_Data()

   *# SNAPCODE USE HELP
   Open_Fil("HELP",Var(NETWORK))
   SET INDEX TO Help1

   *# SNAPCODE USE CITIES
   Open_Fil("CITIES",Var(NETWORK))
   SET INDEX TO Cities1,Cities2,Cities3,Cities4

   *# SNAPCODE USE FRIENDS
   Open_Fil("FRIENDS",Var(NETWORK))
   SET INDEX TO Friends1,Friends2

   RETURN(NIL)

*******************************************************************************
** Initialize All Database Static Arrays                                    **
*******************************************************************************
FUNC DbInit1()
   aCities := ARRAY(Cities->(FCOUNT()))
   Cities->(DbStor(aCities,"EMPTY"))

   aFriends := ARRAY(Friends->(FCOUNT()))
   Friends->(DbStor(aFriends,"EMPTY"))

   RETURN(NIL)
