/*   DLINK.H    include file for dynamically linked functions   */

#ifdef __EV_LIB_C
#    define C
#else
#  ifdef __cplusplus
#    define C   extern "C"
#  else
#    define C   extern
#  endif
#endif

// Constants definition:

#ifndef FALSE                   
#  define FALSE 0
#  define TRUE  1
#endif

typedef unsigned long ulong;
typedef unsigned char uchar;
typedef unsigned int  uint;

#define     SIZE_HEADER         0x400   // size of page Header
#define     SIZE_PAGE_A         0x400   // size of page Page_A
#define     SIZE_PAGE_B         0x400   // size of page Page_B
#define     SIZE_PAGE_C         0x8000  // size of page Page_C

#define     FAT_BITS_12         12      // format of FAT 12 bit / 16 bit
#define     FAT_BITS_16         16

// the special procedures must return one of the values:

#define     R_CLEAN             0       // file is not infected
#define     R_CURE              1       // file is cured
#define     R_DETECT            2       // file is infected
#define     R_DELETE            3       // file is deleted
#define     R_WARNING           4       // file is possible infected
#define     R_ERROR             5       // i/o error
#define     R_MEMORY            6       // no free memory
#define     R_CANCEL            7       // testing/curing cancelled by user
#define     R_SKIP              8       // testing/curing skipped by user
#define     R_USER              9       // display the message from Message_Str
#define     R_FAIL              10      // cure procedure failed
#define     R_PRECURE           11      // processing before standard method

// types of objects and records:

#define     _TSR_               0x0001  // TSR record
#define     _MBR_               0x0002  // MBR sector/record
#define     _BOOT_              0x0004  // logical disk boot sector/record
#define     _COM_               0x0008  // COM file/record
#define     _EXE_               0x0010  // EXE file/record
#define     _SYS_               0x0020  // SYS file/record
#define     _JMP_               0x0040  // JMP record
#define     _EMPTY_             0x0080  // empty record
#define     _WIN_               0x0200  // WIN file/record
#define     _CA_                0x1000  // Code Analyzer record
#define     _SECTOR_            (_MBR_|_BOOT_)             // sector
#define     _FILE_              (_COM_|_EXE_|_SYS_|_WIN_)  // file


// Global data definition:

C void far* List_of_List;               // List of List pointer

typedef struct  DISK_INFO_tag {         // Disk information table

  uchar         Drive;              // Drive 0=A:, 1=B:, 2=C: etc
  uchar         Disk;               // Disk  0=FDD1, 1=FDD2, 80h=HDD1, 81h=HDD2, 40h=driver
                                        // Logical Disk Info
  uchar         Sect_per_Clust;     // number sectors per cluster          
  uchar         Media;              // disk media
  uint          Total_Clust;        // number clusters on disk
  uint          Bytes_per_Sect;     // bytes per sector
  uchar         FAT_Count;          // number of FAT copy
  uint          Root_Dir_Entries;   // number entry in root directory
  uint          Sector_before_FAT;  // number hidden sectors
  uint          Root_Sectors;       // number sectors in root directory
  uint          First_Data_Sector;  // first sector number
  uint          Sectors_into_FAT;   // sectors per one copy of FAT
  uchar         FAT_12_16;          // 12/16 bit FAT
                                        // Physical disk info
  uint          Num_of_Heads;       // number of heads
  uint          Sect_per_Track;     // sectors per track

} DISK_INFO;

C DISK_INFO far* Disk_Info;             // Disk information pointer

C uchar far*    Message_Str;            // message string
C char  far*    Name_Ptr;               // pointer to current virus name
C uchar far*    Header;                 // array 'Header'
C uchar far*    Page_A;                 // array 'Page_A'
C uchar far*    Page_B;                 // array 'Page_B'
C uchar far*    Page_C;                 // array 'Page_C'

C int   far     Handle;                 // handle of current file
C int   far     File_Mode;              // mode of file processing
C char  far*    File_Full_Name;         // pointer to full file name
C char  far*    File_Directory;         // pointer to directory of file
C char  far*    File_Name;              // pointer to file name
C char  far*    File_Ext;               // pointer to file extension
C char  far*    File_Drive;             // pointer to disk of file

C uint  far     File_Format;            // internal file format
C uint  far     File_Extension;         // type of file extension
C ulong far     File_Length;            // length of file
C ulong far     File_Tail;              // distance between entry point and file end

C ulong far     EP;                     // offset of file entry point
C ulong far     EP_Next;                // offset of second file entry point

C ulong far     Exe_Header_Len;         // length of the EXE-file header
C uint  far     Exe_IP;                 // Entry point address of EXE-file
C uint  far     Exe_CS;                 
C uint  far     Com_IP;                 // IP register value at COM file entry point
C uint  far     Sys_Interrupt;          // offset of INTERRUPT proc. of SYS-file
C uint  far     Sys_Strategy;           // offset of STRATEGY proc. of SYS-file

C uint  far     Cur_Obj;                // current object

C uint  far     First_MCB;              // address of the first memory block
C uint  far     Z_MCB;                  // address of the last memory block
C uint  far     BIOS_Mem;               // full size of the main RAM
C uint  far     DOS_Mem;                // size of the memory allocated for DOS
C uint  far     DOS_Segm;               // address of DOS segment
C uint  far     Mem_Segm;               // current segment for memory test
C uint  far     Mem_Offs;               // current offset for memory test


// Standard functions names:

C int   far   decode();   // decode procedure (FILE,SECTOR)
C int   far   cure();     // cure procedure (MEMORY,FILE,SECTOR)
C long  far   jmp();      // calculation of file/sector entry point (JMP)


// Global subroutines definition:

  // File subroutines:

C int   far   Ch_Size(ulong size);
                    // Set file length to 'size'
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Ch_Size_Lehigh(ulong size);
                    // if file is COMMAND.COM, then fill file with 0 from 
                    // 'size' to end of file, else set file length to 'size'.
                    // Return: 1 if OK, 0 if ERROR.

C long  far   Seek(long set);
                    // Set file pointer to 'set'
                    // Return: new file pointer.

C int   far   Read(char far* buf,unsigned len);
                    // Read 'len' bytes to 'buf' from file handle
                    // Return: number of bytes reading, 0 if ERROR or eof.

C int   far   Write(char far* buf,unsigned len);
                    // Read 'len' bytes from 'buf' to file handle
                    // Return: number of bytes writing, 0 if ERROR.

C int   far   Cure_COM_Immediate ( char far* p, int len , long cut );
                    // Write 'len' bytes from '*p' to file beginning, then
                    // cut 'cut' bytes from end of file.
                    // Return: R_CURE if OK, R_FAIL if ERROR.

C int   far   Cure_COM ( long from, int len , long cut );
                    // Write 'len' bytes from offset 'from' to file beginning,
                    // then cut 'cut' bytes from end of file.
                    // Return: R_CURE if OK, R_FAIL if ERROR.

C int   far   Cure_EXE(long nSize, uint nCS, uint nIP, uint nSS, uint nSP);
                    // Write to header of EXE-file registers value CS/IP/SS/SP from
                    // nCS/nIP/nSS/nSP, then set file length to 'nSize', then
                    // correct module length in EXE header
                    // Return:  R_CURE if OK, R_FAIL if ERROR.

C long  far   Jmp_Far ( uint Off_CS, uint Off_IP, signed int Data);
                    // Return: ((long)((int*)page)[Off_CS])*10
                    //                  + ((int*)page)[Off_IP]+Data
                    // if EP==0 page=Header
                    // if EP!=0 page=Page_A

  // Sector subroutines:

C int   far   Read_13(int CX_Sector,int DH_Head,char far *Buffer);
                    // Read physical sector from 'CX_Sector/DH_Head' to 'Buffer'
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Write_13(int CX_Sector,int DH_Head,char far *Buffer);
                    // Write physical sector from 'Buffer' to 'CX_Sector/DH_Head'
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Read_25(int Num_Read, long Sector, char far *Buffer);
                    // Read 'Num_Read' logical sectors from 'Sector' to 'Buffer'
                    // Return: AX.

C int   far   Write_26(int Num_Write, long Sector, char far *Buffer);
                    // Write 'Num_Write' logical sectors from 'Buffer' to 'Sector'
                    // Return: AX.

C int   far   Read_MBR(char far* Page);
                    // Read MBR sector to 'Page'
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Read_BOOT(char far* Page);
                    // Read Boot sector to 'Page'
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Write_MBR(char far* Page);
                    // Write MBR sector from 'Page'
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Write_BOOT(char far* Page);
                    // Write Boot sector from 'Page'
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Move_AbsSect_to_Boot(int Sector, char Head);
                    // Copy physical sector from 'Sector/Head' to Boot sector
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Move_LogSect_to_Boot(long Sector);
                    // Copy logical sector from 'Sector' to Boot sector
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Move_AbsSect_to_MBR(int Sector, char Head);
                    // Copy physical sector from 'Sector/Head' to MBR
                    // Return: 1 if OK, 0 if ERROR.

C int   far   Move_LogSect_to_MBR(long Sector);
                    // Copy logical sector from 'Sector' to MBR
                    // Return: 1 if OK, 0 if ERROR.

  // Decryption subroutines:

C int   far   Xor_Byte ( char far *from , char far *to , char key, int len );
                    // Copy 'len' bytes from 'from' to 'to', XOR each byte
                    // with byte 'key' at the same time.
                    // Return: len.

C int   far   Xor_Word ( char far *from , char far *to , int key, int len );
                    // Copy 'len' bytes from 'from' to 'to', XOR each word
                    // with word 'key' at the same time.
                    // Return: len.

C int   far   Add_Byte ( char far *from , char far *to , signed char key, int len );
                    // Copy len bytes from 'from' to 'to', ADD each byte
                    // with byte 'key' at the same time.
                    // Return: len.

C int   far   Add_Word ( char far *from , char far *to , signed int key, int len );
                    // Copy len bytes from 'from' to 'to', ADD each word
                    // with word 'key' at the same time.
                    // Return: len.

   // Debug subroutines:

C int   far   Printf (const char far *format , ...);
                    // Put message in Scan window. All arguments are in C standard

C int   far   Stop ();   
                    // Temporary pause of scanning

C int   far   Line_outtext (char far *s);
                    // Put message 's' into the bottom line of the screen

C int   far   Line_stop ();
                    // Remove message from the bottom line of the screen

  // Miscellaneous subroutines:

C int   far   Access(char far* filename,int amode);
                    // Check access to file filename
                    // 'amode' - access type: 0 - file exists
                    //                        1 - write possibility
                    // Return: 0 if OK, -1 if ERROR.

C int   far   _Chmod(char far* filename,int func,int attr);
                    // func = 0:  return attributes of file 'filename'
                    // func = 1:  set attributes of file 'filename' to 'attr'
                    // Return: file_attr if OK, -1 if ERROR.

C ulong far   Check_Sum(uchar far* mass,  uchar len);
                    // Calculate control sum in 'mass' on 'len' bytes
                    // Return: control sum.

C long  far   Next_Buffer(long Cur_Buff);
                    // Return: far* to next system buffer, or -1 if end of chain,
                    //      or far* to first system buffer if Cur_Buff=0

C int   far   Strncmp(char far* s1,char far* s2,int n);
                    // Compare strings 's1' and 's2' on 'n' bytes, return 0 if equals.

C int   far   Strlen(char far* s);
                    // Return: length of string 's'


// NEW Executable file data and functions

typedef struct _NE_HEADER {         // NEW Executable Header
  uint          Signature;
  uint          Link_Version;
  uint          ET_Offset_NE;
  uint          ET_Length;
  ulong         Check_Sum;
  uint          M_Flag;
  uint          Auto_Data_Segment;
  uint          LHeap_Size;
  uint          Stack_Size;
  uint          IP;
  uint          CS;
  uint          SP;
  uint          SS;
  uint          ST_Size;
  uint          MRT_Size;
  uint          NNT_Length;
  uint          ST_Offset_NE;
  uint          RT_Offset_NE;
  uint          RNT_Offset_NE;
  uint          MRT_Offset_NE;
  uint          INT_Offset_NE;
  ulong         NNT_Offset;
  uint          Number_MEP;
  uint          Alignment;
  uchar         Reserved[12];
} NE_HEADER;

C ulong	far     NE_Seek;            // entry point of NEW Executable file
C NE_HEADER far* NE_Ptr;            // pointer to NE header

