/*
** Datei: DVIRDDVI.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <stdarg.h>
#ifdef __ATARIGNU__
#include <osbind.h>
#include <aesbind.h>
#include <vdibind.h>
#endif
#include <errno.h>
#include "dvi.h"
#include "dvidef.h"
#include "dvimisc.h"

#define MAX_DVI_STACK 16

FILE *log_file=NULL;

/*
** -------------------------------------------------------------------
** functions interpreting the dvi file
** -------------------------------------------------------------------
*/

#include <string.h>
#ifdef ATARI_ST
#ifdef __TURBOC__
#include <tos.h>
#endif
#endif

typedef struct
{
    FILE    *dvi_file;
    unsigned char huge *dvi_start;
    unsigned char huge *dvi_end;
    unsigned char huge *dvi_ptr;
} dvi_stack_t;

static dvi_stack_t ds_data[MAX_DVI_STACK] = {{NULL,NULL}};
static dvi_stack_t huge *ds = ds_data;

void dvi_fpush(FILE *new_file, byte *new_start, byte *new_end)
{
    if (++ds>=(dvi_stack_t huge*)ds_data+MAX_DVI_STACK)
    {
	halt("DVI Stack Overflow");
	ds--;
    }
    ds->dvi_file = new_file;
    ds->dvi_start = new_start;
    ds->dvi_end = new_end;
    ds->dvi_ptr = new_start;
}

void dvi_fpop(void)
{
    if (ds<=(dvi_stack_t huge*)ds_data) halt("DVI Stack Underflow");
    if (ds->dvi_file!=NULL)
    {
	xprint(-1,")");
	fclose(ds->dvi_file);
	ds->dvi_file = NULL;
    }
    ds--;
}

int dvi_finit(char *name, char *path)
{
    char filename[MAX_PATH_LEN];
    static int first_log = 1;

    dvi_fexit();

    if (*op.log_name!='\0')
    {
	log_file = fopen(op.log_name,first_log ? "w":"a");
	if (log_file==NULL)
	    print("Warning: Cannot open LOG-File %s for output",op.log_name);
	else first_log = 0;
    }

    if (op.dvimemory)
    {
	long dvi_length;
	FILE *fp;

#ifdef ATARI_ST
	int handle;
#endif

	ds->dvi_file = NULL;
	if ( (fp = fopene(name,"rb",path,filename))==NULL) return 1;
	printnnl("(%s",filename);
	if (fseek(fp,0l,SEEK_END)) return 1;
	dvi_length = ftell(fp);
	if (dvi_length<1) return 1;

#ifdef ATARI_ST
	handle = fileno(fp);
	if (Fseek(0,handle,0)) return 1;
	ds->dvi_start = mem_alloc(dvi_length,"DVI-File");
	ds->dvi_end = (ds->dvi_ptr = ds->dvi_start) + dvi_length;
	if ( dvi_length != Fread(handle,dvi_length,ds->dvi_start) )
	    return 1;
#else
	if (fseek(fp,0l,SEEK_SET)) return 1;
	ds->dvi_start = mem_alloc(dvi_length,"DVI-File");
	ds->dvi_end = (ds->dvi_ptr = ds->dvi_start) + dvi_length;
	if ( dvi_length != fread((void*)ds->dvi_start,1,(size_t)dvi_length,fp) )
	    return 1;
#endif
	xprint(-1,":%ld)",dvi_length);
	fclose(fp);
	return 0;
    }

    ds->dvi_file = fopene(name,"rb",path,filename);
    if (ds->dvi_file!=NULL) printnnl("(%s",filename);
    return ds->dvi_file == NULL;
}

int dvi_fseek(long offset)
{
    if (ds->dvi_file==NULL)
    {
	ds->dvi_ptr = ds->dvi_start + offset;
	return ds->dvi_ptr > ds->dvi_end || ds->dvi_ptr < ds->dvi_start;
    }
    return fseek(ds->dvi_file,offset,SEEK_SET);
}

int dvi_fmove(long offset)
{
    if (ds->dvi_file==NULL)
    {
	ds->dvi_ptr += offset;
	return ds->dvi_ptr > ds->dvi_end || ds->dvi_ptr < ds->dvi_start;
    }
    return fseek(ds->dvi_file,offset,SEEK_CUR);
}

static int dvi_feof(void)
{
    if (ds->dvi_file==NULL)
    {
	ds->dvi_ptr = ds->dvi_end;
	return 0;
    }
    return fseek(ds->dvi_file,0l,SEEK_END);
}

void dvi_fexit(void)
{
    while(ds>=(dvi_stack_t huge*)ds_data)
    {
	if (ds->dvi_file!=NULL)
	{
	    xprint(-1,")");
	    fclose(ds->dvi_file);
	    ds->dvi_file = NULL;
	}
	ds--;
    }
    ds = ds_data;
    if (ds->dvi_start!=NULL)
    {
	mem_free(ds->dvi_start,ds->dvi_end-ds->dvi_start);
	ds->dvi_start = NULL;
    }
    if (log_file!=NULL)
    {
	fclose(log_file);
	log_file = NULL;
	print("Transcript writton on %s",op.log_name);
    }
}

int dvi_fgetc(void)
{
    if (ds->dvi_file==NULL)
    {
	if (ds->dvi_ptr<ds->dvi_end) return (int)*ds->dvi_ptr++;
	else return EOF;
    }
    return getc(ds->dvi_file);
}

static long dvi_ftell(void)
{
    if (ds->dvi_file==NULL)
	return ds->dvi_ptr-ds->dvi_start;
    return ftell(ds->dvi_file);
}

unsigned int dvi_fu2(void)
{
    int gw1, gw2;

    gw1 = dvi_fgetc();
    gw2 = dvi_fgetc();
    return ((unsigned)gw1<<8) | (unsigned)gw2;
}

unsigned long dvi_fu3(void)
{
    int gw1, gw2, gw3;

    gw1 = dvi_fgetc();
    gw2 = dvi_fgetc();
    gw3 = dvi_fgetc();  
    return ((unsigned long)gw1<<16) | 
	   ((unsigned long)gw2<<8) | (unsigned long)gw3;
}

unsigned long dvi_fu4(void)
{
    int gw1, gw2, gw3, gw4;

    gw1 = dvi_fgetc();
    gw2 = dvi_fgetc();
    gw3 = dvi_fgetc();
    gw4 = dvi_fgetc();
    return ((unsigned long)gw1<<24) |
	   ((unsigned long)gw2<<16) |
	   ((unsigned long)gw3<<8) | (unsigned long)gw4;
}

int dvi_fs2(void)
{
    int gw1, gw2;

    gw1 = dvi_fgetc();
    gw2 = dvi_fgetc();
    return( (int)( (((int)(signed char)gw1)<<8) | (unsigned)gw2 ) );
}

long dvi_fs3(void)
{
    int gw1, gw2, gw3;

    gw1 = dvi_fgetc();
    gw2 = dvi_fgetc();
    gw3 = dvi_fgetc();
    return( (long)( (((long)(signed char)gw1)<<16) | 
	   ((unsigned)gw2<<8) | (unsigned)gw3 ) );
}

long dvi_fs4(void)
{
    int gw1, gw2, gw3, gw4;

    gw1 = dvi_fgetc();
    gw2 = dvi_fgetc();
    gw3 = dvi_fgetc();
    gw4 = dvi_fgetc();
    return( (long)( (((long)(signed char)gw1)<<24) | 
	   ((unsigned long)gw2<<16) | 
	   ((unsigned)gw3<<8) | (unsigned)gw4 ) );
}

static double dvi_fconv(long mag, long num, long den, long res)
{
    double rconv = ((double)num/254000.0)*((double)res/(double)den);
    return rconv*((double)mag/1000.0);
}

static void dvi_fbad(void)
{
    halt("Error reading dvi-file");
}

int dvi_fpost(dvi_info_t *di, long new_mag)
{
    unsigned long dvi_pos, post_loc;
    long c, s, d,  p, a, k, l;
    int ch, i, load_err = 0;
    char fname[MAX_PATH_LEN];

    if (di->table!=NULL)
    {
	mem_free(di->table,di->pages*sizeof(long));
	xprint(-1,"}");
	di->table = NULL;
    }

    if (di->fonts!=NULL)
    {
	fnt_lfree(di->fonts);
	di->fonts = NULL;
    }

    if (dvi_feof()) dvi_fbad();
    dvi_pos = dvi_ftell();
    while(dvi_pos--)
    {
	if (dvi_fseek(dvi_pos)) dvi_fbad();
	if (dvi_fgetc()==DVI_ID_BYTE) break;
    }
    dvi_pos -= 4;
    if (dvi_fseek(dvi_pos)) dvi_fbad();
    post_loc = dvi_fu4();
    if (dvi_fseek(post_loc)) dvi_fbad();
    if (dvi_fgetc()!=POST) halt("Post not found in dvi-file");

    if (op.landscape) aspect_ratio = (double)op.hres/(double)op.vres;
    else aspect_ratio = (double)op.vres/(double)op.hres;

    di->last    = dvi_fu4();        /* Position der letzten Seite */
    di->num     = dvi_fu4();        /* Zaehler fuer Einheitslaenge */
    di->den     = dvi_fu4();        /* Nenner fuer Einheitslaenge */
    di->orig    = dvi_fu4();        /* Magnification im DVI-File */
    di->l       = dvi_fu4();        /* Hoehe der hoechsten Seite */
    di->u       = dvi_fu4();        /* Breite der breitesten Seiten */
    di->stack   = dvi_fu2();        /* Maximale benoetigte Stacktiefe */
    di->pages   = dvi_fu2();        /* Anzahl Seiten im DVI-File */
    if (op.tracemem) xprint(0,"{PageTable:%ld",(long)di->pages*sizeof(long));
    di->table   = (long*)mem_alloc(di->pages*sizeof(long),"Page-Table");
    di->mag     = new_mag ? new_mag : di->orig;
    di->hconv   = dvi_fconv(di->mag,di->num,di->den,op.hres);
    di->vconv   = dvi_fconv(di->mag,di->num,di->den,op.vres);
    di->width   = (int)round((double)(di->u) * di->hconv) + 1;
    di->height  = (int)round((double)(di->l) * di->vconv) + 1;
    di->fonts   = NULL;

    xprint(0,"[%d Pages]",di->pages);

    while((ch=dvi_fgetc())!=POST_POST)
    {
	fmt_stop();
	switch(ch)
	{
	    case FNT_DEF1:  k = dvi_fgetc(); break;
	    case FNT_DEF1+1: k = dvi_fs2();  break;
	    case FNT_DEF1+2: k = dvi_fs3();  break;
	    case FNT_DEF1+3: k = dvi_fs4();  break;
	    case NOP: continue;
	    default: dvi_fbad();
	}
	c = dvi_fu4();
	s = dvi_fu4();
	d = dvi_fu4();
	a = dvi_fgetc();
	l = dvi_fgetc();
	if (a+l>=MAX_PATH_LEN) halt("Font name too long");
	for (i=0; i<a+l; i++) fname[i] = dvi_fgetc();
	fname[(int)(a+l)] = '\0';
	if (!fnt_define(&di->fonts,k,c,s,d,fname)) load_err = 1;
    }

    (void)dvi_fu4();
    (void)dvi_fgetc();

    p = di->last;
    for(i = di->pages; i; i--)
    {
	fmt_stop();
	di->table[i-1] = p;
	if (dvi_fseek(p)) dvi_fbad();
	if (dvi_fgetc()!=BOP) dvi_fbad();
	(void)dvi_fu4();    (void)dvi_fu4();
	(void)dvi_fu4();    (void)dvi_fu4();
	(void)dvi_fu4();    (void)dvi_fu4();
	(void)dvi_fu4();    (void)dvi_fu4();
	(void)dvi_fu4();    (void)dvi_fu4();
	p = dvi_fu4();
    }
    return load_err;
}

