/*
** Datei: DVIMOTIF.C
** Autor: Ingo Eichenseher
**        Gerhard Wilhelms, 27.8.92
*/

#include <stdio.h>
#include <stdarg.h>
#include <setjmp.h>
#include <stdlib.h>
#include <Xm/Xm.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <X11/Shell.h>
#include <Xm/ArrowB.h>
#include <Xm/CascadeB.h>
#include <Xm/DrawingA.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>

#include "dvi.h"
#include "dvidvi.h"
#include "dviframe.h"
#include "dvihdcp.h"
#include "dvimisc.h"
#include "dvisplin.h"
#include "dvidraw.h"

#define APPL_CLASS "XDvi"
#define X_MAGIC 0x21021961
#define DEFAULT_WIDTH   800
#define DEFAULT_HEIGHT  900

static char *thePath;
static int theScreen;
static Widget graphicW, textW, fileSelW, nameW, dispShell,PopupMenuW;
static Widget traceMemW, traceFontsW, dviMemW, traceCharsW;
static Widget sh_NULLW, sh_p6lowW, sh_p6highW, sh_p6midW, sh_fx80W,
	      sh_shipfileW, sh_hpljW, sh_hpljlowW, sh_bj300W,
	      sh_null_deviceW;
static GC theGC;
static Display *theDisplay;
static XImage *theImage = NULL;
static int last_page = 0;
static XmString theString;
static int PageIsOpen = 0;
static Screen *defaultScreen;
static int Image_x=0, Image_y=0;
static int Press_x, Press_y, Ipress_x, Ipress_y;

static void initImage(void);
void initWidgetBaum();
void initDviOutWindow();
void exitDviOutWindow();
void initPopupMenu();
void exposeCB(Widget widget, caddr_t clientDaten, caddr_t aufrufDaten);
void destroyCB();
void resizeCB(Widget widget, caddr_t clientDaten, caddr_t aufrufDaten);
void inversCB();
void exitCB(Widget widget, caddr_t clientDaten, caddr_t aufrufDaten);
void moveImageCB();

char printer_filename[512]; /****/

typedef struct
{
    char   *mask;
    void   (*callback)(char *name);
} fileSel_t;

typedef struct
{
    void (*callback)(char *string);
    char *str_to_change;
    long *long_to_change;
    real *dimen_to_change;
    int  clean;
} dialog_t;

typedef struct
{
    int (*function)(void);
} driver_t;

Widget initForm(Widget);
Widget initDispForm(Widget);
Widget initMenu(Widget);
Widget initFileSelector(Widget);

static driver_t null_d = { NULL };
static driver_t p6low_d = { p6low };
static driver_t p6mid_d = { p6mid };
static driver_t p6high_d = { p6high };
static driver_t fx80_d = { fx80 };
static driver_t shipfile_d = { shipfile };
static driver_t hplj_d = { hplj };
static driver_t hpljlow_d = { hpljlow };
static driver_t bj300_d = { bj300 };
static driver_t null_device_d = { null_device };


static void new_dvi_file(char *name);
static void read_opt_file(char *name);
static void write_opt_file(char *name);
static void new_log_file(char *name);
static void pageCB(char *string);
static void formatCB(char *string);

static dialog_t printer_dialog = { NULL, printer_filename, NULL, NULL, 0};/****/
static dialog_t page_dialog = { pageCB, NULL, NULL, NULL, 0 };
static dialog_t maximum_dialog = { NULL, NULL, &op.maxmem, NULL, 1 };
static dialog_t clippath_dialog = { NULL, NULL, &op.pathmem, NULL, 1 };
static dialog_t pkpath_dialog = { NULL, op.pk_path, NULL, NULL, 1 }; 
static dialog_t tfmpath_dialog = { NULL, op.tfm_path, NULL, NULL, 1 }; 
static dialog_t vfpath_dialog = { NULL, op.vf_path, NULL, NULL, 1 }; 
static dialog_t dvipath_dialog = { NULL, op.dvi_path, NULL, NULL, 1 }; 
static dialog_t imgpath_dialog = { NULL, op.img_path, NULL, NULL, 0 }; 
static dialog_t grpath_dialog = { NULL, op.input_path, NULL, NULL, 0 }; 
static dialog_t mag_dialog = { NULL, NULL, &op.new_mag, NULL, 1 };
static dialog_t hres_dialog = { NULL, NULL, &op.hres, NULL, 1 };
static dialog_t vres_dialog = { NULL, NULL, &op.vres, NULL, 1 };
static dialog_t hoff_dialog = { NULL, NULL, NULL, &op.hoffset, 1 };
static dialog_t voff_dialog = { NULL, NULL, NULL, &op.voffset, 1 };
static dialog_t hspread_dialog = { NULL, NULL, NULL, &op.hspread, 1 };
static dialog_t vspread_dialog = { NULL, NULL, NULL, &op.vspread, 1 };
static dialog_t format_dialog = { formatCB, NULL, NULL, NULL, 0 };

static fileSel_t fileSelDvi = { "*.dvi",  new_dvi_file };
static fileSel_t fileSelRopt = { "*.dvo",  read_opt_file };
static fileSel_t fileSelWopt = { "*.dvo",  write_opt_file };
static fileSel_t fileSelLog = { "*.log", new_log_file };
static void (*currentFileSelCB)(char *name) = NULL;

static jmp_buf halt_jmp;

void halt(char *format, ...)
{
    va_list l;
    va_start(l,format);
    vprint(format,l);
    va_end(l);
    longjmp(halt_jmp,1);
}

void set_filename(char *name)
{
    static char *old_name = NULL, *short_name = NULL;

    Arg         args[10];
    Cardinal    n;

    if (old_name!=NULL) XtFree(old_name);
    if (short_name!=NULL) XtFree(short_name);
    old_name = XtNewString(name);
    short_name = XtNewString(fname(name));

    n = 0;
    XtSetArg(args[n],XmNtitle,old_name); n++;
    XtSetArg(args[n],XmNiconName,short_name); n++;
    XtSetValues(dispShell,args,n);
}

void out_string(char *string)
{
    int     n;
    Arg     args[10];
    XmTextPosition pos;

    pos = XmTextGetLastPosition(textW);
    XmTextInsert(textW,pos,string);
    XmTextShowPosition(textW,pos);
    XmTextSetInsertionPosition(textW,pos);
}

void out_newline(void)
{
    out_string("\n");
}

void prbyte(int c) /****/
{
    static FILE *printer_fp = NULL;

/*
    if (printer_fp==NULL)
    {
	printer_fp = popen(printer_filename, "w");
	if (printer_fp==NULL)
	{
	    fprintf(stderr, "Cannot pipe to %s\n", printer_filename);
	    exit(1);
	}
	puts("Printer open");
    }
	putchar('*');
    putc(c, printer_fp);
*/
}

int stop_key(void)
{
    return 0;
}

int wait_for_sheet(void)
{
    return 0;
}

real get_dimen(char *string, real old_value)
{
    char c, *s;
    real r, dimen;

    while(isspace(*string)) string++;
    s = string;
    while(isdigit(*s) || *s=='.') s++;
    if (s==string) return old_value;

    strlwr(s); c = *s; *s = 0; r = atof(string); *s = c;
    while(isspace(*s)) s++;
    if (r==0.0 && *s=='\0') dimen = 0.0;
    else if (!strcmp(s,"in")) dimen = r;
    else if (!strcmp(s,"cm")) dimen = r/2.54;
    else if (!strcmp(s,"pt")) dimen = r/72.27;
    else if (!strcmp(s,"pc")) dimen = r*12.0/72.27;
    else if (!strcmp(s,"bp")) dimen = r/72.0;
    else if (!strcmp(s,"mm")) dimen = r/25.4;
    else if (!strcmp(s,"dd")) dimen = r*1238.0/72.27;
    else if (!strcmp(s,"cc")) dimen = r*12*1238.0/72.27;
    else if (!strcmp(s,"sp")) dimen = r/72.27/65536.0;
    else return old_value;

    return dimen;
}

static void print_pages(int first, int last, int step)
{
    if (*dvi_name=='\0') return;
    last_page = format_pages(first,last,step);

    if (shipout==NULL) 
    {
    initDviOutWindow();
    exposeCB(graphicW,(XtPointer)NULL,(XtPointer)NULL);
    }
    else exitDviOutWindow();
}

int main(int argc, char **argv)
{
    XtAppContext    kontext;
    Widget          applShell;
    Cardinal        argcTmp;
    String         *argvTmp;
    int             i;
    Arg             args[10];
    char        ver[64];
    Cardinal        n;

    char            *opt_name = "dvi.dvo";

    thePath = getenv("PATH");
    sprintf(ver,"Dvi (Version %s)",version_string);

    if( !gr_install() )
        exit(1);

    XtToolkitInitialize();
    kontext = XtCreateApplicationContext();
    argcTmp = argc;
    argvTmp = (String*)XtMalloc((Cardinal)(argc*sizeof(String)));
    for (i=0; i<argc; i++)
	argvTmp[i] = XtNewString(argv[i]);

    theDisplay = XtOpenDisplay(kontext,(String)NULL,(String)NULL,
	APPL_CLASS,(XrmOptionDescRec*)NULL,(Cardinal)0,(&argc),argv);

    defaultScreen = DefaultScreenOfDisplay(theDisplay);

    if (theDisplay==NULL)
    {
	fprintf(stderr,"Cannot open display\n");
	exit(1);
    }

    n = 0;
    XtSetArg(args[n], XmNargc, argcTmp); n++;
    XtSetArg(args[n], XmNargv, argvTmp); n++;
    XtSetArg(args[n], XmNiconName,"Dvi"); n++;
    XtSetArg(args[n], XmNtitle,ver); n++;
    XtSetArg(args[n], XmNscreen, defaultScreen); n++;
    applShell = XtAppCreateShell("dviPanel", APPL_CLASS,
	applicationShellWidgetClass, theDisplay, args, n);

    theScreen = DefaultScreen(theDisplay);

    initWidgetBaum(applShell);

    theGC = DefaultGCOfScreen(defaultScreen);

    XtRealizeWidget(applShell);

    argc--; argv++;

    while(argc>0 && **argv=='-')
    {
	switch(tolower(argv[0][1]))
	{
	    case 'o' :
		opt_name = argv[0]+2;
		break;
	}
	argc--; argv++;
    }

    if (argc>0)
    {
	strcpy(dvi_name,*argv);
	argc--; argv++;
    }

    read_opt_file(opt_name);

    if (setjmp(halt_jmp)==0)
	if (*dvi_name && shipout==NULL)
	   print_pages(1,1,1);

    XtAppMainLoop(kontext);

    dvi_clean();

    gr_destall();

    exit(0);
}


static void initImage(void)
{
    Image_x = Image_y = 0;

    theImage = XCreateImage(theDisplay,
	DefaultVisual(theDisplay,theScreen),1,XYBitmap,
	    0,(char*)frame_buffer,frame_width*8,frame_height,16,frame_width);
}


static void exitImage(void)
{
    if (theImage!=NULL) XDestroyImage(theImage);
    theImage = NULL;
}

static void next_page(int diff)
{
    if (shipout==NULL)
    {
	int first;

	if (frame_valid && last_page && last_page+diff>0 && dvi_info.valid)
	    first = last_page + diff;
	else first = 1;
	print_pages(first,first,1);
    }
}

static void prevPageCB(Widget w, caddr_t clientData, caddr_t callData)
{
    next_page(-1);
}

static void nextPageCB(Widget w, caddr_t clientData, caddr_t callData)
{
    next_page(1);
}

void toggle_traceFonts(Widget w, caddr_t clientData, caddr_t callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct*)callData;
    op.showfonts = cb->set ? 1:0;
}

void toggle_traceMemory(Widget w, caddr_t clientData, caddr_t callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct*)callData;
    op.tracemem = cb->set ? 1:0;
}

void toggle_dviMemory(Widget w, caddr_t clientData, caddr_t callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct*)callData;
    op.dvimemory = cb->set ? 1:0;
}

void toggle_traceChars(Widget w, caddr_t clientData, caddr_t callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct*)callData;
    op.tracechars = cb->set ? 1:0;
}

void set_toggles(void)
{
    Arg args[1];
    Cardinal n = 1;

    XtSetArg(args[0], XmNset, op.showfonts ? True:False);
    XtSetValues(traceFontsW, args, n);
    XtSetArg(args[0], XmNset, op.tracemem ? True:False);
    XtSetValues(traceMemW, args, n);
    XtSetArg(args[0], XmNset, op.dvimemory ? True:False);
    XtSetValues(dviMemW, args, n);
    XtSetArg(args[0], XmNset, op.tracechars ? True:False);
    XtSetValues(traceCharsW, args, n);
    XtSetArg(args[0], XmNset, shipout==NULL ? True:False); 
    XtSetValues(sh_NULLW, args, n);
    XtSetArg(args[0], XmNset, shipout==p6low ? True:False); 
    XtSetValues(sh_p6lowW, args, n);
    XtSetArg(args[0], XmNset, shipout==p6high ? True:False); 
    XtSetValues(sh_p6highW, args, n);
    XtSetArg(args[0], XmNset, shipout==p6mid ? True:False); 
    XtSetValues(sh_p6midW, args, n);
    XtSetArg(args[0], XmNset, shipout==fx80 ? True:False); 
    XtSetValues(sh_fx80W, args, n);
    XtSetArg(args[0], XmNset, shipout==shipfile ? True:False); 
    XtSetValues(sh_shipfileW, args, n);
    XtSetArg(args[0], XmNset, shipout==hplj ? True:False); 
    XtSetValues(sh_hpljW, args, n);
    XtSetArg(args[0], XmNset, shipout==hpljlow ? True:False); 
    XtSetValues(sh_hpljlowW, args, n);
    XtSetArg(args[0], XmNset, shipout==bj300 ? True:False); 
    XtSetValues(sh_bj300W, args, n);
    XtSetArg(args[0], XmNset, shipout==null_device ? True:False); 
    XtSetValues(sh_null_deviceW, args, n);
}

static void pageCB(char *string)
{
    if (shipout==NULL)
    {
	int no = atoi(string);
	if (no>0) print_pages(no,no,1);
    }
}

void shipoutCB(Widget w, caddr_t clientData, caddr_t callData)
{
    XmToggleButtonCallbackStruct *t = (XmToggleButtonCallbackStruct*)callData;
    if (t->set) shipout = ((driver_t*)clientData)->function;
}

static void formatCB(char *string)
{
    int first, last, step=1;
    char *p = strtok(string," \t\n,");
    if (p==NULL) first = 1, last = 9999;
    else 
    {
	first = atoi(p);
	if (first<1) first = 1;
	last = first;
	step = 1;
	if ( (p=strtok(NULL," \t\n,"))!=NULL)
	{
	    last = atoi(p);
	    if (last<first) last = first;
	    if ( (p=strtok(NULL," \t\n,"))!=NULL)
	    {
		step = atoi(p);
		if (step<1) step = 1;
	    }
	}
    }
    print_pages(first,last,step);
}

void updateCB(Widget w, caddr_t clientData, caddr_t callData)
{
    dvi_clean();
    exitImage();
    if (shipout==NULL)
    {
	if (last_page<=0) last_page = 1;
	print_pages(last_page,last_page,1);
    }
}

static void new_dvi_file(char *name)
{
    exitDviOutWindow();
    strcpy(dvi_name,name);
    if (shipout==NULL) print_pages(1,1,1);
}

static void new_log_file(char *name)
{
    dvi_clean();
    strcpy(op.log_name,name);
}

static void write_opt_file(char *name)
{
    FILE *fp = fopen(name,"wb");

    if (fp!=NULL)
    {
	op.magic = X_MAGIC;
	if (shipout==p6low) op.shipno=1;
	else if (shipout==p6high) op.shipno=2;
	else if (shipout==p6mid) op.shipno=3;
	else if (shipout==fx80) op.shipno=4;
	else if (shipout==shipfile) op.shipno=5;
	else if (shipout==hplj) op.shipno=6;
	else if (shipout==hpljlow) op.shipno=7;
	else if (shipout==bj300) op.shipno=8;
	else if (shipout==null_device) op.shipno=9;
	else op.shipno=0;
	fwrite(&op,sizeof(op),1,fp);
	fclose(fp);
    }
}

static void read_opt_file(char *name)
{
    FILE *fp = fopene(name,"rb",thePath,(char*)NULL);

    if (fp!=NULL)
    {
	options new_op;
	size_t bytes = fread(&new_op,sizeof(op),1,fp);
	if (bytes!=1 || new_op.magic!=X_MAGIC)
	{
	    print("Invalid optionfile %s",name);
	}
	else
	{
	    op = new_op;
	    dvi_clean();
	    set_toggles();
	    switch(op.shipno)
	    {
		case 1: shipout=p6low; break;
		case 2: shipout=p6high; break;
		case 3: shipout=p6mid; break;
		case 4: shipout=fx80; break;
		case 5: shipout=shipfile; break;
		case 6: shipout=hplj; break;
		case 7: shipout=hpljlow; break;
		case 8: shipout=bj300; break;
		case 9: shipout=null_device; break;
		default: shipout=NULL;
	    }
	}
    }
    else print("Cannot read Optionfile %s",name);
}

void eingabeCB(Widget widget, caddr_t clientData, caddr_t callData)
{
    XmSelectionBoxCallbackStruct *SBinfos;
    String input_string;
    dialog_t *d = *(dialog_t**)clientData;

    SBinfos = (XmSelectionBoxCallbackStruct*)callData;
    XmStringGetLtoR(SBinfos->value,XmSTRING_DEFAULT_CHARSET, &input_string);
    if (d->callback!=NULL) (*d->callback)(input_string);
    if (d->str_to_change!=NULL) strcpy(d->str_to_change,input_string);
    if (d->long_to_change!=NULL) *(d->long_to_change) = atol(input_string);
    if (d->dimen_to_change!=NULL) *(d->dimen_to_change) = 
	get_dimen(input_string,*(d->dimen_to_change));
    XtFree(input_string);
    if (d->clean) exitDviOutWindow();
}

void doDialog(Widget widget, caddr_t clientData, caddr_t callData)
{
    static Widget eingabeW = NULL, textW;
    static dialog_t *currentClientData;
    char default_text[128];
    Arg           args[10];
    Cardinal      n;

    currentClientData = (dialog_t*)clientData;

    if (eingabeW==NULL)
    {
	n = 0;
	XtSetArg(args[n], XmNautoUnmanage, True); n++;
	XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
	eingabeW = XmCreatePromptDialog(widget,"Input",args,n);
	XtAddCallback(eingabeW,XmNokCallback, (XtCallbackProc)eingabeCB, (XtPointer)&currentClientData);
	XtUnmanageChild(XmSelectionBoxGetChild(eingabeW,XmDIALOG_HELP_BUTTON));
	textW = XmSelectionBoxGetChild(eingabeW,XmDIALOG_TEXT);
    }
    if (currentClientData->str_to_change!=NULL) 
	strcpy(default_text,currentClientData->str_to_change);
    else if (currentClientData->long_to_change!=NULL)
	sprintf(default_text,"%ld",*currentClientData->long_to_change);
    else if (currentClientData->dimen_to_change!=NULL)
	sprintf(default_text,"%fin",(double)*currentClientData->dimen_to_change);
    else *default_text = '\0';
    XmTextSetString(textW,default_text);
    XtManageChild(eingabeW);
}

void unmanageCB(Widget w, caddr_t clientData, caddr_t callData)
{
    XtUnmanageChild(w);
}

void fileSelectedCB(Widget w, caddr_t clientData, caddr_t callData)
{
    XmFileSelectionBoxCallbackStruct *FSBinfos;
    String dateiname;

    FSBinfos = (XmFileSelectionBoxCallbackStruct*)callData;
    XmStringGetLtoR(FSBinfos->value,XmSTRING_DEFAULT_CHARSET,&dateiname);
    if (currentFileSelCB!=NULL) (*currentFileSelCB)(dateiname);
    XtFree(dateiname);
}

Widget initFileSelector(Widget parent)
{
    Arg           args[10];
    Cardinal      n;

    n = 0;
    XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
    fileSelW = XmCreateFileSelectionDialog(parent,"Load",args,n);
    XtAddCallback(fileSelW,XmNokCallback,(XtCallbackProc)fileSelectedCB,(XtPointer)NULL);
    XtAddCallback(fileSelW,XmNokCallback,(XtCallbackProc)unmanageCB,(XtPointer)NULL);
    XtAddCallback(fileSelW,XmNcancelCallback,(XtCallbackProc)unmanageCB,(XtPointer)NULL);
    XtUnmanageChild(XmSelectionBoxGetChild(fileSelW,XmDIALOG_HELP_BUTTON));
    return fileSelW;
}

void doFileSelectorCB(Widget widget, caddr_t clientData, caddr_t callData)
{
    Arg           args[10];
    Cardinal      n;
    XmString      tcs;
    fileSel_t     *fs = (fileSel_t*)clientData;

    tcs = XmStringLtoRCreate(fs->mask,XmSTRING_DEFAULT_CHARSET);
    currentFileSelCB = fs->callback;
    n = 0;
    XtSetArg(args[n], XmNdirMask, tcs); n++;
    XtSetValues(fileSelW, args, n);
    XtManageChild(fileSelW);
    XmStringFree(tcs);
}

static void PostPopupMenu(Widget popup, XButtonPressedEvent *event)
{
    XmMenuPosition(popup,event);
    XtManageChild(popup);
}

void moveImageCB(Widget w, XtPointer client_data, XEvent *e, Boolean *ctdp)
{
    int diff_x, diff_y;

    Arg           args[10];
    Cardinal      n;   
    Dimension     width, height;


    n = 0;
    XtSetArg(args[n],XmNwidth,&width); n++;
    XtSetArg(args[n],XmNheight,&height); n++;
    XtGetValues(graphicW,args,n);

    switch(e->type)
    {
    case ButtonPress:
	if (e->xbutton.button==1)
	{
	Press_x = e->xbutton.x;
	Press_y = e->xbutton.y;
	Ipress_x = Image_x;
	Ipress_y = Image_y;
	}
	else PostPopupMenu(PopupMenuW,&e->xbutton);
	break;

    case MotionNotify: 
	diff_x = e->xbutton.x - Press_x;
	diff_y = e->xbutton.y - Press_y;
	Image_x = Ipress_x - diff_x;
	Image_y = Ipress_y - diff_y;
	if (frame_width*8-Image_x<width)
	Image_x = frame_width*8 - width;
	if (frame_height-Image_y<height)
	Image_y = frame_height - height;
	if (Image_x<0) Image_x = 0;
	if (Image_y<0) Image_y = 0;

	exposeCB(graphicW,(XtPointer)NULL,(XtPointer)NULL);
	break;
    }
}

Widget initGraphic(Widget scrollW)
{
    Arg         args[10];
    Cardinal    n;
    Widget      frameW;

    n = 0;
    frameW = XtCreateManagedWidget("GraphicFrame",xmFrameWidgetClass,
    scrollW,args,n);

    n = 0;
    graphicW = XtCreateManagedWidget("Graphic",xmDrawingAreaWidgetClass,
    frameW,args,n);

    XtAddCallback(graphicW,XmNexposeCallback,(XtCallbackProc)exposeCB,(XtPointer)NULL);
    XtAddCallback(graphicW,XmNresizeCallback,(XtCallbackProc)resizeCB,(XtPointer)NULL);

    return frameW;
}

Widget initTitle(Widget menuBarW, char *name)
{
    Arg         args[10];
    Cardinal    n;
    Widget  title;

    n = 0;
    title = XmCreatePulldownMenu(menuBarW,name,args,n);
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, title); n++;
    XtCreateManagedWidget(name,xmCascadeButtonWidgetClass,menuBarW,args,n);

    return title;
}

Widget initItem(Widget title, char *name, XtCallbackProc cb, XtPointer p)
{
    Arg         args[10];
    Cardinal    n;
    Widget  item;

    n = 0;
    item = XtCreateManagedWidget(name,xmPushButtonWidgetClass,title,args,n);
    XtAddCallback(item,XmNactivateCallback,cb,p);

    return item;
}

Widget initToggleItem(Widget title, int one_of_many,
    char *name, XtCallbackProc cb, XtPointer p)
{
    Arg         args[10];
    Cardinal    n;
    Widget  item;

    n = 0;
    if (one_of_many)
    {
    XtSetArg(args[n], XmNindicatorType, XmONE_OF_MANY); n++;
    }
    XtSetArg(args[n], XmNvisibleWhenOff, True); n++;
    item = XtCreateManagedWidget(name,xmToggleButtonWidgetClass,title,args,n);
    XtAddCallback(item,XmNvalueChangedCallback,cb,p);

    return item;
}

void initPopupMenu(Widget parent)
{
    PopupMenuW = XmCreatePopupMenu(parent,"PopupMenu",NULL,0);
    initItem(PopupMenuW,"Next Page",(XtCallbackProc)nextPageCB,(XtPointer)NULL);
    initItem(PopupMenuW,"Prev Page",(XtCallbackProc)prevPageCB,(XtPointer)NULL);
    initItem(PopupMenuW,"Goto Page ...",(XtCallbackProc)doDialog,(XtPointer)&page_dialog);
    initItem(PopupMenuW,"Update Page",(XtCallbackProc)updateCB,(XtPointer)NULL);
    XtCreateManagedWidget("Separator",xmSeparatorWidgetClass,PopupMenuW,NULL,0);
    initItem(PopupMenuW,"Quit",(XtCallbackProc)exitCB,(XtPointer)NULL);
}

Widget initMenu(Widget parent)
{
    Widget      menuBarW, fileW, printW, setupW, margW, optionW, devW;
    Arg         args[10];
    Cardinal    n;

    n = 0;
    menuBarW = XmCreateMenuBar(parent,"MenuBar",args,n);
    XtManageChild(menuBarW);

    fileW = initTitle(menuBarW,"File");
    printW = initTitle(menuBarW,"Print");
    setupW = initTitle(menuBarW,"Setup");
    margW = initTitle(menuBarW,"Margins");
    optionW = initTitle(menuBarW,"Options");
    devW = initTitle(menuBarW,"Devices");

    n=0;
    XtSetArg(args[n],XmNradioBehavior,True); n++;
    XtSetValues(devW,args,n);

    initItem(fileW,"Select File ...",(XtCallbackProc)doFileSelectorCB,(XtPointer)&fileSelDvi);
    XtCreateManagedWidget("Separator",xmSeparatorWidgetClass,fileW,NULL,0);
    initItem(fileW,"Load Options ...",(XtCallbackProc)doFileSelectorCB,(XtPointer)&fileSelRopt);    
    initItem(fileW,"Save Options ...",(XtCallbackProc)doFileSelectorCB,(XtPointer)&fileSelWopt);
    XtCreateManagedWidget("Separator",xmSeparatorWidgetClass,fileW,NULL,0);
    initItem(fileW,"Log File ...",(XtCallbackProc)doFileSelectorCB,(XtPointer)&fileSelLog);
    XtCreateManagedWidget("Separator",xmSeparatorWidgetClass,fileW,NULL,0);
    initItem(fileW,"Quit",(XtCallbackProc)exitCB,(XtPointer)NULL);

    initItem(printW,"Format Pages ...",(XtCallbackProc)doDialog,(XtPointer)&format_dialog);
    initItem(printW,"Magnification ...",(XtCallbackProc)doDialog,(XtPointer)&mag_dialog);

    initItem(setupW,"Clippath Memory ...",(XtCallbackProc)doDialog,(XtPointer)&clippath_dialog);
    initItem(setupW,"Maximum  Memory ...",(XtCallbackProc)doDialog,(XtPointer)&maximum_dialog);
    XtCreateManagedWidget("Separator",xmSeparatorWidgetClass,setupW,NULL,0);
    initItem(setupW,"PK  Font Path ...",(XtCallbackProc)doDialog,(XtPointer)&pkpath_dialog);
    initItem(setupW,"VF  Font Path ...",(XtCallbackProc)doDialog,(XtPointer)&vfpath_dialog);
    initItem(setupW,"TFM Font Path ...",(XtCallbackProc)doDialog,(XtPointer)&tfmpath_dialog);
    initItem(setupW,"IMG Image Path ...",(XtCallbackProc)doDialog,(XtPointer)&imgpath_dialog);
    initItem(setupW,"GR  Input Path ...",(XtCallbackProc)doDialog,(XtPointer)&grpath_dialog);
    initItem(setupW,"DVI Input Path ...",(XtCallbackProc)doDialog,(XtPointer)&dvipath_dialog);

    XtCreateManagedWidget("Separator",xmSeparatorWidgetClass,setupW,NULL,0);		/****/
    initItem(setupW,"Printer ...",(XtCallbackProc)doDialog,(XtPointer)&printer_dialog); /****/
    initItem(margW,"H-Offset ...",(XtCallbackProc)doDialog,(XtPointer)&hoff_dialog);
    initItem(margW,"V-Offset ...",(XtCallbackProc)doDialog,(XtPointer)&voff_dialog);
    initItem(margW,"H-Spread ...",(XtCallbackProc)doDialog,(XtPointer)&hspread_dialog);
    initItem(margW,"V-Spread ...",(XtCallbackProc)doDialog,(XtPointer)&vspread_dialog);

    initItem(optionW,"H-Resolution ...",(XtCallbackProc)doDialog,(XtPointer)&hres_dialog);
    initItem(optionW,"V-Resolution ...",(XtCallbackProc)doDialog,(XtPointer)&vres_dialog);
    XtCreateManagedWidget("Separator",xmSeparatorWidgetClass,optionW,NULL,0);
    dviMemW = initToggleItem(optionW,0,"Dvi in memory",(XtCallbackProc)toggle_dviMemory,(XtPointer)NULL);
    traceFontsW = initToggleItem(optionW,0,"Trace Fonts",(XtCallbackProc)toggle_traceFonts,(XtPointer)NULL);
    traceMemW = initToggleItem(optionW,0,"Trace Memory",(XtCallbackProc)toggle_traceMemory,(XtPointer)NULL);
    traceCharsW = initToggleItem(optionW,0,"Trace Chars",(XtCallbackProc)toggle_traceChars,(XtPointer)NULL);

    sh_NULLW = initToggleItem(devW,1,"Screen",(XtCallbackProc)shipoutCB,(XtPointer)&null_d);
    sh_p6lowW = initToggleItem(devW,1,"P6 Low",(XtCallbackProc)shipoutCB,(XtPointer)&p6low_d);
    sh_p6midW = initToggleItem(devW,1,"P6 Med",(XtCallbackProc)shipoutCB,(XtPointer)&p6mid_d);
    sh_p6highW = initToggleItem(devW,1,"P6 High",(XtCallbackProc)shipoutCB,(XtPointer)&p6high_d);
    sh_fx80W = initToggleItem(devW,1,"Epson FX 80",(XtCallbackProc)shipoutCB,(XtPointer)&fx80_d);
    sh_shipfileW = initToggleItem(devW,1,"File",(XtCallbackProc)shipoutCB,(XtPointer)&shipfile_d);
    sh_hpljW = initToggleItem(devW,1,"HP Laserjet",(XtCallbackProc)shipoutCB,(XtPointer)&hplj_d);
    sh_hpljlowW = initToggleItem(devW,1,"HP Laserjet Low",(XtCallbackProc)shipoutCB,(XtPointer)&hpljlow_d);
    sh_bj300W = initToggleItem(devW,1,"Canon BJ300",(XtCallbackProc)shipoutCB,(XtPointer)&bj300_d);
    sh_null_deviceW = initToggleItem(devW,1,"NULL Device",(XtCallbackProc)shipoutCB,(XtPointer)&null_device_d);

    initFileSelector(menuBarW);

    return menuBarW;
}

Widget initForm(Widget parent)
{
    Arg         args[10];
    static char ver[64];
    Cardinal    n;


    n = 0;
    XtSetArg(args[n],XmNeditMode,XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n],XmNeditable,False); n++;
    XtSetArg(args[n],XmNautoShowCursorPosition,True); n++;
    XtSetArg(args[n],XmNcolumns,64); n++;
    XtSetArg(args[n],XmNrows,10); n++;
    XtSetArg(args[n],XmNcursorPositionVisible,False); n++;
    textW = XmCreateScrolledText(parent,"Text",args,n);
    XtManageChild(textW);

    return XtParent(textW);
}

void initWidgetBaum(Widget applShell)
{
    Widget mainW, formW, menuW;

    mainW = XtCreateManagedWidget("Main",xmMainWindowWidgetClass,applShell,(Arg*)NULL,0);
    formW = initForm(mainW);
    menuW = initMenu(mainW);

    XmMainWindowSetAreas(mainW,menuW,(Widget)NULL,(Widget)NULL,(Widget)NULL,formW);
}

void destroyCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    PageIsOpen = 0;
    dvi_clean();
    exitImage();
}

void initDviOutWindow(void)
{
    Arg         args[10];
    Cardinal    n;
    Widget  mainW, formW, hscrollW, vscrollW;

    if (!PageIsOpen)
    {
    n = 0;
    /*
    XtSetArg(args[n], XmNargc, argcTmp); n++;
    XtSetArg(args[n], XmNargv, argvTmp); n++;
    XtSetArg(args[n], XmNdeleteResponse,XmDO_NOTHING); n++;
    */
    XtSetArg(args[n], XmNiconName,"Dvi"); n++;
    XtSetArg(args[n], XmNscreen, defaultScreen); n++;
    dispShell = XtAppCreateShell("dviPage", APPL_CLASS,
	topLevelShellWidgetClass, theDisplay, args, n);

    XtAddCallback(dispShell,XmNdestroyCallback,(XtCallbackProc)destroyCB,NULL);

    if (dvi_name) set_filename(dvi_name);

    n = 0;
    mainW = XtCreateManagedWidget("Main",xmMainWindowWidgetClass,
	dispShell,args,n);
    initGraphic(mainW);
    initPopupMenu(graphicW);
    XtAddEventHandler(graphicW,Button1MotionMask|ButtonPressMask,
		  False,moveImageCB,NULL);

	XtRealizeWidget(dispShell);
    PageIsOpen = 1;
    }
    if (theImage==NULL) initImage();
}

void exitDviOutWindow(void)
{
    if (PageIsOpen)
    {
    XtDestroyWidget(dispShell);
    dvi_clean();
    }
}

void resizeCB(Widget widget, caddr_t clientDaten, caddr_t aufrufDaten)
{
    Arg           args[10];
    Cardinal      n;   
    Dimension     width, height;
    int       expose = 0;

    n = 0;
    XtSetArg(args[n],XmNwidth,&width); n++;
    XtSetArg(args[n],XmNheight,&height); n++;
    XtGetValues(graphicW,args,n);
    if (frame_width*8-Image_x<width) 
    Image_x = frame_width*8 - width, expose=1;
    if (frame_height-Image_y<height) 
    Image_y = frame_height - height, expose=1;
    if (Image_x<0) Image_x = 0, expose=1;
    if (Image_y<0) Image_y = 0, expose=1;
    if (expose) exposeCB(graphicW,(XtPointer)NULL,(XtPointer)NULL);
}

void exposeCB(Widget widget, caddr_t clientDaten, caddr_t aufrufDaten)
{
    Arg           args[10];
    Cardinal      n;   
    Dimension     width, height;

    n = 0;
    XtSetArg(args[n],XmNwidth,&width); n++;
    XtSetArg(args[n],XmNheight,&height); n++;
    XtGetValues(graphicW,args,n);

    if (theImage!=NULL)
    {
    int draw_width, draw_height;
    draw_width = width>frame_width*8-Image_x ? frame_width*8-Image_x:width;
    draw_height = height>frame_height-Image_y ? frame_height-Image_y:height;
    if (draw_width<width)
	XClearArea(XtDisplay(widget),XtWindow(widget),draw_width,0,0,0,False);
    if (draw_height<height)
	XClearArea(XtDisplay(widget),XtWindow(widget),0,draw_height,0,0,False);

    XPutImage(XtDisplay(widget),XtWindow(widget),theGC,
	theImage,Image_x,Image_y,0,0,draw_width,draw_height);
    }
    else
    {
	XClearWindow(XtDisplay(widget),XtWindow(widget));
    }
}

void inversCB(Widget widget, caddr_t clientDaten, caddr_t aufrufDaten)
{
    Arg         args[10];
    Cardinal    n;
    Pixel       fg, bg;

    n = 0;
    XtSetArg(args[n], XmNforeground, &fg); n++;
    XtSetArg(args[n], XmNbackground, &bg); n++;
    XtGetValues(widget, args, n);

    n = 0;
    XtSetArg(args[n], XmNforeground, bg); n++;
    XtSetArg(args[n], XmNbackground, fg); n++;
    XtSetValues(widget, args, n);
}

void exitCB(Widget widget, caddr_t clientDaten, caddr_t aufrufDaten)
{
    dvi_clean();
    exit(0);
}
