/*
	ftl0.h

	FTL0 header file defines

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk
*/

#define PID_FILE	0xBB
#define PID_DIRECTORY	0xBD

typedef struct
{
  char  fFlag __attribute__ ((packed));
  unsigned fileId __attribute__ ((packed));
  char  nFileType __attribute__ ((packed));
  unsigned short wOffset __attribute__ ((packed));
  unsigned char nOffsetHigh __attribute__ ((packed));
} FILEHEADER;

typedef struct
{
  char  flags __attribute__ ((packed));
  unsigned fileId __attribute__ ((packed));
  unsigned offset __attribute__ ((packed));
  time_t tOld __attribute__ ((packed));
  time_t tNew __attribute__ ((packed));
} DIRHEADER;


#define VERSION      0
#define VERSIONFLAG  0x0C
#define LENGTHFLAG   0x01
#define LASTBYTEFLAG 0x20
#define OFFSETFLAG   0x02

#define PFHBROADCAST    0x00
#define TYPEFLAG        0x03
#define NEWESTFLAG  0x40

typedef struct
{
	unsigned char flags __attribute__ ((packed));
	unsigned long fileId __attribute__ ((packed));
	short blockSize __attribute__ ((packed));
} REQUESTHEADER;

typedef struct
{
	unsigned short  offset __attribute__ ((packed));
	unsigned char offset_msb __attribute__ ((packed));
	unsigned short  length __attribute__ ((packed));
} HOLEPAIR;


typedef struct
{
	unsigned int   startTime __attribute__ ((packed));
	unsigned int   endTime __attribute__ ((packed));
} DIRHOLEPAIR;

typedef struct
{
	unsigned char flags __attribute__ ((packed));
	short blockSize __attribute__ ((packed));
} DIRREQUESTHEADER;


/*
 *	connected protocols - UPLOAD only defined
 */

typedef enum
{
	DATA, DATA_END, LOGIN_RESP, UPLOAD_CMD, UL_GO_RESP, UL_ERROR_RESP,
	UL_ACK_RESP, UL_NAK_RESP
} PACKET_TYPE;


typedef struct
{
	unsigned long file;
	unsigned long length;
} UPLOAD_REQUEST;

typedef struct
{
	unsigned long file;
	unsigned long offset;
} UPLOAD_RESPONSE;
