/*
This command tests the Rexx functions.
*/

/*=============================================================================
Test the RexxDate functions.
*/
say 'Testing RexxDate functions.'
/*
signal on failure name RexxDate_cleanup
signal on halt name RexxDate_cleanup
signal on syntax name RexxDate_cleanup
*/
if RxFuncQuery('RexxDate_Init')
  then
    do
      say 'Registering RexxDate_Init.'
      retcode = RxFuncAdd(RexxDate_Init, 'REXXDATE', 'RexxDate_Init')
      retcode = RexxDate_Init()
    end /* end do */
/******************************************************************************/

  say 'Testing date difference routine.'

  parse value DATE('U') with mon'/'day'/'yr
  
  say 'Calling RexxDate_Diff with both arguments.'
  date1 = '2/28/94'
  date2 = '2/18/94'
  diff = RexxDate_Diff(date1,date2)
  say 'Difference in days between' date1 'and' date2 'is' diff

  say 'Calling RexxDate_Diff with first argument omitted.'
  date2 = '1/1/'yr
  diff = RexxDate_Diff( ,date2)
  say 'Difference in days between' DATE('U') 'and' date2 'is' diff

  say 'Calling RexxDate_Diff with second argument omitted.'
  date1 = DATE(U)
  diff = RexxDate_Diff(date1, )
  say 'Difference in days between' date1 'and' DATE(U) 'is' diff

/******************************************************************************/

  say "Testing leap year routine."

  parse value DATE('U') with mon'/'day'/'yr
  say 'Test with no arguments:' RexxDate_Isleap('96')

  Do year = 1900 + yr to 2010
     say year // 100  RexxDate_Isleap(year // 100 ) year RexxDate_Isleap(year)
  end /* do */
/*
Exits.
*/
RexxDate_cleanup:
  retcode = RexxDate_Drop()
  say 'Exiting.'
