/*****************************************************************
 * Pegasus Resource Monitor                                      *
 * Version 1 Release 10                                          *
 * (c) 1993,1994 C.O.L. Systems Inc. All Rights Reserved.        *
******************************************************************/

/* Register with REXX API extensions. */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initializers                 */

iFound = 0;

/* Get command line parameters. */

Parse Arg InstallDir

if InstallDir = "" then do
   r=Instructions();
   exit;
   end;

else do

   Call SysFileTree InstallDir , "Cfiles" , "SD"
   do i = 1 to Cfiles.0
      if pos( translate(InstallDir) , translate(Cfiles.i) ) > 0 then do
         iFound = 1;
         i = Cfiles.0
         end;
      end;
   end;

/* If the directory pointed to was not found, then create it   */

if iFound = 0 then do
   r = Call SysMkDir( InstallDir );
   r = delword(r,1,1);
   if( r <> 0 ) then do
      say;
      say 'An error occured creating the specified directory rc = 'r;
      'helpmsg 'r;
      say 'Pegasus installation aborting due to error in pathname';
      r=Instructions();
      exit;
      end;
   end;

/* Copy files. */

Call SysCls

Say
Say 'Installing Pegasus Resource Monitor Version 1 Release 10'

'copy pegasus.exe '||InstallDir
'copy pegasus.hlp '||InstallDir
'copy pegasus.inf '||InstallDir
'copy pegasus.ico '||InstallDir
'copy os2dcf.exe '||InstallDir
'copy dcfapi.dll '||InstallDir
'copy os2com.dll '||InstallDir
'copy readme.1st '||InstallDir
'copy register.doc '||InstallDir
'copy os2share.doc '||InstallDir

Say;
Say 'Creating Pegasus Desktop objects.';
Say;

r = Call SysCreateObject("WPFolder","Pegasus","<WP_DESKTOP>","OBJECTID=<PEGFOLDER>","update")
                     
if (r <> 0 ) then do

      r = Call SysCreateObject("WPProgram","Pegasus 1.10","<PEGFOLDER>",,
               "EXENAME="||InstallDir||"\PEGASUS.EXE;STARTUPDIR="||InstallDir,"replace" );

      r = Call SysCreateObject("WPProgram","Pegasus Reference","<PEGFOLDER>",,
               "EXENAME=VIEW.EXE;PARAMETERS="||InstallDir||"\PEGASUS.INF;STARTUPDIR="||InstallDir,"replace" );
   end;

else do
   say;
   say   'An error occured during the creation of the Pegasus Folder ';
   say   'and program objects. Contact C.O.L. Systems Inc. ';
   end;

Say 'Pegasus Resource Monitor 1.10 has been installed!'
Say
olddir = directory();
f = directory(InstallDir);
'view pegasus License And Warranty';
f = directory(olddir);

Exit

/* Instructions on installation procedure */

Instructions:
      Say
      Say
      Say '     Pegasus Resource Monitor Installation Instructions: '
      Say
      Say
      Say 'Directions:    To install Pegasus, you must choose a target'
      Say '               directory on your hard drive.'
      Say
      Say
      Say 'Example:       PINSTALL C:\PEGASUS '
      Say

Return 0;
