/***********************************************************************\
 *                                PC2.c                                *
 *              Copyright (C) by Stangl Roman, 1993, 1994              *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * PC2.h        Program Commander/2 header file.                       *
 *                                                                     *
\***********************************************************************/

#ifndef IPFC                            /* Don't include if we compile HLP files */
#define         INCL_WIN                /* Environment include files */
#define         INCL_GPI
#define         INCL_DOS
#define         INCL_DOSERRORS
#define         INCL_DOSPROCESS
#include        <os2.h>

#include        <stdio.h>               /* C Set/2 include files */
#include        <stdlib.h>
#include        <string.h>
#include        <ctype.h>
#include        <memory.h>
#endif

                                        /* PC/2 semaphore to avoid loading PC/2 twice */
#define         PC2_SEM "\\SEM32\\PC2_SEM.SEM"
#define         DESKTOP_CLASS   "#37"   /* Class name of the "Desktop" window handle (which
                                           is reserved in the Toolkit) but it's a container */

                                        /* WIN-OS2 3.1 settings defined only in 2.1 toolkit */
#define         PROG_31_STDSEAMLESSVDM      15
#define         PROG_31_STDSEAMLESSCOMMON   16
#define         PROG_31_ENHSEAMLESSVDM      17
#define         PROG_31_ENHSEAMLESSCOMMON   18
#define         PROG_31_ENH                 19
#define         PROG_31_STD                 20
                                        /* Define an additional session type of WPS object
                                           representing any object */
#define         SSF_TYPE_WPSOBJECT          21
#define         FAPPTYP_WINDOWSPROT31       0x1000
                                        /* Number of KEYDATA hotkeys defined for PC/2 */
#define         KEYDATACOUNT                72

#define         CLASSNAMESIZE               7
#define         SWP_MOVEWINDOWVISIBLE       0x20000000
#define         SWP_NOMOVE                  0x40000000
#define         SWP_MOVEWINDOW              0x80000000

/*--------------------------------------------------------------------------------------*\
 *                                                                                      *
 * +-----+-----+-----+                                                                  *
 * | www |    www========== Some windows, only two seen by the user on the display.     *
 * | www |     |     |                                                                  *
 * +-----+-----www---+===== Virtual Desktop (9fold-size of physical Desktop).           *
 * |     | www wwww  |                                                                  *
 * |  +----www | ww  |                                                                  *
 * +--|ww  www-+-----+                                                                  *
 * |  |ww   |============== Physical Desktop somewhere within virtual Desktop. The      *
 * |  +-----+  |     |      physical Desktop is the part of the virtual Desktop which   *
 * +-----+-----+-----+      the user visually can see, therefor large parts of the      *
 *                          virtual Desktop can't be ssen by the user. He must use      *
 * his pointing device, the slide the physical Desktop around the virtual Desktop, by   *
 * moving the pointer over the surrounding rows and columns of the physical screen.     *
 *                                                                                      *
\*------------------------------------------------------------------------------------- */
                                        /* Status bits defined for bitmapped ulMoveFlag */
#define         MOVEXR          0x1     /* Set if we move all windows right (our physical
                                           Desktop will move left on the virtual Desktop) */
#define         MOVEXL          0x2     /* Set if we move all windows left */
#define         MOVEYU          0x4     /* Set if we move all windows up (our physical
                                           Desktop will move down on the virtual Desktop */
#define         MOVEYD          0x8     /* Set if we move all windows down */
#define         MOVED4CLICK     0x10    /* Set if we are to move all windows, but the
                                           CLICK2MOVE flag is set, and therefor we require
                                           a click before we really move */
                                        /* Status bits defined for bitmapped ulStatusFlag */
#define         SLIDINGFOCUS    0x01    /* Set if the user requested a sliding focus */
#define         VIRTUALDESKTOP  0x02    /* Set if the user requested a virtual Desktop */
#define         MOVEDESKTOP     0x04    /* Set if the user also wants the WPS to move */
#define         CLICK2MOVE      0x08    /* Set if the user wants to click before Desktop
                                           moves */
#define         OVERVIEW        0x10    /* Set if the user wants an overview window */
#define         PRESERVEZORDER  0x20    /* Set if sliding focus should preserve the Z-order of
                                           the windows */
#define         BUTTON2ZORDER   0x40    /* Set if mouse button 2 click downs on titlebars should
                                           set the window to the bottom of all windows */
#define         KEEPONTOP       0x80    /* Set if overview window should be the topmost window,
                                           even when another window has the focus */

#define         VISIBLE         0x01    /* Set if window visible on overview window */
#define         FRAMECLASS      0X02    /* Set if window has a known frame class */

#define         EF_SIZE255      255

typedef struct  _SESSIONDATA            SESSIONDATA;
typedef struct  _MENUDATA               MENUDATA;
typedef struct  _COMMANDLINEPARAMS      COMMANDLINEPARAMS;
typedef struct  _HOOKPARAMETERS         HOOKPARAMETERS;
typedef struct  _NBPAGE                 NBPAGE;
typedef struct  _KEYDATA                KEYDATA;
typedef struct  _WINDOWDATA             WINDOWDATA;
typedef struct  _WINDOWS                WINDOWS;

#define         ENTRYSUBMENU    0       /* Popup-Menu entry is a (sub)menu */
#define         ENTRYMENUITEM   1       /* Popup-Menu entry is a programm */
#define         ENTRYCONTROL    2       /* Popup-Menu entry is a PC/2 configuration control */
#define         ENTRYEMPTY      3       /* Popup-Menu entry is empty */

#define         CTRL_CONFIGMENU         "Config Menu"
#define         CTRL_CONFIGDESKTOP      "Config Desktop"
#define         CTRL_ABOUT              "About PC/2"
#define         CTRL_SHUTDOWN           "ShutDown OS/2"
#define         CTRL_HELP               "Help\tF1"
#define         CTRL_EXIT               "Exit\tF3"
#define         CTRL_BREAKSEPARATOR     "-- Vert. Break --"
#define         CTRL_SEPARATOR          "--- Separator ---"

#define         PAGE_1          0       /* Index of 1st notebook page */
#define         PAGE_2          1
#define         PAGE_3          2
#define         PAGE_4          3
#define         PAGE_5          4

struct  _KEYDATA                        /* Structure that defined 1 hotkey */
{
USHORT          usFlags;                /* Keyboard control codes: KC_CTRL, KC_ALT,... */
USHORT          usCh;                   /* Keyboard character value: 0, 1,... */
BOOL            bUsed;                  /* True if this hotkey is defined */
MENUDATA        *pMenuData;             /* Pointer to MenuData structure where is Hotkey
                                           is defined */
};

struct _SESSIONDATA                     /* Control structure to start a new session */
{
ULONG           id;                     /* Session ID for menu ressources */
UCHAR           PgmTitle[MAXNAMEL+1];   /* Session title */
                                        /* Session (sub)title on window's titlebar */
UCHAR           WindowTitle[MAXNAMEL+1];
UCHAR           PgmName[EF_SIZE255+1];  /* Session path and filename */
                                        /* Session working directory */
UCHAR           PgmDirectory[EF_SIZE255+1];
                                        /* Session parameter */
UCHAR           PgmInputs[EF_SIZE255+1];
UCHAR           PgmDosSettings[2049];   /* DOS Settings for DOS sessions */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
SHORT           InitXPos;               /* X position */
SHORT           InitYPos;               /* Y position */
SHORT           InitXSize;              /* X size */
SHORT           InitYSize;              /* Y size */
KEYDATA         KeyData;                /* Hotkey data, if none defined, usCh=0, bUsed=0, pMenuData=NULL */
ULONG           SwpFlag;                /* Activation on hotkey SWP flag: SWP_RESTORE or SWP_MAXIMIZE,
                                           SWP_NOMOVE */
USHORT          PriorityClass;          /* Priority Class */
SHORT           PriorityDelta;          /* Priority Delta */
};

struct _MENUDATA                        /* Control structure to build popup menu */
{
USHORT          Item;                   /* MENUITEM or SUBMENU */
HWND            hwndItem;               /* Window handle within Popup-Menu */
ULONG           id;                     /* Session ID for menu ressources */
PSZ             PgmTitle;               /* Session title */
PSZ             WindowTitle;            /* Session (sub)title on window's titlebar */
PSZ             PgmName;                /* Session path and filename */
PSZ             PgmDirectory;           /* Session working directory */
PSZ             PgmInputs;              /* Session parameter */
PSZ             PgmDosSettings;         /* Session settings for DOS applications */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
SHORT           InitXPos;               /* X position */
SHORT           InitYPos;               /* Y position */
SHORT           InitXSize;              /* X size */
SHORT           InitYSize;              /* Y size */
KEYDATA         KeyData;                /* Hotkey data, if none defined, usCh=0, bUsed=0, pMenuData=NULL */ 
ULONG           SwpFlag;                /* Activation on hotkey SWP flag: SWP_RESTORE or SWP_MAXIMIZE,
                                           SWP_NOMOVE */
USHORT          PriorityClass;          /* Priority Class */
SHORT           PriorityDelta;          /* Priority Delta */
MENUDATA        *Back;                  /* Pointer to previous menu */
MENUDATA        *Submenu;               /* Pointer to a submenu */
MENUDATA        *Next;                  /* Pointer to next menu */
};

struct  _COMMANDLINEPARAMS
{
UCHAR           ucPgmTitle[MAXNAMEL+1]; /* Session title */
UCHAR           ucPBefore[MAXNAMEL+1];  /* Parameters before user requested parameter */
UCHAR           ucPUser[128];           /* User requested parameter */
UCHAR           ucPAfter[MAXNAMEL+1];   /* Parameters after user requested parameter */
};

struct  _HOOKPARAMETERS
{
HAB             habWindow;              /* Anchor block handle of PC/2 */
HWND            hwndWPS;                /* WPS window handle where mouse clicks on WPS
                                           can be found */
HWND            hwndDesktop;            /* PM window handle where mouse clicks on Desktop
                                           can be found */
HWND            hwndPC2;                /* PC/2's window handle to send/post messages to */
ULONG           ProcessId;              /* PC/2's process ID */
USHORT          PriorityClass;          /* PC/2's standard Priority Class */
SHORT           PriorityDelta;          /* PC/2's stantard Priority Delta */
                                        /* Name of Desktop, f.e. OS/2 2.0 Desktop */
UCHAR           ucDesktopName[MAXNAMEL+1];
                                        /* Name of Task List, f.e. Window List */
UCHAR           ucWindowListName[MAXNAMEL+1];
ULONG           ulScrollPercentage;     /* Percentage of physical Desktop used to scroll
                                           through virtual Desktop (25, 50, 75, 100 %) */
ULONG           ulStatusFlag;           /* Bitmapped status flag */
ULONG           ulClickFlag;            /* WM_BUTTON1CLICK for a single click, and
                                           WM_BUTTON1DBLCLK for a double click */
SWP             swpPC2;                 /* Overview window size and position */
SWP             swpPC2Client;           /* Overview window client's size and position */
float           fScaleX, fScaleY;       /* Reduce factor to reduce horizontal size of virtual
                                           Desktop to horizonal client window size */
POINTL          ptlOrigin;              /* Coordinates (0|0) within client area */
POINTL          LLHotBorder;            /* Lower left coordinates that force sliding in x & y direction */
POINTL          URHotBorder;            /* Upper right coordinates that force sliding in -x & -y direction */
POINTL          DesktopSize;            /* Size of the physical Desktop screen */
POINTL          VirtualDesktopPos;      /* Position of the physical Desktop within the virtual */
POINTL          VirtualDesktopMin;      /* Lower left position of whole virtual Desktop */
POINTL          VirtualDesktopMax;      /* Upper right position of whole virtual Desktop */
LONG            SlidingXFactor;         /* Sliding offset in pixel for horizontal movements */
LONG            SlidingYFactor;         /* Sliding offset in pixel for vertical movements */
};

struct  _NBPAGE                         /* Notebook pages setup data */
{
PFNWP           pDialogWndProc;         /* Window procedure of a  notebook page */
HWND            hwndPINBPage;           /* Window handle of a notebook page */
ULONG           ulIDPage;               /* ID of notebook page */
PSZ             pszStatusLine;          /* Status line text */
PSZ             pszTab;                 /* Tab text */
ULONG           ulIDDialogPage;         /* ID of a dialog resource */
ULONG           ulIDFocus;              /* ID of control to receive focus */
};

struct  _WINDOWDATA                     /* All we need to know about a certain window */
{
UCHAR           ucPgmTitle[MAXNAMEL+1]; /* Session title on titlebar */
                                        /* Session title in Window List */
UCHAR           ucWindowTitle[MAXNAMEL+1];
                                        /* Session's class name */
UCHAR           ucClassName[CLASSNAMESIZE];
SWP             swpWindow;              /* Window's SWP structure */
KEYDATA         KeyData;                /* Hotkey data */
ULONG           SwpFlag;                /* Activation on hotkey SWP flag: SWP_RESTORE or SWP_MAXIMIZE,
                                           SWP_NOMOVE */
HSWITCH         hswitchWindow;          /* Switch handle of the window */
ULONG           ulStatus;               /* Status on overview window */
};

struct  _WINDOWS                        /* All windows on PM are traced here */
{
ULONG           ulDesktop;              /* Index of Desktop in WINDOWDATA[] */
ULONG           ulWindowList;           /* Index of Window List in WINDOWDATA[] */
ULONG           ulWindowLast;           /* Index of last window in WINDOWDATA[] */
WINDOWDATA      wdWindow[128];          /* Assume 128 windows maximum */
};

#define ID_PC2MAINWINDOW        256
#define ID_PC2THREADWINDOW      257
#define ID_PC2POPUPMENU         258

#define PC2_CLASSNAME           "PC2 - Main"
#define PC2_CLASSNAME_THREAD    "PC2 - Thread"

#define ID_PC2SETUP             300     /* Defines for PopUp Menu, that is popped up after
                                           the user presses mouse button 1 on DESKTOP */
#define ID_CONFIGDIALOG         301     /* User pressed Configure Menu */
#define ID_ABOUTDIALOG          302     /* User pressed About PC/2 */
#define ID_EXIT                 303     /* User pressed F3 to exit PC/2 */
#define ID_SHUTDOWN             304     /* User pressed ShutDown OS/2 */
#define ID_DESKTOPDIALOG        305     /* User pressed Configure Desktop */
#define ID_HELP                 306     /* ID used for HELP panels */

#define ID_ICONEXIT             310     /* Exit PC/2 smarticon */
#define ID_ICONMOVE             311     /* Move smarticon */
#define ID_ICONZORDERTOP        312     /* Set window behind HWND_TOP smarticon */
#define ID_ICONZORDERBOTTOM     313     /* Set window behind HWND_BOTTOM smarticon */
#define ID_ICONCLOSE            314     /* Close window smarticon */
#define ID_ICONMAXIMIZE         315     /* Maximize window smarticon */
#define ID_ICONMINIMIZE         316     /* Minimize window smarticon */
#define ID_ICONRESTORE          317     /* Restore window smarticon */
#define ID_ICONSHUTDOWN         318     /* Shutdown OS/2 smarticon */
#define ID_ICONHELP             319     /* Help PC/2 window smarticon */
#define ID_ICONHIDE             320     /* Hide PC/2 window smarticon */

#define ID_MOVEPOINTER          330     /* Pointer active while moving windows on
                                           overview window is enabled */
#define ID_ACTIONPOINTER        331     /* Pointer active while performing actions (except
                                           moving) on windows */

#define PIID_PROGRAMDIALOG      500     /* Program installation notebook dialog */
#define PINB_NOTEBOOK           501
#define PIID_PAGE1              502     /* First notebook page */
#define PIGRP_PROGRAM           503     /* Program data group */
#define PIEF_PROGRAMTITLE       504
#define PIEF_PATHFILENAME       505
#define PIEF_DIRECTORY          506
#define PIEF_PARAMETERS         507
#define PIMLE_DOSSETTINGS       508
#define PIPB_WINFILEDLG         509

#define PIID_PAGE2              510     /* Second notebook page */
#define PIGRP_TYPE              511     /* Program type group */
#define PIRB_SHELL              512
#define PIRB_OS2FULLSCREEN      513
#define PIRB_OS2WINDOW          514
#define PIRB_PM                 515
#define PIRB_DOSFULLSCREEN      516
#define PIRB_DOSWINDOW          517
#define PIRB_WPSOBJECT          518
#define PIRB_WINOS2             519

#define PIGRP_WINOS2            520     /* Seamless WIN-OS2 settings */
#define PIRB_WINREAL            521
#define PIRB_WINSTANDARD        522
#define PIRB_WIN386ENHANCED     523
#define PICB_WINCOMMON          524

#define PIID_PAGE3              530     /* Third notebook page */
#define PIGRP_STYLE             531     /* Program style group */
#define PIRB_DEFAULTSTYLE       532
#define PIRB_MAXIMIZED          533
#define PIRB_MINIMIZED          534
#define PIRB_SIZEPOSITION       535
#define PIRB_INVISIBLE          536
#define PIRB_NOAUTOCLOSE        537
#define PIRB_BACKGROUND         538
#define PIGRP_SIZEPOSITION      540     /* User defined size & position */
#define PIEF_X                  541
#define PIEF_Y                  542
#define PIEF_XSIZE              543
#define PIEF_YSIZE              544

#define PIID_PAGE4              550     /* Forth notebook page */
#define PIGRP_HOTKEY            551     /* Hotkey settings group */
#define PIEF_SESSIONTITLE       552
#define PICB_HOTKEYENABLED      553
#define PIRB_WSMAXIMIZED        554
#define PIRB_WSRESTORE          555
#define PIRB_NONE               556
#define PIRB_CTRL               557
#define PIRB_ALT                558
#define PICBX_HOTKEY            559
#define PIGRP_DESKTOP           560
#define PICB_DONTMOVE           561
#define PIGRP_WINDOWLIST        562
#define PILB_WINDOWLIST         563

#define PIID_PAGE5              570     /* Fifth notebook page */
#define PIGRP_PROCESSPRIORITY   571     /* Process priority */
#define PIRB_IDLETIME           572
#define PIRB_REGULAR            573
#define PIRB_NOCHANGE           574
#define PIRB_TIMECRITICAL       575
#define PIRB_FOREGROUNDSERVER   576
#define PIEF_PRIORITYDELTA      577
#define PIHSB_PRIORITYDELTA     578

#define PIID_EXAMPLE1           580
#define PIID_EXAMPLE2           581
#define PIID_EXAMPLE3           582
#define PIID_EXAMPLE4           583
#define PIID_EXAMPLE5           584

#define ADID_ABOUTDIALOG        600     /* About program dialog */

#define DDID_DESKTOPDIALOG      650     /* Desktop configuration dialog */
#define DDGRP_SLIDINGFOCUS      651
#define DDCB_SLIDINGFOCUS       652
#define DDCB_PRESERVEZORDER     653
#define DDGRP_VIRUTALDESKTOP    660
#define DDCB_BUTTON2ZORDER      661
#define DDCB_VIRTUALDESKTOP     662
#define DDCB_MOVEDESKTOP        663
#define DDCB_CLICK2MOVE         664
#define DDCB_OVERVIEW           665
#define DDCB_KEEPONTOP          666
#define DDEF_DESKTOPNAME        667
#define DDEF_WINDOWLISTNAME     668
#define DDEF_SCROLLPERCENTAGE   669
#define DDHSB_SCROLLPERCENTAGE  670
#define DDGRP_POPUP             675
#define DDRB_BUTTON1CLICK       676
#define DDRB_BUTTON1DBLCLK      677

#define CDID_CONFIGDIALOG       700     /* Configuration menu dialog */
#define CDGRP_PROGRAM           701     /* Submenu/Program installation group */
#define CDLB_MENUPROGRAM        702
#define CDID_LEVELUP            703
#define CDID_LEVELDOWN          704
#define CDID_ADDMENU            705
#define CDID_ADDPROGRAM         706
#define CDID_CHANGEENTRY        707
#define CDID_REMOVEENTRY        708
#define CDID_RESORT             709
#define CDID_ADDCONTROL         710

#define CDID_HELP_1             711     /* Help pages */
#define CDID_HELP_2             712

#define RDID_RESORTDIALOG       750     /* Resort menuentries dialog */
#define RDPB_MOVE               751     /* Move pushbutton */
#define RDGRP_SOURCEMENU        755     /* Move from menu */
#define RDLB_SOURCEMENU         756
#define RDGRP_DESTINATIONMENU   760     /* Move into menu */
#define RDLB_DESTINATIONMENU    761

#define MIID_MENUDIALOG         800     /* Menu installation dialog */
#define MIGRP_PROGRAM           801     /* Menu data group */
#define MIEF_MENUTITLE          802

#define MIID_HELP_1             810     /* Help page */

#define MDID_CONTROLDIALOG      850     /* PC/2 Menu-Control dialog */
#define MDGRP_CTRL              851
#define MDRB_CTRL_CONFIGMENU    852
#define MDRB_CTRL_CONFIGDESKTOP 853
#define MDRB_CTRL_ABOUT         854
#define MDRB_CTRL_SHUTDOWN      855
#define MDRB_CTRL_HELP          856
#define MDRB_CTRL_EXIT          857
#define MDRB_CTRL_BRKSEPARATOR  858
#define MDRB_CTRL_SEPARATOR     859

#define SDID_SHUTDOWNDIALOG     900     /* OS/2 ShutDown dialog */
#define SDID_SHUTDOWNMESSAGE    901     /* Message diaplayed a ShutDown */

#define SUID_STARTUPDIALOG      950     /* Request parameters from user before launching
                                           an application */
#define SUTF_STARTUPPROGRAM     951     /* Application to be started */
#define SUTF_STARTUPINFO        952     /* Info to the user what to do */
#define SUTF_STARTUPPARAMETERS  953     /* Info to the user of current parameters */
#define SUEF_STARTUPPARAMETERS  954     /* Entryfield for user data */

#define ID_POPUPMENU            1500    /* ID used by first user entered entry in the
                                           popup menu. It is incremented by 1 by tracing
                                           through the linked list for each entry (submenu
                                           or menuitem). */
#define USERITEMFIRST           ID_POPUPMENU
#define USERITEMLAST            ID_POPUPMENU+499

                                        /* IDs used for HELP panels */
#define MAIN_HELP_TABLE         2001
#define MAIN_HELP_SUBTABLE      2002
#define ID_GENERALHELP          2003
#define ID_CONCEPTSHELP         2004
#define ID_USINGHELP            2005
#define ID_ERRORHELP            2006
#define ID_ERRORHELP_1          2007
#define ID_INSTALLATIONHELP     2008
#define ID_OVERVIEWHELP         2009
                                        /* New messages for the configuration menu dialog */
                                        /* Load the current level into configuration listbox */
#define WM_LOADPOPUPMENU        WM_USER+1
                                        /* Initialize the input queue hook */
#define WM_LOADHOOK             WM_USER+2
                                        /* Save Popup-Menu to Profile */
#define WM_SAVEPOPUPMENU        WM_USER+3
                                        /* Load Popup-Menu from Profile */
#define WM_SETPOPUPMENU         WM_USER+4
                                        /* Display Popup-Menu on Desktop */
#define WM_POPUPMENU            WM_USER+5

                                        /* Insert an item to the linked list */
#define MM_INSERTITEMMENUITEM   WM_USER+6
                                        /* Change the first item of a Submenu to an item */
#define MM_INSERTITEMSUBMENU    WM_USER+7
                                        /* Move an item of a Submenu to another position */
#define MM_MOVEMENUITEM         WM_USER+8
                                        /* ShutDown message to ShutDown dialog */
#define WM_SHUTDOWN             WM_USER+9
                                        /* Program Type configuration of Program Installation
                                           dialog */
#define WM_SETUPPROGRAMTYPE     WM_USER+10
                                        /* Program Priority configuration of Program Installation
                                           dialog */
#define WM_SETUPPROGRAMPRIORITY WM_USER+11
                                        /* Program Size & Position configuration of Program
                                           Installation dialog */
#define WM_SETUPSIZEPOSITION    WM_USER+12
                                        /* Hotkey settings to be initialized by Program
                                           Installation dialot */
#define WM_SETUPHOTKEY          WM_USER+13
                                        /* Query and set desktop window handle */
#define WM_SETDESKTOPHANDLE     WM_USER+14
                                        /* Sent by PC2HOOK.DLL if windows need to be moved */
#define WM_DESKTOPMOVE          WM_USER+15
                                        /* Sent by Program Installation dialog to dialog window
                                           procedure to initialize notebook pages with user data */
#define WM_SETUPNOTEBOOKPAGES   WM_USER+16
                                        /* Sent by PC2Hook.DLL when a WM_CHAR message was detected
                                           that is used by the Hotkey function */
#define WM_HOTKEY               WM_USER+17
                                        /* Sent by PC2Hook.DLL when mouse clicks are detected on
                                           PM that would display the window list on the WPS */
#define WM_WINDOWLIST           WM_USER+18
                                        /* This message is sent to the working thread whenever
                                           the overview window needs to be redrawn and any
                                           function thinks so */
#define WM_REPAINT              WM_USER+19
                                        /* The working thread posts itself permanently this
                                           message to repeatedly perform tasks */
#define WM_WORKINGTHREAD        WM_USER+20
                                        /* Sent by PC2Hook.DLL when the pointer is positioned on 
                                           a surrounding row and/or column and the Desktop should
                                           be moved */
#define WM_MOVEREQUEST          WM_USER+21
                                        /* Procedures */
extern int              main(int argc, char *argv[], char *envp[]);
extern BOOL             WinStartUp(HAB *pHab, HMQ *pHmq);
extern BOOL             WinStartHelp(HAB hab, UCHAR *pHelpfile, HWND *pHwndHelp);
extern BOOL             WinCloseDown(HWND *pHwndHelp, HAB *pHab, HMQ *pHmq);
extern void             StartSession(SESSIONDATA *SessionData);
extern BOOL             LoadMenuData2SessionData(MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern BOOL             LoadSessionData2MenuData(MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern MENUDATA         *AllocateMenuData(void);
extern void             LoadMenu(MENUDATA *pMenuData);
extern void             SaveMenu(MENUDATA *pMenuData);
extern MRESULT          SetPopupMenu(ULONG msg, MPARAM mp1, MPARAM mp2);
extern MENUDATA         *SearchItem(MENUDATA *pMD, ULONG *id);
extern MENUDATA         *SearchTitle(MENUDATA *pMD, WINDOWDATA *pWD, BOOL *pbFlag);
extern void             InstallFilename2Dialog(HWND hwndDlg, UCHAR *pucFullFileName, BOOL bObject);
extern void             DisableDialogItem(HWND hwndDlg, USHORT usDialogIDs[], USHORT usItemCount, ULONG ulStyle);
extern void             INIAccess(UCHAR *pucFilenameINI, BOOL bRead);
extern void             DrawWindow(HPS hpsClient, SWP *pswpWindow, ULONG ulWindowColor, ULONG ulTextColor, BOOL bWindow, PSZ pszWindowName);
extern void EXPENTRY    PC2DLL_SetParameters(void);
extern BOOL EXPENTRY    PC2DLL_Hook(HAB hab, PQMSG pqmsg, ULONG option);

                                        /* PC/2's working thread */
extern void _Optlink    PC2_Thread(void *ThreadArg);

                                        /* Window procedures */
extern MRESULT  EXPENTRY PC2_MainWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_SubclassedDialogProcedure(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_NotebookProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY CD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY RD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY DD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY MD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

                                        /* Working thread (object) window procedure */
extern MRESULT  EXPENTRY PC2_ThreadWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

extern HAB              hab;            /* Handle of PM anchor block */
extern HMQ              hmq;            /* Handle of message queue */
extern HWND             hwndFrame;
extern HWND             hwndClient;
extern HWND             hwndPopupMenu;  /* Handel of popup menu window */
extern HWND             hwndHelp;
extern SESSIONDATA      SessionData;
extern HOOKPARAMETERS   HookParameters; /* Parameters passed to PC2HOOK.DLL */
extern MENUDATA         *pPopupMenu;    /* First entry of linked list of menus */
extern MENUDATA         *pMenuData;     /* First entry of current level of linked list */
extern USHORT           DialogResult;   /* Result of last dialog */
extern USHORT           MenuDataId;     /* Id of the items in the Popup-Menu and linked list */
extern FILE             *Pc2Profile;    /* Profile filename */
                                        /* Path of PC2.INI */
extern UCHAR            *pucFilenameINI;
extern SWP              swpScreen;      /* The screen dimensions */
extern  BOOL            bConfigDialog;  /* TRUE only if the Configuration dialog exists */
                                        /* Hotkeys allowed for PC/2 */
extern KEYDATA          KeyData[KEYDATACOUNT];
extern WINDOWS          Windows;        /* Trace all windows here */
                                        /* Program Installation notebook pages setup */
extern NBPAGE           nbPINotebookPage[];

extern HWND             hwndThread;     /* PC/2's working thread window handle */

