/* Rexx */
/*=========================================================================*/
/* In the unfortunate situation that your Email index file (OEMASUB.IDX)   */
/* gets hosed, this REXX will rebuild a new Email index file from all of   */
/* the Email message residing in your Email directory.                     */
/*                                                                         */
/* Upon completion of this REXX, there will be a file called EMAIL.CAP     */
/* present which will be read in a processed. The next time you run        */
/* ODN.EXE, this EMAIL.CAP file will be processed just as if               */
/* it had been captured during a pass through Delphi, therefore all of the */
/* Email messages will show up as being unread once processed by ODN.      */
/*                                                                         */
/* Please back up your Email directory prior to running this REXX.         */
/*=========================================================================*/
If RxFuncQuery('SysLoadFuncs') <> 0 Then
Do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
End
If RxFuncQuery('rexxlibregister') <> 0 Then
Do
  call rxfuncadd 'rexxlibregister', 'rexxlib', 'rexxlibregister'
  call rexxlibregister
End
"@CD EMAIL"
CapFile="EMAIL.CAP"
RC=DosDel("OEMASUB.IDX")
Line.1=D2C(13)||D2C(10)"MAIL> EXT/ALL TT"; Line.0=1
RC=FileWrite(CapFile,"Line.")

RC=SysFileTree("*.msg","Matches.")
Do Z=1 to Matches.0
  Emf=Strip(SubStr(Matches.Z,38,255))
  Say "Working on "Emf
  Line.1=D2C(13)||D2C(10)||D2C(12); Line.0=1
  RC=FileWrite(CapFile,"Line.","A")
  RC=FileRead(Emf,"Line.")
  If Left(LIne.6,12)="Binary File:" Then Line.1=Line.1" 01-JAN-1980 00:00:00.01"
  RC=FileWrite(CapFile,"Line.","A")
End
Line.1=D2C(13)||D2C(10)"MAIL>"; Line.0=1
RC=FileWrite(CapFile,"Line.","A")
Say ""
Say "Deleting MSG files. Please wait..."
"@Del *.MSG"
