/* rexx */
/* This rexx utility is for use with JoeView, version 1.2 or greater*/
/* This particular example is setup for making a random lockup screen image */
/*  You will need to setup the lockup screen setting for your system to the correct */
/*  file that you indicate at the end of this file */
/*  I have this being executed in my startup.cmd file for a background image and */
/*  by the alarm utility (or cron) every few hours for my lockup screen */
/*  You can also use a similar file and put it in your startup.cmd to have a new */
/*  background image each time you startup your computer */
'@echo off'

/*You may need to uncomment the following 7 lines if your use the alarm command*/
/*to launch this file or you have a cron command that won't automatically minimize*/
/*this file*/

/*parse upper arg detach_me*/
/*if detach_me <> "DETACH" then*/
/*   do*/
/*      cmd = "start /min lockup_image detach"*/
/*      cmd*/
/*      exit*/
/*   end*/

'@echo on'
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

which_one = random(1, 990)   /* Seeding the random function a little */
which_one = random(3, 789)
which_one = random(6, 234)
/*Choose a directory, this example weights the odds towards one particular directory */

which_one = random(1,5)  
if which_one = 1 then
   change_direct = directory("e:\images\g")          /*put your path here */
else
   change_direct = directory("e:\images\pg")
 
/*Looking for jpegs only, change to other file format to suit your setup */
call SysFileTree "*.jpg",  "files", "F"
which_one = random(1,files.0)   /*Choose a random file */
fullpath = substr(files.which_one, 38)  /*The 38 is extra info in front of file name */
drive    = filespec("drive", fullpath)
path     = filespec("path", fullpath)
fullname = filespec("name", fullpath)
dotpos   = lastpos(".", fullname)

/* put your path to joeview here */
/* You will need to change the lockup screen's file to agree with whatever you
    specify here.  I.E. replace c:\os2\bitmap\lockup.bmp with whatever file you have
    indicated in the main settings lockup image option */
  cmd = "c:\os2\util\joeview -bs " fullpath " c:\os2\bitmap\lockup.bmp"
  cmd 
  cmd = 'exit'
  cmd
exit
