/**/ 
/* infprint.cmd 
Some HPL5 control codes----picked up from 2up.cmd.
 X2C(1B45)                  /* esc E         - reset printer*/
 x2c(1B266C2641)          /* esc&l&A       - select A4 paper*/
 x2c(B266C314F)        /*   esc&l1O       - select orientation*/
 x2c(1B266C3145)       /*    esc&l1E       - set top margin*/
 x2c(1B28733054)       /*    esc(s0T       - typeface for primary*/
 x2c(1B28313055)         /*  esc(10U       - select character set*/
 x2c(1B287331362E3648)  /* esc(s16.6H    - select font pitch for primary*/
 x2c(1B266C3844)        /*  esc&l8D       - set line pitch*/*/


 call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'Sysloadfuncs'
 call Sysloadfuncs

arg mypar  setpar
call inihandler 
if mypar = s  then do 
call setup
exit
end /*do */
else nop
if setpar = s  then call setup
back = 0
ricoh = 'lpt1:'
if portrait = 1  then lperp = portlperp
else lperp = landlperp
if portrait = 1 then prtll = 120
else prtll = 85
if portrait = 1 then cd=X2C(1B451B266C26411B266C304F1B266C31451B283130551B287331362E36481B266C3844)
                else cd=X2C(1B451B266C26411B266C314F1B266C31451B283130551B287331362E36481B266C3844)
prnfile = mypar
yfile = stream(prnfile,c,query exists)
if yfile = "" then exit
tempfile = 'cwtcwt.cwt'
tmpric = stream(tempfile,c,query exists)
if tmpric \= "" then call sysfiledelete tempfile
tmpric = stream(tempfile,c,open)
if portrait = 1 then fullside = lperp
else fullside = (lperp/2)
page = 0
n = 0
do until lines(prnfile) < 1
do  n = 1 to lperp
stub.n = linein(prnfile)
end
call printlines
drop stub.
end  /* Do */
if oneside = 0  then call backprint
exit
/*-------------------------------------------------*/
BACKPRINT:

say 'Printing even numbered pages.'
say 'Wait for printing to finish then turn the paper over'
say 'and press any key to print odd numbered pages on reverse'
pull ent
ricoh = 'lpt1:'
do forever      
thisline = ""
thisline = linein(tempfile)
call lineout ricoh, thisline
if lines(tempfile)<1 then leave
end /* do */
call lineout tempfile
call sysfiledelete cwtcwt.cwt
return
/*----------------------------------------------------*/
PRINTLINES:
r = 0
page = page + 1
back = back
if oneside = 1  then back = 0
if back = 1 then do 
ricoh = tempfile
spmgin = 5
end  /* Do */
else do 
ricoh = 'lpt1:'
spmgin = 2
if oneside = 1 then spmgin = 5
end /* do */
filepage = prnfile||'  Page '||page
topline = copies(' ',(160-(portrait*80)-length(filepage)))||filepage
underline = copies(' ',(160-(portrait*80)-length(filepage)))||copies('',length(filepage))
call charout ricoh, cd
call lineout ricoh,topline
call lineout ricoh,underline
do t = 1 to fullside
sd = t + fullside
if sd > n  then stub.sd = " "
if t > n then stub.t = " "
if portrait = 1 then alline.t = copies(' ',spmgin)||'   '||left(stub.t, prtll)
else alline.t = copies(' ',spmgin)||'   '||left(stub.t, prtll)||'   '||left(stub.sd, prtll)||''
call lineout ricoh, alline.t  
end
call lineout ricoh
return
/*----------------------------------------------------------*/
setup:
do forever
cls
if portrait = 1 then orient = 'portrait'
else orient = 'landscape'
if oneside = 1  then sideno = 'one side'
else sideno = 'both sides'
call syscurpos 4,0
say '           Orientation set to 'orient
say '           Print on 'sideno' of paper'
say '           Lines per page is 'portlperp' portrait'
say '           Lines per page is 'landlperp' landscape'
say   ''
say '          Select'
say '            O - to change orientation'
say '            P - for one/both sides printing'
say '            L - to alter lines per page'
say '            S - to save current settings as default'
say '            Q - to return to program'
pull nsel
select
when nsel = o then portrait = portrait
when nsel = p then oneside = oneside
when nsel = l  then call lset
when nsel = q  then return
when nsel = s  then do
call sysfiledelete inifile
newiniline = portrait' 'portlperp' 'landlperp' 'oneside
call lineout inifile, newiniline
call lineout inifile
end /*do */
otherwise nop
end /*select*/
end /* do */
return

/*------------------------------------------------------*/
INIHANDLER:
inifile = 'infprnt.ini'
 yini = stream(inifile,c,query exists)
 if yini = ""  then do
          iniline = "0 85 118 1"
          call lineout inifile,iniline
          end
else nop
iniset = linein(inifile,1,1)
parse value iniset with portrait portlperp landlperp oneside
call lineout inifile
return
/*----------------------------------------------------------*/
lset:
say '   Alter Portrait or Landscape'
pull pol
if pol = p | pol = l then do
say 'New lines per page'
pull llpp
if datatype(llpp) = num & llpp > 0  then do
if pol = p  then portlperp = llpp
else landlperp = llpp
end /*do */
else nop
end /*do*/
else nop
return
/*----------------------------------------------------------*/
Original release - infprint.cmd b0.15 21st June 1993.
See infextra.doc for details.
Modify and use as you please at your risk.
 written by Colin Thomson.
Fidonet at STRANGE***daze***(2:250/313)
/*----------------------------------------------------------*/

