/*  Copyright (C) 1993, 1994, Russell Lang.  All rights reserved.

 This file is part of GSview.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GSVIEW General Public License for more details.

 Everyone is granted permission to copy, modify and redistribute
 this program, but only under the conditions described in the GSVIEW
 General Public License.  A copy of this license is supposed to have been
 given to you along with this program so you can know your rights and
 responsibilities.  It should be in a file named COPYING.  Among other
 things, the copyright notice and this notice must be preserved on all
 copies. */

/* gvwprf.c */
/* Profile (INI file) routines for Windows */

#include "gvwin.h"

PROFILE *
profile_open(char *filename)
{
PROFILE *prf;
	if ( (prf = (PROFILE *)malloc(sizeof(PROFILE))) == (PROFILE *)NULL )
	    return (PROFILE *)NULL;
	if ( (prf->name = malloc(strlen(filename)+1)) == (char *)NULL ) {
	    free(prf);
	    return (PROFILE *)NULL;
	}
	strcpy(prf->name, filename);
	return prf;
}

int 
profile_read_string(PROFILE *prf, char *section, char GVFAR *entry, char *def, char *buffer, int len)
{
	return GetPrivateProfileString(section, entry, def, buffer, len, prf->name);
}

BOOL
profile_write_string(PROFILE *prf, char *section, char *entry, char *value)
{
	return WritePrivateProfileString(section, entry, value, prf->name);
}

BOOL
profile_close(PROFILE *prf)
{
	if (prf == (PROFILE *)NULL)
		return FALSE;
	if (prf->name)
	    free(prf->name);
	free(prf);
	return TRUE;
}

