/*  Copyright (C) 1993, 1994, Russell Lang.  All rights reserved.

 This file is part of GSview.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GSVIEW General Public License for more details.

 Everyone is granted permission to copy, modify and redistribute
 this program, but only under the conditions described in the GSVIEW
 General Public License.  A copy of this license is supposed to have been
 given to you along with this program so you can know your rights and
 responsibilities.  It should be in a file named COPYING.  Among other
 things, the copyright notice and this notice must be preserved on all
 copies. */

/* epstool.h */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#ifdef __EMX__
#define GSCOMMAND "gsos2"
#define BYTE unsigned char	/* 8 bits unsigned */
#define WORD  unsigned short	/* 16 bits unsigned */
#define DWORD unsigned int	/* 32 bits unsigned */
#define UINT  unsigned int	/* native unsigned */
#define LONG  int		/* 32 bits signed */
#define BOOL  int
#define GVFAR 
#define GVHUGE 
#define READBIN  "rb"
#define WRITEBIN "wb"
#define MAXSTR 256
#define DIRSEP '\\'
#define EOLSTR "\r\n"
#endif

#ifdef MSDOS
#define GSCOMMAND "gsos2"
#define BYTE unsigned char
#define WORD  unsigned short
#define DWORD unsigned long
#define UINT  unsigned int
#define LONG  long
#define BOOL  int
#define GVFAR far
#define GVHUGE huge
#define READBIN  "rb"
#define WRITEBIN "wb"
#define MAXSTR 126
#define DIRSEP '\\'
#define EOLSTR "\r\n"
#include <alloc.h>
#include <dir.h>
#endif

#ifdef UNIX
#define GSCOMMAND "gs"
#define BYTE unsigned char
#define WORD  unsigned short
#define DWORD unsigned int
#define UINT  unsigned int
#define LONG  int
#define BOOL  int
#define GVFAR 
#define GVHUGE
#define READBIN  "r"
#define WRITEBIN "w"
#define MAXSTR 256
#define DIRSEP '/'
#define EOLSTR "\n"
char *getcwd(char *, int);
#define stricmp(s1, s2) strcasecmp(s1, s2)
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_END 2
#endif
#endif

#include "gvcdsc.h"
#include "gvceps.h"

#define TRUE 1
#define FALSE 0

#ifndef min
#define min(x,y)  ( (x) < (y) ? (x) : (y) )
#endif
#ifndef max
#define max(x,y)  ( (x) > (y) ? (x) : (y) )
#endif

extern char oname[MAXSTR];
extern char szScratch[];
extern char szAppName[];

typedef struct tagPSFILE {
	BOOL	ignore_dsc;	/* true if DSC to be ignored */
	PSDOC	*doc;		/* DSC structure.  NULL if not DSC */
	int 	pagenum;	/* current page number */
	char 	name[MAXSTR];	/* name of selected document file */
	FILE 	*file;		/* selected file */
	int 	preview;	/* preview type IDS_EPSF, IDS_EPSI, etc. */
} PSFILE;

typedef struct tagOPTION {
	float	xdpi;
	float	ydpi;
} OPTION;

FILE * gp_open_scratch_file(const char *prefix, char *fname, const char *mode);
void gserror(UINT id, char *str, UINT icon, int sound);
char * _getcwd(char *dirname, int size);
void play_sound(int i);

/* temporary kludges */
extern PSDOC *doc;
extern PSFILE psfile;
extern OPTION option;
#define MB_ICONEXCLAMATION 1
#define SOUND_ERROR 1
#define IDM_EXTRACTPS  1
#define IDM_EXTRACTPRE 2
#define IDM_MAKEEPST   3
#define IDM_MAKEEPST4  4
#define IDS_TOPICEDIT 1
#define COPY_BUF_SIZE 4096

/* error messages */
#define IDS_NOPREVIEW 1
