/* Print address labels. The label carrier (by 'Zweckform') is     */
/* supposed to look like this:                                     */
/*                                                                 */
/*     ----------------------------------------------              */
/*     |                                             | top offfset */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               | 3 columns   */
/*     |              |              |               | 8 rows      */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     //             //             //              //            */
/*                                                                 */
/*                                                                 */
/*     //             //             //              //            */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |                                             | bottom      */
/*     ----------------------------------------------  margin      */

columns = 3     /* number of labels/line                           */
rows    = 8     /* number of lines                                 */
toffset = 5     /* top border    (must be at least 5 mm)           */
boffset = 5     /* bottom margin (must be at least 5-7 mm)         */
paperx  = 210   /* paper width  [mm]                               */
papery  = 298   /* paper height [mm]                               */

/* ----------------------------------------------------------------*/

options results
shell

address HISPEED.1

SET BOOK     OFF
SET HEADER   OFF          /* 5 mm still remain unusable :-(       */
SET DX 7                  /* i.e. left/right border = 3.5 mm      */
SET DY 10

'SET PAPERX' 210 + 7      /* add 7 mm for right border            */
'SET PAPERY' papery + 10  /* compensate for borders               */

SET SEPARATE OFF

SET LAYOUTX columns       /* two columns/label                    */
SET LAYOUTY rows

SET QUALITY LQ

SET TOP    toffset + 5
SET BOTTOM boffset
SET LEFT   7
SET RIGHT  7

/* consider position of DeskJet's middle platen (used as guide): */

QUERY BLOCKX  /* maximum entry length [characters] incl. CR */

blockx  = trunc(RESULT) - 1
labels  = columns * rows

say ""
say " This script does support printing on labels by Zweckform "
say " (70 * 50.8 mm, on a 3 x 5 carrier).                      "
say ""
say " Tell me the number of the 1st label you want to print or "
say " 0 to exit. The sheet's top left label is considered to be"
say " 1, its right neighbour 2, the last label is " || labels

pull first

if (first < 1) | (first > labels) then do

  say " Done (please close window)."
  exit

end

say " Enter file to scan (addresses separated by *):"
pull database

QUERY BLOCKY           /* how many lines can be printed on a label ? */
maxEntries = RESULT

/* remove 'waste' of last run (if any) */

shell
DELETE ">NIL:" "T:LABELTEXT"
address HISPEED.1

/* open 'label' file (will become output file) */

R = open('txt', "T:LABELTEXT", 'WRITE')

if (R = 0) then do
  SET WARN "Error - couldn't create temporary file"
  exit
end

/* open input file (database) */

R = Open('data', database, 'READ')

if (R = 0) then do
  SET WARN "Error - couldn't open read file"
  exit
end

/* 'jump' to first label */

if (first > 1) then do
  do piece = 0 to (first - 2)
    do n = 1 to maxEntries
        R = writeln('txt', "")
    end
  end
end

/* Read database */

piece     = first - 1  /* count used labels   */
terminate = 0

do while (terminate = 0)

  say " reading label N" (piece + 1) "..."

  if EOF('data') then

      terminate = 1

  else do

    entries = 0

    /* read % store next label (until *) */

    do while (entries < maxEntries)

        line = readln('data')

        if (line = "*") then

            break

        else do

            /* use bold printing for first line */

            if (entries = 0) then
                R = writeln('txt', '[1m' || line || '[22m')
            else
                R = writeln('txt', line)
        end

        entries = entries + 1

        /* empty line between name & rest of address */

        if (entries = 1) then do

            R = writeln('txt', '')
            entries = 2

        end

    end

    /* 'fill' empty lines of labels */

    do while (entries < maxEntries)

      entries = entries + 1
      R = writeln('txt', "")

    end

    piece = piece + 1

  end

end

R = close('txt')
R = Close('data')

CLR
SET FILE "T:LABELTEXT"

/* anything to print ? */

QUERY JOBS

if RESULT = 0 then

  SET WARN " Couldn't set files. Maybe empty ?!"

else do

  SET ASK " Proceed with printing (Y/N) ?"
  if RESULT = 1 then
      PRINT
end

say " Ready (please close window)."
