/* -----------------------------------------------------------------------------

  Example: scan handler looking for  AutoDoc  nodes.  Scan  handlers  are  plain
  functions  (LoadSeg'ed  by GED): no standard C startup code, no library calls.
  This handler is faster than GoldED's built in AutoDoc handler since it  simply
  looks  for formfeeds. Won't work with all AutoDocs though Commodore's AutoDocs
  are handled properly.

  DICE-C: dcc ADoc.c -// -l0 -md -mRR -o ram:ADoc

  ------------------------------------------------------------------------------
*/

#include <exec/types.h>

#define FORMFEED 12

ULONG
ScanHandlerGuide(__D0 ULONG len, __A0 char **text)
{
    // look for node header

    if (**text == FORMFEED) {

        // look for beginning of header string (e.g. "Dos.Library/Open")

        while (len && (**text <= ' ')) {

            ++*text;
            --len;
        }

        // ignore first part of header string

        while (len && (**text != '/')) {

            ++*text;
            len--;
        }

        // extract node name

        if (len) {

            UWORD letters;

            ++*text;
            --len;

            for (letters = 0; len && ((*text)[letters] != 32); --len)
                ++letters;

            return(letters);
        }
    }

    return(NULL);
}
