@echo off
REM ************************************************************************
REM *** PathStak.cmd - Utility to save or restore a path location using  ***
REM *** ver.1          environment variables to remember.  The paths are ***
REM ***                saved in the PATH_STACK environment variable.     ***
REM ***                Return ERRORLEVEL 0 for success and ERRORLEVEL 1  ***
REM ***                if there was a problem.  No error on restore or   ***
REM ***                forget if there is nothing saved.                 ***
REM ************************************************************************
CALL CEnviSet.cmd %0.cmd %1 %2
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( 2 != argc ) {
      Instructions();
      Success = False;
   } else {
      Success = True;
      command = argv[1], len = strlen(command);
      // determine how many paths are currently saved
      PathStackDepth = defined(PATH_STACK) ? (GetArraySpan(PATH_STACK) + 1) : 0 ;
      if ( !strnicmp("PUSH",command,len) ) {
         PATH_STACK[PathStackDepth] = FullPath(".") // current directory
      } else if ( !strnicmp("POP",command,len) ) {
         if ( 0 != PathStackDepth ) {
            OldPath = PATH_STACK[PathStackDepth-1];
            // set PATHSTAK_SET_PATH to be the new environment to change to
            sprintf(PATHSTAK_SET_PATH,"cd %s",OldPath)
            // set PATHSTAK_SET_DRIVE to be the new drive letter
            strcpy(PATHSTAK_SET_DRIVE,OldPath)
            PATHSTAK_SET_DRIVE[2] = 0; // cut down to drive:
            // remove this final element from the PATH_STACK array
            if ( 1 == PathStackDepth ) {
               undefine(PATH_STACK);
            } else {
               SetArraySpan(PATH_STACK,PathStackDepth - 2);
            }
         }
      } else if ( !strnicmp("FORGET",command,len) ) {
         undefine(PATH_STACK);
      } else {
         Instructions();
         Success = False;
      }
   }
   return( Success ? 0 : 1 );
}

Instructions()
{
   printf("\a\n")
   printf("PathStak.cmd - Save or restore directory paths.\n")
   printf("\n")
   printf("SYNTAX: PathStak PUSH | POP | FORGET\n")
   printf("\n")
   printf("Where:  PUSH    Save the current directory as most recent.\n")
   printf("        POP     Return to the most recently saved directory.\n")
   printf("        FORGET  Forget all saved directories.\n")
   printf("\n")
}


:CENVI_EXIT
REM ****************************************************************************
REM *** The previous code set PATHSTAK_SET_DRIVE to the new drive letter and ***
REM *** PATHSTAK_SET_PATH to the new path, and so set those variables and    ***
REM *** then remove the environment variables.                               ***
REM ****************************************************************************
%PATHSTAK_SET_PATH%
set PATHSTAK_SET_PATH=
%PATHSTAK_SET_DRIVE%
set PATHSTAK_SET_DRIVE=
