EXTPROC CEnvi
/**********************************************************************
 *** Parents.cmd - Display the current process id and name, and the ***
 *** ver.1         tree of all ancestors of the current proc.       ***
 **********************************************************************/

#include <DosCalls.lib>

// Build List of all running processes
ProcessCount = BuildProcessList(PList);
// starting with the current ID, show the process ID's of this and all parents
ShowProcessInfo(GetMyID(),PList,ProcessCount,"Current Process ID");


ShowProcessInfo(id,list,count,Text) // show this process information, and then call
{                                   // recursively for parent
   // find entry for this process ID
   for ( i = 0; i < count; i++ ) {
      if ( id == list[i].id ) {
         // found this ID, so print it
         printf("%s = %d, name = %s\n",Text,id,list[i].name);
         // now try this function recursively on the parent ID
         ShowProcessInfo(list[i].parent,list,count,"Parent Process ID");
         break;
      }
   }
}

GetMyID()   // get current process ID. Current ID is first UWORD32 in Process Info Block
{
   DosGetInfoBlocks(tid,pid);
   return( peek(pid,UWORD32) );
}

BuildProcessList(list) // build list of processes in list, and return number of processes running
{
   list = ProcessList();
   assert( NULL != list );
   return( 1 + GetArraySpan(list) );
}

