EXTPROC CEnvi
/**************************************************************************
 *** DoMenu.cmd - Quick interface to pass menu commands directly.       ***
 *** ver.1        This posts menu command directly to any frame window. ***
 **************************************************************************/

#include <MenuCtrl.lib>
#include <WinTools.lib>

main(argc,argv)
{
   if ( (2 != argc && 3 != argc)  ||  !strcmp(argv[1],"/?")  ||  !strcmpi(argv[1],"help") )
      Instructions();

   if ( 2 == argc ) {
      hwnd = GetActiveWindow();
      MenuString = argv[1];
   } else {
      if ( !(hwnd = GetWindowHandle(WindowTitle = argv[1])) ) {
         printf("\aCould not find window \"%s\"\n",WindowTitle);
         exit(EXIT_FAILURE);
      }
      MenuString = argv[2];
   }
   // try regular menu first, then system menu, then anything else
   if ( !MenuCommand(hwnd,FID_MENU,MenuString,True)
     && !MenuCommand(hwnd,FID_SYSMENU,MenuString,True)
     && !MenuCommand(hwnd,0,MenuString,True) ) {
      printf("\aSelection \"%s\" not found in any menu.\n",MenuString);
      exit(EXIT_FAILURE);
   }
   return EXIT_SUCCESS;
}


Instructions()
{
   printf("\a\n")
   printf("DoMenu - Post menu selection to a PM window\n")
   printf("\n")
   printf("SYNTAX: DoMenu <WinTitle> MenuString\n")
   printf("\n")
   printf("Where: WinTitle - Name of a window; if this parameter not supplied then\n")
   printf("                  use currently active window\n")
   printf("       MenuString - Ascii text of menu string to select from any menu.\n")
   printf("                    Will select first match for length of MenuString,\n")
   printf("                    case-insensitive\n")
   printf("\n");
   printf("Example: If the calculator is running, this would set font to 18 x 10\n")
   printf("            DoMenu Calculator \"18 x 10\"\n")
   printf("\n")
   printf("Example: If an \"OS/2 Window\" session is active, to choose \"Copy All\"\n")
   printf("            DoMenu \"Copy All\"\n")
   printf("\n")
   exit(EXIT_FAILURE);
}

