EXTPROC CEnvi
//************************************************************************
//*** ExamineW.cmm - CEnvi utility to examine properties of the active ***
//*** ver.1          window. This provides information to use with     ***
//***                other window menu, dialog, and message calls.     ***
//************************************************************************

#define CHECK_INTERVAL  2000  // approx. milliseconds between check for ctrl-shift

#include <WinTools.lib>
#include <GiveMem.lib>
//#include <Window.lib>
//#include <MenuCtrl.lib>


#define HWND_DESKTOP    1

printf("ExamineW - Examine properties of the active window.  At any time\n"
       "           press and hold Ctrl-Shift to bring up this window to\n"
       "           describe great detail about the state of the currently\n"
       "           active window.\n");

// many routines here require that the PM process making these calls also
// have access to the shared memory
GiveMemoryToProcess(PMInfo().Process);


printf("\n***************************************************************************");
printf("\nWaiting for Ctrl-Shift...");
WaitForKeysHeld();
printf("\a\r                                                    \r");

DescribeCurrentWindow();

WaitForKeysHeld() // wait for keys to be held
{
   #define VK_SHIFT     0x09
   #define VK_CTRL      0x0A
   // first wait for keys to not all be down before continuing
   while ( KeyPressed(VK_SHIFT)  &&  KeyPressed(VK_CTRL) ) ;
 
   do {
      suspend( CHECK_INTERVAL );
   } while ( !KeyPressed(VK_SHIFT)  ||  !KeyPressed(VK_CTRL) );
}


DescribeCurrentWindow()
{
   // show title and handle for active window
   if ( !(ActiveHwnd = GetActiveWindow()) ) {
      printf("Active window handle unknown.\n");
      return;
   }
   if ( !(ActiveTitle = GetWindowTitle(ActiveHwnd)) ) ActiveTitle = "<Unknown>";
   printf("Active window \"%s\", handle = %08X\n",ActiveTitle,ActiveHwnd);

   // show title and handle for focus window
   if ( !(FocusHwnd = GetFocusChild(ActiveHwnd)) ) {
      printf("No focus window\n");
   } else {
      printf("Focus window");
      if ( FocusTitle = GetWindowText(FocusHwnd) )
         printf(" \"%s\"",FocusTitle);
      printf(" handle = %04X\n",FocusHwnd);
   }

   ShowWindowDetails(ActiveHwnd,0);
}

ShowWindowDetails(hwnd,Level)
{
   printf("%04X",hwnd);
   if ( Title = GetWindowText(hwnd) )
      printf(" \"%s\"", Title);
   printf("\n");

   in = Level + 1;

   #define QWS_ID (-1)
   inprintf(in,"ID: ");
   ShowWindowID(WinQueryWindowUShort(hwnd,QWS_ID));

   GetWindowRect(hwnd,lRect);
   inprintf(in,"Coordinates: (L,B,R,T) %d, %d, %d, %d\n",
            lRect.left,lRect.bottom,lRect.right,lRect.top);

   #define QWL_STYLE (-2)
   ShowStyle(in,lStyle = WinQueryWindowULong(hwnd,GWL_STYLE));

   //inprintf(in,"ExtendedStyle: %08X\n",GetWindowLong(hwnd,GWL_EXSTYLE));

   ShowClass(in,hwnd);

   //if ( (lStyle & WS_SYSMENU)  &&  0 != (lMenu = GetSystemMenu(hwnd)) ) {
   //   inprintf(in,"SYSTEM MENU:\n");
   //   ShowMenu(in,lMenu);
   //}

   //if ( !(lStyle & WS_CHILD)  &&  0 != (lMenu = GetMenu(hwnd)) )
   //   ShowMenu(in,lMenu);

   // Do this same routine for each child window of this window
   lEnum = WinBeginEnumWindows(hwnd);
   while ( lChild = WinGetNextWindow(lEnum) ) {
      printf("\n");
      inprintf(Level,"  ");
      ShowWindowDetails(lChild,in);
   }
   WinEndEnumWindows(lEnum);
}

ShowWindowID(pID)
{
   #define FID_SYSMENU     0x8002
   #define FID_TITLEBAR    0x8003
   #define FID_MINMAX      0x8004
   #define FID_MENU        0x8005
   #define FID_VERTSCROLL  0x8006
   #define FID_HORZSCROLL  0x8007
   #define FID_CLIENT      0x8008
   #define FID_DBE_APPSTAT 0x8010
   #define FID_DBE_KBDSTAT 0x8011
   #define FID_DBE_PECIC   0x8012
   #define FID_DBE_KKPOPUP 0x8013
   switch ( pID ) {
      case FID_SYSMENU:       lID = "FID_SYSMENU";       break;
      case FID_TITLEBAR:      lID = "FID_TITLEBAR";      break;
      case FID_MINMAX:        lID = "FID_MINMAX";        break;
      case FID_MENU:          lID = "FID_MENU";          break;
      case FID_VERTSCROLL:    lID = "FID_VERTSCROLL";    break;
      case FID_HORZSCROLL:    lID = "FID_HORZSCROLL";    break;
      case FID_CLIENT:        lID = "FID_CLIENT";        break;
      case FID_DBE_APPSTAT:   lID = "FID_DBE_APPSTAT";   break;
      case FID_DBE_KBDSTAT:   lID = "FID_DBE_KBDSTAT";   break;
      case FID_DBE_PECIC:     lID = "FID_DBE_PECIC";     break;
      case FID_DBE_KKPOPUP:   lID = "FID_DBE_KKPOPUP";   break;
      default:
         printf("%04X\n",pID);
         return;
   }
   printf("%s\n",lID);
}

ShowStyle(in,pStyle)
{
   #define FS_ICON            0x00000001
   #define FS_ACCELTABLE      0x00000002
   #define FS_SHELLPOSITION   0x00000004
   #define FS_TASKLIST        0x00000008
   #define FS_NOBYTEALIGN     0x00000010
   #define FS_NOMOVEWITHOWNER 0x00000020
   #define FS_SYSMODAL        0x00000040
   #define FS_DLGBORDER       0x00000080
   #define FS_BORDER          0x00000100
   #define FS_SCREENALIGN     0x00000200
   #define FS_MOUSEALIGN      0x00000400
   #define FS_SIZEBORDER      0x00000800
   #define FS_AUTOICON        0x00001000
   #define FS_DBE_APPSTAT     0x00008000

   #define WS_GROUP           0x00010000
   #define WS_TABSTOP         0x00020000
   #define WS_MULTISELECT     0x00040000
   #define WS_ANIMATE         0x00400000
   #define WS_MAXIMIZED       0x00800000
   #define WS_MINIMIZED       0x01000000
   #define WS_SYNCPAINT       0x02000000
   #define WS_SAVEBITS        0x04000000
   #define WS_PARENTCLIP      0x08000000
   #define WS_CLIPSIBLINGS    0x10000000
   #define WS_CLIPCHILDREN    0x20000000
   #define WS_DISABLED        0x40000000
   #define WS_VISIBLE         0x80000000
   #define WS_UNUSED_BITS     0x00386000

   // show style, and decipher it
   inprintf(in,"Style: %08X\n",pStyle);
   lStr[0] = '\0';
   if ( pStyle & WS_VISIBLE )       strcat(lStr,"VISIBLE|");
   if ( pStyle & WS_DISABLED )      strcat(lStr,"DISABLED|");
   if ( pStyle & WS_CLIPCHILDREN )  strcat(lStr,"CLIPCHILDREN|");
   if ( pStyle & WS_CLIPSIBLINGS )  strcat(lStr,"CLIPSIBLINGS|");
   if ( pStyle & WS_PARENTCLIP )    strcat(lStr,"PARENTCLIP|");
   if ( pStyle & WS_SAVEBITS )      strcat(lStr,"SAVEBITS|");
   if ( pStyle & WS_SYNCPAINT )     strcat(lStr,"SYNCPAINT|");
   if ( pStyle & WS_MINIMIZED )     strcat(lStr,"MINIMIZED|");
   if ( lStr[0] )
      inprintf(in,"       %s\n",lStr);
   lStr[0] = '\0';
   if ( pStyle & WS_MAXIMIZED )     strcat(lStr,"MAXIMIZED|");
   if ( pStyle & WS_ANIMATE )       strcat(lStr,"MAXIMIZED|");
   if ( pStyle & WS_MULTISELECT )   strcat(lStr,"MULTISELECT|");
   if ( pStyle & WS_TABSTOP )       strcat(lStr,"TABSTOP|");
   if ( pStyle & WS_GROUP )         strcat(lStr,"GROUP|");
   if ( pStyle & FS_DBE_APPSTAT )   strcat(lStr,"DBE_APPSTAT|");
   if ( pStyle & FS_AUTOICON )      strcat(lStr,"AUTOICON|");
   if ( pStyle & FS_SIZEBORDER )    strcat(lStr,"SIZEBORDER|");
   if ( lStr[0] )
      inprintf(in,"       %s\n",lStr);
   lStr[0] = '\0';
   if ( pStyle & FS_MOUSEALIGN )    strcat(lStr,"MOUSEALIGN|");
   if ( pStyle & FS_SCREENALIGN )   strcat(lStr,"SCREENALIGN|");
   if ( pStyle & FS_BORDER )        strcat(lStr,"BORDER|");
   if ( pStyle & FS_DLGBORDER )     strcat(lStr,"DLGBORDER|");
   if ( pStyle & FS_SYSMODAL )      strcat(lStr,"SYSMODAL|");
   if ( pStyle & FS_NOMOVEWITHOWNER)strcat(lStr,"NOMOVEWITHOWNER|");
   if ( pStyle & FS_NOBYTEALIGN )   strcat(lStr,"NOBYTEALIGN|");
   if ( pStyle & FS_TASKLIST )      strcat(lStr,"TASKLIST|");
   if ( lStr[0] )
      inprintf(in,"       %s\n",lStr);
   lStr[0] = '\0';
   if ( pStyle & FS_SHELLPOSITION ) strcat(lStr,"SHELLPOSITION|");
   if ( pStyle & FS_ACCELTABLE )    strcat(lStr,"ACCELTABLE|");
   if ( pStyle & FS_ICON )          strcat(lStr,"ICON|");
   inprintf(in,"       %s0x%08X\n",lStr,pStyle & WS_UNUSED_BITS);
}

ShowMenu(in,pMenu)
{
   if ( -1 == (lCount = GetMenuItemCount(pMenu)) )
      return;
   inprintf(in,"MENU\n");
   for ( lOrd = 0; lOrd < lCount; lOrd++ ) {
      lMenuString = GetMenuString(pMenu,lOrd,MF_BYPOSITION);
      lMenuID = GetMenuItemID(pMenu,lOrd);
      inprintf(in,"%3d ID: %04X  TEXT: \"%s\"  ",lOrd,lMenuID,lMenuString);
      lState = GetMenuState(pMenu,lOrd,MF_BYPOSITION);
      if ( lState & MF_BITMAP )        printf("|BITMAP");
      if ( lState & MF_CHECKED )       printf("|CHECKED");
      if ( lState & MF_DISABLED )      printf("|DISABLED");
      if ( lState & MF_GRAYED )        printf("|GRAYED");
      if ( lState & MF_POPUP )         printf("|POPUP");
      if ( lState & MF_MENUBREAK )     printf("|MENUBREAK");
      if ( lState & MF_MENUBARBREAK )  printf("|MENUBARBREAK");
      if ( lState & MF_HILITE )        printf("|HILITE");
      if ( lState & MF_SEPARATOR )     printf("|SEPARATOR");
      printf("\n");
      if ( -1 == lMenuID ) {
         // This is a Submenu, so show the submenu
         if ( (lSubMenu = GetSubMenu(pMenu,lOrd)) )
            ShowMenu(in+1,lSubMenu);
      }
   }
}

ShowClass(in,pHwnd)
{
   #define WC_FRAME        0xFFFF0001
   #define WC_COMBOBOX     0xFFFF0002
   #define WC_BUTTON       0xFFFF0003
   #define WC_MENU         0xFFFF0004
   #define WC_STATIC       0xFFFF0005
   #define WC_ENTRYFIELD   0xFFFF0006
   #define WC_LISTBOX      0xFFFF0007
   #define WC_SCROLLBAR    0xFFFF0008
   #define WC_TITLEBAR     0xFFFF0009
   #define WC_MLE          0xFFFF000A
   #define WC_APPSTAT      0xFFFF0010
   #define WC_KBDSTAT      0xFFFF0011
   #define WC_PECIC        0xFFFF0012
   #define WC_DBE_KKPOPUP  0xFFFF0013
   #define WC_SPINBUTTON   0xFFFF0020
   #define WC_CONTAINER    0xFFFF0025
   #define WC_SLIDER       0xFFFF0026
   #define WC_VALUESET     0xFFFF0027
   #define WC_NOTEBOOK     0xFFFF0028
   lClassName = GetClassName(pHwnd);
   sprintf(lClassName,"\"%s\"",lClassName);
   if ( '#' == lClassName[1] ) {
      switch ( atoi(lClassName + 2) | 0xFFFF0000 ) {
         case WC_FRAME:       lClassName = "WC_FRAME";         break;
         case WC_COMBOBOX:    lClassName = "WC_COMBOBOX";      break;
         case WC_BUTTON:      lClassName = "WC_BUTTON";        break;
         case WC_MENU:        lClassName = "WC_MENU";          break;
         case WC_STATIC:      lClassName = "WC_STATIC";        break;
         case WC_ENTRYFIELD:  lClassName = "WC_ENTRYFIELD";    break;
         case WC_LISTBOX:     lClassName = "WC_LISTBOX";       break;
         case WC_SCROLLBAR:   lClassName = "WC_SCROLLBAR";     break;
         case WC_TITLEBAR:    lClassName = "WC_TITLEBAR";      break;
         case WC_MLE:         lClassName = "WC_MLE";           break;
         case WC_APPSTAT:     lClassName = "WC_APPSTAT";       break;
         case WC_KBDSTAT:     lClassName = "WC_KBDSTAT";       break;
         case WC_PECIC:       lClassName = "WC_PECIC";         break;
         case WC_DBE_KKPOPUP: lClassName = "WC_DBE_KKPOPUP";   break;
         case WC_SPINBUTTON:  lClassName = "WC_SPINBUTTON";    break;
         case WC_CONTAINER:   lClassName = "WC_CONTAINER";     break;
         case WC_SLIDER:      lClassName = "WC_SLIDER";        break;
         case WC_VALUESET:    lClassName = "WC_VALUESET";      break;
         case WC_NOTEBOOK:    lClassName = "WC_NOTEBOOK";      break;
      }
   }
   inprintf(in,"CLASS: %s\n",lClassName);
   //if ( !stricmp(lClassName,"Button") ) ShowButtonClass(in+1,pHwnd);
   //if ( !stricmp(lClassName,"ComboBox") ) ShowComboBoxClass(in+1,pHwnd);
   //if ( !stricmp(lClassName,"ListBox") ) ShowListBoxClass(in+1,pHwnd);
}

ShowButtonClass(in,pHwnd)
{
   inprintf(in,"%s, ",SendMessage(pHwnd,BM_GETCHECK,0,0) ? "CHECKED" : "UNCHECKED" );
   printf("%s\n",SendMessage(pHwnd,BM_GETSTATE,0,0) ? "HILITED" : "PLAIN" );
}

ShowComboBoxClass(in,pHwnd)
{
   inprintf(in,"Count: %d",SendMessage(pHwnd,CB_GETCOUNT,0,0));
   lCurSel = SendMessage(pHwnd,CB_GETCURSEL,0,0);
   if ( CB_ERR == lCurSel )
      printf(", None selected");
   else {
      printf(", selected: %d",lCurSel);
      lTextLen = SendMessage(pHwnd,CB_GETLBTEXTLEN,lCurSel,0);
      lText[lTextLen+10] = '\0';
      SendMessage(pHwnd,CB_GETLBTEXT,lCurSel,lText);
      lText[lTextLen] = 0;
      printf(", Text: \"%s\"",lText);
   }
   printf("\n");
}

ShowListBoxClass(in,pHwnd)
{
   lStyle = GetWindowLong(pHwnd,GWL_STYLE);
   inprintf(in,"Count: %d",SendMessage(pHwnd,LB_GETCOUNT,0,0));
   // determine if this is a multiple selection listbox
   if ( LBS_MULTIPLESEL & lStyle ) {
      // multiple selections
      lCount = SendMessage(pHwnd,LB_GETSELCOUNT,0,0);
      printf(", %d selected",lCount);
   } else {
      lCurSel = SendMessage(pHwnd,LB_GETCURSEL,0,0);
      if ( LB_ERR == lCurSel )
         printf(", None selected");
      else {
         printf(", selected: %d",lCurSel);
         lTextLen = SendMessage(pHwnd,LB_GETTEXTLEN,lCurSel,0);
         lText[lTextLen+10] = '\0';
         SendMessage(pHwnd,LB_GETTEXT,lCurSel,lText);
         lText[lTextLen] = 0;
         printf(", Text: \"%s\"",lText);
      }
   }
   printf("\n");
}

/************ Useful functions ********/
KeyPressed(pKey)  // return boolen TRUE if keypressed now, else FALSE
{
   #define ORD_WIN32SETKEYBOARDSTATETABLE   921
   _table[255] = '\0';   // initialize 256-byte key table
   DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
               HWND_DESKTOP,_table,FALSE);
   return( 0x80 & _table[pKey] );
}

inprintf(IndentLevel,FormatString/*,arg,arg,arg*/)
{  // like printf, but indent IndentLevel characers
   for ( lIn = 0; lIn < IndentLevel; lIn++ )
      printf("  ");
   va_start(va_list,FormatString);
   vprintf(FormatString,va_list);
   va_end(va_list);
}

GetClassName(pHwnd)
{
   #define ORD_WIN32QUERYCLASSNAME  805
   lString[1000] = '\0';
   lString[DynamicLink("PMWIN",ORD_WIN32QUERYCLASSNAME,BIT32,CDECL,pHwnd,999,lString)] = 0;
   strcpy(lRet,lString);
   return lRet;
}

GetWindowText(pHwnd) // NULL if none
{
   lSharedMem = GiveMemoryToWindow(pHwnd);
   #define ORD_WIN32QUERYWINDOWTEXT 841
   if ( lTextLen = PMDynamicLink("PMWIN",ORD_WIN32QUERYWINDOWTEXT,BIT32,CDECL,pHwnd,1000,lSharedMem) ) {
      lString = peek(lSharedMem,lTextLen);
      lString[lTextLen] = '\0';
   } else
      lString = NULL;
   return lString;
}

WinQueryWindowULong(pHwnd,pIndex)
{
   #define ORD_WIN32QUERYWINDOWULONG   843
   return PMDynamicLink("PMWIN",ORD_WIN32QUERYWINDOWULONG,BIT32,CDECL,pHwnd,pIndex);
}


WinQueryWindowUShort(pHwnd,pIndex)
{
   #define ORD_WIN32QUERYWINDOWUSHORT  844
   return 0xFFFF & PMDynamicLink("PMWIN",ORD_WIN32QUERYWINDOWUSHORT,BIT32,CDECL,pHwnd,pIndex);
}

