EXTPROC CEnvi
/**********************************************************************
 *** IsDay_1.cmd - Display message about whether it is The WeekDay  ***
 *** ver.1         requested, and set ErrorLevel to 1 if it is else ***
 ***               0 if it is not                                   ***
 **********************************************************************/

main(argc,argv)
{
   IsDay = 0                           // Assume that it is not the correct day
   if ( argc != 2  ||  strlen(argv[1]) < 3 ) {
      // Invalid parameters were passed, and so explain how to use this program
      ShowHelp()
   } else {
      TimeString = ctime(time())       // Standard C functions to get NOW as a string
      strcpy(QueryDay,argv[1])         // copy first argument to work with it
      QueryDay[3] = 0                  // limit to search on first three letters
      // case-inensitive (i.e., both string converted to upper-case) search for
      // QueryDay in TimeString
      if strstr(strupr(TimeString),strupr(QueryDay)) {
         printf("Yes, today is %s\n",argv[1])
         IsDay = 1
      } else
         printf("No, today is not %s\n",argv[1])
   }
   return IsDay
}

ShowHelp() // This routine is called above if input seems invalid
{
   printf("\n\a")      // This makes an audible beep
   printf("IsDay.cmd - CMM program to check if it is a certain day of the week.\n")
   printf("            Will print messages if it is or isn't, and return with\n")
   printf("            ERRORLEVEL 1 if it is the requested day, and 0 if it is not.\n")
   printf("            You must supply at least the first three letters of the day.\n")
   printf("Example:\n")
   printf("\tISDAY <Friday | Fri | FRI | FRICASSE>\n\n");
}

