/*-------------------------------------------------------------------------*/
/* Program:    DVClock .C                                                  */
/* Purpose:    A no-frills digital clock for DESQview.                     */
/* Notes:      Compiles under Borland C++ v3.1. Requires DV.               */
/* Status:     Source released into the public domain. If you find this    */
/*                program useful, I'd appreciate something tangible, like  */
/*                a postcard, from you.                                    */
/* Updates:    19-Dec-92, GAT, v1.0-alpha                                  */
/*                - stole code from TifaWARE DVAlarm.                      */
/*             21-Mar-93, GAT, v1.0-beta                                   */
/*                - spruced up code a tad.                                 */
/*                - checked CPU type so as to support 386-specific code    */
/*                   in DV386.Lib.                                         */
/*             19-May-93, GAT, v1.1a                                       */
/*                - removed dependency on DV v2.2+ since the version       */
/*                   seems irrelevant.                                     */
/*                - allowed user to configure how often time display is    */
/*                   updated (and how much CPU overhead there is :-).      */
/*                - improved error messages.                               */
/*             05-Jul-93, GAT, v1.1b                                       */
/*                - compiled with BCC 3.1.                                 */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Author:     George A. Theall                                            */
/* SnailMail:  TifaWARE                                                    */
/*             610 South 48th St                                           */
/*             Philadelphia, PA.  19143                                    */
/*             U.S.A.                                                      */
/* E-Mail:     george@tifaware.com                                         */
/*             theall@popmail.tju.edu                                      */
/*             theall@mcneil.sas.upenn.edu                                 */
/*             george.theall@satalink.com                                  */
/*-------------------------------------------------------------------------*/

#define FALSE        0
#define TRUE         !FALSE
#ifndef CLR_SCREEN                           /* colour of main screen */
#define CLR_SCREEN   0x71                    /*   blue letters, white bg */
#endif
#ifndef CLR_SELECT                           /* colour of select fields */
#define CLR_SELECT   0x17                    /*   white letters, blue bg */
#endif
#define FTE_SIZE     8                       /* size of a field table entry */

#include <dos.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "dvlib.h"                           /* TifaWARE routines for DV */
#include "tifa.h"                            /* TifaWARE libs -- getopt() */

#define errmsg(s)    display_err_win(my_win(), s, strlen(s), 0, 0, 0, 0)

/* Global variables */
int MaxFieldSize,                            /* max size of date/time field */
   TickFreq = 60;                            /* default secs / clock update */
char *DateFmt = "%m/%d/%y",                  /* default format for date */
   *TimeFmt = "%I:%M %p";                    /*    and time             */
HANDLE MainWin;                              /* Main window object */

extern unsigned _stklen = 1024U;             /* reduce size of stack */
void _setenvp(void) {};                      /* drop some start-up code */


/*---  main  --------------------------------------------------------------+
|  Purpose:    Main body of program.                                       |
|  Notes:      Provided DESQview v2.2+ is running, the program will loop   |
|                 endlessly here. Use the DV Close-Window command to shut  |
|                 it down if that's desired. There is no harm, though, in  |
|                 simply quitting out of DV while DVClock is active.       |
|  Entry:      argc = argument count,                                      |
|              argv = array of argument variables.                         |
|  Exit:       Return code = 1 if DV is not running, 2 if not running on   |
|                 a 386+ (386-specific version), or 9 if help given.       |
+-------------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
   char ch,
      buf[12];                               /* room for "hh:mm:ss pm" */
   int i, j;
   time_t secs;
   struct tm *now;

   void init_Display(void);
   void pause(ULONG secths);


   /*
    * Abort if we're not running under DESQview. The version 
    * of DOS in use is not important.
    */
   if (0 == isdv())
   {
      fputs("sorry, gotta have DV", stderr);
      return 1;
   }
#ifdef i386
   if (id_cpu() < 386)
   {
      errmsg("this version needs a 386+");
      return 2;
   }
#endif

   /*
    * Process program options.
    *
    * NB: DVClock may be running in a window that closes on exit. Using
    * errmsg() ensures the error message will be seen if it's generated.
    */
   while ((ch = getopt(argc, argv, "d:s:t:")) != EOF)
      switch (ch)
      {
         case 'd':                           /* user-defined date format */
            DateFmt = strdup(optarg);
            break;
         case 's':                           /* pause specified # secs */
            if (strspn(optarg, "0123456789") != strlen(optarg)) {
               errmsg("bad value");
               exit(9);
            }
            else
               TickFreq = atoi(optarg);
            break;
         case 't':                           /* user-defined time format */
            TimeFmt = strdup(optarg);
            break;
         case '?':                           /* help needed or requested */
            errmsg("invalid syntax");
            exit(9);
            /*** UNREACHED ***/
            break;
         default: /*** EMPTY ***/ ;
      }

   /*
    * Determine maximum field size based on supplied formats.
    * Note the actual time used is irrelevant.
    */
   secs = time(NULL);
   now = localtime(&secs);
   i = strftime(buf, sizeof(buf), DateFmt, now);
   j = strftime(buf, sizeof(buf), TimeFmt, now);
   MaxFieldSize = max(i,j);

   /* Identify important objects and initialize display. */
   MainWin = my_win();
   init_Display();

   /*
    * NB: Unless the time zone is set properly, the values returned
    * are likely become inaccurate around biannual time changes.
    */
   tzset();

   /*
    * THIS LOOP NEVER EXITS!
    */
   while (TRUE)
   {
      secs = time(NULL);
      now = localtime(&secs);

      i = strftime(buf, sizeof(buf), DateFmt, now);
      write_fld(MainWin, 1, buf, i);
      j = strftime(buf, sizeof(buf), TimeFmt, now);
      write_fld(MainWin, 2, buf, j);

      pause(100UL*TickFreq);
   }
}


/*---  init_Display  ------------------------------------------------------+
|  Purpose:    Initializes screen display.                                 |
|  Notes:      If NDEBUG is undefined, a second window is opened for       |
|                 debugging messages.                                      |
|              The field table must be a static structure. DV uses it      |
|                 internally.                                              |
|              If the screen display is unexplicably screwed-up, make      |
|                 sure the max height/width in the DVP file agrees with    |
|                 that specified below as part of slayout.                 |
|  Entry:      n/a                                                         |
|  Exit:       n/a                                                         |
+-------------------------------------------------------------------------*/
void init_Display(void)
{
   static BYTE flayout[4+2+1+6+(FTE_SIZE*2)] =
      {MAGIC, S_WINDOW, 0, 0,
         0xe5, 0x18,                         /* select 2-letter menus */
                                             /*   means FTE_SIZE == 8 */
         0xff,                               /* field table header */
            2,                               /*   number of fields */
            FTH_READMOD | FTH_KBDSELECT      /*   screen behaviour bits */
               | FTH_AUTORESET,
            0, 0,                            /*   used by DV */
            CLR_SELECT,                      /*   attr when pointed to */
            CLR_SELECT,                      /*   attr when selected */
         0, 9, 0, 19, FTE_OUTPUT, 0, 0, 0,   /* field 1 -- current date */
         1, 9, 1, 19, FTE_OUTPUT, 0, 0, 0    /* field 2 -- current time */
      };
   BYTE slayout[] = {MAGIC, S_WINDOW, 0, 0,
         0xc3, 2, 21,                        /* set window size */
         0xd5,                               /* hide window */
         0xd1,                               /* always have complete frame */
         0xe2, CLR_SCREEN,                   /* set current output colour */
         0xe3,                               /* clear screen using colour */
         0xc0, 0, 1,                         /* set logical cursor position */
         0x67, 'D','a','t','e',':',' ','',  /* display next 7 chasr */
         0xc0, 1, 1,                         /* set logical cursor position */
         0x67, 'T','i','m','e',':',' ',''   /* display next 7 chars */
      };


   /* Turn off hardware cursor. */
   reset_bits_kbd(my_kbd(), 2);

   /* Configure screen. */
   * (int *) &slayout[2] = sizeof(slayout) - 4;
   write_win(MainWin, slayout, sizeof(slayout));   /* screen layout */
   * (int *) &flayout[2] = sizeof(flayout) - 4;
   write_win(MainWin, flayout, sizeof(flayout));   /* field layout */

   /* Dynamically shrink window if formats allow this. */
   if (MaxFieldSize < (get_cols_win(MainWin)-10))
      resize_win(MainWin, 0, -3);

   /* Finally, make window visible. */
   unhide_win(MainWin);
   redraw_win(MainWin);
}


/*---  pause  -------------------------------------------------------------+
|  Purpose:    Pauses execution for a specified amount of time.            |
|  Notes:      Uses DESQview so as not to churn thru CPU time.             |
|              No sanity checks are done on secths.                        |
|  Entry:      secths = number of 1/100ths seconds to pause.               |
|  Exit:       n/a                                                         |
+-------------------------------------------------------------------------*/
void pause(ULONG secths)
{
   HANDLE timer;

   timer = create_tim();
   addto_tim(timer, secths);
   read_tim(timer);                          /* execution pauses here */
   free_tim(timer);
}
