/******************************************************************************
* Module    :   Post header file.
*
* Author    :   John W. M. Stevens
******************************************************************************/

/*  Global constants.   */
#define TRUE    1
#define ERROR   1
#define MATCH   1
#define FALSE   0
#define OK      0

#define MAX_PATH            256
#define BFR_SZ              256
#define BYTES_PER_LINE      45
#define LINES_PER_PART      950

typedef unsigned char   BYTE;
typedef unsigned long   CRC_TYPE;

/*  Header type for macro replacement.  */
typedef struct  {
    char    MacroTag;
    char    Bfr[BFR_SZ];
} HDR_TYPE;

/*  Post type.  */
typedef struct  {
    char        FlName[BFR_SZ];     /*  Binary file name.               */
    char        PictType[BFR_SZ];   /*  Picture type.                   */
    int         RepostFlag;         /*  Is this a repost, or not?       */
    int         CalcCRC;            /*  CRC calculation flag.           */
} BIN_DATA;

/*  Define binary file type enumerations.   */
typedef enum
{
    UNKNOWN_TYPE,
    GIF87A,
    GIF89A,
    JFIF_JPEG,
    HSI1_JPEG
} BIN_TYPES;

#if	defined(SYSTEM_MS_DOS)

#define BIN_READ    "rb"
#define TXT_READ    "rt"
#define TXT_WRITE   "wt"

#else

extern	char		*sys_errlist[];

#define	strerror(x)	sys_errlist[x]

#define BIN_READ    "r"
#define TXT_READ    "r"
#define TXT_WRITE   "w"

#endif

/*  Function prototypes.    */
extern
void    Split(FILE      *HdrFl,
              FILE      *DescFl,
              BIN_DATA  *BinData,
              char      *CmdBfr);
extern
void    StripExt(char   *FlName,
                 char   *OutFlNm);
extern
void    BaseName(char   *FlName,
                 char   *BaseName);
extern
int     ModifyFlNm(char         *FlName,
                   BIN_TYPES    FileType,
                   char         *Exten,
                   char         *OutName);
extern
void    Encode(FILE     *BinFlPtr,
               FILE     *PartFlPtr,
               long     Lines);
extern
BIN_TYPES   IdBinFile(FILE  *FlPtr,
                      char  *ext);
extern
CRC_TYPE
CalcCRC(FILE    *BinFlPtr);
