/******************************************************************************
* Module    :   UU Encode --- Encode and write part of a binary to the output
*               file.
*
* Author    :   John W. M. Stevens
******************************************************************************/

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>

#include    "post.h"

#define     MASK    0x3f
#define     ENC(b)  (((b) == 0) ? '`' : (b) + ' ')

/*-----------------------------------------------------------------------------
| Routine   :   EncLine() --- Encode a complete line.
|
| Inputs    :   NoBytes - Number of bytes in input buffer.
|               InBfr   - Input buffer.
| OutPuts   :   OutPtr  - Output buffer pointer.
-----------------------------------------------------------------------------*/

static
void    EncLine(int     NoBytes,
                BYTE    *InBfr,
                char    *OutPtr)
{
    register    int     i;
    auto        BYTE    Tmp;

    /*  Encode and print the input buffer.  */
    for (i = 0; i < NoBytes; i += 3)
    {
        /*  Convert and print three bytes.  */
        Tmp = (InBfr[i] >> 2) & 0x3f;
        *OutPtr++ = ENC( Tmp );

        Tmp = ((InBfr[i + 1] >> 4) & 0x0f) |
              ((InBfr[i] & 0x03) << 4);
        *OutPtr++ = ENC( Tmp );

        Tmp = ((InBfr[i + 2] >> 6) & 0x03) |
              ((InBfr[i + 1] & 0x0f) << 2);
        *OutPtr++ = ENC( Tmp );

        Tmp = InBfr[i + 2] & 0x3f;
        *OutPtr++ = ENC( Tmp );
    }
    *OutPtr = '\0';
}

/*-----------------------------------------------------------------------------
| Routine   :   Encode() --- Encode the number of lines specified, or until
|               end of file is reached.
|
| Inputs    :   BinFlPtr    - Binary file pointer.
|               PartFlPtr   - Output file pointer.
|               Lines       - Number of lines to write per part.
-----------------------------------------------------------------------------*/

void    Encode(FILE     *BinFlPtr,
               FILE     *PartFlPtr,
               long     Lines)
{
    register    int     i;
    auto        int     ret;
    auto        BYTE    InBfr[BFR_SZ];
    auto        char    OutBfr[BFR_SZ];

    /*  Encode and print all the lines of a part.   */
    for (i = 0; i < Lines; i++)
    {
        /*  Read a line from the file.  */
        ret = fread(InBfr, 1, BYTES_PER_LINE, BinFlPtr);

        /*  Check for end of file.  */
        if (ret <= 0)
            if ( feof( BinFlPtr ) )
                break;
            else if ( ferror( BinFlPtr ) )
            {
                fprintf(stderr,
                        "%s %d : Error - Could not read from binary file.\n",
                        __FILE__,
                        __LINE__);
                exit( 1 );
            }

        /*  Write the record size.  */
        OutBfr[0] = ENC( ret );

        /*  Encode and write the line out.  */
        EncLine(ret, InBfr, OutBfr + 1);

        /*  Print the line to the part file.    */
        fprintf(PartFlPtr, "%s\n", OutBfr);
    }
}
