@ECHO OFF
IF "%1"=="" GOTO SYNTAX:

ECHO ͻ
ECHO   Applying patch to upgrade Clarion VGA Kit 3007 to revision 3009       
ECHO                                                                         
ECHO ͼ

ECHO ͻ
ECHO   The patch will overwrite the following files:                         
ECHO                                                                         
ECHO   VGACOLOR.DOC, SPECTRUM*.* (SOURCE CODE, PROJECT AND .EXE)             
ECHO   RBG.* (SOURCE CODE, PROJECT AND RGB.EXE                               
ECHO   ???RGB.* (RGB.CLA -- LIBRARY FILES ALL MODELS )                       
ECHO   SETRGB*.*                                                             
ECHO                                                                         
ECHO   If you want to save old versions of these files, PRESS CTRL-C NOW     
ECHO   to exit the Patch process!!                                           
ECHO                                                                         
ECHO                                                                         
ECHO ͼ

ECHO ͻ
ECHO  Press any key to continue or Control-C to abort.            
ECHO ͼ
pause


PATCH %1 VGA7to9.RTP

IF ERRORLEVEL 37 GOTO ERRORFILE
IF ERRORLEVEL 36 GOTO BADVER
IF ERRORLEVEL 35 GOTO SYNTAX
IF ERRORLEVEL 34 GOTO NOTADIR
IF ERRORLEVEL 29 GOTO NOSPACE
IF ERRORLEVEL 24 GOTO PATCH_COMPLETE
IF ERRORLEVEL 16 GOTO PATCH_COMPLETE
IF ERRORLEVEL 15 GOTO BADVER_15
IF ERRORLEVEL 9 GOTO BAD_PATCHFILE
IF ERRORLEVEL 8 GOTO BAD_PATCHEXE
IF ERRORLEVEL 5 GOTO NOTADIR
IF ERRORLEVEL 4 GOTO NOTADIR
IF ERRORLEVEL 1 GOTO SYNTAX

ECHO *
ECHO *
GOTO PATCH_COMPLETE

:NOTADIR
ECHO ͻ
ECHO  CANNOT FIND A DIRECTORY NAMED:    " %1 "
ECHO ͼ
GOTO SYNTAX

:SYNTAX
ECHO ͻ
ECHO  This patch should be applied by UNZIPPING VGA9.ZIP          
ECHO  then typing:                                                
ECHO                                                              
ECHO   VGA7to9 [DRIVE:\DIRECTORY]                                 
ECHO                                                              
ECHO   where [DRIVE:\DIRECTORY] is the name of the drive and path 
ECHO          where CDD 3.0 is installed                          
ECHO                                                              
ECHO                                                              
ECHO   example: if CDD 3.0 is installed in C:\Clarion3            
ECHO            then type VGA7to9 C:\Clarion3                     
ECHO                                                              
ECHO ͼ
GOTO EXIT

:ERRORFILE
ECHO   An error occurred when Patch.exe was opening %1\Patch.err
ECHO ͻ
ECHO  The probable cause is some type of DOS error, retry the operation  
ECHO  after checking the disks integrity.                                
ECHO ͼ
GOTO EXIT


:PATCH_COMPLETE
IF NOT EXIST %1\PATCH.ERR GOTO noerrors

ECHO 
ECHO ͻ
ECHO  PATCH HAS ERRORs, press any key to view error file  
ECHO  after viewing the errors you can rerun the patch    
ECHO ͹
ECHO   The following errors can be ignored:               
ECHO                                                      
ECHO   ept0016: New file already exists                   
ECHO   ept0024: New file already exists                   
ECHO ͼ
Pause
EDITOR %1\PATCH.ERR

CLS
ECHO ͻ
ECHO  A patchkit install set is available from Clarion Customer Service    
ECHO  at 305-785-4555 for $10.00 plus shipping charges.                    
ECHO                                                                       
ECHO ͼ
pause
GOTO EXIT

:missing_file
ECHO ͻ
ECHO  Cannot locate patch file(s)                                
ECHO  This patch should be applied by UNZIPPING VGA9.ZIP         
ECHO  then typing:                                               
ECHO                  VGA627 [DRIVE:\DIRECTORY]                  
ECHO ͼ
GOTO EXIT

:BADVER
ECHO ͻ
ECHO  error ept0036: Old file not found. However, a file of the same name    
ECHO           was found. No update done since file contents do not match.   
ECHO                                                                         
ECHO  PATCH was unable to locate an exact match for the original file to     
ECHO  be updated. However, PATCH was able to locate a file with the same     
ECHO  name as the original file. However, the file found did not have either 
ECHO  the same size or checksum as the actual original file that PATCH is    
ECHO  seeking in order to perform the update.                                
ECHO ͼ

GOTO EXIT
:BADVER_15
ECHO ͻ
ECHO                                                                         
ECHO  error ept0015: Old file does not exist                                 
ECHO                                                                         
ECHO  PATCH needs Bytes from the existing version of a file in order to build
ECHO  the new file. However, it was unable to locate the old file.           
ECHO ͼ
GOTO EXIT

:nospace
ECHO ͻ
ECHO                                                             
ECHO  There is insufficient disk space to apply the Patch,       
ECHO  please free up some space and reapply the Patch.           
ECHO                                                             
ECHO ͼ
GOTO EXIT

:BAD_PATCHFILE
ECHO ͻ
ECHO  error ept0009:                                             
ECHO  PATCH.EXE was unable to read the correct information       
ECHO  from the patch file.  Get a new copy and rerun the PATCH   
ECHO                                                             
ECHO ͼ
GOTO EXIT

:BAD_PATCHEXE
ECHO ͻ
ECHO  error ept0008: PATCH.EXE and Patch file are incompatible   
ECHO                                                             
ECHO  You need a new copy of PATCH.EXE to apply this patch.      
ECHO                                                             
ECHO ͼ
GOTO EXIT

:NOERRORS
ECHO  
ECHO ͻ
ECHO   Patch is complete, no errors encountered!      
ECHO ͼ
:EXIT
