'Pilgrim Station Heat Balance
'Copyright (c) by Michael Krabach 4-15-94
'adapted from HP-41CX Rev. 5-11-86 for Seabrook recirc analysys,
'to Turbo Basic, Rev. 3-9-90, for Seabrook Station
'latest full BECo Rev. 5-7-92,
'adapted to interactive screen mode, rev$
'Written in PowerBASIC 3.00c

rev$="4-28-94"

'=======================================================================
GOSUB resetup

'For Pilgrim Station Condenser
WALLCF=0.0734	'table III Ecolaire, for 0.875" 22 B.W.G.
MATCF=0.87		'table IV Ecolaire, for titanium, 22 B.W.G., H.E.I. adden. 1
TUBLEN=49.77	'effective tube length, ft
PASSES=1		'condenser passes
GFACTOR=1.642	'gpm per tube at 1 fps, table II Ecolaire, 0.875" 22 B.W.G.
CONDAREA=400000	'condenser surface area, ft2
OD=0.875        'tube O.D., inches
DELTAHG=0

'data for % change in heat rate vs back pressure curve set

c0a = -8.3613146D+01  'coefs for polynominal for D0 coef
c0b =  4.2258261D+02  'from file c40.dat
c0c = -6.2279685D+02
c0d =  2.8301935D+02

c1a =  1.2337307D+02  'coefs for polynominal for D1 coef
c1b = -7.6742144D+02  'from file c41.dat
c1c =  1.2307937D+03
c1d = -5.8365612D+02

c2a = -6.7923989D+01  'coefs for polynominal for D2 coef
c2b =  5.0484591D+02  'from file c42.dat
c2c = -8.6175149D+02
c2d =  4.2120656D+02

c3a =  1.7896337D+01 'coefs for polynominal for D3 coef
c3b = -1.4379201D+02 'from file c43.dat
c3c =  2.5402242D+02
c3d = -1.2652886D+02

c4a = -1.6290343D+00 'coefs for polynominal for D4 coef
c4b =  1.4379191D+01 'from file c44.dat
c4c = -2.6255110D+01
c4d =  1.3307604D+01

MWA =  -3.7452028D+01   'coefs for MWE vs PWR polynominial
MWB =   7.4155719D+02   'from file coefmwe.dat
MWC =  -4.1531061D+01
MWD =  -7.2597340D+00

HRA =  1.6103994D+04  'coefs for heat rate vs PWR polynominal
HRB = -1.9264316D+04  'from file coefhr.dat
HRC =  2.1079914D+04
HRD = -7.9905870D+03

STMA =  -1.1905400D+00 'coefs for steam flow vs PWR polynominal
STMB =   7.5600916D+06 'from file coefflo.dat
STMC =  -1.2378775D+01
STMD =   5.1537091D+00

'=======================================================================

KEY 15, CHR$(&h08, &h02, &h70)		'alt plus !1 KEY
KEY 16, CHR$(&H08, &H23, &H70)		'alt plus H KEY
KEY 17, CHR$(&H08, &H2d, &H70)		'alt plus X KEY
KEY 18, CHR$(&H08, &H2e, &H70)		'alt plus C KEY
KEY 19, CHR$(&H08, &H03, &H70)		'alt plus @2 KEY
KEY 20, CHR$(&H08, &H04, &H70)		'alt plus #3 KEY
KEY 21, CHR$(&H08, &H24, &H70)		'alt plus J KEY
KEY 22, CHR$(&H08, &H13, &H70)		'alt plus #3 KEY
KEY 23, CHR$(&H08, &H05, &H70)		'alt plus $4 KEY
KEY 24, CHR$(&H08, &H06, &H70)		'alt plus %5 KEY

ON KEY (1) GOSUB powerdown
ON KEY (2) GOSUB powerup
ON KEY (3) GOSUB circdown
ON KEY (4) GOSUB circup
ON KEY (5) GOSUB oceandown
ON KEY (6) GOSUB oceanup
ON KEY (7) GOSUB cleandec
ON KEY (8) GOSUB cleaninc
ON KEY (9) GOSUB bwashdec
ON KEY (10) GOSUB bwashinc
ON KEY (15) GOSUB freeze
ON KEY (16) GOSUB help
ON KEY (17) GOSUB shutdown
ON KEY (18) GOSUB resetup
ON KEY (19) GOSUB decdev
ON KEY (20) GOSUB incdev
ON KEY (21) GOSUB help2
ON KEY (22) GOSUB resetscrn
ON KEY (23) GOSUB lossvacuum
ON KEY (24) GOSUB gainvacuum

KEY (1) ON
KEY (2) ON
KEY (3) ON
KEY (4) ON
KEY (5) ON
KEY (6) ON
KEY (7) ON
KEY (8) ON
KEY (9) ON
KEY (10) ON
KEY (15) ON
KEY (16) ON
KEY (17) ON
KEY (18) ON
KEY (19) ON
KEY (20) ON
KEY (21) ON
KEY (22) ON
KEY (23) ON
KEY (24) ON

'=======================================================================

progloop:

ON ERROR GOTO finish
TIN=OCEAN	'also as condenser inlet temp.

LBL4:	'calc constants for exhaust correction factor coeff.
D0=((c0d*PWR+c0c)*PWR+c0b)*PWR+c0a
D1=((c1d*PWR+c1c)*PWR+c1b)*PWR+c1a
D2=((c2d*PWR+c2c)*PWR+c2b)*PWR+c2a
D3=((c3d*PWR+c3c)*PWR+c3b)*PWR+c3a
D4=((c4d*PWR+c4c)*PWR+c4b)*PWR+c4a

LBL5:	'heat rate, btu/kwhr, for UE&C heat balances at specific power level
HRATE=(((HRD)*PWR+HRC)*PWR+HRB)*PWR+HRA
NEFF=3415/HRATE			'plant efficiency

'turbine output, MWE at %pwr at condenser design pressure.
MWE=(((MWD)*PWR+MWC)*PWR+MWB)*PWR+MWA
MWT=MWE/NEFF			'plant thermal output
HRR=(MWT-MWE)*3415E3		'heat rejection rate, btu/hr

LBL6:
'inlet circ water correction factor from Ecolaire Table V, H.E.I. adden. 1
ICWCF=((((1.3986E-8)*TIN-4.036519E-6)*TIN+3.476689E-4)*TIN-2.511266E-3)*TIN+0.511212

K=WALLCF*MATCF*ICWCF*CLEAN*SQR(TUBLEN*PASSES*GFACTOR*CONDAREA*12/(3.14159*OD*GPM))
R=1-1/EXP(K)

LBL7:
TRISE=HRR/(GPM*489.8)	'delta temp = temp rise, H.E.I. Standards
ITD=TRISE/R
TTD=ITD-TRISE
IF TTD<=5 THEN ITD=TRISE+5
'locate 1,1:print using "##.#";ttd

LBL8:			'for saturated steam
TSS=ITD+TIN		'saturated steam temperature
TSS=TSS+DEV     'correction for hotwell deviation above Tsat.

'from regression of the steam tables, pressure in inches mercury.
HG=((((2.0247669E-8)*TSS-2.54974E-6)*TSS+0.00031099)*TSS-0.008568)*TSS+0.20557
HG=hg+deltahg		'a manual variation in vacuum

'percent increase in heat rate, from GE curves
PERHRR=(((D4*HG+D3)*HG+D2)*HG+D1)*HG+D0   'percent increase in heat rate
PERLOAD=-PERHRR*100/(100+PERHRR)		'percent load change
NEFF=3415/(HRATE*(1+PERHRR/100))		'at inlet water temp
TSTMWT=(MWE+MWE*PERLOAD/100)/NEFF		'trial thermal output at inlet water temp
TSTHRR=(TSTMWT-(MWE+MWE*PERLOAD/100))*3415E3	'trial btu/hr rejected at Tin.

PERCHG=100*(TSTHRR-HRR)/HRR

HRR=TSTHRR	'save TSTHRR as HRR for next iteration if necessary.
IF ABS(PERCHG)>.1 THEN LBL7	'if difference not small enough, repeat loop
TSTDT=HRR/(489.8*GPM)		'for Tin
TOUT=TIN+TSTDT

LBL9:
QRECIRC=(GPM+SWGPM)*BWASH
QOUT=GPM+SWGPM-QRECIRC	'amount of water discharged out tunnel
TMIX=(GPM*TOUT+SWGPM*(SWDT+OCEAN))/(GPM+SWGPM)	'mixed temp leaving
TSTTIN=(QRECIRC*TMIX+(GPM-QRECIRC)*OCEAN)/GPM
PERCHG=100*(TSTTIN-TIN)/TIN
TIN=TSTTIN
IF ABS(PERCHG)>.1 THEN LBL6

DTOCEAN=TMIX-OCEAN

LBL9A:
MWE=MWE*(1+PERLOAD/100)
valueday = (mwe)*mwhrcost*24
valuechg = (mwe-basemwe)*mwhrcost*24
IF flag1=0 THEN GOSUB freeze
HRR=3415/NEFF

STM=(((STMD)*PWR+STMC)*PWR+STMB)*PWR+STMA
'SV=((((((16.037)*HG-252.96)*HG+1588.3)*HG-5077.6)*HG+8786.5)*HG-8102.03)*HG+3677.4
'CVEL=SQR(SV*32.17*144*1.329*HG/2.036)

IF HG<2.5 THEN hgflag=0		'condenser normal operation
IF HG>2.5 THEN hgflag=1		'above recommemded limit
IF HG>3.81 THEN hgflag=2	'condenser high pressure alarm at 26" vac
IF HG>7 THEN hgflag=3   	'reactor scram at 23" vac
IF (tout>=75 AND tstdt>=30) OR (tout<75 AND tstdt>=32) THEN	dtflag=1 ELSE dtflag=0 	'NPDES DT limit
IF tout>102 THEN toutflag=1 ELSE toutflag=0		'NPDES temperature limit

LOCATE 1,5
	COLOR 13: PRINT "=======  PILGRIM NUCLEAR POWER STATION STEAM SYSTEM SIMULATOR  ======= ";
LOCATE 3,7
	COLOR 10: PRINT "------ INPUT DATA ------"
LOCATE 3,45
	PRINT "------ OUTPUT DATA -------"

COLOR 7
LOCATE 5,5
	PRINT "Reactor power level (.%) ";:COLOR 10:PRINT USING "#.###";pwr
LOCATE 6,8
    COLOR 10: PRINT "F1 ";
    COLOR 7: PRINT "-0.1%   ";
	COLOR 10: PRINT "F2 ";
    COLOR 7: PRINT "+0.1%";

LOCATE 8,5
	PRINT "Circ Pumps flow (gpm)  ";:COLOR 10:PRINT USING "###,###";gpm
LOCATE 9,8
    COLOR 10: PRINT "F3 ";
    COLOR 7: PRINT "-1%     ";
	COLOR 10: PRINT "F4 ";
    COLOR 7: PRINT "+1%";

LOCATE 11,5
	PRINT "Ocean intake water (F)   ";:COLOR 10:PRINT USING "###.#";ocean
LOCATE 12,8
	COLOR 10: PRINT "F5 ";
    COLOR 7: PRINT "-0.5 F  ";
	COLOR 10: PRINT "F6 ";
    COLOR 7: PRINT "+0.5 F";

LOCATE 14,5
	PRINT "Cond. cleanliness (.%)    ";:COLOR 10:PRINT USING "#.##";clean
LOCATE 15,8
	COLOR 10: PRINT "F7 ";
    COLOR 7: PRINT "-0.1    ";
	COLOR 10: PRINT "F8 ";
    COLOR 7: PRINT "+0.1";

LOCATE 17,5
	PRINT "Pump recirculation (.%)   ";:COLOR 10:PRINT USING "#.##";bwash
LOCATE 18,8
	COLOR 10: PRINT "F9 ";
    COLOR 7: PRINT "-0.01   ";
	COLOR 10: PRINT "F10 ";
    COLOR 7: PRINT "+0.01";

LOCATE 20,7
	COLOR 10: PRINT "Alt-H,J  ";
    COLOR 7: PRINT "Help files";
LOCATE 21,7
	COLOR 10: PRINT "Alt-1   ";
    COLOR 7: PRINT "Zero gain/loss $ ";
LOCATE 22,7
	COLOR 10: PRINT "Alt-C   ";
    COLOR 7: PRINT "Reset design parameters";
LOCATE 23,7
	COLOR 10: PRINT "Alt-X   ";
    COLOR 7: PRINT "Exit ";

LOCATE 5,40
	PRINT "Steam Plant:"
LOCATE 6,45
IF hgflag=3 THEN		'for plant scram
	mwe=0
    hrr=0
END IF
	PRINT "Gross MWE            ";USING "#####,.##";mwe
LOCATE 7,45
	PRINT "Gross HR (btu/kwhr)  ";USING "#####,.##";hrr
LOCATE 8,45
	PRINT "Steam flow (lbm/hr)  ";USING "########,";stm

LOCATE 10,40
	PRINT "Condenser:"
LOCATE 11,45
	PRINT "Backpressure (in.Hg)     ";
IF hgflag=1 THEN COLOR 14
IF hgflag=2 THEN COLOR 12
IF hgflag=3 THEN COLOR 28
    PRINT USING "##.##";hg
COLOR 7
LOCATE 12,45
	PRINT "Delta temp F             ";
IF dtflag=1 THEN COLOR 14 ELSE COLOR 7
	PRINT USING "##.##";tstdt
COLOR 7
LOCATE 13,45
	PRINT "Temp out F              ";
IF toutflag=1 THEN COLOR 14 ELSE COLOR 7
PRINT USING "###.##";tout
COLOR 7
LOCATE 14,45
	PRINT "Hotwell dev F           ";USING "##.#";dev

LOCATE 16,40
	PRINT "Ocean:"
LOCATE 17,45
	PRINT "Delta temp F            ";USING "###.##";dtocean
LOCATE 18,45
	PRINT "Discharge (gpm)       ";USING "#######,";qout

LOCATE 20,40
	PRINT "Value of power per day     ";USING "$######,";valueday
LOCATE 21,40
	PRINT "Gain or loss per day      ";USING "$#######,";valuechg
LOCATE 22,40
IF hgflag=0 THEN COLOR 7: PRINT  "                                     ";
IF hgflag=1 THEN COLOR 14: PRINT "Recommemded condenser in.Hg exceeded.";
IF hgflag=2 THEN COLOR 12: PRINT "Condenser high back pressure alarm.  ";
IF hgflag=3 THEN COLOR 28: PRINT "Reactor SCRAM on condenser pressure. ";
LOCATE 23,40
IF dtflag=0 THEN COLOR 7: PRINT  "                                     ";
IF dtflag=1 THEN COLOR 14: PRINT "NPDES condenser delta temp' exceeded.";
LOCATE 24,40
IF toutflag=0 THEN COLOR 7: PRINT  "                                     ";
IF toutflag=1 THEN COLOR 14: PRINT "NPDES discharge temp' limit exceeded.";
GOTO progloop

circup:
gpm=gpm*1.01
RETURN

circdown:
gpm=gpm*0.99
RETURN

oceanup:
ocean=ocean+0.5
IF ocean > 100 THEN ocean=100
RETURN

oceandown:
ocean=ocean-0.5
IF ocean < 29 THEN ocean=29
RETURN

powerup:
pwr=pwr+0.001
IF pwr > 1.05 THEN pwr=1.05
RETURN

powerdown:
pwr=pwr-0.001
IF pwr < .25 THEN pwr=0.25
RETURN

cleaninc:
clean=clean+0.01
IF clean > 1 THEN clean=1
RETURN

cleandec:
clean=clean-0.01
IF clean < 0.4 THEN clean=0.4
RETURN

bwashinc:
bwash=bwash+0.01
IF bwash > 1 THEN bwash=1
RETURN

bwashdec:
bwash=bwash-0.01
IF bwash <= 0 THEN bwash=0.00001
RETURN

incdev:
dev=dev+0.1
RETURN

decdev:
dev=dev-0.1
IF dev < 0 THEN dev=0
RETURN

lossvacuum:
deltahg=deltahg+0.01
RETURN

gainvacuum:
deltahg=deltahg-0.01
IF deltahg < 0 then deltahg=0
RETURN

resetup:
PWR=1.0
GPM=311000
DTACTUAL=0
BWASH=0.00001
CLEAN=.95
OCEAN=48
OCEANDT=0
SWGPM=10323	'service water nominal pumping flow
SWDT=16		'service water nomional delta temp
DEV=1.5  	'deviation from condenser saturated temp
DELTAHG=0	'normal tight condenser
mwhrcost=54	'cost of power $/mwhr
basemwe=0
flag1=0
hgflag=0	'describes backpressure effect on plant
CLS
RETURN

freeze:
basemwe=mwe
flag1=1
LOCATE 20,70: PRINT "        ";
CLS
RETURN

shutdown:
COLOR 10
LOCATE 25,1
	PRINT "Program ended.";
LOCATE 25,56
	PRINT "(c) M H Krabach, " rev$;
STOP

help:
SCREEN 0,0,2,2		'active page 2 and show visual page 2
CLS
LOCATE 2,27
	COLOR 10:PRINT "BRIEF DOCUMENTATION"
PRINT ""
COLOR 7
PRINT "This program is a compact computer model of the Boston Edison Pilgrim"_
"Nuclear Station located on Massachusetts Bay in Plymouth MA.  It can be"_
"used to view the effect of various environmental parameters on the"_
"operation of the plant.  An example would be showing what the effect"_
"of an increasing inlet ocean water temperature would be on the efficiency"_
"of the plant and the dollar value of that change.  This model is based on"_
"actual plant design specifications for the secondary steam plant and the"_
"condenser system.  This model has the ability to couple the results of"_
"the original General Electric heat balances for the Steam System with"_
"industry HEI Standards for condenser performance.  Normally these two"_
"calculations are presented separately.  Combining them gives a better"_
"indication of the plant operation.  Several assumptions are also used:"_
"The service water pumps are operating at 10,323 gpm and with a delta"_
"temperature of 16.0 F. The condenser hotwell is assumed to operate at"_
"1.5 F above the saturated steam temperature. The two circulating water"_
"pumps normally operate between high tide (340,000 gpm) and low tide"_
"(320,000 gpm).  Any user variation outside this range would not be possible"_
"in actual operation, although 1 pump operation would be about 170,000 gpm."_
"The cost (or loss) of power is $54/MWH.  For further information, contact;"_
"Michael Krabach, 747 Nate Whipple Hwy, Cumberland, RI 02864."
COLOR 10
LOCATE 25,50
	PRINT "Space key to return to program";
GOTO waitabit
RETURN


help2:
SCREEN 0,0,3,3		'active page 2 and show visual page 2
CLS
LOCATE 2,25
	COLOR 10:PRINT "ADDITIONAL DOCUMENTATION"
PRINT ""
COLOR 7
PRINT "Here are a few operational parameters that you can play with in addition "_
"to the input variables as defined by the function keys."_
"                                                             "_
"Alt-2 and Alt-3 (top numeric row) will increase or decrease the hotwell"_
"temperature deviation from the saturation temperature."_
"                                                             "_
"A leak in the condenser can be simulated with a loss of vacuum with Alt-4."_
"Alt-5 will increase the vacuum, but only to its nominal value."_
"                                                             "_
"If misplaced characters appear on the screen, refresh the screen with Alt-R."
COLOR 10
LOCATE 25,50
	PRINT "Space key to return to program";
GOTO waitabit
RETURN

waitabit:
a$=INKEY$: IF a$="" THEN waitabit
SCREEN 0,0,0,0		'restore the main program screen
CLS
RETURN

finish:
locate 24,1
	print "Unable to compute!"
goto shutdown

resetscrn:
cls
RETURN