; -------------------------------------------------
; Function: C:MVALIGN
;
; Aligns (registers) views in two or
; more model space viewports.

(defun C:MVALIGN ( / vp1 cvport vpset vplist e i)
   (cond
      (  (not (zerop (getvar "tilemode")))
         (princ (strcat "\n*** Command not allowed"
            " unless TILEMODE is set to 0.")))
      (  (progn
            (setvar "cmdecho" 0)
            (command "._undo" "_g")
            (setq cvport (getvar "cvport"))
            (cond
               (  (> cvport 1)
                  (princ (strcat
                     "\n*** Switching to"
                     " paper space ***"))
                  (command ".PSPACE")))
            nil
         )
      )
      (  (not (setq vp1 (car
            (entsel "\nDefining viewport: ")))))
      (  (not (eq "VIEWPORT"
                 (cdr (assoc 0 (entget vp1)))))
         (princ (strcat "\nInvalid, selected"
            " object is not a viewport.")))
      (  (progn (princ "\nSelect target viewports,")
         nil))
      (  (not (setq vpset
                 (ssget '(  (-4 . "<and")
                               (0 . "VIEWPORT")
                               (-4 . ">") (68 . 0)
                            (-4 . "and>")))))
         (princ "\nNothing selected."))

      (  (and (eq 1 (sslength vpset))
              (ssmemb vp1 vpset))
         (princ (strcat "\nDefining viewport"
            " ignored, nothing selected.")))

      (  (progn
            (repeat (setq i (sslength vpset))
               (setq e (ssname vpset (setq i (1- i))))
               (if (not (eq vp1 e))
                   (setq vplist
                       (append vplist
                               (list e)))))
            (not vplist)))

      (t (setq i (mvalign (cons vp1 vplist)))
         (cond
            (  (eq cvport 1)
               (command ".pspace"))
            (t (setvar "cvport" cvport)))
         (command "._undo" "_e")
         (cond
            (i (princ (strcat "\nAligned "
                               (itoa i)
                               " viewports.")))
            (t (princ "\nNo viewports aligned.")))
      )
   )
   (princ)
)

; -------------------------------------------------
; Function: MVALIGN
;
; (mvalign <vportlist>)
;

  (defun mvalign (vplist / cvport vp1 vp1xd vp1d
                           pscen1 xpfact mscen1
                           viewdir vp2d pscen2
                           psang msdist xpscale i)

     (setq cvport (getvar "cvport"))
     (if (eq 1 (getvar "cvport"))
         (command ".mspace")
     )
     (setq vp1     (car vplist)
           vp1xd   (entxdata vp1 "acad")
           vp1d    (entget vp1)
           vp1id   (cdr (assoc 69 vp1d))
           pscen1  (cdr (assoc 10 vp1d))
           xpfact  (/ (cdr (assoc 41 vp1d))
                      (cdr (nth 6 vp1xd)))
           xpscale (/ 1.0 xpfact)
           mscen1  (list (cdr (nth 7 vp1xd))
                         (cdr (nth 8 vp1xd)))
     )
     (setvar "cvport" (cdr (assoc 69 vp1d)))
     (setq viewdir (getvar "viewdir"))
     (setq i 0)
     (foreach vp2 (cdr vplist)
        (cond
           (  (and (/= vp1 vp2)
                   (setq vp2d (entget vp2))
                   (eq "VIEWPORT"
                        (cdr (assoc 0 vp2d)))
                   (/= 0 (cdr (assoc 68 vp2d)))
                   (progn (setvar "cvport"
                             (cdr (assoc 69 vp2d)))
                          (equal viewdir
                             (getvar "viewdir"))))
              (setq pscen2 (cdr (assoc 10 vp2d))
                    psang  (angle pscen1 pscen2)
                    msdist (* xpscale
                              (distance pscen1
                                        pscen2))
                    i      (1+ i)
              )
              (command ".zoom" "c"
                       (polar mscen1 psang msdist)
                       (/ (cdr (assoc 41 vp2d))
                          xpfact)
              )
           )
        )
     )
     (cond (  (zerop i) nil) (t i))
  )

; --------------------------------------------------
; Function: ENTXDATA
;
; (entxdata <ename> <appid>)
;
; Retrieves extended data attached to an entity
; for a given APPID.

  (defun entxdata (ent appid / d)
     (if (and (setq d (entget ent (list appid)))
              (setq d (assoc -3 d))
              (cdadr d))
         (cdadr d))
  )


