;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; AUTOLISP CONCEPTS      W.KRAMER
;; CADENCE  APRIL 1994
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Listing 1
(defun C:TXED ( / T1   ;;search substring
                  T2   ;;replace substring
                  SS1  ;;selection set
                  EL   ;;entity list
                  EN   ;;entity name
              )
   (setq T1 (getstring 1 "\nText string to locate:")
         T2 (getstring 1 "\nReplacement string   :")
   )
   ;;get all text or insert w/attribute entities
   (setq SS1 
      (ssget "X" 
        '((-4 . "<OR") 
                    (0 . "TEXT")
                    (-4 . "<AND")
                            (0 . "INSERT")
                            (66 . 1)
                    (-4 . "AND>")
          (-4 . "OR>")
        );;end list
   ))
   ;; while we have entities in the selection set.
   (while SS1
     (setq EN (ssname SS1 0) ;;get entity name
           EL (entget EN)    ;;get entity list
           SS1 (ssdel EN SS1) ;remove EN from SS1
     )
     ;;if SS1 empty, set to nil to cancel while loop
     (if (zerop (sslength SS1)) (setq SS1 nil))
     ;;test type of entity in EL
     (cond
       ;;TEXT entity processing
       ((= (cdr (assoc 0 EL)) "TEXT")
          ;;Wild Card Match test
          (if (wcmatch 
                 (cdr (assoc 1 EL)) ;;string from EL
                 (strcat "*" T1 "*"));search string
             ;;if found, modify database
             (entmod
               (subst ;;subsitute text in list
                 (cons 1 ;;build new group 1 data
                       (sub_text ;;see listing 2
                          (cdr (assoc 1 EL)) ;;source
                          T1   ;;search string
                          T2)) ;;replacement string
                 (assoc 1 EL) ;;old group 1 data
                 EL))
          ) ;;end IF WCMATCH
       ) ;;end processing TEXT
       ;;INSERT with ATTRIB entity processing
       ((= (cdr (assoc 0 EL)) "INSERT")
          (while (= "ATTRIB" ;;as long as attribute
                    (cdr     ;;found in data for
                      (assoc 0 ;;group code 0 of
                        (setq EL ;;saved EL which is
                          (entget ;;entity list from
                            (entnext ;;next entity
                              (cdr   ;;from current EL
                                (assoc -1 EL))))))))
             
             (if (wcmatch ;;Wild Card Match of string
                    (cdr (assoc 1 EL))  ;;source 
                    (strcat "*" T1 "*")) ;search
                (entmod ;;modify database with new
                  (subst ;entity list containing group
                    (cons 1 with modified text.
                          (sub_text ;;see Listing 2
                            (cdr (assoc 1 EL))
                            T1 
                            T2))
                    (assoc 1 EL)
                    EL))
             ) ;;end IF WCMATCH
          ) ;;end inside (WHILE)
          (entupd EN) ;;update complex object
       ) ;;end processing INSERT
     );;end COND
   );;end WHILE loop
   (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Listing 2
(defun SUB_TEXT (S1 ;;source string
                 S2 ;;search string
                 S3 ;;replacement string
                 /
                 C0 ;;integer counter for S1 index
                 C1 ;;integer size of search string
                 S4 ;;return string
                )
   (setq C1 (strlen S2) ;;length of search string
         C0 1 ;;index into S1 source string
         S4 "" ;;return string
   )
   (while (<= C0 (strlen S1)) ;;C0 <= S1 string size
      (if (= S2 (substr S1 C0 C1)) ;; found one?
         (setq S4 (strcat S4 S3) ;;yes, use replace
               C0 (+ C0 C1)      ;;text. increment
         )                       ;;counter by C1
         (setq S4 (strcat S4 (substr S1 C0 1))
               C0 (1+ C0)  ;;no, concat char, inc 1
         )
      )
   )
   S4 ;;return contents of S4 to calling function
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Listing 3
;; "Set up" Function for recursive routine
(defun SUBTXT1 (S1 S2 S3 / C0)
   (setq C0 (strlen S2))
   (subtxt2 S1)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Recursive routine
(defun SUBTXT2 (S1)
  (cond
    ((< (strlen S1) C0)  ;;source string too small?  
       S1) ;;then return source string
    ((= S2 (substr S1 1 C0)) ;;search string on front?
       (strcat S3 ;;then concat replacement with
                  ;;result of (SUBTXT2) with a search
                  ;;string removed.
               (SUBTXT2 (substr S1 (1+ C0))))
    )
    (t ;;otherwise, 
       ;;concat the first character of string to
       ;;result of (SUBTXT2) reduced by one char.
       (strcat (substr S1 1 1)
               (SUBTXT2 (substr S1 2))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Listing 4
(defun TIMER1 ()
  (setq TIME_START (getvar "DATE"))
)
(defun TIMER2 ()
  (- (getvar "DATE") TIME_START)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun C:TEST ()
   (prompt "\nTest1 running...single change")
   (setq S1 "A quick brown fox jumped over the fence"
         S2 "over"
         S3 "under"
   )
   (runtest S1 S2 S3)
   (prompt "\n\nTest2 running...many changes")
   (setq S1 "FGHFGHFGHFGHFGHFGHFGHFGHFGHFGHFGHFGHFGHFGH"
         S2 "FG"
         S3 "fg"
   )
   (runtest S1 S2 S3)
   (princ)
)
(defun RUNTEST (S1 S2 S3 / T1 T2)
   (timer1)
   (repeat 100 (subtxt1 S1 S2 S3))
   (setq T1 (timer2))
   (timer1)
   (repeat 100 (sub_text S1 S2 S3))
   (setq T2 (timer2))
   (prompt (strcat "\nResults  Recursion        " (rtos (* 86400.0 T1))))
   (prompt (strcat "\n         Direct iteration " (rtos (* 86400.0 T2))))
)
