(defun C:SL ()
   (prompt "\nPick entity on the layer you want current:  ")
   (setq name (cdr (assoc 8 (entget (car (entsel))))))
   (command "layer" "s" name "")
   (princ)
 )

 (defun C:CL ()
   (prompt "\nSelect the entities you want to change:  ")
   (setq ss (ssget))
   (prompt "\nPick an entity on the target layer:  ")  
   (setq name (cdr (assoc 8 (entget (car (entsel))))))
   (command "chprop" ss "" "la" name "")
   (princ)
 )

(defun C:CPL ()
   (prompt "\nSelect the entities you want to copy:  ")
   (setq ss (ssget))
   (setq name (getstring "\nEnter destination layer name:  "))
   (if (= nil (tblsearch "LAYER" name))
     (command "layer" "n" name ""))
   (command "copy" ss "" "@" "@")
   (command "chprop" ss "" "la" name "")
   (princ)
 )

 (defun C:LF ()
   (prompt "\nPick entity on the layer you to freeze:  ")
   (setq name (cdr (assoc 8 (entget (car (entsel))))))
   (command "layer" "f" name "")
   (princ)
 )

 (defun C:LM ()
   (setq name (getstring "\nEnter the new layer name:  "))
   (setq col (getstring "\nEnter the color for the new layer:  "))
   (command "layer" "m" name "c" col name "")
   (princ)
 )

 (defun C:WL ()
   (prompt "\nPick entity on the layer you want listed:  ")
   (setq name (cdr (assoc 8 (entget (car (entsel))))))
   (princ "\nThe layer is  ")(princ name)
   (princ)
 )
