
(defun extract (s / i prefix number suffix)
   (setq i 0 prefix "" number "" suffix "")
   (repeat (strlen s)
      (setq c (substr s (setq i (1+ i)) 1))
      (cond
         (  (and (wcmatch c "#")
                 (eq suffix ""))
            (setq number (strcat number c)))   ; 3
         (  (and (eq c "-")
                 (= suffix number "")
                 (wcmatch
                    (substr s (1+ i) 1) "#"))
            (setq number (strcat number c)))   ; 3
         (  (eq number "")
            (setq prefix (strcat prefix c)))   ; 3
         (t (setq suffix (strcat suffix c))))) ; 5

   (if (not (zerop (strlen number)))           ; 3
       (list prefix number suffix)
   )
)

(defun C:INCNUM ( / ss off e d s s1 i fltr)
  (setq fltr '((0 . "TEXT") (1 . "*#*")))
  (cond
    ((not (setq ss (ssget fltr))))               ; 4
    ((not (setq off (getint "\nIncrement: "))))  ; 4
    (  (zerop off)
       (princ "\nValue must be non-zero."))
    (t (setvar "cmdecho" 0)
       (command ".undo" "g")
       (repeat (setq i (sslength ss))
          (setq e (ssname ss (setq i (1- i)))   ; 3
                d (entget e)
                s (cdr (assoc 1 d)))            ; 3
          (if (setq s (extract s))              ; 3
            (entmod
              (list
                (cons -1 e)
                (cons 1
                  (strcat
                    (car s)
                    (itoa
                       (+ off (atoi (cadr s)))) ; 4
                    (caddr s)))))))             ; 7
       (command ".undo" "e")))                  ; 3
  (princ)
)

