;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Advanced Programming  CADENCE  MAR 1994  Bill Kramer
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 1.
;;
;; X_DATA_GET  retrieve the extended data list for 
;;             application APID contained in the entity 
;;             list for entity name EN
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun X_DATA_GET (EN APID / EL)
  (setq EL (entget EN (list APID)))
  (cdadr (assoc -3 EL)) ;;return only data items
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; X_DATA_ADD  add extended data list DLST with 
;;             application name APID to the entity list 
;;             of entity name EN.
;;             Overwrites existing.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun X_DATA_ADD (EN APID DLST / EL TMP1)
   (if (null (tblsearch "APPID" APID)) ;;registered?
      (regapp APID)) ;;register it
   (setq EL (entget EN) ;;get Entity list
         TMP1 (list -3 (cons APID DLST))
   )
   (if (< (xdsize TMP1) (xdroom EN)) ;;got enough room?
      (entmod (append EL (list TMP1)))) ;;modify database
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 2.
;;                                                    
;; X_DATA_DEL  remove extended data for application 
;;             APID from entity name EN.
;;
;; *NOTE* Uses function from CADENCE January 94 article
;;        (X_DATA_APPIDS)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun X_DATA_DEL (EN APID / EL TMP1 TMP2)
   (if (null X_DATA_APPIDS) (progn
      (prompt "\nNeed CADENCE Jan 94 AutoLISP!")
      (exit)
   ))
   (if (setq TMP2 (X_DATA_APPIDS)) ;;find X data?
     (progn
       (setq EL (entget EN TMP2)  ;;get ALL data
             TMP1 (assoc -3 EL)   ;;get X data
       )
       ;;is APID in X data info for object?
       (if (assoc APID (cdr TMP1)) 
         (progn
          (setq TMP1 (cdr TMP1) ;;take off -3
                TMP1 ;;remove existing X data
                  (append ;;rebuild X data list
                    (list -3)
                    (reverse ;;X data before APID
                      (cdr 
                        (member 
                          (assoc APID TMP1) 
                          (reverse TMP1))))
                    (cdr     ;;X data after APID
                      (member 
                        (assoc APID TMP1) 
                        TMP1)))
                EL (subst TMP1 (assoc -3 EL) EL)
          )
          (entdel EN) ;;remove previous member
          (entmake EL))))));;add with modified X data
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 3.
;;
;; ESTimator tool for AutoCAD.  Operator adds
;; descriptions and amounts as Xdata to existing
;; objects.  Simple version contains ability to
;; sum amounts, edit/add/del Xdata, and highlight
;; all existing Xdata objects.
;;
(defun C:EST ( / TMP DONE)
   (setq APID "CDNC3-94")
   (prompt "\nESTimator tool for AutoCAD.")
   (while (null DONE)
     (initget 0 "Sum Edit Look Add Del Xit")
     (setq TMP 
       (getkword 
          "\nEST: Sum/Edit/Look/Add/Del/<Xit>: "))
     (cond
       ((or (null TMP) (= TMP "Xit")) 
          (setq DONE 'T))
       ((= TMP "Sum") (EST_SUM APID))
       ((= TMP "Edit") (EST_EDIT APID))
       ((= TMP "Look") (EST_LOOK APID))
       ((= TMP "Add") (EST_ADD APID))
       ((= TMP "Del") (EST_DEL APID))
     )
   )
   (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 4.
;;
;; Add new Xdata for the estimator.
;;
(defun EST_ADD (APID / EN T1 T2)
  (setq EN (car (entsel "\nSelect object: ")))
  (if EN
    (progn
       (setq T1 (getstring 1 "\nDescription: "))
       (if (/= T1 "")  
         (progn
           (setq T2 (getreal "\nAmount: "))
           (if T2
             (X_DATA_ADD EN APID
               (list (cons 1000 T1)
                     (cons 1040 T2)))))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 5.
;;
;; Allow operator to edit description and amount data
;; for estimator.
;;
(defun EST_EDIT (APID / EN TMP T1 T2)
   (setq EN (car (entsel "\nSelect object: ")))
   (if (setq TMP (X_DATA_GET EN APID))
     (progn
        (setq T1 
           (getstring 1 
              (strcat "\nDescription <"
                      (cdar TMP) ">: "))
              T2
           (getreal
              (strcat "\nAmount <"
                      (rtos (cdadr TMP)) ">: "))
              TMP
               (list
                 (cons 1000 (if T1 T1 (cdar TMP)))
                 (cons 1040 (if T2 T2 (cdadr TMP))))
        )
        (X_DATA_ADD EN APID TMP))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 6.
;;
;; Remove estimator data
;;
(defun EST_DEL (APID / EN)
  (setq EN (car (entsel "\nSelect object: ")))
  (if EN (X_DATA_DEL EN APID)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 7.
;;
;; Highlight all objects containing extended data for
;; the estimator program.
;;
(defun EST_LOOK ( APID / SS1 TMP)
  (setq SS1 (ssget "X" (list (list -3 (list APID)))))
  (if SS1
    (progn
       (setq TMP (sslength SS1))
       (repeat TMP
         (redraw 
            (ssname 
               SS1 
               (setq TMP (1- TMP))) 
            3)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; LISTING 8.
;;
;; Sum all EST amount data and output to the screen.
;;
(defun EST_SUM ( APID / TMP SUM SS1)
   (setq SS1 (ssget "X" (list (list -3 (list APID)))))
   (if SS1
     (progn
        (setq TMP (sslength SS1)
              SUM 0.0)
        (repeat TMP
           (setq TMP (1- TMP)
                 T1 (X_DATA_GET (ssname SS1 TMP) APID)
                 SUM (+ SUM (cdadr T1))))
        (prompt 
          (strcat 
             "\nSum total = " 
             (rtos SUM))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
