(defun C:mcv ()
  (setq suf (getstring 1 "\nEnter the suffix for dimensioning  "))
  (setq fac (getreal "\nEnter the factor for conversion  "))
  (setvar "lunits" 2)
  (setvar "luprec" 2)
  (setq ss (ssget "x"))
  (command "scale" ss "" "0,0" fac)
  (setq limitx (* (car (getvar "limmax")) fac))
  (setq limity (* (cadr (getvar "limmax")) fac))
  (setvar "limmax" (list limitx limity))
  (setq gridx (* (car (getvar "gridunit")) fac))
  (setq gridy (* (cadr (getvar "gridunit")) fac))
  (setvar "gridunit" (list gridx gridy))
  (setq snapx (* (car (getvar "snapunit")) fac))
  (setq snapy (* (cadr (getvar "snapunit")) fac))
  (setvar "snapunit" (list snapx snapy))
  (setq scalefac (* (getvar "dimscale") fac))
  (command "dim" "dimscale" scalefac ^c)
  (command "dim" "dimpost" suf ^c)
  (command "dim" "update" ss "" ^c)
  (command "zoom" "a")
)
