###################################
#
#  Modem and Host Scripts -- U of M version 1.4
#
#  U of M basic scripts
#
###################################
#
#   Modem scripts
#
#  For each modem type xxx, supply script:
#
#      Modem.xxx.Dial         Dials the phone, waits for connection
#      Modem.xxx.Hangup       Gets the modem to hang up the phone
#      Modem.xxx.Status       Returns the modem's status (-1,0,1=?,no cd,cd)
#
###################################
#
#
procedure     Modem.Hayes.Dial
Message   'Hayes newer modem login script --  Version 1.0'
Send      'AT <'
TimeOut   5             'Your modem is not responding, try turning it off, then on.'
Reject    "ERROR"       'Your modem said "Error" to the initialization string.'
Expect    'OK'          'Your modem did not say "OK".'
join  Modem.Default.Dial
EndProcedure   Modem.Hayes.Dial
#
#

procedure     Modem.Default.Dial
Message   'Waking up your modem...'
Send      'AT <'
TimeOut   5             'Your modem is not responding, try turning it off, then on.'
Reject    "ERROR"       'Your modem said "Error" to the initialization string.'
Expect    'OK^M'         'Your modem did not say "OK".'
Wait 1
Message   'Dialling up the SLIP server...'
SendPT 'AT DT %n^M'  'AT DT %n^M'
TimeOut 60              'No connection after 1 minute.'
Reject  'NO DIALTONE'   "Your modem can't get a dial tone, check phone line to modem."
Reject  'BUSY'          'The server is fully occupied.'
Reject  'NO CARRIER'    'The server modem is not responding.  Try again.'
Expect  'CONNECT'       'Did not get the CONNECT response.'
Message 'SLIP server reached'
EndProcedure   Modem.Default.Dial
#
#
#
Procedure Modem.Default.HangUp
Flush
Message        "Hanging up phone."
#TimeOut 5      "Your modem may be already hung up"
#Wait 2
Send '+++'
Wait 2
Send '<'
Send 'AT H0<'
Expect 'OK'
Message        'Hangup complete.'
EndProcedure Modem.Default.HangUp
#
#
##########################################################################
#
#
#        Host Scripts
#
#
#    For each host hhh, supply two scripts:
#
#
#      Host.hhh.Login          Logs in and goes into SLIP mode
#
#      Host.hhh.LogOut         Does any logout chores (often empty)
#
#
Procedure  Host.Demon.Login
TimeOut 60		 'Demon is not responding.'
Flush
Expect 'ogin:'
Wait 1
Send '%u<'
Flush
Expect 'assword:'
#Private
Send '%p<'
Expect 'otocol'
Send 'SLIP<'
Flush
Expect 'HELLO'
EndProcedure Host.Demon.Login
#
#
#
Procedure  Host.Demon.LogOut
Send 'exit'
EndProcedure Host.Demon.LogOut
#
#   End of Script file
#
