; TIP973.LSP: LST.LSP   Improved List Command   (c)1994, Daryl L. Monk

;LST.LSP
;gets layer, color, linetype data, ENTITY NAME, & much more info!
;
;DXF function to extract entity data
;
(defun dxf (code e_list)
   (cdr (assoc code e_list))
)
;
(defun C:LST ( / e en ed lay ltyp name clr layclr layltyp en1 ed1 
                 attclr attltyp justnam Hjust Vjust inspt)
(princ "\nLST: Condensed Listings by Daryl Monk.\n")

(setq e (entsel "\nPick Object to List: <return to exit> "))

(while e
  (setq en (car e) ed (entget en))
  (redraw en 3)             ;HIGHLIGHT ENTITY
  (setq lay (dxf 8 ed) ltyp (dxf 6 ed) name (dxf 0 ed) clr (dxf 62 ed))
  (if (not clr)
    (setq layed (tblsearch "LAYER" lay) layclr (dxf 62 layed))
  )
  (if (not ltyp)
    (setq layed (tblsearch "LAYER" lay) layltyp (dxf 6 layed))
  )

  ;PRINT RESULTS
  (princ (strcat "\n\nListing of " name ": "))
  (if clr
    (princ (strcat "\n  >>Layer: " lay "\n  >>Entity Color: " (itoa clr)))
    (princ (strcat "\n  >>Layer: " lay "\n  >>BYLAYER Color: " (itoa layclr)))
  )
  (if ltyp
    (princ (strcat "\n  >>Entity Linetype: " ltyp))
    (princ (strcat "\n  >>BYLAYER Linetype: " layltyp))
  )

  (cond
  ((= name "INSERT") 
    (princ (strcat "\n  >>Block Name: " (dxf 2 ed)))
    (setq inspt (dxf 10 ed) en1 (entnext en))
    (princ "\tIns. Pt: ") (princ inspt)

    (if en1 (setq ed1 (entget en1) name (dxf 0 ed1)))
    (princ "\n  >>Xscale: ") (princ (dxf 41 ed))
    (princ "\n  >>Yscale: ") (princ (dxf 42 ed))
    (princ "\n  >>Zscale: ") (princ (dxf 43 ed))
    (princ "\n  >>Rotation: ") (princ (angtos (dxf 50 ed)))
    (getstring "\n....Press any key....")

    (if (= name "ATTRIB")
      (while en1
        (princ "\n  >>Attribute Layer: ") (princ (setq attlay (dxf 8 ed1)))
        (princ "\n  >>Attribute Value: ") (princ (dxf 1 ed1))
        (princ "\n  >>Attribute Style: ") (princ (dxf 7 ed1))
        (princ "\n  >>Attribute Height: ") (princ (dxf 40 ed1))
        (princ "\n  >>Attribute Rotation: ") (princ (angtos (dxf 50 ed1)))
        (if (setq attclr (dxf 62 ed1)) 
          (princ (strcat "\n  >>Attribute Color: " (itoa attclr)))
          (progn
            (setq layed (tblsearch "LAYER" attlay) 
                  attclr (dxf 62 layed)
                  attltyp (dxf 6 layed)
            )
            (princ (strcat "\n  >>Attribute BYLAYER Color: " (itoa attclr)))
          )
        );if
        (if (setq attltyp (dxf 6 ed1)) 
          (princ (strcat "\n  >>Attribute Linetype: " attltyp))
          (progn
            (if (not attltyp)
              (setq layed (tblsearch "LAYER" attlay) attltyp (dxf 6 layed))
            )
            (princ (strcat "\n  >>Attribute Linetype: BYLAYER " attltyp))
          )
        );if
        (getstring "\n....Press any key....")

        (setq en1 (entnext en1) ed1 (entget en1) name (dxf 0 ed1))
        (if (= name "SEQEND") (setq en1 nil))
      );while
    );if
   )
  ((= name "TEXT")
    (princ "\n  >>Value: ") (princ (dxf 1 ed))
    (princ "\n  >>Style: ") (princ (dxf 7 ed))
    (princ "\n  >>Height: ") (princ (dxf 40 ed))
    (princ "\n  >>Rotation: ") (princ (angtos (dxf 50 ed)))
    (setq Hjust (dxf 72 ed) Vjust (dxf 73 ed))
    (cond
     ((= Hjust 0) (setq justnam "Left"))
     ((= Hjust 1) (setq justnam "Center"))
     ((= Hjust 2) (setq justnam "Right"))
     ((= Hjust 3) (setq justnam "Aligned"))
     ((= Hjust 4) (setq justnam "Middle"))
     ((= Hjust 5) (setq justnam "Fit"))
    )
    (if (< Hjust 3)
      (cond
       ((= Vjust 3) (setq justnam (strcat "Top " justnam)))
       ((= Vjust 2) (setq justnam (strcat "Middle " justnam)))
       ((= Vjust 1) (setq justnam (strcat "Bottom " justnam)))
      )
    );if
    (if (/= Hjust 0) (setq inspt (dxf 11 ed)) (setq inspt (dxf 10 ed)))
    (princ "\n  >>Insertion Pt: ") (princ inspt) 
    (princ (strcat "\n  >>Justification: " justnam))
   )
  ((or (= name "CIRCLE") (= name "ARC"))
    (princ "\n  >>Center Point: ") (princ (dxf 10 ed))
    (princ "\n  >>Radius: ") (princ (dxf 40 ed))
   )
  ((= name "LINE")
    (princ "\n  >>Start Point: ") (princ (dxf 10 ed))
    (princ "\n  >>End Point: ") (princ (dxf 11 ed))
   )
  );cond

  (redraw en 1)             ;DE-HIGHLIGHT ENTITY
  (setq e (entsel "\n\nPick Object to List: <return to exit> "))
)
(princ "\nLST complete.")
(prin1)
)
