; TIP968.LSP: BIORYTHM.LSP  Plot Biorhythms [Wackiest Tip Winner]
;                           (c)1994, Henry Vinerts

; ===== BIORYTHM.LSP by VHV, 1/23/94. Biorhythm curves.
; V.H.Vinerts, 36139 Chelsea Dr., Newark, CA 94560.
; This program offers no guarantees about accuracy or validity
; of its results. Its purpose is two-fold: 1) To enter CADalyst's
; Hot Tip Harry's January 1994 Wackiest Tip contest, and 
; 2) To illustrate the many wonderful things that can be done
; with the minimal--yet versatile--toolset of AutoLISP.
; (As time permits, Flatland Hank intends to work on this some
; more--to polish, add, subtract, explain--perhaps to make it
; a sample for some tutorial.
; (Just for the record: this was produced with Edlin on 12MHz
; 8088, monochrome, with ACAD 10 (v.7 for 286) for proving ground.
; For next version, set colors: RED for Physical, BLUE for
; Sensitivity (or Emotional), GREEN for Cognitive (Intellectual).)
; ===
; Ref. HP-33E APPLICATIONS Manual, Rev.B, 3/79, p.17 for
; calendar algorithm and the first 8 variable names.
; The input dates must be between 1/1/1901 and 12/31/2099.
; The default ACAD.DWG should be OK to draw the graph on.
; =================================================================
(defun C:BIO (/ M1 D1 Y1 M2 D2 Y2 N1 N2 DSB Xp Xs Xc Yp Ys Yc Bp Bs
              Bc ORIG DINT delay pt ABSC D# YSCALE weekda xpdmod
              xpdsiz x_end xblip)
  ; === To start with, save old variable settings, set text style.
  (setvar "CMDECHO" 0)
  (setq xpdmod (getvar "PDMODE"))
  (setq xpdsiz (getvar "PDSIZE"))
  (setq xblip (getvar "BLIPMODE"))
  (setvar "PDSIZE" -2) ; experiment with this, but BLIPMODE=0
  (command "STYLE" "pica" "ROMANT" 0.1029 "" "" "" "" "")
  ; (Flatland Hank's typewriter. Golden section x 1/6 = height)
  ; === Enter the starting date for the Biorhythm curves
  (prompt "\nFor the start date of your BIORHYTHM curves,")
  (setq M1 (getreal "\ninput one or two digits for month: ")
        D1 (getreal "\nInput one or two digits for day: ")
        Y1 (getreal "\nInput four digits for the year: ")
  )
  ; === Calculate number of day for biorhythm date
  (setq N1 (if (<= M1 2)
    (+ (fix (* (+ M1 13)30.6))(fix (* (- Y1 1)365.25)) D1)
    (+ (fix (* (+ M1  1)30.6))(fix (* Y1 365.25)) D1)
           )
  )
  ; === Enter your birthdate
  (prompt "\nNow input your birthdate...")
  (setq M2 (getreal "\nInput one or two digits for month: ")
        D2 (getreal "\nInput one or two digits for day: ")
        Y2 (getreal "\nInput four digits for the year: ")
  )
  ; === Calculate number of day for birthday
  (setq N2 (if (<= M2 2)
    (+ (fix (* (+ M2 13)30.6))(fix (* (- Y2 1)365.25)) D2)
    (+ (fix (* (+ M2  1)30.6))(fix (* Y2 365.25)) D2)
           )
  )
  ; === Day of week for your birthday may be of interest
  ;
    (setq weekda (rem (- N2 2) 7)) ; modulo 7 from Sun.,12/30/1900
    (cond ((= weekda 0)(princ "\nYou were born on a Sunday"))
          ((= weekda 1)(princ "\nYou were born on a Monday"))
          ((= weekda 2)(princ "\nYou were born on a Tuesday"))
          ((= weekda 3)(princ "\nYou were born on a Wednesday"))
          ((= weekda 4)(princ "\nYou were born on a Thursday"))
          ((= weekda 5)(princ "\nYou were born on a Friday"))
          ((= weekda 6)(princ "\nYou were born on a Saturday"))
    ) ; end COND
      (princ "\n  Obey instructions, or you'll have to start over. ")
      (princ "Next version will have error-checking.")
    (setq delay (getstring " *** Push space bar to go on...***"))
; === And now to the bio-values:
  (setq DSB (- N1 N2))  ; number of days since birthday
    (setq Xp (- (/ DSB 23.0)(fix (/ DSB 23.0)))) ; x-offset for p
    (setq Yp (sin (* Xp 2 pi)))      ; physical bio-value
    (setq Xs (- (/ DSB 28.0)(fix (/ DSB 28.0)))) ; x-offset for s
    (setq Ys (sin (* Xs 2 pi)))      ; sensitivity bio-value
    (setq Xc (- (/ DSB 33.0)(fix (/ DSB 33.0)))) ; x-offset for c
    (setq Yc (sin (* Xc 2 pi)))      ; cognitive bio-value
    (setq Bp (rtos Yp 2 2)  Bs (rtos Ys 2 2)  Bc (rtos Yc 2 2))
    (prompt "\nThese are your bio-values: \n")
    (princ (strcat "P " Bp ", S " Bs ", C " Bc))
    (princ)
  ; === Graph all 3 curves for 10 days from "bio-date"
  (setq ORIG (getpoint "\nPick a point near left edge of paper, to start 10-day graph:"))
  (setq DINT (getreal "\nInput horizontal scale interval for each day; 0.625 is suggested: "))
  (setq x_end (polar ORIG 0 (* 9 DINT))) ; e.g.,set end of x-axis w/P-A-D.
  (command "LINE" ORIG  x_end "")
  (setq YSCALE 2)  ; Set as you wish to spread the ordinates
    (command "UCS" "Origin" ORIG)
  ; === Draw PHYSICAL biorhythm curve for 10 days from "bio-date"
  ; (Of course, you may make it for more days, if paper permits.)
  (setq delay (getstring "\nPush space bar to see Physical curve:"))
    (setvar "PDMODE" 65)
    (setq ABSC 0)   ; abscissa is zero at the origin
    (setq D# DSB)  ; D#=day number, to be incremented 9 times
      (WHILE (< ABSC (* 10 DINT))
        (setq Xp (- (/ D# 23.0)(fix (/ D# 23.0))))
        (setq Yp (sin (* Xp 2 pi)))
          (setq pt (list ABSC (* Yp YSCALE)))
          (command "POINT" pt)
          (setq ABSC (+ ABSC DINT))
          (setq D# (+ D# 1))
      ) ; end of WHILE
    (command "TEXT" "@" "" " _P")
  ; === Draw SENSITIVITY biorhythm curve for 10 days from "bio-date"
  (setq delay (getstring "\nPush space bar to see Sensitivity curve:"))
    (setvar "PDMODE" 33)
    (setq ABSC 0)   ; abscissa is zero at the origin
    (setq D# DSB)  ; D#=day number, to be incremented 9 times
      (WHILE (< ABSC (* 10 DINT))
        (setq Xs (- (/ D# 28.0)(fix (/ D# 28.0))))
        (setq Ys (sin (* Xs 2 pi)))
          (setq pt (list ABSC (* Ys YSCALE)))
          (command "POINT" pt)
          (setq ABSC (+ ABSC DINT))
          (setq D# (+ D# 1))
      ) ; end of WHILE
    (command "TEXT" "@" "" " _ S")
  ; === Draw COGNITIVE biorhythm curve for 10 days from "bio-date"
  (setq delay (getstring "\nPush space bar to see Cognitive curve:"))
    (setvar "PDMODE" 3)
    (setq ABSC 0)   ; abscissa is zero at the origin
    (setq D# DSB)  ; D#=day number, to be incremented 9 times
      (WHILE (< ABSC (* 10 DINT))
        (setq Xc (- (/ D# 33.0)(fix (/ D# 33.0))))
        (setq Yc (sin (* Xc 2 pi)))
          (setq pt (list ABSC (* Yc YSCALE)))
          (command "POINT" pt)
          (setq ABSC (+ ABSC DINT))
          (setq D# (+ D# 1))
      ) ; end of WHILE
    (command "TEXT" "@" "" " _  C")
  ; === Return variables to original settings
    (setvar "PDMODE" xpdmod)
    (setvar "PDSIZE" xpdsiz)
    (setvar "BLIPMODE" xblip)
  (princ "\nProgram is finished. Enter BIO to start again.")
  (princ "\nAdd notes, PRPLOT on 8.5x11, or whatever...")
  (princ)
) ; end of C:BIO

