; TIP972.LSP: COUNT.LSP   Count Entity Types   (c)1994, Mark H. Miller

;COUNT.LSP - reports on numbers of entities in drawing database

(defun c:count (/ cnta cntc cntl cntp cntt cntd cntply cntb cnt3d
cnto ss)
 (textscr)
 (prompt "Counting...")
 (terpri)
 (cond ((setq ss (ssget "X" '((0 . "ARC"))))(setq cnta (sslength ss)))
       ((setq cnta 0)))
 (cond ((setq ss (ssget "X" '((0 . "CIRCLE"))))
        (setq cntc (sslength ss)))
       ((setq cntc 0)))
 (cond ((setq ss (ssget "X" '((0 . "LINE"))))
        (setq cntl (sslength ss)))
       ((setq cntl 0)))
 (cond ((setq ss (ssget "X" '((0 . "POINT"))))
        (setq cntp (sslength ss)))
       ((setq cntp 0)))
 (cond ((setq ss (ssget "X" '((0 . "TEXT"))))
        (setq cntt (sslength ss)))
       ((setq cntt 0)))
 (cond ((setq ss (ssget "X" '((0 . "DIMENSION"))))
        (setq cntd (sslength ss)))
       ((setq cntd 0)))
 (cond ((setq ss (ssget "X" '((0 . "POLYLINE"))))
        (setq cntply (sslength ss)))
       ((setq cntply 0)))
 (cond ((setq ss (ssget "X" '((0 . "INSERT"))))
        (setq cntb (sslength ss)))
       ((setq cntb 0)))
 (cond ((setq ss (ssget "X" '((0 . "3DFACE"))))
        (setq cnt3d (sslength ss)))
       ((setq cnt3d 0)))
 (setq cnto (+ (cond ((setq ss (ssget "X" '((0 . "SOLID"))))
                      (sslength ss))
                     ('0))
               (cond ((setq ss (ssget "X" '((0 . "SHAPE"))))
                      (sslength ss))
                     ('0))
               (cond ((setq ss (ssget "X" '((0 . "TRACE"))))
                      (sslength ss))
                     ('0))))

 (terpri)
 (princ "ITEM    QUANTITY")
 (terpri)
 (princ (strcat "arcs""       "(itoa cnta)))(terpri)
 (princ (strcat "blocks""     "(itoa cntb)))(terpri)
 (princ (strcat "circles""    "(itoa cntc)))(terpri)
 (princ (strcat "dims""       "(itoa cntd)))(terpri)
 (princ (strcat "lines""      "(itoa cntl)))(terpri)
 (princ (strcat "points""     "(itoa cntp)))(terpri)
 (princ (strcat "plines""     "(itoa cntply)))(terpri)
 (princ (strcat "text""       "(itoa cntt)))(terpri)
 (terpri)
 (princ (strcat "misc""       "(itoa cnto)"      (shapes, solids, traces)"))
 (terpri)
 (princ (strcat "3dfaces""    "(itoa cnt3d)))
 (prin1)
);end count.lsp
