; TIP969.LSP: YAT.LSP   Play Yahtzee Without the Dice   [Wackiest Tip Runner Up]
;                           (c)1994, Kurt E. Kilheffer

;       This is a Yahtzee game that runs within AutoCAD
;

(defun c:yat ()
    ;  if this is 1st time run, run SETUP else erase scores
    (if (= dival nil)(setup)(resetgame))
    (setq nextgame 0) ; if NEXTGAME=0 start new game else exit
    (while (= nextgame 0)
        (setq q (getstring "Do you need instructions? Y/N  "))
        (setq q (substr q 1 1))
        ; if Q=y display game instructions
        (if (or (= q "Y")(= q "y"))(instruct))
        (getusers) ;  get 2 user names
        (resetval) ;  reset both user scores to un-selected
        (clhold)   ;  release all dice's hold
        (setq i 1)
        (while (< i 12) ; loop 11 times - for each Yahtzee option
            (setq u 1)
            (while (< u 3) ; loop 2 times - for each player
                ; set USTR to current user name
                (if (= u 1)(setq ustr user1)(setq ustr user2))
                (setq st (strcat ustr "'s turn - select ROLL "))
                (setq st1 (strcat ustr "'s turn - select dice to hold & then select ROLL "))
                ; erase previous player's name and status
                (command "erase" "c" "5,7" "4,6" "")
                (command "text" "m" "4.25,7" ".3" "0" ustr) ; display current player's name
                (command "text" "m" "4.25,6" ".25" "0" "ROLL #1") ; display ROLL #1
                (setq test 0) 
                (while (= test 0) ; loop until ROLL is selected
                  (setq p (getpoint st)) ; player selects point
                  (getbutton1 p)(terpri) ; return which button was selected
                  (if (= b 22)(setq test 1)) ; is button selected ROLL?
                )
                (rolldi) ; roll all five dice
                (setq rll 1)
                (while (< rll 4) ; loop 3 times - 3 rolls
                  (rolldi) ; roll all dice not on hold
                  (if (< rll 3)
                    (progn
                      ; erase previous roll status
                      (command "erase" "c" "3,6" "4.25,6.5" "")
                      (setq rl (+ rll 1))
                      (setq st3 (strcat "ROLL #" (itoa rl)))
                      ; display current roll status
                      (command "text" "m" "4.25,6" ".25" "0" st3)
                      (setq test 0)
                      (while (= test 0) ; loop until ROLL is selected
                        (setq p (getpoint st1)) ; get point on screen
                        (getbutton1 p)(terpri)  ; get selected button
                        ; if dice is selected, change hold status
                        (if (and (< b 6)(> b 0))(hold b))
                        (if (= b 22)(setq test 1)) ; exit loop if ROLL is selected
                      )
                    )
                  )
                  (setq rll (+ 1 rll))
                )
              (command "erase" "c" "3,6" "4.25,6.5" "") ; erase roll status
              (command "text" "m" "4.25,6" ".25" "0" "Select Yahtzee option")
              (getval) ;  calculate Yahtzee option score
              (setq u (+ u 1))
              (clhold) ;  clear all 5 dice holds
            )
          (setq i (+ i 1))
        )
        (total) ;  calculate & display total scores
        (setq q (getstring "Do you want to play another game? Y/N "))
        (setq q (substr q 1 1))
        (if (or (= q "N")(= q "n"))(setq nextgame 1)(resetgame)) ; another game?
    )
)

(defun setup ()
        (command "erase" "all" "") ;  erase everything
        (command "limits" "0,0" "12,9") ;  set limits
        (setvar "LUNITS" 2)     ;  set decimal units
        (setvar "LUPREC" 4)     ;  set 4 decimal places
        (setvar "CMDECHO" 0)
        (setvar "PDMODE" 35)    ;  set point type for dice dots
        (setvar "PDSIZE" 0.025) ; set point size
        (setvar "BLIPMODE" 0)
        (setvar "UCSICON" 0)
        (setvar "FILLETRAD" 0.05)
        (command "zoom" "all")
        ; create a red layer for the dice
        (command "layer" "m" "dice" "c" "red" "dice" "")
        ; draw a pline square for the dice
        (command "pline" "0,0" "w" ".025" ".025" ".5,0" ".5,.5" "0,.5" "c")
        (command "fillet" "p" "l")
        ; make square into a block called DI
        (command "block" "di" "0,0" "l" "")
        ; insert DI block
        (command "insert" "di" "2,3.5" "" "" "")
        ; make 5 dice 
        (command "array" "l" "" "r" "1" "5" "1")
        (command "point" "0.25,0.25")
        (mkblock "1") ; make block called 1 with one point
        (command "point" "0.2357<45")
        (command "point" "0.4714<45")
        (mkblock "2") ; make block called 2 with two points
        (command "point" "0.17678<45")
        (command "point" "0.25,0.25")
        (command "point" "0.53<45")
        (mkblock "3") ; make block called 3 with three points
        (command "point" "0.2357<45")
        (command "array" "l" "" "r" "2" "2" "@" ".4714<45")
        (mkblock "4") ; make block called 4 with four points
        (command "point" "0.17678<45")
        (command "array" "l" "" "r" "2" "2" "@" "0.53<45")
        (command "point" "0.25,0.25")
        (mkblock "5") ; make block called 5 with five points
        (command "point" "0.125,0.2")
        (command "array" "l" "" "r" "2" "3" "0.125" "0.125")
        (mkblock "6") ; make block called 6 with six points
        (diloc 1 1)   ; display block 1 at position 1
        (diloc 2 2)   ; display block 2 at position 2
        (diloc 3 3)   ; display block 3 at position 3
        (diloc 4 4)   ; display block 4 at position 4
        (diloc 5 5)   ; display block 5 at position 5
        (setq y 6.5)  
        ; display Yahtzee options on new green layer called TEXT
        (command "layer" "m" "text" "c" "green" "text" "")
        (command "text" "m" "9.5,6.5" ".25" "0" "1")
        (command "text" "m" "9.5,6.0" ".25" "0" "2")
        (command "text" "m" "9.5,5.5" ".25" "0" "3")
        (command "text" "m" "9.5,5.0" ".25" "0" "4")
        (command "text" "m" "9.5,4.5" ".25" "0" "5")
        (command "text" "m" "9.5,4.0" ".25" "0" "6")
        (command "text" "m" "9.5,3.5" ".25" "0" "HI")
        (command "text" "m" "9.5,3.0" ".25" "0" "LO")
        (command "text" "m" "9.5,2.5" ".25" "0" "STR")
        (command "text" "m" "9.5,2.0" ".25" "0" "FH")
        (command "text" "m" "9.5,1.5" ".25" "0" "Y")
        ; make and set current layer to ROLL
        (command "layer" "m" "roll" "c" "cyan" "roll" "")
        ; create ROLL box
        (command "pline" "3,1" "w" "0.025" "0.025" "@2<0" "@1<90" "@2<180" "c")
        (command "fillet" "p" "l")
        (command "text" "m" "4.0,1.5" "0.5" "0" "ROLL")
        ; make and set current layer to VALUES
        (command "layer" "m" "values" "c" "yellow" "values" "")
        ; set current dice values ((1.1)(2.2)(3.3)(4.4)(5.5))
        (setq dival (list (cons '1 1)(cons '2 2)(cons '3 3)(cons '4 4)(cons '5 5)))
)

(defun getval ()
        (setq test2 0)
          (while (= test2 0)
            (getbutton2) ; get selected Yahtzee option  b = 1-11
            ; get current player's score & set to CURRUSER
            (if (= u 1)(setq curruser u1)(setq curruser u2))
            ; set DV to current value of option
            (setq dv (cdr (assoc b curruser)))
            ; if value = * (unselected), continue else try again
            (if (= dv "*")(setq test2 1))
          )
        (setq d 1)(setq tv 0)
        (while (< d 6)
          (setq dv (cdr (assoc d dival))) ; set DV to dice value
          (setq tv (+ tv dv))             ; TV is total dice value
          (setq d (+ 1 d))
        )
        (if (< b 7)             ; Yahtzee option 1 - 6
          (progn
            (setq tv 0)(setq d 1)
            (while (< d 6)   ; loop through 5 dice
              (setq dv (cdr (assoc d dival)))   ; set DV to dice value
              ; if = to selected option, add to TV
              (if (= dv b)(setq tv (+ tv dv))) 
              (setq d (+ d 1))
            )
          )
        )
        (if (and (< b 9)(> b 6))        ; HI and LO  b=7=HI  b=8=LO
          (progn
            ;  set BALT to opposite of selected option
            (if (= b 7)(setq balt 8)(setq balt 7))
            (setq dv1 (cdr (assoc balt curruser))) ; value of BALT
            ; if opposite has not been selected, set TV to total value of dice
            (if (/= dv1 "*")
              (progn
                ;  if low is greater or = to hi, set HI = 0
                (if (and (= b 7)(>= dv1 tv))(setq tv 0))
                (if (and (= b 8)(<= dv1 tv))(setq tv 0))
                ;  if high is less than or = to lo, set LO = 0
              )
            )
          )
        )
        (if (= b 9)                     ; STRAIGHT
          (progn
            ;  set STRSTAT to ((1.1)(2.2)(3.3)(4.4)(5.5)(6.6))
            (setq strstat (list (cons '1 1)(cons '2 2)(cons '3 3)(cons '4 4)(cons '5 5)(cons '6 6)))
            (setq d 1)
            (setq tt 0)(setq ta 0)
            (while (< d 6) ;  loop through all five dice
              (setq dv (cdr (assoc d dival))) ; set DV = dice value
              (setq ev (cdr (assoc dv strstat))) ; set EV = value status
              (if (> ev 0)
                (progn
                  ;  if dice value has not been duplicated, add value to TT
                  (setq tt (+ tt dv))
                  (setq strstat (subst (cons dv 0)(assoc dv strstat) strstat))
                  (setq ta (+ ta 1)) ;  count the number of different dice
                )
              )
              (setq d (+ 1 d))
            )
            ;  if total=15 or 20 & all 5 dice were different, straight is good
            ;                                  else set TV = 0
            (if (and (or (= 15 tt)(= 20 tt))(= ta 5))(setq tv tv)(setq tv 0))
          )
        )
        (if (= b 10)                    ; FULL HOUSE
          (progn
            ;  set STRSTAT = ((1.0)(2.0)(3.0)(4.0)(5.0)(6.))
            (setq strstat (list (cons '1 0)(cons '2 0)(cons '3 0)(cons '4 0)(cons '5 0)(cons '6 0)))
            (setq d 1)
            (while (< d 6) ;  loop through each dice
              ; set DV to dice value
              (setq dv (cdr (assoc d dival)))
              ; add 1 to the status of each dice #
              (setq ev (+ 1 (cdr (assoc dv strstat))))
              (setq strstat (subst (cons dv ev)(assoc dv strstat) strstat))
              (setq d (+ d 1))
            )
            (setq d 1)(setq tt 0)
            (while (< d 7) ; loop through dice status
              (setq ev (cdr (assoc d strstat)))
              ; if # of alike dice=3 or 2, add # of alike dice to tt
              (if (or (= ev 3)(= ev 2))(setq tt (+ tt ev)))
              (setq d (+ 1 d))
            )
            ; if TT = 5, then FH is good else set TV = 0
            (if (= tt 5)(setq tv tv)(setq tv 0))
          )
        )
        (if (= b 11)                    ; YAHTZEE
          (progn
            (setq tv 30)                ; set TV = 30
            (setq ev (cdr (assoc 1 dival))) ; set EV to 1st dice value
            (setq d 2)
            (while (< d 6) ;  loop through dice #2 - #5
              (setq dv (cdr (assoc d dival))) ; set DV to value of dice
              (if (/= dv ev)(setq tv 0)) ; if dice is not = to 1st, set TV=0
              (setq d (+ 1 d))
            )
          )
        )
        ;  get X position based on user
        (if (= u 1)(setq x 8.5)(setq x 10.5))
        ;  get Y position based on Yahtzee option
        (setq y (- 7.0 (* b 0.5)))
        (setq inst (list x y)) ; create insertion point for score
        (command "text" "m" inst "0.25" "0" (itoa tv)) ; display TV score
        ;  update score variable U1 or U2
        (if (= u 1)(setq u1 (subst (cons b tv)(assoc b u1) u1)))
        (if (= u 2)(setq u2 (subst (cons b tv)(assoc b u2) u2)))
)


;  clear dice holds and erase all scores
(defun resetgame ()
        (clhold)
        (command "erase" "c" "8.4,0" "8.6,9.0" "")
        (command "erase" "c" "10.4,0" "10.6,9.0" "")
)

;  calculate and display total scores
(defun total ()
        (setq d 1)(setq tuser1 0)(setq tuser2 0)
        (while (< d 12)
          (setq v1 (cdr (assoc d u1)))
          (setq v2 (cdr (assoc d u2)))
          (setq tuser1 (+ tuser1 v1))
          (setq tuser2 (+ tuser2 v2))
          (setq d (+ d 1))
        )
        (command "text" "m" "8.5,0.5" ".25" "0" (itoa tuser1))
        (command "text" "m" "10.5,0.5" ".25" "0" (itoa tuser2))
)

;  make blocks for dice 1-6
(defun mkblock (nbr)
        (command "block" nbr "0,0" "w" "0,0" "0.5,0.5" "")
)

;  display current value of dice at position POS
(defun diloc (pos dval1)
        (setq dval1 (itoa dval1))
        (command "erase" "c" (list (+ 1.125 pos) 3.625) "@.25,.25" "")
        (command "insert" dval1 (list (+ 1 pos) 3.5) "" "" "")
)

;  get random value 1-6 for dice roll
(defun roll ()
        (setq n (getvar "tdindwg")) ; use time in drawing variable
        (setq nw (* n 1000000))
        (setq n1 (fix nw))
        (setq nd (- nw n1))
        (setq dval (+ 1 (* nd 6)))
        (setq dval (fix dval))
)

;  get and display player name
(defun getusers ()
        (setq user1 (getstring "Enter 1st name of player #1: "))(terpri)
        (setq user2 (getstring "Enter 1st name of player #2: "))(terpri)
        (command "erase" "c" "9.0,7.0" "10.5,7.5" "")
        (command "text" "r" "9.0,7.0" ".25" "0" user1)
        (command "text" "10.0,7.0" ".25" "0" user2)
)

;  reset both players scores to unselected  "*"
(defun resetval ()
        (setq u1 (list (cons '1 "*")(cons '2 "*")(cons '3 "*")(cons '4 "*")(cons '5 "*")(cons '6 "*")(cons '7 "*")(cons '8 "*")(cons '9 "*")(cons '10 "*")(cons '11 "*")))
        (setq u2 (list (cons '1 "*")(cons '2 "*")(cons '3 "*")(cons '4 "*")(cons '5 "*")(cons '6 "*")(cons '7 "*")(cons '8 "*")(cons '9 "*")(cons '10 "*")(cons '11 "*")))
)

;  change hold status to opposite of current status
(defun hold (bv)
        (setq h (cdr (assoc bv holdstat)))
        (if (= h 0)(setq h 1)(setq h 0))
        ;  update HOLDSTAT variable
        (setq holdstat (subst (cons bv h)(assoc bv holdstat) holdstat))
        (setq ins (list (+ bv 1.25) 3.0))
        ;  if H=0, remove HOLD text else display HOLD
        (if (= h 0)(command "erase" ins "")(command "text" "c" ins "0.125" "0" "HOLD"))
)

;  clear hold status for all dice   HOLDSTAT = ((1.0)(2.0)(3.0)(4.0)(5.0))
(defun clhold ()
        (setq holdstat (list (cons '1 0)(cons '2 0)(cons '3 0)(cons '4 0)(cons '5 0)))
        (command "erase" "c" "2.0,2.5" "7.0,3.0" "") ; erase all HOLD text
)

;  return dice # selected or ROLL     b = 1-6 or 22
(defun getbutton1 (p)
        (setq b 0)
        (setq x (car p))
        (setq y (cadr p))
        (if (and (< x 2.5)(> x 2.0)(< y 4.0)(> y 3.5))(setq b 1)) ; dice #1
        (if (and (< x 3.5)(> x 3.0)(< y 4.0)(> y 3.5))(setq b 2)) ; dice #2
        (if (and (< x 4.5)(> x 4.0)(< y 4.0)(> y 3.5))(setq b 3)) ; dice #3
        (if (and (< x 5.5)(> x 5.0)(< y 4.0)(> y 3.5))(setq b 4)) ; dice #4
        (if (and (< x 6.5)(> x 6.0)(< y 4.0)(> y 3.5))(setq b 5)) ; dice #5
        (if (and (< x 5.0)(> x 3.0)(< y 2.0)(> y 1.0))(setq b 22)) ; ROLL
)

;  return Yahtzee option     b = 1-11
(defun getbutton2 ()
        (setq b 0)
        (while (= b 0)
          (setq test 0)
          (while (= test 0)
            (setq p (getpoint "Select yahtzee option for this roll"))
            (terpri)
            (setq x (car p))
            (setq y (cadr p))
            (setq test1 1)
            (while (< test1 12)
              (setq y1 (- 7.25 (* test1 0.5)))
              (if (and (> x 8.0)(< x 11.0)(< y y1)(> y (- y1 0.5)))(setq b test1))
              (setq test1 (+ 1 test1))
            )
          (setq test (+ test 1))
          )
        )
)

;  roll all none HOLD dice
(defun rolldi ()
        (setq d 1)
        (while (< d 6)
           (setq h (cdr (assoc d holdstat)))
           (if (= h 0)        ; if HOLD is set goto next dice
             (progn
               (roll)         ; roll dice
               (diloc d dval) ; update dice display
               ;  update dice value
               (setq dival (subst (cons d dval)(assoc d dival) dival))
             )
           )
           (setq d (+ d 1))
        )
        (clhold) ; clear all dice HOLDs
)

;                       Yahtzee instructions
(defun instruct ()
  (textpage)
  (princ "Yahtzee is a game played with five dice.  The player gets three rolls\n")
  (princ "per turn and then must select one of the Yahtzee options:\n")
  (princ "     1 2 3 4 5 6 HI LO STRAIGHT FULL-HOUSE YAHTZEE\n")
  (princ "After each roll, the player may hold any dice they wish and roll again.\n")
  (princ "The values for each Yahtzee option are calculated as follows\n\n")
  (princ "Yahtzee Option         Value                  Example\n")
  (princ "    1 - 6       sum of all selected   3 opt.  1-3-5-3-3 = 9\n")
  (princ "                      option\n\n")
  (princ "     HI               sum of all dice         6-5-5-4-6 = 26\n")
  (princ "                'must be greater than LO\n\n")
  (princ "     LO               sum of all dice         4-5-6-4-6 = 25\n")
  (princ "                'must be less than HI'\n\n")
  (princ "     STR              sum of all dice         2-3-4-5-6 = 20\n")
  (princ "                '1-2-3-4-5 or 2-3-4-5-6'\n\n")
  (princ "     FH               sum of all dice         6-3-3-6-6 = 24\n")
  (princ "                '3 of one # & 2 of another'\n\n")
  (princ "     Y                      30                4-4-4-4-4 = 30\n")
  (princ "                'all five dice the same'\n")
  (getstring "Press the space bar to continue")
  (textpage)
  (princ "After the game is started, you are prompted for the user names. The\n")
  (princ "current player 1st selects ROLL.  The player then selects the dice\n")
  (princ "they want to hold & then select ROLL.  Then again select the dice to\n")
  (princ "hold and select ROLL. Then select an unselected Yahtzee option.  If\n")
  (princ "a dice is in a hold mode, by re-selecting that dice, the dice will\n")
  (princ "release.\n\n\n")                           
  (princ "")
  (getstring "press the space bar to continue")
  (terpri)(graphscr)
)
