{$A-,B-,D+,E-,F+,G-,I-,L+,N-,O-,R-,S-,V-,X+}
{$M 16384,0,0}
const
     HeaderSign:array[0..3] of char='mdat';
     DescrSign:array[0..3] of char='moov';
     QTType:array[0..3] of char='MooV';
type
   appleDword=longint;
   appleWord=word;
   tswitches=record
		executor:boolean; {Executor created files?}
	     end;

   tmacheader=record
		namelen:appleword;
		name:array[0..62] of char;
		filetype:array[0..3] of char; {MooV for QT movie}
		creator:array[0..3] of char;
		smth1:array[0..9] of byte;
		fsize:appleDword;
		smth2:array[0..40] of byte;
	      end;
   tfilestruct=record
		handle:word;
		smth:array[0..45] of byte;
		name:array[0..79] of char;
	       end;
     qtheader=record
		DescrOffset:appleDword;
		Sign:array[0..3] of char; {mdat}
	      end;
     qtDescr=record
	       StructSize:appleDword;
	       sign:array[0..3] of char;  {moov}
	     end;
procedure quit(message:string);
begin
 writeln(message);
 halt;
end;

function copyfile(var fin,fout:file;size:longint):boolean;
var p:pointer;                 {Copies SIZE bytes from FIN to FOUT}
 len:longint;I:integer;      { using all free memory for buffer}
 hbuf,hbuflen:word;

procedure readfile(var f:file;buf:pointer;asize:longint);
var i:integer;a,nreads:word;
begin
 nreads:=asize div $8000;
 for i:=1 to  nreads do
		begin
		  blockread(f,buf^,$8000);
		  buf:=ptr(seg(buf^)+$800,0);
		end;
 blockread(f,buf^,asize mod $8000,a);
end;

procedure writefile(var f:file;buf:pointer;asize:longint);
var i:integer;a,nreads:word;
begin
 nreads:=asize div $8000;
 for i:=1 to nreads do
		begin
		  blockwrite(f,buf^,$8000);
		  buf:=ptr(seg(buf^)+$800,0);
		end;
 blockwrite(f,buf^,asize mod $8000,a);
end;

begin
 asm
	mov ah,48h
	mov bx,0ffffh
	int 21h
	mov hbuflen,bx
	mov ah,48h
	int 21h        {Allocate All memory for buffer}
	mov hbuf,ax
 end;
 len:=longint(hbuflen) shl 4;
 p:=ptr(hbuf,0);
 for i:=1 to (size div len) do
  begin
   readfile(fin,p,len);
   writefile(fout,p,len);
  end;
  readfile(fin,p,size mod len);
  writefile(fout,p,size mod len);
 asm
	mov ah,49h
	mov es,hbuf {Free memory}
	int 21h
 end;
end;

function Ask(question:string):char;
var c:char;
begin
 write(question);
 repeat
 asm
	mov ah,0
	int 16h   {Get character from keyboard}
	mov c,al
 end;
  c:=upcase(c);
 until (c='Y') or (c='N');
 writeln(c);
 ask:=c;
end;

Function IBMDD(AppleDD:appleDword):longint;assembler;
asm
	les dx,appleDD     {Convert Apple DD to IBM DD}
	mov ax,es
	xchg al,ah
	xchg dl,dh
end;
Function AppleDD(DD:longint):appleDword;
begin
 appleDD:=IbmDD(dd);    {Convert IBM DD to Aplle DD}
end;

function skipmacheader(var f:file):boolean;
var res:boolean;
    h:tmacheader;
begin
 res:=true;
 blockread(f,h,sizeof(h));
 if h.filetype<>QTType then begin seek(f,filepos(f)-128); res:=false; end;
skipmacheader:=res;
end;


var l:longint;
    fdat,fres,fout:file;
    sysexitproc:pointer;
    tmpstr:string;
    header:qtheader;
    desc:qtdescr;
    nparam:byte;
    mheader:tmacheader;
    switches:tswitches;

procedure Fatalerror;far; { Exit procedure}
begin
 close(fdat);
 close(fres);
 close(fout);
 if ioresult<>0 then;
 if Exitcode<>0 then writeln('Error number ',Exitcode);
 Exitcode:=0;
 Erroraddr:=nil;
 exitproc:=sysexitproc;
end;

procedure help;
begin
 Writeln('Makes flattened movie from separate Resource and Data fork'#13#10+
	 'Use "qtflat.exe  Data_Fork_File  Resource_Fork_File  Resulting_Flattened_Movie"');
 Writeln(#13#10'Also checks the integrity of flattened movie'#13#10+
	 'In this case use "qtflat.exe   Flattened_Movie"');
 Writeln('Use /e switch if resource and data fork were produced by Executor');
 halt;
end;

procedure check(movie:string);
var size,dif:longint;tmp:string[20];macbinary:boolean;
begin
 assign(fout,movie);
 reset(fout,1);
 if ioresult<>0 then quit('Can''t open QuickTime Movie '+movie);
 macbinary:=skipmacheader(fout);
 if macbinary then writeln('The movie contains macbinary header');
  blockread(fout,header,sizeof(header));
  seek(fout,filepos(fout)-sizeof(header));
   if header.sign<>HeaderSign then quit('File '+movie+' dosen''t seem to be a Quicktime Movie');
 if ibmDD(header.descroffset)=0 then quit('The Movie '+movie+' doesn''t seem to be flattened');
if macbinary then
 if ask('Macbinary header is better to be removed. Remove it?[Y/N]')='Y' then
  begin
   assign(fdat,movie);
   reset(fdat,1);
   seek(fout,sizeof(tmacheader));
   copyfile(fout,fdat,filesize(fout)-sizeof(tmacheader));
   truncate(fdat);
   close(fdat); macbinary:=false;
  end;
 size:=ibmDD(header.descroffset);
 if macbinary then inc(size,sizeof(tmacheader));
 seek(fout,size);
 blockread(fout,desc,sizeof(desc));
 if desc.sign<>DescrSign then quit('File '+movie+' seems to have an improper "resource fork"');
 size:=ibmDD(header.descroffset)+ibmDD(desc.structsize);
 if macbinary then inc(size,sizeof(tmacheader));
 dif:=filesize(fout)-size;
 if dif=0 then quit('The movie seems to be OK');
 if dif>0 then
	    begin
		str(dif,tmp);
		if ask('The Movie '+movie+' contains '+tmp+' extra bytes.'#13#10+
		'(It might be the reason for being unplayable by QTW).Truncate?[Y/N]')='N'
		then halt
		else begin
		      seek(fout,size);
		      truncate(fout);
		     end;
	      end;
 if dif<0 then quit('The movie is probably invalid or incomplete');
end;

function getfname(var f:file):string;
var s:string;
begin
 move(tfilestruct(f).name,s[1],80);
 s[0]:=char(pos(#0,s)-1);
 getfname:=s;
end;

function ScanFormoov(var f:file):boolean;
var size,len,pos,p:longint;
    d:qtdescr;
    found:boolean;
begin
 found:=false;
 size:=filesize(f);
 pos:=filepos(f);
 blockread(f,p,sizeof(p));
 inc(pos,ibmDD(p));
 seek(f,pos);
 while pos<size do
 begin
  blockread(f,len,sizeof(len));
  blockread(f,d,sizeof(d));
  inc(pos,4);
  if d.sign=DescrSign then begin seek(f,pos); found:=true; break; end;
  if ibmDD(len)=0 then break;
  inc(pos,ibmDD(len));
  seek(f,pos);
 end;
 ScanFormoov:=found;
end;

procedure flattenfile(var fdat,fres,fout:file);
var len:longint;
begin
 blockread(fdat,header,sizeof(header));
  if header.sign<>HeaderSign then quit('Data Fork file '+getfname(fdat)+'  dosen''t seem to be a Quicktime Movie');
   if ibmDD(header.descroffset)<>0 then if ask('The Movie seems to be flattened already.Proceed?[Y/N]')='N' then halt;
   header.descroffset:=appleDD(filesize(fdat));
   blockwrite(fout,header,sizeof(header));
   copyfile(fdat,fout,ibmDD(header.descroffset)-sizeof(header));
   blockread(fres,desc,sizeof(desc));
   blockwrite(fout,desc,sizeof(desc));
   copyfile(fres,fout,ibmDD(desc.structSize)-sizeof(desc));
   truncate(fout);
   writeln('Now QuickTime for Windows ought to load the file with no problem');
   writeln('Have fun.');
end;

procedure flatten(data,resource,movie:string);
begin
   assign(fdat,data);
   assign(fres,resource);
   assign(fout,movie);
   reset(fdat,1); if ioresult<>0 then quit('Can''t open Data Fork file '+data);
   reset(fres,1); if ioresult<>0 then quit('Can''t open Resource Fork file '+resource);
   reset(fout,1); if ioresult=0 then
				  begin
				   if ask('File '+movie+' already exists. Overwrite?[Y/N]')='N' then halt;
				  end
				 else rewrite(fout,1);
   if skipmacheader(fdat) then writeln('Data fork has macbinary header');
   if switches.executor then seek(fres,filepos(fres)+512);
   if skipmacheader(fres) then writeln('Resorce fork has macbinary header');
   if not ScanFormoov(fres) then quit('Resource Fork '+resource+' file doesn''t seem to be a proper QuickTime resource fork.');
   flattenfile(fdat,fres,fout);
end;
procedure GetSwitches(var switches:tswitches);
var param:^string;p:byte;
begin
 fillchar(switches,sizeof(switches),0);
 param:=ptr(prefixseg,128);
 for p:=1 to length(param^) do param^[p]:=upcase(param^[p]);
 p:=pos('/E',param^);
 if p<>0 then begin  delete(param^,p,2); switches.executor:=true; end;
end;

BEGIN
   sysexitproc:=exitproc;
   exitproc:=@fatalerror;
   Writeln('QuickTime Movie flattener for DOS by Alex Novikov (Chip) V1.1 1994. Use free. '#13#10);
      getswitches(switches);
      nparam:=paramcount;
 case nparam of
  1:check(paramstr(1));
  3:flatten(paramstr(1),paramstr(2),paramstr(3));
  else help;
 end;
END.