{***************************************************************************}
{** Program : ULIST                                                       **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** This will display a simple userlist like the Novell utility USERLIST  **}
{**                                                                       **}
{** I haven't taken to much time sorting out the columns as this is only  **}
{** an example of the Netware API's.                                      **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

{$X+}

{ $DEFINE OPRO} {define this to use OPRO date/time formatting routines}

program CAPLPT;

uses

  crt,
  {$IFDEF OPRO}
  opdate,
  {$ENDIF}
  nwvar,
  nwerror,
  nwconn,
  nwfsserv;

var

  Connection  : ConnectionOBJ;
  FileServer  : FileServerOBJ;
  FSInfo      : File_Serv_Info;
  ObjectName  : TObjectName;
  ObjectType  : OT_BinderyType;
  ObjectID    : OT_BinderyID;
  LoginTime   : TByte7Array;
  Counter     : word;

begin

  clrscr;
  Connection.Init (true);
  FileServer.Init (true);
  with Connection, FileServer do
    begin

      if GetFileServerInformation (FSInfo) = SUCCESSFUL then
        begin

          writeln;
          writeln ('User Information for Server ', FSInfo.ServerName);
          writeln ('Connection  User Name       Login Time');
          writeln ('----------  --------------  -------------------');
          for Counter := 1 to FSInfo.MaxConnectionsSupported do
            begin

              GetConnectionInformation (Counter, ObjectName, ObjectType,
                                        ObjectID, LoginTime);

              if ObjectName <> '' then
                begin

                  write (' ':3,Counter:3, ' ':6, ObjectName:5, ' ':6,
                         LoginTime [2], '-', LoginTime [1], '-', LoginTime [0]);
                  {$IFDEF OPRO}
                  writeln (' ':2, TimeToAmPmString ('hh:mm te', HMStoTime (LoginTime [3], LoginTime [4], LoginTime [5])));
                  {$ELSE}
                  writeln;
                  {$ENDIF}

                end;

            end;

        end;

    end;

  FileServer.Done;
  Connection.Done;

end.