{***************************************************************************}
{** Program : DOWN.PAS                                                    **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** DOWN allows a superviosr or equivalent to down the current server     **}
{** from DOS.                                                             **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{** USAGE : DOWN forcedown                                                **}
{**                                                                       **}
{** if forcedown is false then the server will NOT be downed if active    **}
{** files are open.  if true then server will be forced down.             **}
{**                                                                       **}
{***************************************************************************}

program DOWN;

USES

  nwvar,
  nwfsserv,
  nwmisc;

CONST

  ProgramName = 'DOWN.EXE';
  Version     = '1.0';
  Description = 'Allows SUPERVISOR or equivalent to down a file server from DOS';

VAR

  FileServer  : FileServerOBJ;
  MiscFunc    : MiscFuncOBJ;
  ForceDown   : BYTE;
  Error       : WORD;

{******}

procedure GetCommandLine;

BEGIN

  IF (PARAMCOUNT < 1) OR (NOT MiscFunc.SupervisorEquivalent) THEN
    BEGIN

      WRITELN;
      WRITELN ('Program : ', ProgramName);
      WRITELN ('Version : ', Version);
      WRITELN ('Description : ', Description);
      WRITELN;
      WRITELN ('USAGE : ');
      WRITELN;
      WRITELN ('DOWN forcedown');
      WRITELN;
      WRITELN ('if forcedown is true then server will go down regardless of open files');
      HALT (1);

    END;

  IF MiscFunc.UppercaseNW (PARAMSTR (1) ) = 'TRUE' THEN
    ForceDown := 255
  ELSE
    ForceDown := 0;

END; {procedure GetCommandLine}

{******}

BEGIN

  FileServer.Init (true);
  MiscFunc.Init (true);
  GetCommandLine;
  Error := FileServer.DownFileServer (ForceDown);
  IF Error <> 0 THEN
    WRITELN ('Could not down server ERROR CODE : ', Error);
  FileServer.Done;
  MiscFunc.Done;

END.
