/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/***************************************************************************
 * This program displays the time and allows the user to change it.
 *
 * Author: James Hall
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "getopt.h"
#include "freedos.h"


void usage (void);


/* Quick-C structure for the time */

struct dostime_t dtime;


main (int argc, char **argv)
{
  int i;
  unsigned uHour, uMin, uSec;
  char szBuf[MAX_STR];

  /* Scan the command line */

  while ((i = getopt (argc, argv, "?")) != EOF)
    {
      switch (i)
	{
	default:
	  usage ();
	  break;
	}
    }

  /* Get the current time */

  if ((argc - optind) > 0)
    strcpy (szBuf, argv[optind]);

  else
    {
      _dos_gettime (&dtime);
      printf ("Current time is: %u:%02u:%02u\n", dtime.hour,
	      dtime.minute, dtime.second);

      /* Get the new time */

      printf ("Enter new time: ");
      gets (szBuf);
    }

  /* Parse the new time */

  if (strlen (szBuf))
    {
      sscanf (szBuf, "%u:%u:%u", &uHour, &uMin, &uSec);

      if (uHour < 24)
	{
	  dtime.hour = (unsigned char) uHour;
	}

      if (uMin < 60)
	{
	  dtime.minute = (unsigned char) uMin;
	}

      if (uSec < 60)
	{
	  dtime.second = (unsigned char) uSec;
	}

      /* Set the time */
      /* _dos_settime from Quick-C sets the time from a structure */

      _dos_settime (&dtime);
      _dos_gettime (&dtime);

      printf ("New time: %u:%02u:%02u\n",
	      dtime.hour, dtime.minute, dtime.second);
    }
  exit (0);
}

void 
usage (void)
{
  printp ("TIME", "Displays the time and allows the user to change it.");
  printu ("TIME", "[hh:mm:ss]");
  exit (1);
}
